<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.5.3
 * @date 30/10/19
 * @time 5:40 PM
 * 
 */
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
<div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
            </div>
<div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Portal Properties</h4>
                    </div>
                    <div class="panel-body">
                        <form class="portalProperties" ng-submit="savePortalProperties()" data-parsley-validate>
                            <div class="row" style="margin-left:0px !important;margin-right:0px !important;">
<div class="form-group col-lg-6">
                                    <label for="WindowsClientFilename">Windows Client Filename</label>
                                    <input type="text" class="form-control" name="WindowsClientFilename" id="WindowsClientFilename" value="<?=$data['portal']->{'WINDOWS_CLIENT_FILENAME'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="MacClientFilename">Mac Client Filename</label>
                                    <input type="text" class="form-control" name="MacClientFilename" id="MacClientFilename" value="<?=$data['portal']->{'MAC_CLIENT_FILENAME'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="MaximumEnablePartialFileTransfer">Maximum Enable Partial File Transfer</label>
                                    <input type="text" class="form-control" name="MaximumEnablePartialFileTransfer" id="MaximumEnablePartialFileTransfer" value="<?=$data['portal']->{'MAX_ENABLE_PARTIAL_FILE_TRANSFER'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="MaximumPartialFileTransferChunkSize">Maximum Partial File Transfer Chunk Size</label>
                                    <input type="text" class="form-control" name="MaximumPartialFileTransferChunkSize" id="MaximumPartialFileTransferChunkSize" value="<?=$data['portal']->{'MAX_PARTIAL_FILE_TRANSFER_CHUNK_SIZE'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="StorageType">Storage Type</label>
                                    <input type="text" class="form-control" name="StorageType" id="StorageType" value="<?=$data['portal']->{'STORAGE_TYPE'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="ProxyURL">Proxy URL</label>
                                    <input type="text" class="form-control" name="ProxyURL" id="ProxyURL" value="<?=$data['portal']->{'PROXY_URL'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
                                                                <div class="form-group col-lg-6">
                                    <label for="ProxyUsername">Proxy Username</label>
                                    <input type="text" class="form-control" name="ProxyUsername" id="ProxyUsername" value="<?=$data['portal']->{'PROXY_USERNAME'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="ProxyPassword">Proxy Password</label>
                                    <input type="text" class="form-control" name="ProxyPassword" id="ProxyPassword" value="<?=$data['portal']->{'PROXY_PASSWORD'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="CopyrightName">Copyright Name</label>
                                    <input type="text" class="form-control" name="CopyrightName" id="CopyrightName" value="<?=$data['portal']->{'COPYRIGHT_NAME'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="LoginPageImage">Login Page Image</label>
                                    <input type="text" class="form-control" name="LoginPageImage" id="LoginPageImage" value="<?=$data['portal']->{'NEIL_IMG_NAME'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="HeaderImage">Header Image</label>
                                    <input type="text" class="form-control" name="HeaderImage" id="HeaderImage" value="<?=$data['portal']->{'HEADER_NAME'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
<div class="form-group col-lg-6" style="margin-bottom:20px;">
                                    <label for="ComplexPassword">Complex Password</label>
                                    <select class="form-control ComplexPassword selectpicker" name="ComplexPassword" id="ComplexPassword" >
                                        <option value="true" <?php if($data["portal"]->{'COMPLEX_PASSWORD'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'COMPLEX_PASSWORD'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="ShareWithinOrg">Share Within Organisation</label>
                                    <select class="form-control ShareWithinOrg selectpicker" name="ShareWithinOrg" id="ShareWithinOrg" >
                                        <option value="true" <?php if($data["portal"]->{'SHARE_WITHIN_ORG'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'SHARE_WITHIN_ORG'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="DiskSpaceDetails">Disk Space Details</label>
                                    <select class="form-control DiskSpaceDetails selectpicker" name="DiskSpaceDetails" id="DiskSpaceDetails" >
                                        <option value="true" <?php if($data["portal"]->{'DISK_SPACE_DETAILS'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'DISK_SPACE_DETAILS'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="EULAEnabled">EULA Enabled</label>
                                    <select class="form-control EULAEnabled selectpicker" name="EULAEnabled" id="EULAEnabled" >
                                        <option value="true" <?php if($data["portal"]->{'EULA_ENABLED'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'EULA_ENABLED'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="PortalLightVersion">Portal Light Version</label>
                                    <select class="form-control PortalLightVersion selectpicker" name="PortalLightVersion" id="PortalLightVersion" >
                                        <option value="true" <?php if($data["portal"]->{'PORTAL_LIGHT_VERSION'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'PORTAL_LIGHT_VERSION'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="RequestResponseLogs">Request Response Logs</label>
                                    <select class="form-control RequestResponseLogs selectpicker" name="RequestResponseLogs" id="RequestResponseLogs" >
                                        <option value="true" <?php if($data["portal"]->{'REQ_RES_LOGS'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'REQ_RES_LOGS'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="EnableEye">Enable Eye</label>
                                    <select class="form-control EnableEye selectpicker" name="EnableEye" id="EnableEye" >
                                        <option value="true" <?php if($data["portal"]->{'ENABLE_EYE'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'ENABLE_EYE'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="DisableView">Disable View</label>
                                    <select class="form-control DisableView selectpicker" name="DisableView" id="DisableView" >
                                        <option value="true" <?php if($data["portal"]->{'DISABLE_VIEW'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'DISABLE_VIEW'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="DisableDownload">Disable Download</label>
                                    <select class="form-control DisableDownload selectpicker" name="DisableDownload" id="DisableDownload" >
                                        <option value="true" <?php if($data["portal"]->{'DISABLE_DOWNLOAD'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'DISABLE_DOWNLOAD'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="BluDriveMode">BluDrive Mode</label>
                                    <select class="form-control BluDriveMode selectpicker" name="BluDriveMode" id="BluDriveMode" >
                                        <option value="true" <?php if($data["portal"]->{'BLUDRIVE_MODE'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'BLUDRIVE_MODE'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="RelaxedCheck">Relaxed Check for username</label>
                                    <select class="form-control RelaxedCheck selectpicker" name="RelaxedCheck" id="RelaxedCheck" >
                                        <option value="true" <?php if($data["portal"]->{'RELAXED_CHECK'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'RELAXED_CHECK'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="ShowTotalCompletedBackups">Show Total Completed Backups in front</label>
                                    <select class="form-control ShowTotalCompletedBackups selectpicker" name="ShowTotalCompletedBackups" id="ShowTotalCompletedBackups" >
                                        <option value="true" <?php if($data["portal"]->{'TOTAL_COMPLETED_BACKUPS'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'TOTAL_COMPLETED_BACKUPS'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="ShowTotalActualStorageUtilized">Show Total Actual Storage Utilized in front</label>
                                    <select class="form-control ShowTotalActualStorageUtilized selectpicker" name="ShowTotalActualStorageUtilized" id="ShowTotalActualStorageUtilized" >
                                        <option value="true" <?php if($data["portal"]->{'TOTAL_ACTUAL_STORAGE_UTILIZED'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'TOTAL_ACTUAL_STORAGE_UTILIZED'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="EnableEPA">Enable EPA</label>
                                    <select class="form-control EnableEPA selectpicker" name="EnableEPA" id="EnableEPA" >
                                        <option value="true" <?php if($data["portal"]->{'ENABLE_EPA'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'ENABLE_EPA'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="WindowsEPA">Windows EPA</label>
                                    <select class="form-control WindowsEPA selectpicker" name="WindowsEPA" id="WindowsEPA" >
                                        <option value="true" <?php if($data["portal"]->{'WINDOWS_EPA'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'WINDOWS_EPA'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="MacEPA">Mac EPA</label>
                                    <select class="form-control MacEPA selectpicker" name="MacEPA" id="MacEPA" >
                                        <option value="true" <?php if($data["portal"]->{'MAC_EPA'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'MAC_EPA'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="EnableMobileApps">Enable Mobile Apps</label>
                                    <select class="form-control EnableMobileApps selectpicker" name="EnableMobileApps" id="EnableMobileApps" >
                                        <option value="true" <?php if($data["portal"]->{'ENABLE_MOBILE_APPS'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'ENABLE_MOBILE_APPS'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="EnableAndroidApp">Enable Android App</label>
                                    <select class="form-control EnableAndroidApp selectpicker" name="EnableAndroidApp" id="EnableAndroidApp" >
                                        <option value="true" <?php if($data["portal"]->{'ENABLE_ANDROID_APP'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'ENABLE_ANDROID_APP'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="EnableWindowsPhoneApp">Enable Windows Phone App</label>
                                    <select class="form-control EnableWindowsPhoneApp selectpicker" name="EnableWindowsPhoneApp" id="EnableWindowsPhoneApp" >
                                        <option value="true" <?php if($data["portal"]->{'ENABLE_WINDOWS_PHONE_APP'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'ENABLE_WINDOWS_PHONE_APP'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="EnableIosApp">EnableIosApp</label>
                                    <select class="form-control EnableIosApp selectpicker" name="EnableIosApp" id="EnableIosApp" >
                                        <option value="true" <?php if($data["portal"]->{'ENABLE_IOS_APP'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'ENABLE_IOS_APP'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="Disclaimer">Disclaimer</label>
                                    <select class="form-control Disclaimer selectpicker" name="Disclaimer" id="Disclaimer" >
                                        <option value="true" <?php if($data["portal"]->{'DISCLAIMER'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'DISCLAIMER'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="EnableHeaderLogo">Enable Header Logo</label>
                                    <select class="form-control EnableHeaderLogo selectpicker" name="EnableHeaderLogo" id="EnableHeaderLogo" >
					<option value="true" <?php if($data["portal"]->{'HEADER_LOGO'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
					<option value="false" <?php if($data["portal"]->{'HEADER_LOGO'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
<div class="form-group col-lg-6">
                                    <label for="FLIP_TOTAL_COMPLETED_BACKUPS">Make Total Completed Backups tile flippable</label>
                                    <select class="form-control FLIP_TOTAL_COMPLETED_BACKUPS selectpicker" name="FLIP_TOTAL_COMPLETED_BACKUPS" id="FLIP_TOTAL_COMPLETED_BACKUPS" >
<option value="true" <?php if($data["portal"]->{'FLIP_TOTAL_COMPLETED_BACKUPS'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
<option value="false" <?php if($data["portal"]->{'FLIP_TOTAL_COMPLETED_BACKUPS'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
<div class="form-group col-lg-6">
                                    <label for="FLIP_TOTAL_ACTUAL_STORAGE_UTILIZED">Make Total Actual Storage Utilized tile flippable</label>
<select class="form-control FLIP_TOTAL_ACTUAL_STORAGE_UTILIZED selectpicker" name="FLIP_TOTAL_ACTUAL_STORAGE_UTILIZED" id="FLIP_TOTAL_ACTUAL_STORAGE_UTILIZED" >
<option value="true" <?php if($data["portal"]->{'FLIP_TOTAL_ACTUAL_STORAGE_UTILIZED'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
<option value="false" <?php if($data["portal"]->{'FLIP_TOTAL_ACTUAL_STORAGE_UTILIZED'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
<div class="form-group col-lg-6">
                                    <label for="RECAPTCHA">Google reCAPTCHA</label>
<select class="form-control RECAPTCHA selectpicker" name="RECAPTCHA" id="RECAPTCHA" >
<option value="true" <?php if($data["portal"]->{'RECAPTCHA'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
<option value="false" <?php if($data["portal"]->{'RECAPTCHA'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
<div class="form-group col-lg-6">
                                    <label for="GOOGLE_AUTHENTICATOR">Google 2-factor authentication</label>
<select class="form-control GOOGLE_AUTHENTICATOR selectpicker" name="GOOGLE_AUTHENTICATOR" id="GOOGLE_AUTHENTICATOR" >
<option value="true" <?php if($data["portal"]->{'GOOGLE_AUTHENTICATOR'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
<option value="false" <?php if($data["portal"]->{'GOOGLE_AUTHENTICATOR'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
</div>

<div class="row" style="margin-left:10px;">
<legend class="h4" style="color: #585f69;"><?=Language::show('Ideal Timeout Settings', 'keywords')?></legend>
<div class="form-group col-lg-6">
                                    <label for="EnableIdealTimeout">Enable Ideal Timeout</label>
<select class="form-control EnableIdealTimeout selectpicker" name="EnableIdealTimeout" id="EnableIdealTimeout" >
                                        <option value="true" <?php if($data["portal"]->{'ENABLE_IDEAL_TIMEOUT'} == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["portal"]->{'ENABLE_IDEAL_TIMEOUT'} == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>

<div class="form-group col-lg-6">
                                    <label for="IdealTimeout">Ideal Timeout in minutes</label>
                                    <input type="text" class="form-control" name="IdealTimeout" id="IdealTimeout" value="<?=$data['portal']->{'IDEAL_TIMEOUT'}?>" placeholder="Enter your id" autocomplete="off">
                                </div>
</div>
                            <div class="row">
                                <button style="margin-right: 5px;" type="submit" class="btn btn-success pull-right mongoSave">Save</button>
                            </div>
                        </form>
</div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>




