<?php

use \Core\View;
use Helpers\Form;
use \Helpers\Url;
use Helpers\Auth;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='adCredentials'?></span>
            <div class="row">
                <div class="panel adPanel col-lg-12">
                    <div class="panel-heading">
                        <?php if(maxADGroup == false){ ?>
                        <h4 style="padding: 0px 0px 0px 15px;"><?=Language::show('activeDirectoryCredentials', 'keywords')?><span class="pull-right" id="adButton" data-toggle="tooltip" data-placement="top" style="cursor: not-allowed";><a class="btn btn-success btn-small adButton" href="" data-toggle="modal" data-target="#addad"><?=Language::show('addAd', 'keywords');?></a></span></h4>
                        <?php } else {?>
                        <h4 style="padding: 0px 0px 0px 15px;"><?=Language::show('activeDirectoryCredentials', 'keywords')?><span class="pull-right"><a class="btn btn-success btn-small" href="" data-toggle="modal" data-target="#addad"><?=Language::show('addAd', 'keywords');?></a></span></h4>
                        <?php } ?>
                    </div>

                   <div class="row" id="noActive" style="display:none;">
                        <div class="col-lg-12">
                            <h2 align="center">No Active Directory Credentials found</h2>
                        </div>
                    </div>
                    
                    <div class="panel-body table-responsive" ng-if="adcS.length > 0">
                        <div class="row col-lg-12">
                            <table id="example" class="table table-bordered table-striped adtableList">
                            <thead>
                            <tr>
                                <th class="text-left"><?=Language::show('userDomainName', 'keywords')?></th>
                                <th class="text-left"><?=Language::show('activeDirectoryProductType', 'keywords')?></th>
                                <th class="text-left"><?=Language::show('activeDirectoryCommonName', 'keywords')?></th>
                                <th class="text-left"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody ng-cloak>
                            <tr ng-repeat="value in adcS track by $index">
                                <td > {{ value.userDn }}</td>
                                <?php if(BLUDRIVE_MODE == false){?>
                                    <td ng-if="value.adProductType=='sync'">BluDrive</td>
                                <?php } else { ?>
                                    <td ng-if="value.adProductType=='sync'">BluDrive</td>
                                <?php } ?>
                                <td ng-if="value.adProductType=='backup'">BluVault</td>
                                <td ng-if="value.adProductType=='O365'">Office365</td>
                                <td>{{ value.adCn }}</td>
                                <td>
                                   <a style="margin-top: 5px;" class="btn btn-success btn-small" ng-click="getAdCredentials($index)">Edit</a>
                                    <a style="margin-top: 5px;" class="btn btn-danger btn-small removeCredentialsBtn{{$index}}" ng-click="removeAdCredentials($index)">Delete</a> 
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        </div>
                        <div ng-repeat="value in adcS track by $index" class="d-none col-lg-6 ng-scope block-ui block-ui-anim-fade" block-ui="myBlockUI" aria-busy="false">
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-language"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <span class="d-none" ng-if="value.userDn.length > 0">
                                        <a>Id: </a><a class="pull-right">{{ value.id }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.userDn.length > 0">
                                        <a>User Domain Name: </a><a ng-cloak class="pull-right">{{ value.userDn }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adPassword.length > 0">
                                        <a>Active Directory Password: </a><a ng-cloak class="pull-right">**********</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adUrl.length > 0">
                                        <a>Active Directory URL: </a><a ng-cloak class="pull-right">{{ value.adUrl }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adBase.length > 0">
                                        <a>Active Directory Base: </a><a ng-cloak class="pull-right">{{ value.adBase }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adGroupName.length > 0">
                                        <a>Active Directory Group Name: </a><a ng-cloak class="pull-right">{{ value.adGroupName }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adProductType.length > 0">
                                        <a>Active Directory Product Type: </a>
<?php if(DISABLE_BLUSYNC == false){ ?>
					<a ng-cloak ng-if="value.adProductType=='sync'" class="pull-right"> BluSync</a>
<?php } ?>
<?php if(DISABLE_BLUVAULT == false){ ?>
                                        <a ng-cloak ng-if="value.adProductType=='backup'" class="pull-right"> BluVault</a>
<?php } ?>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adBase.length > 0">
                                        <a>Active Directory Common Name: </a><a ng-cloak class="pull-right">{{ value.adCn }}</a>
                                        <br/>
                                    </span>
                                </div>
                                <div class="panel-footer">
                                    <a style="margin-top: 5px;" class="btn btn-primary btn-small" ng-click="getAdCredentials($index)">Edit</a>
                                    <a style="margin-top: 5px;" class="btn btn-danger btn-small removeCredentialsBtn{{$index}}" ng-click="removeAdCredentials($index)">Delete</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

<!-- kjdbvjdkbvjbf start -->
<div class="modal fade" id="addad" tabindex="-1" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?= Form::open(array(
                            'ng-submit' => 'saveAdCredentials("createAdCredentials")',
                            'class' => 'createAdCredentials',
			    'id' => 'createAdCredentials',
                            'csrf' => $data['csrf_token'],
                            'data-parsley-validate' => true,
                            'autocomplete' => 'off'
                            )); ?>
                            <div class="modal-header">
				<h4 class="modal-title"><?=Language::show('addYourActiveDirectoryCredentials', 'keywords')?></h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="d-none">
                                                <label for="pubkey">Public Key</label><br/>
                            <textarea id="pubkey" rows="15" cols="65">-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCqGKukO1De7zhZj6+H0qtjTkVxwTCpvKe4eCZ0
FPqri0cb2JZfXJ/DgYSF6vUpwmJG8wVQZKjeGcjDOL5UlsuusFncCzWBQ7RKNUSesmQRMSGkVb1/
3j+skZ6UtW+5u09lHNsj6tQ51s1SPrCBkedbNf0Tp0GbMJDyR4e9T04ZZwIDAQAB
-----END PUBLIC KEY-----</textarea><br/>
                        </div>
                                    <div class="form-group col-lg-6">
                                    <label for="userDn"><?=Language::show('userDomainName', 'keywords')?></label>
                                    <input type="text" class="form-control" name="userDn" id="userDn" value="" placeholder="Enter User Domains" required autocomplete="off" onfocusout="checkUserDn()">
                                    <span id="userDnerror" style="color: #f55753;font-size: 0.9em;"></span>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="adPassword"><?=Language::show('aDPassword', 'keywords')?></label>
                                    <input type="password" class="form-control" name="adPassword" id="adPassword" value="" placeholder="Enter Active Directory Password" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="adBase"><?=Language::show('aDBase', 'keywords')?></label>
                                    <input type="text" class="form-control" name="adBase" id="adBase" value="" placeholder="Enter Active Directory Base" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6" style="margin-bottom:25px !important;">
                                    <label for="adCn"><?=Language::show('activeDirectoryCommonName', 'keywords')?></label>
                                    <!--<input type="text" class="form-control" name="adCn" id="adCn" value="" placeholder="Enter your Active Directory Common Name" required autocomplete="off">-->
                                    <select class="form-control adCn selectpicker" name="adCn" id="adCn" title="Select Active Directory Common name" required="required" >
                                         <option value="cn"><?=Language::show('cn', 'keywords')?></option>
                                         <option value="sAMAccountName"><?=Language::show('sAMAccountName', 'keywords')?></option>
                                     </select>
                                </div>
                                <div class="form-group col-lg-6 adUrl">
                                    <label for="adUrl"><?=Language::show('aDUrl', 'keywords')?></label>
                                    <input type="text" class="form-control" name="adUrl" id="adUrl" value="" placeholder="Enter Active Directory URL" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6" style="margin-bottom:40px !important;">
                                    <label for="adPort"><?=Language::show('AD Port', 'keywords')?></label>
                                    <input type="number" class="form-control" name="adPort" id="adPort" value="" placeholder="Enter AD port number" autocomplete="off">
                                </div>
				<div class="form-group col-lg-6">
				    <label for="adProductType"><?=Language::show('Select Product Type', 'keywords')?></label>
                                    <select class="form-control adProductType selectpicker" name="adProductType" id="adProductType" title='Select Product Type' required>
                                        <?php if(Auth::checkCloudPermission('backup')){ ?>
                                        	<option value="BluVault"><?=Language::show('bluVault', 'keywords')?></option>
                                        <?php } ?>
                                        <?php if(Auth::checkCloudPermission('office365')){ ?>
                                        	<option value="O365"><?=Language::show('Office365', 'keywords')?></option>
                                        <?php } ?>
                                        <?php if(Auth::checkCloudPermission('sync')){ ?>
                                        	<?php if(BLUDRIVE_MODE == false){ ?>
                                        		<option value="BluSync"><?=Language::show('bluSync', 'keywords')?></option>
                                        	<?php } else { ?>
                                        		<option value="BluSync"><?=Language::show('BluDrive', 'keywords')?></option>
                                        	<?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="adGroupName"><?=Language::show('aDGroupName', 'keywords')?></label>
                                    <input type="text" class="form-control" name="adGroupName" id="adGroupName" value="" placeholder="Enter AD Group Name" autocomplete="off">
                                </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success createCredentialsBtn"><?=Language::show('Save', 'keywords')?></button>
                                <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>
                            </div>
                <?= Form::close(); ?>
                 </div>
        </div>
    </div>
<!-- jkdbvjdbvdbvj ends-->
                
                
    
                
          
    <div class="modal fade" id="editAdCredentialsModal" tabindex="-1" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                <?= Form::open(array(
                    'ng-submit' => 'editAdCredentials("editAdCredentials")',
                    'class' => 'editAdCredentials',
		    'id' => 'editAdCredentials',
                    'csrf' => $data['csrf_token'],
                    'autocomplete' => 'off',
                    'data-parsley-validate' => true
                )); ?>
                <div class="modal-header">
		    <h4 class="modal-title">Edit Active Directory Credentials</h4>
<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="row">
<div class="d-none">
                            <label for="privkey">Private Key</label><br/>
                <textarea id="privkey1" rows="15" cols="70">-----BEGIN RSA PRIVATE KEY-----
MIICXAIBAAKBgQCaVFCuBhZ2QmGjMKbazOBlO/NTClwVo+QQyzAG8Nun80ZIXtse
fSse7a0Objtp33PJO5ddPkHIZQ3KTzJnjIociZFUKWc1zRkDU6XCkRihPU+ujTv3
s0zUf/5KET6x3OorHALO7lZZOuHp3K73cGshaZ5fZz6fMPh3cBdgIcdXowIDAQAB
AoGAXfGxYx3Fkpt5//LfvxU0C6vgxM3rnCi17hsh0zfPHn+Sav+C9x5On3ci/0PO
2vXw77BcxZ/eP3R0XpCzKCF++ERXpooCN15/hSL1G9jtOvw0EnXFAc6LXXoqGFO4
kxusG2AHnVJNZmTsDbPZd1ZsHivPwIbWbpCJ8xpGftyw7iECQQD3gwl+++clfrl8
9d7ZA2BusEJrWitNfxRAezVn7QOIDmVjZNxigvfme0sFNfl14COKawrOxwccd5st
pbjd3kP7AkEAn581KHhP5R+L2oxsis+AOT2sn9AQhgJygK+V/avVpz66irdZoSa0
+s3Dbpx7vWe7nD73/pGCf/jZDLKcoY/CeQJAf8ikH24YERCS3QPnMG0A3UScleXw
k0r3fq7djLEd8KFWEPGioi1xpQmkWqVaDFRSpQTMiKLSdgz+DZwQjGNS/wJAAbR1
oOUIFW5s0/zD/AeTWwkpmttiEcxc5Lr7YyY+tfaZj3m931bGgBdKixfoynEdM+II
TBPJzQwfZV9TBPbAIQJBAMKSTyPoaxSgC0UwmC92apRG1+V8GRaa9wImRTMTwc8K
OxIsKjeIfgY8+bK3ATe/AR3wTMXLJ6tvFybS5FeIHGA=
-----END RSA PRIVATE KEY-----
</textarea>
<br/>
                <label for="pubkey">Public Key</label><br/>
<textarea id="pubkeyedit" rows="15" cols="70">-----BEGIN PUBLIC KEY-----
        MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDlOJu6TyygqxfWT7eLtGDwajtN
        FOb9I5XRb6khyfD1Yt3YiCgQWMNW649887VGJiGr/L5i2osbl8C9+WJTeucF+S76
        xFxdU6jE0NQ+Z+zEdhUTooNRaY5nZiu5PgDB0ED/ZKBUSLKL7eibMxZtMlUDHjm4
        gwQco1KRMDSmXSMkDwIDAQAB
        -----END PUBLIC KEY-----</textarea>
            </div>
                        <div class="form-group col-lg-6 d-none">
                            <label for="id">Id</label>
                            <input type="text" class="form-control" name="id" id="id" placeholder="id" required autocomplete="off" readonly>
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="userDn">User Domain</label>
                            <input type="text" class="form-control" name="userDn" id="editUserDn" placeholder="Enter User Domains" required autocomplete="off" readonly>
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adPassword">AD Password</label>
                            <input type="password" class="form-control" name="editAdPassword" id="editAdPassword" placeholder="Enter Active Directory Password" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adBase">AD Base</label>
                            <input type="text" class="form-control" name="adBase" id="editAdBase" placeholder="Enter Active Directory Base" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6" style="margin-bottom:20px !important;">
                            <label for="adCn">AD Common Name</label>
                            <!--<input type="text" class="form-control" name="adCn" id="editAdCn" placeholder="Enter your Active Directory Common Name" required autocomplete="off">-->
                            <select class="form-control editAdCn selectpicker" name="editAdCn" id="editAdCn" required="required" >
                                 <option value="cn"><?=Language::show('cn', 'keywords')?></option>
                                 <option value="sAMAccountName"><?=Language::show('sAMAccountName', 'keywords')?></option>
                             </select>
                        </div>
                        <div class="form-group col-lg-6 adUrl">
                            <label for="adUrl">AD URL</label>
                            <input type="text" class="form-control" name="adUrl" id="editAdUrl" placeholder="Enter Active Directory URL" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adPort"><?=Language::show('AD Port', 'keywords')?></label>
                            <input type="number" class="form-control" name="adPort" id="editAdPort" value="" placeholder="Enter AD port number" autocomplete="off">
                        </div>
				<div class="form-group col-lg-6">
				<label for="adProductType"><?=Language::show('Select Product Type', 'keywords')?></label>
		                    <select class="form-control adProductType selectpicker" name="adProductType" id="editAdProductType" title='Select Product Type' required>
                            	<?php if(Auth::checkCloudPermission('backup')){ ?>
                            	    <option value="BluVault"><?=Language::show('bluVault', 'keywords')?></option>
                                <?php } ?>
                                <?php if(Auth::checkCloudPermission('office365')){ ?>
                                	<option value="O365"><?=Language::show('Office365', 'keywords')?></option>
                                <?php } ?>
                                <?php if(Auth::checkCloudPermission('sync')){ ?>
                                	<?php if(BLUDRIVE_MODE == false){ ?>
                                		<option value="BluSync"><?=Language::show('bluSync', 'keywords')?></option>
                                	<?php } else { ?>
                                		<option value="BluSync"><?=Language::show('BluDrive', 'keywords')?></option>
                                	<?php } ?>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adGroupName">AD Group Name</label>
                            <input type="text" class="form-control" name="adGroupName" id="editAdGroupName" value="" placeholder="Enter AD Group Name" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success editCredentialsBtn">Save</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
</div>  </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
function checkUserDn(){
    var userDn = $('#userDn').val();
    if(userDn.startsWith(" ") || userDn.endsWith(" ")){
        $('#userDn').addClass('parsley-error');
        document.getElementById("adPassword").style.marginBottom = "40px";
        document.getElementById("userDnerror").innerHTML = "User Domain Name cannot have space in beginning or end";
    }else{
        $('#userDn').removeClass('parsley-error');
        document.getElementById("userDnerror").innerHTML = " ";
        document.getElementById("adPassword").style.marginBottom = "15px";
    }
}

</script>
