<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.4
* @date 23/07/19
* @time 16:10 PM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-12">
            <ol class="breadcrumb">
            <li><a href="<?=Url::basePath('pms')?>"><h3><?=$data['title']?></h3></a></li>
                <li><span><?='Microsoft Exchange Policy Mapping'?></span></li>
                <li><span><?=$data['crumb2']?></span></li>
            </ol>
        </div>
        <div class="col-lg-6 d-none">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11" block-ui="myBlockUI">
	    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
<span class="d-none currentPage"><?='multipleExchangePolicyMapping'?></span>
            <div class="panel">
            <div class="panel-heading">
                    <h4><?=$data['crumb2']?></h4>
                </div>
                <div class="panel-body">
                    <?php if(isMobile()){ ?>
                    <ul class="nav nav-pills nav-stacked" style="border: 1px solid #EC6621;border-radius: 10px;">
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link active" data-toggle="tab" data-target="#general" aria-expanded="true" aria-controls="general">General</a></li>
                      <li class="nav-item" style="display:unset !important;"><a class="nav-link" data-toggle="tab" data-target="#advanced" aria-expanded="false" aria-controls="advanced">Advanced</a></li>
                    </ul>
		            <?php } ?>
		            <?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" role="tablist" style="font-size: medium;font-weight: 600;">
                        <li role="presentation" class="nav-item"><a href="" class="nav-link active" data-target="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>                        
                        <li role="presentation" class="nav-item"><a href="" class="nav-link" data-target="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>
		            <?php } ?>
                    <div class="tab-content">
			            <div role="tabpanel" class="tab-pane active" id="general">
                            <br>
                            <div class="form-group">
                                <label for="policy"><?=Language::show('policyName', 'keywords');?></label><br/>
                                <select class="form-control selectPolicyPicker" name="multiplePolicyName" id="policy" required="" title='Select Policy'>
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){ 
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                                    <label for="userNames"><?=Language::show('Server Names', 'keywords');?></label>
                                    <a href="#" data-toggle="tooltip" data-placement="top" title="Enter comma separated list of user names"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    <br/>
                                <?php }else{ ?>
                                    <label for="userNames"><?=Language::show('User Names', 'keywords');?></label>
                                    <a href="#" data-toggle="tooltip" data-placement="top" title="Enter comma separated list of user names"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                    <br/>
                                <?php } ?>
                                <a href="javascript:;" class="btn btn-default" ngf-select="readUserNamesFromExcelOld($files)" <?php if(isMobile()){ ?> disabled <?php } ?>>
                                    <i class="share-icon fa fa-upload"> Import UserNames from Excel</i>
                                </a>
                                <a href="" ng-click="downloadSample('common')" style="<?php if(isMobile()){?>pointer-events:none;opacity: 0.5; <?php } ?>cursor: pointer;font-weight:600 !important;"><i class="fa fa-download"></i> Download template</a>
                                <p style="margin-top:10px;"><span>OR</span></p>
                                <input type="text" data-role="tagsinput" value="" class="form-control" name="userNames[]" id="userNames" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('userNames', 'keywords');?>" required autocomplete="off">
                            </div>
                            <div class="form-group">
                                <a ng-click="changeMultipleOneDrivePolicyOld()" class="btn btn-success pmsSavePolicyBtn"><i class="fa fa-save"></i> Save</a>
                                <a class="btn btn-danger" href="<?=Url::basePath('pms')?>"><i class="fa fa-times"></i> Cancel</a>
                                <a id="policyDump" ng-click="downloadSample('downloadDump')" class="btn btn-success btn-small pull-right" style="display:none;">Download List</a>
                            </div>
			            </div>
			            <div role="tabpanel" class="tab-pane" id="advanced">
                            <br>
                            <div class="form-group">
                                <a href="javascript:;" class="btn btn-default" ngf-select="readUserNamesFromExcelAdvanced($files)" <?php if(isMobile()){ ?> disabled <?php } ?>>
                                    <i class="share-icon fa fa-upload"> Import Excel</i>
                                </a>
                                <a href="" ng-click="downloadSample('common1')" style="<?php if(isMobile()){?>pointer-events:none;opacity: 0.5; <?php } ?>cursor: pointer;font-weight:600 !important;"><i class="fa fa-download"></i> Download template</a>
                                <p class="hide" style="margin-top:10px;"><span>OR</span></p>
                            </div>                    
                            <div class="row unMapped col-lg-12" style="display: none;">
                                <div class="panel-heading">
                                    <h3>
                                        User Policy mapping status
                                        <a id="unMappedDump" ng-click="downloadSample('downloadDump')" class="btn btn-success btn-small pull-right" style="display:none;">Download List</a>
                                        <span id="unMappedDumpStatement" style="color: #f55753;font-size: 0.7em !important;"></span>
                                    </h3>
                                </div>
                            </div>
			        </div>
                </div>                                       
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.selectPolicyPicker').selectpicker('render');
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
//    $(".assignUsers").select2({
//        ajax: {
//            url: "<?//=DIR?>//"+"user/searchUserName",
//            dataType: 'json',
//            delay: 250,
//            data: function (params) {
//                return {
//                    q: params.term, // search term
//                    page: params.page
//                };
//            },
//            processResults: function (data, params) {
//                params.page = params.page || 1;
//                if(data.users.length > 0){
//                    $('.assignSaveBtn').removeAttr('disabled');
//                }
//                return {
//                    results: $.map(data.users, function (o) {
//                        return { id: o.userName, text: o.userName, img: o.profilePic };
//                    }),
//                    pagination: {
//                        more: (params.page * 30) < data.total_count
//                    }
//                };
//            },
//            cache: true
//        },
//        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
//        minimumInputLength: 0,
//        templateResult: selectTemplateResult,
//        templateSelection: selectTemplateSelection,
//        placeholder: 'Select user names/server names'
//    });
//
//    function selectTemplateResult(users){
//        if(users.text != undefined){
//            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
//            if(users.img){
//              template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
//            }
//            template += users.text + "</div></div>";
//            return template;
//        }else{
//            return "<div class='select2-user-result'>Fetching...</div>";
//        }
//    }
//
//    function selectTemplateSelection(users){
//        return users.text;
//    }
</script>
