<?php
use \Core\View;
use Helpers\Url;
use Core\Language;

 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('migration')?>"><?=Language::show('userMigration', 'report')?></a></h3></li>
                <?php if($data['isLdapEnabled'] == 'true') { ?>
                    <li><?=$data['crumb1']?></li>
                <?php } else { ?>
                    <li>Import Users from Azure Active Directory</li>
                <?php } ?>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="MigrationController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token d-none"><?=$data['csrf_token']?></span>
            <span class="currentPage d-none"><?='importUsers'?></span>
            <div class="row">
                <div class="panel panel-default col-lg-12">
                    <div class="panel-heading">
                       <?php if($data['isLdapEnabled'] == 'true') { ?>
                            <h3>Import Users From AD</h3>
                        <?php } else { ?>
                            <h3>Import Users From AAD</h3>
                        <?php } ?>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="bs-callout bs-callout-primary" style="padding-top: 10px; padding-bottom: 1px;">
                                    <p>
                                        Enter comma separated list of usernames.
                                        <?php if($data['isLdapEnabled'] == 'true') { ?>
                                            <br/>Usernames will be matched with Active Directory for verification.
                                        <?php } else { ?>
                                            <br/>Usernames will be matched with Azure Active Directory for verification.
                                        <?php } ?>
                                        <br/>This is to be used by ParaBlu team only. Handle with care as this can corrupt the entire system.
                                        <br/>Excel Upload : Excel sheet should contain a column called usernames and all the users should be mentioned only in the column.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <a href="javascript:;" class="btn btn-default"
                                   ngf-select="readUserNamesFromExcel($files)" <?php if(isMobile()){ ?> disabled <?php } ?>>
                                    <i class="share-icon fa fa-upload"> Import Usernames from Excel</i>
                                </a>
                                <a href="" ng-click="downloadSample()" style="<?php if(isMobile()){?>pointer-events:none;opacity: 0.5; <?php } ?>cursor: pointer;font-weight:600 !important;"><i class="fa fa-download"></i> Download template</a>
                                </br>
                                <?php if(isMobile()){ ?>
                                    <span class="help-line text-muted">Note:- Bulk Import feature is available from your workstation.</span>
                                <?php } ?>
                            </div>
                        </div>
                        <br/>
                        <div class="row col-lg-12">
                            <div class="form-group col-lg-12">
                                <label for="migrationType"><?=Language::show('Migration Type', 'keywords');?></label><br/>
                                <select class="form-control selectPicker" name="migrationType" id="migrationType" required="" title='Select Migration Type'>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <option value="backup">BluVault</option>
                                    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                                        <option value="exchange">Microsoft Exchange</option>
                                    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                                        <option value="sharepoint">SharePoint</option>
                                    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                                        <option value="onedrive">OneDrive for Business</option>
                                    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                        <option value="sync">BluSync</option>
                                    <?php } ?>
                                    <option value="both">All</option>
                                </select>
                            </div>
<?php if(DISABLE_BLUVAULT == false){ ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                            <div class="form-group policyDiv col-lg-6">
                                <label class="star" for="policy">BluVault Policy Name</label><br/>
                                <select class="form-control selectPolicyPicker" ng-model="policy" name="policy" id="policy" required="" title='Select a Policy for Backup'>
                                    <?php if(!empty($data['policies1'])){ ?>
                                        <?php foreach($data['policies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>"><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
<?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                            <div class="form-group exchangePolicyDiv col-lg-6">
                                <label class="star" for="exchangePolicy"><?=Language::show('Microsoft Exchange Policy Name', 'keywords');?></label><br/>
                                <select class="form-control selectExchangePolicyPicker" ng-model="exchangePolicy" name="exchangePolicy" id="exchangePolicy" required="" title='Select a Microsoft Exchange Policy'>
                                        <?php if(!empty($data['exchangePolicies1'])){ ?>
                                            <?php foreach($data['exchangePolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                            <div class="form-group sharepointPolicyDiv col-lg-6">
                                <label class="star" for="sharepointPolicy"><?=Language::show('Sharepoint Policy Name', 'keywords');?></label><br/>
                                <select class="form-control selectSharepointPolicyPicker" ng-model="sharepointPolicy" name="sharepointPolicy" id="sharepointPolicy" required="" title='Select a Sharepoint Policy'>
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                            <div class="form-group onedrivePolicyDiv col-lg-6">
                                <label class="star" for="onedrivePolicy"><?=Language::show('OneDrive for Business Policy Name', 'keywords');?></label><br/>
                                <select class="form-control selectOnedrivePolicyPicker" ng-model="onedrivePolicy" name="onedrivePolicy" id="onedrivePolicy" required="" title='Select a OneDrive for Business Policy'>
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                            <?php if(DISABLE_BLUSYNC == false){ ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                            <div class="form-group syncPolicyDiv col-lg-6">
                                <label class="star" for="syncPolicy">BluSync Policy Name </label><br/>
                                <select class="form-control selectSyncPolicyPicker" ng-model="syncPolicy" name="syncPolicy" id="syncPolicy" required="" title='Select a Policy for BluSync'>
                                    <?php if(!empty($data['syncPolicies1'])){ ?>
                                        <?php foreach($data['syncPolicies1'] as $key => $value){
                                        $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                        ?>
                                            <option value="<?=$value?>"><?=$label?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <?php } ?>
                            <?php } ?>
                            <div class="form-group col-lg-6 hide">
                                <label for="relax"><?=Language::show('relax', 'keywords');?></label>
                                <input type="text" class="form-control" name="relax" id="relax" <?php if(RELAXED_CHECK == true){?> value="relaxed" <?php } else { ?> value="notrelaxed" <?php } ?>>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="userNames"><?=Language::show('userNames', 'keywords');?></label>
                                <a href="#" data-toggle="tooltip" data-placement="top" title="Enter comma separated list of user names"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                <br/>
                                <input type="text" data-role="tagsinput" value="" class="form-control" name="userNames[]" id="userNames" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('userNames', 'keywords');?>" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-12">
                                <?php if($data['isLdapEnabled'] == 'true') { ?>
                                    <a ng-click="getUsers(policy, syncPolicy, exchangePolicy , sharepointPolicy, onedrivePolicy)" class="btn btn-success"><i class="fa fa-save"></i> Import</a>
                                <?php } else { ?>
                                    <a ng-click="getUsersAAD(policy, syncPolicy, exchangePolicy , sharepointPolicy, onedrivePolicy)" class="btn btn-success"><i class="fa fa-save"></i> Import</a>
                                <?php } ?>
                                <a class="btn btn-danger" href="<?=Url::basePath('migration')?>"><i class="fa fa-times"></i> Cancel</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row migrationDetails" style="display: none;">
                <div class="panel panel-default col-lg-12">
                    <div class="panel-heading">
                        <h3>
                            User Migration Details - {{ userList.length+' users' }}
                            <?php if($data['isLdapEnabled'] == 'true') { ?>
                            <a ng-click="startMigrating()" class="btn btn-success btn-small pull-right">Start Migrating Users</a>
                            <?php } else { ?>
                            <a ng-click="startMigratingAAD()" class="btn btn-success btn-small pull-right">Start Migrating Users</a>
                            <?php } ?>
                        </h3>
                    </div>
                    <div class="panel-body table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>First Name</th>
                                    <th>Email Address</th>
                                    <?php if($data['isLdapEnabled'] == 'true') { ?>
                                        <th>OU</th>
                                    <?php } ?>
                                    <?php if(DISABLE_BLUVAULT == false){ ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <th>Backup Policy</th>
                                    <?php } ?>
                                    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                                        <th>Microsoft Exchange Policy</th>
                                    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                                        <th>Sharepoint Policy</th>
                                    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                                        <th>OneDrive for Business Policy</th>
                                    <?php } ?>
                                    <?php if(DISABLE_BLUSYNC == false){ ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                        <th>BluSync Policy </th>
                                    <?php } ?>
                                    <?php } ?>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="value in userList track by $index">
                                    <td ng-cloak>{{ value.userName }}</td>
                                    <?php if($data['isLdapEnabled'] == 'true') { ?>
                                    	 <td ng-cloak>{{ value.emailId }}</td>
                                     <?php } else { ?>
                                      <td ng-cloak>{{ value.mail }}</td>
                                     <?php } ?>
                                    <?php if($data['isLdapEnabled'] == 'true') { ?>
                                        <td ng-cloak>{{ value.organizationUnit }}</td>
                                    <?php } ?>
<?php if(DISABLE_BLUVAULT == false){ ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                    <td class="policy">
                                        <span ng-if="value.defaultPolicy !=''" class="selectedPolicySpan{{$index}}" ng-cloak>{{ value.defaultPolicy }}</span>
                                        <span ng-if="value.defaultPolicy ==''" class="selectedPolicySpan{{$index}}" ng-cloak>NA</span>
                                        <div class="form-group selectPolicyPicker{{$index}}" style="display: none;">
                                            <select class="form-control" name="selectedPolicy{{$index}}" required>
                                                <?php if(!empty($data['policies1'])){ ?>
                                                    <?php foreach($data['policies1'] as $key => $value){
                                                        $label = $value;
                                                        if( strlen( $label ) > 25 ) {
                                                           $label = substr( $label, 0, 25 ) . '...';
                                                        }
                                                    ?>
                                                        <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </td>
                                    <?php } ?>
<?php } ?>
<?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                                    <td class="exchangePolicy">
                                        <span ng-if="value.defaultExchangePolicy !=''" class="selectedExchangePolicySpan{{$index}}" ng-cloak>{{ value.defaultExchangePolicy }}</span>
                                        <span ng-if="value.defaultExchangePolicy ==''" class="selectedExchangePolicySpan{{$index}}" ng-cloak>NA</span>
                                        <div class="form-group selectExchangePolicyPicker{{$index}}" style="display: none;">
                                            <select class="form-control" name="selectedExchangePolicy{{$index}}" required>
                                                <?php if(!empty($data['exchangePolicies1'])){ ?>
                                                    <?php foreach($data['exchangePolicies1'] as $key => $value){
                                                    $label = $value['name'];
                                                    if( strlen( $label ) > 25 ) {
                                                       $label = substr( $label, 0, 25 ) . '...';
                                                    }
                                                    ?>
                                                    <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </td>
                                    <?php } ?>
<?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                                    <td class="sharepointPolicy">
                                        <span ng-if="value.defaultSharepointPolicy !=''" class="selectedSharepointPolicySpan{{$index}}" ng-cloak>{{ value.defaultSharepointPolicy }}</span>
                                        <span ng-if="value.defaultSharepointPolicy ==''" class="selectedSharepointPolicySpan{{$index}}" ng-cloak>NA</span>
                                        <div class="form-group selectSharepointPolicyPicker{{$index}}" style="display: none;">
                                            <select class="form-control" name="selectedSharepointPolicy{{$index}}" required>
                                                <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                                    <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                                    $label = $value['name'];
                                                    if( strlen( $label ) > 25 ) {
                                                       $label = substr( $label, 0, 25 ) . '...';
                                                    }
                                                    ?>
                                                    <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </td>
                                    <?php } ?>
<?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                                    <td class="onedrivePolicy">
                                        <span ng-if="value.defaultOdbPolicy !=''" class="selectedOdbPolicySpan{{$index}}" ng-cloak>{{ value.defaultOdbPolicy }}</span>
                                        <span ng-if="value.defaultOdbPolicy ==''" class="selectedOdbPolicySpan{{$index}}" ng-cloak>NA</span>
                                        <div class="form-group selectOdbPolicyPicker{{$index}}" style="display: none;">
                                            <select class="form-control" name="selectedOdbPolicy{{$index}}" required>
                                                <?php if(!empty($data['odbPolicies1'])){ ?>
                                                    <?php foreach($data['odbPolicies1'] as $key => $value){
                                                    $label = $value['name'];
                                                    if( strlen( $label ) > 25 ) {
                                                       $label = substr( $label, 0, 25 ) . '...';
                                                    }
                                                    ?>
                                                    <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </td>
                                    <?php } ?>
<?php if(DISABLE_BLUSYNC == false){ ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                    <td class="syncPolicy">
                                        <span ng-if="value.defaultSyncPolicy !=''" class="selectedSyncPolicySpan{{$index}}" ng-cloak>{{ value.defaultSyncPolicy }}</span>
                                        <span ng-if="value.defaultSyncPolicy ==''" class="selectedPolicySpan{{$index}}" ng-cloak>NA</span>
                                        <div class="form-group selectSyncPolicyPicker{{$index}}" style="display: none;">
                                            <select class="form-control" name="selectedSyncPolicy{{$index}}" required>
                                                <?php if(!empty($data['syncPolicies1'])){ ?>
                                                    <?php foreach($data['syncPolicies1'] as $key => $value){
                                                        $label = $value;
                                                        if( strlen( $label ) > 25 ) {
                                                           $label = substr( $label, 0, 25 ) . '...';
                                                        }
                                                    ?>
                                                        <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </td>
                                    <?php } ?>
<?php } ?>
                                    <td>
<?php if(DISABLE_BLUVAULT == false){ ?>
<?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <span ng-show="value.defaultPolicy == ''">NA</span>
                                        <span ng-hide="value.defaultPolicy == ''">
                                            <a ng-click="changePolicy(value.defaultPolicy, $index)" class="btn btn-default btn-small changePolicyBtn{{$index}}">Change Backup Policy</a>
                                            <a ng-click="savePolicy($index)" class="btn btn-success btn-small savePolicyBtn{{$index}}" style="display: none;">Save Backup Policy</a>
                                        </span>
                                        <?php } ?>
<?php } ?>
<?php if(\Helpers\Auth::checkCloudPermission('exchange')){ ?>
                                        <span ng-show="value.defaultExchangePolicy == ''">NA</span>
                                        <span ng-hide="value.defaultExchangePolicy == ''">
                                            <a ng-click="changeExchangePolicy(value.defaultExchangePolicy, $index)" class="btn btn-default btn-small changeExchangePolicyBtn{{$index}}">Change Microsoft Exchange Policy</a>
                                            <a ng-click="saveExchangePolicy($index)" class="btn btn-success btn-small saveExchangePolicyBtn{{$index}}" style="display: none;">Save Microsoft Exchange Policy</a>
                                        </span>
                                        <?php } ?>
<?php if(\Helpers\Auth::checkCloudPermission('sharepoint')){ ?>
                                        <span ng-show="value.defaultSharepointPolicy == ''">NA</span>
                                        <span ng-hide="value.defaultSharepointPolicy == ''">
                                            <a ng-click="changeSharepointPolicy(value.defaultSharepointPolicy, $index)" class="btn btn-default btn-small changeSharepointPolicyBtn{{$index}}">Change Sharepoint Policy</a>
                                            <a ng-click="saveSharepointPolicy($index)" class="btn btn-success btn-small saveSharepointPolicyBtn{{$index}}" style="display: none;">Save Sharepoint Policy</a>
                                        </span>
                                        <?php } ?>
<?php if(\Helpers\Auth::checkCloudPermission('onedrive')){ ?>
                                        <span ng-show="value.defaultOdbPolicy == ''">NA</span>
                                        <span ng-hide="value.defaultOdbPolicy == ''">
                                            <a ng-click="changeOdbPolicy(value.defaultOdbPolicy, $index)" class="btn btn-default btn-small changeOdbPolicyBtn{{$index}}">Change OneDrive for Business Policy</a>
                                            <a ng-click="saveOdbPolicy($index)" class="btn btn-success btn-small saveOdbPolicyBtn{{$index}}" style="display: none;">Save OneDrive for Business Policy</a>
                                        </span>
                                        <?php } ?>                                     
<?php if(DISABLE_BLUSYNC == false){ ?>
<?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                        <span ng-show="value.defaultSyncPolicy == ''">NA</span>
                                        <span ng-hide="value.defaultSyncPolicy == ''">
                                            <a ng-click="changeSyncPolicy(value.defaultSyncPolicy, $index)" class="btn btn-default btn-small changeSyncPolicyBtn{{$index}}">Change BluSync Policy </a>
                                            <a ng-click="saveSyncPolicy($index)" class="btn btn-success btn-small saveSyncPolicyBtn{{$index}}" style="display: none;">Save BluSync Policy </a>
                                        </span>
                                        <?php } ?>
<?php } ?>
                                        <span>
                                            <a ng-click="removeRow($index)" class="btn btn-small btn-danger clickAble"><i class="fa fa-times"></i></a>
                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.selectPolicyPicker').selectpicker('render');
    $('.selectPolicyPickerEdit').selectpicker('render');
    $('.selectSyncPolicyPicker').selectpicker('render');
    $('.selectSyncPolicyPickerEdit').selectpicker('render');
    $('.selectExchangePolicyPicker').selectpicker('render');
    $('.selectExchangePolicyPickerEdit').selectpicker('render');
    $('.selectSharepointPolicyPicker').selectpicker('render');
    $('.selectSharepointPolicyPickerEdit').selectpicker('render');
    $('.selectOnedrivePolicyPicker').selectpicker('render');
    $('.selectOnedrivePolicyPickerEdit').selectpicker('render');
    $('.selecto365PolicyPicker').selectpicker('render');
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/MigrationController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('[name="migrationType"]').on('change', function(){
            var migrationType = $('#migrationType').val();
            console.log("migrationType : "+migrationType);
        if(migrationType == 'sync'){
            $('.selectPolicyPicker').prop('disabled', true);
            $('.selectPolicyPicker').selectpicker('refresh');
            $('.selectSyncPolicyPicker').prop('disabled', false);
            $('.selectSyncPolicyPicker').selectpicker('refresh');
//            $('.selecto365PolicyPicker').prop('disabled', true);
//          $('.selecto365PolicyPicker').selectpicker('refresh');
            $('.selectExchangePolicyPicker').prop('disabled', true);
            $('.selectExchangePolicyPicker').selectpicker('refresh');
            $('.selectSharepointPolicyPicker').prop('disabled', true);
            $('.selectSharepointPolicyPicker').selectpicker('refresh');
            $('.selectOnedrivePolicyPicker').prop('disabled', true);
            $('.selectOnedrivePolicyPicker').selectpicker('refresh');
        }else if(migrationType == 'backup'){
            $('.selectPolicyPicker').prop('disabled', false);
            $('.selectPolicyPicker').selectpicker('refresh');
            $('.selectSyncPolicyPicker').prop('disabled', true);
            $('.selectSyncPolicyPicker').selectpicker('refresh');
//            $('.selecto365PolicyPicker').prop('disabled', true);
//          $('.selecto365PolicyPicker').selectpicker('refresh');
            $('.selectExchangePolicyPicker').prop('disabled', true);
            $('.selectExchangePolicyPicker').selectpicker('refresh');
            $('.selectSharepointPolicyPicker').prop('disabled', true);
            $('.selectSharepointPolicyPicker').selectpicker('refresh');
            $('.selectOnedrivePolicyPicker').prop('disabled', true);
            $('.selectOnedrivePolicyPicker').selectpicker('refresh');
        }else if(migrationType == 'exchange'){
//            $('.selecto365PolicyPicker').prop('disabled', false);
//          $('.selecto365PolicyPicker').selectpicker('refresh');
            $('.selectExchangePolicyPicker').prop('disabled', false);
            $('.selectExchangePolicyPicker').selectpicker('refresh');
            $('.selectPolicyPicker').prop('disabled', true);
            $('.selectPolicyPicker').selectpicker('refresh');
            $('.selectSyncPolicyPicker').prop('disabled', true);
            $('.selectSyncPolicyPicker').selectpicker('refresh');
            $('.selectSharepointPolicyPicker').prop('disabled', true);
            $('.selectSharepointPolicyPicker').selectpicker('refresh');
            $('.selectOnedrivePolicyPicker').prop('disabled', true);
            $('.selectOnedrivePolicyPicker').selectpicker('refresh');
        }else if(migrationType == 'sharepoint'){
//            $('.selecto365PolicyPicker').prop('disabled', false);
//          $('.selecto365PolicyPicker').selectpicker('refresh');
            $('.selectSharepointPolicyPicker').prop('disabled', false);
            $('.selectSharepointPolicyPicker').selectpicker('refresh');
            $('.selectPolicyPicker').prop('disabled', true);
            $('.selectPolicyPicker').selectpicker('refresh');
            $('.selectSyncPolicyPicker').prop('disabled', true);
            $('.selectSyncPolicyPicker').selectpicker('refresh');
            $('.selectExchangePolicyPicker').prop('disabled', true);
            $('.selectExchangePolicyPicker').selectpicker('refresh');
            $('.selectOnedrivePolicyPicker').prop('disabled', true);
            $('.selectOnedrivePolicyPicker').selectpicker('refresh');
        }else if(migrationType == 'onedrive'){
//            $('.selecto365PolicyPicker').prop('disabled', false);
//          $('.selecto365PolicyPicker').selectpicker('refresh');
            $('.selectOnedrivePolicyPicker').prop('disabled', false);
            $('.selectOnedrivePolicyPicker').selectpicker('refresh');
            $('.selectPolicyPicker').prop('disabled', true);
            $('.selectPolicyPicker').selectpicker('refresh');
            $('.selectSyncPolicyPicker').prop('disabled', true);
            $('.selectSyncPolicyPicker').selectpicker('refresh');
            $('.selectSharepointPolicyPicker').prop('disabled', true);
            $('.selectSharepointPolicyPicker').selectpicker('refresh');
            $('.selectExchangePolicyPicker').prop('disabled', true);
            $('.selectExchangePolicyPicker').selectpicker('refresh');
        }else{
            $('.selectPolicyPicker').prop('disabled', false);
            $('.selectPolicyPicker').selectpicker('refresh');
            $('.selectSyncPolicyPicker').prop('disabled', false);
            $('.selectSyncPolicyPicker').selectpicker('refresh');
            $('.selectExchangePolicyPicker').prop('disabled', false);
            $('.selectExchangePolicyPicker').selectpicker('refresh');
            $('.selectSharepointPolicyPicker').prop('disabled', false);
            $('.selectSharepointPolicyPicker').selectpicker('refresh');
            $('.selectOnedrivePolicyPicker').prop('disabled', false);
            $('.selectOnedrivePolicyPicker').selectpicker('refresh');
            $('#syncPolicy').attr('required', 'required');
            $('#policy').attr('required', 'required');
            $('#exchangePolicy').attr('required', 'required');
            $('#sharepointPolicy').attr('required', 'required');
            $('#onedrivePolicy').attr('required', 'required');
        }
    });         
</script>
<script>
$('#userNames').tagsinput({
  trimValue: true
});
</script>
