<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.5.5.2
* @date 28/10/2022
* @time 18:30 PM
*
*/
?>
<div class="container">
    <div>
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <!--<li><?=$data['crumb1']?></li>-->
            </ol>
        </div>
        <div class="col-lg-6">
        </div>
    </div>
</div>
<div class="main" ng-controller="BackupController">
    <span class="d-none currentPage"><?='manageDevices'?></span>
    <span class="d-none csrf_token"><?=$data['csrf_token']?></span>
    <span class="d-none selectedUser"><?=$data['selectedUser']?></span>
    <span class="d-none userType"><?=$data['userType']?></span>
    <span class="d-none rwDetectionEnabled"><?=$data['rwDetectionEnabled']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <!--<div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body">
                    <ul class="nav navbar-nav">
                        <li class="listOfDevices"><a style="color: #000 !important;">List of All Devices</a></li>
                    </ul>
                </div>
	    </div>-->
            <!--new start-->
            <?php if(isMobile()){ ?>
		    <ul class="nav nav-pills flex-column" style="border: 1px solid #EC6621;border-radius: 10px;">
			<?php if(Auth::checkCloudPermission('backup')){ ?>
			    <li class="nav-item" style="display:unset !important;"><a class="nav-link <?php echo $data['activeTabBackup'];?>" data-target="#backup" aria-controls="backup" aria-expanded="true" data-toggle="tab">BluVault</a></li>
			<?php } ?>
			<?php if(Auth::checkCloudPermission('exchange')){ ?>
			    <li class="nav-item" style="display:unset !important;"><a class="nav-link <?php echo $data['activeTabExchange'];?>" data-target="#exchange" aria-controls="exchange" aria-expanded="false" data-toggle="tab">Microsoft Exchange</a></li>
			<?php } ?>
			<?php if(Auth::checkCloudPermission('sharepoint')){ ?>
			    <li class="nav-item" style="display:unset !important;"><a class="nav-link <?php echo $data['activeTabSharepoint'];?>" data-target="#sharepoint" aria-controls="sharepoint" aria-expanded="false" data-toggle="tab">SharePoint</a></li>
			<?php } ?>
			<?php if(Auth::checkCloudPermission('onedrive')){ ?>
			    <li class="nav-item" style="display:unset !important;"><a class="nav-link <?php echo $data['activeTabOnedrive'];?>" data-target="#onedrive" aria-controls="onedrive" aria-expanded="false" data-toggle="tab">OneDrive for Business</a></li>
			<?php } ?>
		    </ul>
            <?php } ?>
            <?php if(!isMobile()){ ?>
                    <ul class="nav nav-tabs" role="tablist" style="font-weight: 600;<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>">                
                        <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                            <li role="presentation" class="nav-item"><a href="" class="nav-link <?php echo $data['activeTabBackup'];?>" data-target="#backup" aria-controls="backup" role="tab" data-toggle="tab">BluVault</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('exchange')){ ?>
                            <li role="presentation" class="nav-item"><a href="" class="nav-link <?php echo $data['activeTabExchange'];?>" data-target="#exchange" aria-controls="exchange" role="tab" data-toggle="tab">Microsoft Exchange</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('sharepoint')){ ?>
                            <li role="presentation" class="nav-item"><a href="" class="nav-link <?php echo $data['activeTabSharepoint'];?>" data-target="#sharepoint" aria-controls="sharepoint" role="tab" data-toggle="tab">SharePoint</a></li>
                        <?php } ?>
                        <?php if(Auth::checkCloudPermission('onedrive')){ ?>
                            <li role="presentation" class="nav-item"><a href="" class="nav-link <?php echo $data['activeTabOnedrive'];?>" data-target="#onedrive" aria-controls="onedrive" role="tab" data-toggle="tab">OneDrive for Business</a></li>
                        <?php } ?>
                    </ul>
            <?php } ?>
            <!--new end-->		
                                    
            <div class="tab-content">
		<div role="tabpanel" class="tab-pane <?php echo $data['activeTabBackup'];?>" id="backup">
		<br>
		<!--backup start-->
		<div class="panel panel-default files-panel no-box-shadow">
                <div class="status" style="display: none; text-align: center;margin:20px;">Loading ...</div>
                <div class="table-responsive devicesList" style="display: none;">
		    <div class="form-group col-lg-12" style="margin-top:10px;">
                    	<input class="form-control" type="text" id="searchBluvaultInput" onkeyup="searchedBluvaultDevices()" placeholder="Search for Devices.." title="Type in a Device Name">
                    </div>
                    <table class="table table-bordered table-striped table-hover files-table" id="devicesListTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Device
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
			    <th class="text-left clickAble" ng-click="sortType = 'userNamePlain'; sortReverse = !sortReverse">
                                UserName
                                <span ng-show="sortType == 'userNamePlain' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'userNamePlain' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                Status
                                <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'createdOn'; sortReverse = !sortReverse">
                                Device Configured on
                                <span ng-show="sortType == 'createdOn' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'createdOn' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Last Successful Backup
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
			    <th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Action
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody class="clickAble">
                        <tr ng-repeat="value in devices | orderBy:sortType:sortReverse track by $index">
                            <td class="text-left" title="{{ value.name }}" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> {{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</td>
                            <td class="text-left" title="{{ value.userNamePlain }}" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.userNamePlain  | limitTo:20 }}{{value.userNamePlain.length > 20 ? '...' : ''}}</td>
			    <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.status }}</td>
                            <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.createdOn}}</td>
			    <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.lastSuccessfullBackup}}</td>
			    <td class="text-left">
				<a ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management">Backup Management</a>
				<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore">Restore</a>
				<?php //if($data['showRestore'] == 'no'){?>
				    <!--<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="background-color: gainsboro !important;pointer-events:none !important;">Restore</a>-->
				<?php //} ?>
				<?php //if($data['showRestore'] == 'yes'){?>
				    <?php //if($data['allowEndUserTocontrolRestore'] == 'yes'){?>
				    	<!--<a ng-class="{false:'invalid'}[value.canAdminRestore]" ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore">Restore</a>-->
				    <?php //}else{ ?>
				    	<!--<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore">Restore</a>-->
				    <?php //} ?>
				<?php //} ?>
				<!--<a ng-click="initiateRestoreForDeviceManage(value.uuId,value.deviceType, value.quarantineDevice, value.blocked, value.userNamePlain, value.name)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Initiate Restore">Initiate Restore</a>-->
				<a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameNew }}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a>
			    </td>
                        </tr>
                        </tbody>
                    </table>
		</div>
		<div class="row devicesListTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" title="First" ng-click="manageDevicesNavigate('backup', first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" title="Previous" ng-click="manageDevicesNavigate('backup', previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" title="Next" ng-click="manageDevicesNavigate('backup', next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" title="Last" ng-click="manageDevicesNavigate('backup', last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div>
            </div>
		    <!--backup ends--> 
		    </div>
		    <div role="tabpanel" class="tab-pane <?php echo $data['activeTabOnedrive'];?>" id="onedrive">
		<br>
		<!--onedrive start-->
		<div class="panel panel-default files-panel no-box-shadow">
                <div class="statusOneDrive" style="display: none; text-align: center;margin:20px;">Loading ...</div>
                <div class="table-responsive devicesListOneDrive" style="display: none;">
		    <div class="form-group col-lg-12" style="margin-top:10px;">
                    	<input class="form-control" type="text" id="searchOnedriveInput" onkeyup="searchedOnedriveDevices()" placeholder="Search for Devices.." title="Type in a Device Name">
                    </div>
                    <table class="table table-bordered table-striped table-hover files-table" id="devicesListOnedriveTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Device
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
			    <th class="text-left clickAble" ng-click="sortType = 'userNamePlain'; sortReverse = !sortReverse">
                                UserName
                                <span ng-show="sortType == 'userNamePlain' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'userNamePlain' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                Status
                                <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'createdOn'; sortReverse = !sortReverse">
                                Device Configured on
                                <span ng-show="sortType == 'createdOn' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'createdOn' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Last Successful Backup
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Action
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody class="clickAble">
                        <tr ng-repeat="value in devicesOneDrive | orderBy:sortType:sortReverse track by $index">
                            <td class="text-left" title="{{ value.name }}" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> {{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</td>
                            <td class="text-left" title="{{ value.userNamePlain }}" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.userNamePlain  | limitTo:20 }}{{value.userNamePlain.length > 20 ? '...' : ''}}</td>
			    <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.status }}</td>
                            <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.createdOn}}</td>
                            <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.lastSuccessfullBackup}}</td>
			    <td class="text-left">
				<a ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management">Backup Management</a>
				<?php if($data['showRestore'] == 'no'){?>
				    <a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="background-color: gainsboro !important;pointer-events:none !important;">Restore</a>
				<?php } ?>
				<?php if($data['showRestore'] == 'yes'){?>
				    <?php if($data['allowEndUserTocontrolRestore'] == 'yes'){?>
				    	<a ng-class="{false:'invalid'}[value.canAdminRestore]" ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore">Restore</a>
				    <?php }else{ ?>
				    	<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore">Restore</a>				
				    <?php } ?>
				<?php } ?>
				<!--<a ng-click="initiateRestoreForDeviceOnedriveManage(value.uuId,value.deviceType, value.quarantineDevice, value.blocked, value.userNamePlain, value.name)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Initiate Restore">Initiate Restore</a>-->
				<a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameNew }}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a>
			    </td>
                        </tr>
                        </tbody>
                    </table>
		</div>
		<div class="row devicesListOnedriveTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountOnedrive}} of {{totalpageCountOnedrive}}</span></p>
                            <a class="btn btn-primary firstOnedrive" title="First" ng-click="manageDevicesOneDriveNavigate('ODB', firstOnedrive)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousOnedrive" title="Previous" ng-click="manageDevicesOneDriveNavigate('ODB', previousOnedrive)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextOnedrive" title="Next" ng-click="manageDevicesOneDriveNavigate('ODB', nextOnedrive)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastOnedrive" title="Last" ng-click="manageDevicesOneDriveNavigate('ODB', lastOnedrive)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div>
            </div>
		    <!--onedrive ends-->
		    </div>
		    <div role="tabpanel" class="tab-pane <?php echo $data['activeTabExchange'];?>" id="exchange">
<br>
		    <!--exchange starts-->
			<div class="panel panel-default files-panel no-box-shadow">
                <div class="statusExchange" style="display: none; text-align: center;margin:20px;">Loading ...</div>
                <div class="table-responsive devicesListExchange" style="display: none;">
		    <div class="form-group col-lg-12" style="margin-top:10px;">
                    	<input class="form-control" type="text" id="searchExchangeInput" onkeyup="searchedExchangeDevices()" placeholder="Search for Devices.." title="Type in a Device Name">
                    </div>
                    <table class="table table-bordered table-striped table-hover files-table" id="devicesListExchangeTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Device
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
			    <th class="text-left clickAble" ng-click="sortType = 'userNamePlain'; sortReverse = !sortReverse">
                                UserName
                                <span ng-show="sortType == 'userNamePlain' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'userNamePlain' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                Status
                                <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'createdOn'; sortReverse = !sortReverse">
                                Device Configured on
                                <span ng-show="sortType == 'createdOn' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'createdOn' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Last Successful Backup
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Action
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody class="clickAble">
                        <tr ng-repeat="value in devicesExchange | orderBy:sortType:sortReverse track by $index">
                            <td class="text-left" title="{{ value.name }}" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> {{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</td>
                            <td class="text-left" title="{{ value.userNamePlain }}" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.userNamePlain  | limitTo:20 }}{{value.userNamePlain.length > 20 ? '...' : ''}}</td>
			    <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.status }}</td>
                            <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.createdOn}}</td>
                            <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.lastSuccessfullBackup}}</td>
			    <td class="text-left">
				<a ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management">Backup Management</a>
				<?php if($data['showRestore'] == 'no'){?>
				    <a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="background-color: gainsboro !important;pointer-events:none !important;">Restore</a>
				<?php } ?>
				<?php if($data['showRestore'] == 'yes'){?>
				    <?php if($data['allowEndUserTocontrolRestore'] == 'yes'){?>
				    	<a ng-class="{false:'invalid'}[value.canAdminRestore]" ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore">Restore</a>
				    <?php }else{ ?>
				    	<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore">Restore</a>				
				    <?php } ?>
				<?php } ?>
				    <!--<a ng-click="initiateRestoreForDeviceOutlookManage(value.uuId,value.deviceType, value.quarantineDevice, value.blocked, value.userNamePlain, value.name)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Initiate Restore">Initiate Restore</a>-->
				<a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameNew }}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a>
			    </td>
                        </tr>
                        </tbody>
                    </table>
		</div>
		<div class="row devicesListExchangeTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountExchange}} of {{totalpageCountExchange}}</span></p>
                            <a class="btn btn-primary firstExchange" title="First" ng-click="manageDevicesExchangeNavigate('Exchange', firstExchange)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousExchange" title="Previous" ng-click="manageDevicesExchangeNavigate('Exchange', previousExchange)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextExchange" title="Next" ng-click="manageDevicesExchangeNavigate('Exchange', nextExchange)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastExchange" title="Last" ng-click="manageDevicesExchangeNavigate('Exchange', lastExchange)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div>
            </div>
		    <!--exchange ends-->
		    </div>
		    <div role="tabpanel" class="tab-pane <?php echo $data['activeTabSharepoint'];?>" id="sharepoint">
		    <br>
		    <!--sharepoint starts-->
			<div class="panel panel-default files-panel no-box-shadow">
		    <div class="panel-heading">
                        <a ng-click="configureSites()" class="btn btn-small pull-right" style="margin-top: 2px;margin-right: 10px;">Configure Sites</a>
                </div>
                <div class="statusSharepoint" style="display: none; text-align: center;margin:20px;">Loading ...</div>
                <div class="table-responsive devicesListSharepoint" style="display: none;">
		    <div class="form-group col-lg-12" style="margin-top:10px;">
                    	<input class="form-control" type="text" id="searchSharepointInput" onkeyup="searchedSharepointDevices()" placeholder="Search for Devices.." title="Type in a Device Name">
                    </div>
                    <table class="table table-bordered table-striped table-hover files-table" id="devicesListSharepointTable">
                        <thead>
                        <tr>
                            <th class="text-left clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Sites
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
			    <th class="text-left clickAble" ng-click="sortType = 'userNamePlain'; sortReverse = !sortReverse">
                                UserName
                                <span ng-show="sortType == 'userNamePlain' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'userNamePlain' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                Status
                                <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'createdOn'; sortReverse = !sortReverse">
                                Site Configured on
                                <span ng-show="sortType == 'createdOn' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'createdOn' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left  clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Last Successful Backup
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="text-left clickAble" ng-click="sortType = 'lastSuccessfullBackup'; sortReverse = !sortReverse">
                                Actions
                                <span ng-show="sortType == 'lastSuccessfullBackup' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'lastSuccessfullBackup' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody class="clickAble">
                        <tr ng-repeat="value in devicesSharepoint | orderBy:sortType:sortReverse track by $index">
                            <td class="text-left" title="{{ value.name }}" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak><img src="<?=Url::templatePath()?>images/SharePoint-Logo.wine.svg?>" style="height:20px;width:20px;"> {{ value.name  | limitTo:20 }}{{value.name.length > 20 ? '...' : ''}}</td>
                            <td class="text-left" title="{{ value.userNamePlain }}" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.userNamePlain  | limitTo:20 }}{{value.userNamePlain.length > 20 ? '...' : ''}}</td>
			    <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.status }}</td>
                            <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.createdOn}}</td>
                            <td class="text-left" ng-click="openFilesPage(value.id, value.name, value.uuId, value.deviceType, value.icon, value.userName, value.blocked)" ng-cloak>{{ value.lastSuccessfullBackup}}</td>
			    <td class="text-left">
				<a ng-click="logAction(value.uuId,value.deviceType)" class="btn btn-primary btn-small initiateBackupBtn{{$index}}" title="Backup Management">Backup Management</a>
				<?php if($data['showRestore'] == 'no'){?>
				    <a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore" style="background-color: gainsboro !important;pointer-events:none !important;">Restore</a>
				<?php } ?>
				<?php if($data['showRestore'] == 'yes'){?>
				    <?php if($data['allowEndUserTocontrolRestore'] == 'yes'){?>
				    	<a ng-class="{false:'invalid'}[value.canAdminRestore]" ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore">Restore</a>
				    <?php }else{ ?>
				    	<a ng-click="goToRestore(value.uuId, value.deviceType, value.icon, value.name, value.userNamePlain, value.blocked, value.quarantineDevice)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Restore">Restore</a>				
				    <?php } ?>
				<?php } ?>
				<!--<a ng-click="initiateRestoreForDeviceSharepoint(value.uuId)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}" title="Initiate Restore">Initiate Restore</a>-->
				<a class="btn btn-small btn-primary" href="<?=Url::basePath('user/backupHistory/{{value.userName}}/{{ value.uuId }}/{{ value.nameNew }}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a>
			    </td>
                        </tr>
                        </tbody>
                    </table>
		</div>
		<div class="row devicesListSharepointTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCountSharepoint}} of {{totalpageCountSharepoint}}</span></p>
                            <a class="btn btn-primary firstSharepoint" title="First" ng-click="manageDevicesSharepointNavigate('Sharepoint', firstSharepoint)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previousSharepoint" title="Previous" ng-click="manageDevicesSharepointNavigate('Sharepoint', previousSharepoint)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary nextSharepoint" title="Next" ng-click="manageDevicesSharepointNavigate('Sharepoint', nextSharepoint)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary lastSharepoint" title="Last" ng-click="manageDevicesSharepointNavigate('Sharepoint', lastSharepoint)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                </div> 
            </div>
		    <!--sharepoint ends-->
		    </div>
            </div>
<!--new ends-->
<!-- restore for outlook start -->

<!-- restore for outlook device start -->

<div class="modal fade restoreBuckettOutlookDevice" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog" style="width:90%;">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;padding:10px 10px !important;">
                        <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathOutlookDevice"></span>
					</div>
				<div class="settingsDivOutlookDevice">
                                    <div class="col-lg-12" style="margin-bottom:5px;">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOutlookDevice">User Id</label>
                                            <select name="searchUsernameOutlookDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOutlookDevice"
                                                    id="searchUsernameOutlookDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameOutlookDevice" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameOutlookDevice form-control" id="searchDeviceNameOutlookDevice" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
				    <input class="hide" type="text" id="uuuOutlookDevice" value=""/>

                                    <div class="form-group col-lg-12">
                                        <!--<br/>-->
                                        <label id="destinationPathlabelOutlookDevice" for="destinationPathOutlookDevice">Enter a Destination Path</label>
					<div class="col-lg-12 row">
    						<div class="col-lg-10">
                                            		<input type="text" class="" name="destinationPathOutlookDevice" id="destinationPathOutlookDevice" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
	    					</div>
						<div class="col-lg-2">
                                            		<span class="input-group-btn">
							<button id="browseOutlookDevice" ng-click="browseOutlookDevice()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
							</span>
						</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12" style="margin-top:5px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row">
						<div class="col-lg-6">
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookDevice"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1OutlookDevice" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOutlookDevice"><?=Language::show('In place Restore', 'keywords');?></label>
</div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceOutlookDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreDeletedFilesOutlookDevice"><?=Language::show('Restore Deleted Mails', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreDeletedFilesOutlookDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
</div>
                                        <div class="col-lg-6" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;/*margin-left: -30px;*/">
                                                <div class="col-lg-6">
<label style="margin-top:7px;" for="maxVersionsOutlookDevice"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-6">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateOutlookDevice" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row col-lg-12">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateOutlookDevice">Date </label>
                                                    <input type="text" class="form-control restoreDateOutlookDevice" id="restoreDateOutlookDevice" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeOutlookDevice"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeOutlookDevice" name="restoreTimeOutlookDevice" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
</div>					
<!--tableresponsive-->
                            <div class="table-responsive currentProgressOutlookDevice col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="hide" id="batchIdOutlookDevice"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current item being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span></td>
					    <td ng-if="progress.currentFolderPath == ''">-</td>
					    <td>
					    	<div class="progress">
					    		<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
						</div>
					    </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" style="padding:10px !important;">
			<button type="button" ng-click="calculateRestorableSizeDevice('OutlookDevice')" class="btn btn-default calculateRestorableSizeBtnOutlookDevice">Calculate Restorable Size</button>
                        <button type="submit" ng-click="initiateRestoreOutlookDevice()"  class="btn btn-default initiateRestoreBtnOutlookDevice">Initiate Restore</button>
			<button type="button" ng-click="restoreCancelConfirmOutlookDevice()" class="btn btn-primary cancelRestoreBtnOutlookDevice" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshOutlookDevice()" class="btn btn-default normalCancelOutlookDevice" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreOutlookDevice()"  class="btn btn-default warningCancelOutlookDevice" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>
<!--<div class="modal fade restoreEventsExistsOutlookDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">A restore request already exists</h4>
                        </div>
                        <div class="modal-body">
                            <p class="hide"><span id="statementForCompPathOutlook"></span><span id="statementForDesPathOutlook"></span></p>
                            
                            <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>File Path</th>
                                            <th>Destination Path</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>{{ restoreEventsExists.fileElement.fileCompletePath }}</td>
                                            <td ng-if="restoreEventsExists.destinationPath != ''">{{ restoreEventsExists.destinationPath }}</td>
                                            <td ng-if="restoreEventsExists.destinationPath == ''"> - </td>
                                            <td>{{restoreEventsExists.status}}</td>
<td>
                                                <a ng-if="restoreEventsExists.status == 'QUEUE'" ng-click="deleteRestoreOutlook()" class="btn btn-danger btn-small">Cancel Restore</a>
                                            </td>
                                        </tr>
                                        </tbody>
</table>
                                </div>
                                <p><span id="restorealreadyexistsOutlook"></span></p>
                        </div>
                        <div class="modal-footer">
          			<button type="button" class="btn btn-default closeBtnRestoreBtnForFilesOutlook" data-dismiss="modal" style="display:none;">Close</button>
      				<button type="button" ng-click="deleteRestoreOutlook()" class="btn btn-primary cancelRestoreBtnForFilesOutlook" style="display:none;">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>-->
<div class="modal fade restoreWindowConfirmCloseOutlookDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnOutlookDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmOutlookDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="deleteRestoreOutlookDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseOutlookDevice">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Browse path</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>                            
                        </div>
                        <div class="modal-body">
<span>Current Path : </span><span ng-if="pathOutlookDevice == ''" ng-cloak>/</span><span ng-if="pathOutlookDevice != ''" ng-cloak>{{pathOutlookDevice}}</span>
<div class="col-lg-12">
	<div class="row">
<div class="col-lg-7" style="border: 1px solid black;">
<a class="btn btn-small btn-primary" ng-click="backOutlookDevice(pathOutlookDevice)" style="margin:5px;" ng-if="pathOutlookDevice != ''"><i class="fa fa-arrow-left"></i> Back</a>
</br>
                        <div class="table-responsive browsePathDivOutlookDevice">
<span class="noPathOutlookDevice" style="display:none;"> No path available</span>
			<span ng-if="browseElements == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathOutlookDevice" class="table table-hover table-bordered browsePathOutlookDevice" style="display: none;">
                                <tbody>
                                <tr ng-repeat="value in browseElements" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                        <td ng-click="pickOutlookDevice(value, $index)" ng-dblclick="getChildsOutlookDevice(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolderOutlookDevice"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderOutlookDevice" id="newFolderOutlookDevice" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderOutlookDevice()" class="btn btn-default addNewFolderBtnOutlookDevice" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
	</div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathOutlookDevice" ng-click="usePathOutlookDevice(pathOutlookDevice)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for outlook device end -->

<!-- restore for outlook end -->

<!-- restore for onedrive device start -->

<div class="modal fade restoreBuckettOnedriveDevice" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog" style="width:90%;">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;padding:10px 10px !important;">
                        <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathOnedriveDevice"></span>
					</div>
				<div class="settingsDivOnedriveDevice">
                                    <div class="col-lg-12" style="margin-bottom:5px;">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
                                        <div class="col-lg-6">
                                            <label for="searchUsernameOnedriveDevice">User Id</label>
                                            <select name="searchUsernameOnedriveDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameOnedriveDevice"
                                                    id="searchUsernameOnedriveDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>					
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameOnedriveDevice" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameOnedriveDevice form-control" id="searchDeviceNameOnedriveDevice" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
				    <input class="hide" type="text" id="uuuOnedriveDevice" value=""/>

                                    <div class="form-group col-lg-12">
                                        <!--<br/>-->
                                        <label id="destinationPathlabelOnedriveDevice" for="destinationPathOnedriveDevice">Select a Destination Path</label>
					<div class="col-lg-12 row">
    						<div class="col-lg-10">
                                            		<input type="text" class="" name="destinationPathOnedriveDevice" id="destinationPathOnedriveDevice" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
	    					</div>
						<div class="col-lg-2">
                                            		<span class="input-group-btn">
							<button id="browseOnedriveDevice" ng-click="browseOnedriveDevice()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
							</span>
						</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-12" style="margin-top:5px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row">
						<div class="col-lg-6">
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
<div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1OnedriveDevice" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                        <label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('Restore all Versions', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchallversionsOnedriveDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('In place Restore', 'keywords');?></label>
</div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceOnedriveDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
</div>							
                                        <div class="col-lg-6" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;/*margin-left: -30px;*/">
                                                <div class="col-lg-6">
<label style="margin-top:7px;" for="maxVersionsOnedriveDevice"><?=Language::show('Restore Data Before', 'keywords');?></label>
</div>
                                                <div class="col-lg-6">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateOnedriveDevice" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row col-lg-12">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateOnedriveDevice">Date </label>
                                                    <input type="text" class="form-control restoreDateOnedriveDevice" id="restoreDateOnedriveDevice" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeOnedriveDevice"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeOnedriveDevice" name="restoreTimeOnedriveDevice" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
</div>					
<!--tableresponsive-->
                            <div class="table-responsive currentProgressOnedriveDevice col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="hide" id="batchIdOnedriveDevice"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current file being processed</th>
                                            <th>Overall Progress</th>
					</tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span></td>
					    <td ng-if="progress.currentFolderPath == ''">-</td>
					    <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
					    <div class="progress">
					    	<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
						</div>
					     </td>
					     <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" style="padding:10px !important;">
			<button type="button" ng-click="calculateRestorableSizeDevice('OnedriveDevice')" class="btn btn-default calculateRestorableSizeBtnOnedriveDevice">Calculate Restorable Size</button>
                        <button type="submit" ng-click="initiateRestoreOnedriveDevice()"  class="btn btn-default initiateRestoreBtnOnedriveDevice">Initiate Restore</button>
			<button type="button" ng-click="restoreCancelConfirmOnedriveDevice()" class="btn btn-primary cancelRestoreBtnOnedriveDevice" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshOnedriveDevice()" class="btn btn-default normalCancelOnedriveDevice" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreOnedriveDevice()"  class="btn btn-default warningCancelOnedriveDevice" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade restoreWindowConfirmCloseOnedriveDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnOnedriveDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmOnedriveDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>
</div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="deleteRestoreOnedriveDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseOnedriveDevice">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
			    <h4 class="modal-title">Browse path</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>                            
                        </div>
                        <div class="modal-body">
<span>Current Path : </span><span ng-if="pathOnedriveDevice == ''" ng-cloak>/</span><span ng-if="pathOnedriveDevice != ''" ng-cloak>{{pathOnedriveDevice}}</span>
<div class="col-lg-12">
	<div class="row">
<div class="col-lg-7" style="border: 1px solid black;">
<a class="btn btn-small btn-primary" ng-click="backOnedriveDevice(pathOnedriveDevice)" style="margin:5px;" ng-if="pathOnedriveDevice != ''"><i class="fa fa-arrow-left"></i> Back</a>
</br>
                        <div class="table-responsive browsePathDivOnedriveDevice">
<span class="noPathOnedriveDevice" style="display:none;"> No path available</span>
			<span ng-if="browseElements == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathOnedriveDevice" class="table table-hover table-bordered browsePathOnedriveDevice" style="display: none;">
                                <tbody>
<tr ng-repeat="value in browseElements" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                        <td ng-click="pickOnedriveDevice(value, $index)" ng-dblclick="getChildsOnedriveDevice(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolderOnedriveDevice"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderOnedriveDevice" id="newFolderOnedriveDevice" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderOnedriveDevice()" class="btn btn-default addNewFolderBtnOnedriveDevice" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
	</div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathOnedriveDevice" ng-click="usePathOnedriveDevice(pathOnedriveDevice)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for Onedrive device end -->
<!--browse modal start-->
<div class="modal fade browseEndPointOnedriveDevice" style="z-index: 999999999999999;">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Browse path</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                                <span>Current Path : </span><span ng-if="pathEndPointOnedriveDevice == ''" ng-cloak>/</span><span ng-if="pathEndPointOnedriveDevice != ''" ng-cloak>{{pathEndPointOnedriveDevice}}</span>
                                <div class="col-lg-12">
<div class="row">
                                <div class="col-lg-7" style="border: 1px solid black;">
                                <a class="btn btn-small btn-primary" ng-click="backEndPointOnedriveDevice(pathEndPointOnedriveDevice)" style="margin:5px;" ng-if="pathEndPointOnedriveDevice != ''"><i class="fa fa-arrow-left"></i> Back</a>
                                </br>
                        <div class="table-responsive browsePathDivEndPointOnedriveDevice">
                        <span class="noPathEndPointOnedriveDevice" style="display:none;"> No path available</span>
                        <span ng-if="browseElementsEndPointDevice == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                        <table id="browsePathEndPointOnedriveDevice" class="table table-hover table-bordered browsePathEndPointOnedriveDevice" style="display: none;">
                                <tbody>
                                <tr ng-repeat="value in browseElementsEndPointDevice" class="text-left" ng-class="{'selected':$index == selectedRowEndPointDevice}">
                                        <td ng-click="pickEndPointOnedriveDevice(value, $index)" ng-dblclick="getChildsEndPointOnedriveDevice(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                </tr>
                                </tbody>
                            </table>
                            </div>
</div>
<div class="col-lg-5">
<div class="form-group">
                                        <label for="newFolderEndPointOnedriveDevice"><?=Language::show('Create new folder', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="newFolderEndPointOnedriveDevice" id="newFolderEndPointOnedriveDevice" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                            <span class="input-group-btn">
                                        <button ng-click="addNewFolderEndPointOnedriveDevice()" class="btn btn-default addNewFolderBtnEndPointOnedriveDevice" style="padding-bottom: 10px;" type="button">Create</button>
</span>
                                        </div>
                                    </div>
</div>
</div>
</div>
<div class="modal-footer">
<a class="btn btn-small btn-primary usePathEndPointOnedriveDevice" ng-click="usePathEndPointOnedriveDevice(pathEndPointOnedriveDevice)">Use Path</a>
 <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->	
<!-- restore for EndPointDevice start -->
<div class="modal fade restoreBuckettEndPointDevice" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog" style="width:90%;">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;padding:10px 10px !important;">
<!--                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
					<div class="form-group col-lg-12">
						<span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathEndPointDevice"></span>
					</div>
				<div class="settingsDivEndPointDevice">
                                    <div class="col-lg-12" style="margin-bottom:5px;">
					<div class="row" style="margin-left:0px;">
						<span class="star">Select a destination device:</span>
					</div>
<div class="row">
                                        <div class="col-lg-6">
                                            <label for="searchUsernameEndPointDevice">User Id</label>
                                            <select name="searchUsernameEndPointDevice"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsernameEndPointDevice"
                                                    id="searchUsernameEndPointDevice"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                            </select>
                                        </div>					
                                        <div class="col-lg-6">
                                            <label for="searchDeviceNameEndPointDevice" style="margin-bottom:8px;">Device Name</label>
                                            <select class="searchDeviceNameEndPointDevice form-control" id="searchDeviceNameEndPointDevice" style="width: 100%;" readonly>
                                            </select>
					</div>
</div>
                                    </div>
                                    <input class="hide" type="text" id="uuu" value=""/>
				    <input class="hide" type="text" id="uuuOS" value=""/>
                                    <div class="form-group col-lg-12" id="destinationPathEndPointDeviceRow">
                                        <!--<br/>-->
                                        <label id="destinationPathlabelEndPointDevice" for="destinationPathEndPointDevice">Enter a Destination Path</label>
					<input type="text" class="form-control" style="width: 100%;" id="destinationPathEndPointDevice" placeholder="Enter Destination Path" required/>
                                        <span class="help-block hide">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
				    <!--browse for endpoint start-->
                                    <div class="form-group col-lg-12" id="destinationPathEndPointOnedriveDeviceRow" style="margin-bottom:10px;display:none;">
                                        <!--<br/>-->
                                        <label for="destinationPathEndPointOnedriveDevice">Select a Destination Path</label>
                                        <div class="col-lg-12 row">
                                                <div class="col-lg-10">
                                                        <input type="text" class="" name="destinationPathEndPointOnedriveDevice" id="destinationPathEndPointOnedriveDevice" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required readonly style="width:100%;"/>
                                                </div>
                                                <div class="col-lg-2">
                                                        <span class="input-group-btn">
                                                        <button id="browseEndPointOnedriveDevice" ng-click="browseEndPointOnedriveDevice()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
                                                        </span>
                                                </div>
                                        </div>
                                    </div>
                                    <!--browse for endpoint ends-->
                                    <div class="form-group col-lg-12" style="margin-top:5px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
					<div class="form-group col-lg-12 row" id="noOfThreadsRow">
						<label for="noOfThreads">Number of Threads</label>
						<input type="number" class="form-control" style="width: 100%;" id="noOfThreads" min="1" max="6" value="1" placeholder="Enter number of Threads" required/>
					</div>
                                        <div class="col-lg-12 row" id="suspendbackupEndPointDeviceRow">
						<div class="col-lg-6">
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
<label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
						    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackupEndPointDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                        <label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('Restore all Versions', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchallversionsEndPointDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row" id="inPlaceRestoreEndPointDeviceRow">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('In place Restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceEndPointDevice" type="checkbox">
                                                <div class="slider round"></div>
						</label>
                                            </div>
                                        </div>
					    <div class="col-lg-12 row">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="restoreDeletedFilesEndPoint"><?=Language::show('Restore Deleted Files', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchrestoreDeletedFilesEndPoint" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
					<div class="col-lg-12 row" id="overwriteNewerFilesEndPointDeviceRow">
					    <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="overwriteNewerFilesEndPoint"><?=Language::show('Overwrite Newer Files', 'keywords');?></label>
        				    </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchoverwriteNewerFilesEndPoint" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
</div>							
					    <div class="col-lg-6" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;/*margin-left: -30px;*/">
                                                <div class="col-lg-6">
                                                    <label style="margin-top:7px;" for="maxVersionsEndPointDevice"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-6">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateEndPointDevice" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row col-lg-12">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateEndPointDevice">Date </label>
                                                    <input type="text" class="form-control restoreDateEndPointDevice" id="restoreDateEndPointDevice" placeholder="Restore Date" data-parsley-trigger="change" disabled>
</div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTime"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeEndPointDevice" name="restoreTimeEndPointDevice" disabled>
</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
</div>					
<!--tableresponsive-->
                            <div class="table-responsive currentProgressEndPointDevice col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
				    <span class="hide" id="batchIdEndPointDevice"></span>
				    </br>
                                    <table class="table table-bordered table-striped currentProgressEndPointDeviceTable" style="display:none;">
                                        <thead>
						<tr>
						    <th>Source Path</th>
						    <th>Overall Progress</th>
						    <th>Status</th>
						</tr>
                                        </thead>
                                        <tbody>
                                        <tr>
						<td ng-if="progress.currentFolderPath">{{ progress.currentFolderPath | limitTo:40 }}{{progress.currentFolderPath.length > 40 ? '...' : ''}}</td>
						<td ng-if="!progress.currentFolderPath">-</td>
						<td ng-if="progress.totalRestorePct != ''">
							<div class="progress">
								<div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
							</div>
						</td>
						<td ng-if="progress.totalRestorePct == ''">-</td>
					    	<td><span id="statusEndPointDevice"></span></td>
                                        </tr>
                                        </tbody>
                                    </table>
				    <table class="table table-bordered table-striped currentProgressEndPointOneDriveDeviceTable" style="display:none;">
                                        <thead>
                                        <tr>
                                            <th>Current file being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>
                                                    <span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
                                                <div class="progress">
                                                        <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
                                                </div>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" style="padding:10px !important;">
			<button type="button" ng-click="calculateRestorableSizeDevice('EndPointDevice')" class="btn btn-default calculateRestorableSizeBtnEndPointDevice">Calculate Restorable Size</button>
			<button type="submit" ng-click="initiateRestoreEndPointDevice()"  class="btn btn-default initiateRestoreBtnEndPointDevice">Initiate Restore</button>
                        <button type="button" ng-click="restoreCancelConfirmEndPointDevice()" class="btn btn-primary cancelRestoreBtnEndPointDevice" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshEndPointDevice()" class="btn btn-default normalCancelEndPointDevice" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreEndPointDevice()"  class="btn btn-default warningCancelEndPointDevice" style="display:none;">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade restoreWindowConfirmCloseEndPointDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
<div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
<!--                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnEndPointDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
				</div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmEndPointDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
    <!--                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">

                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>

                        </div>
                        <div class="modal-footer">
<button type="button" class="btn btn-default" ng-click="deleteRestoreEndPointDevice()">Ok</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
</div>
                    </div>
                </div>
            </div>
<!-- restore for EndPointDevice end -->		
<!--sharepoint device start-->
<!-- restore for sharepoint device start -->
<div class="modal fade restoreBuckettSharepointDevice" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;padding:10px 10px !important;">
<!--                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                        <h4 class="modal-title">Restore Settings</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                        <div class="form-group col-lg-12">
                                                <span>Source Path - </span><span style="font-size:16px;" title="" id="fileCompletePathSharepointDevice"></span>
                                        </div>
                                <div class="settingsDivSharepointDevice">
                                    <div class="col-lg-12" style="margin-bottom:5px;">
                                        <div class="row" style="margin-left:0px;">
                                                <span class="star">Select a destination Site:</span>
                                        </div>
<div class="row">
                                    <div class="col-lg-10">
                                        <select class="searchDeviceNameSharepointDevice" id="deviceNameSharepointDevice" style="width: 100%;" data-parsley-trigger="change"></select>
                                    </div>
                                </div>
                                    </div>
                                    <input class="d-none" type="text" id="uuuSharepointDevice" value=""/>
                                    <div class="form-group col-lg-12" style="margin-bottom:10px;">
                                        <!--<br/>-->
                                        <label id="destinationPathlabelSharepointDevice" for="destinationPathSharepointDevice">Select a Destination Path</label>
<!--                                        <div class="col-lg-12 row">
                                                <div class="col-lg-10">-->
                                                        <input type="text" class="" name="destinationPathSharepointDevice" id="destinationPathSharepointDevice" placeholder="<?=Language::show('Enter a Destination Path', 'keywords');?>" required style="width:100%;"/>
<!--                                                </div>
                                                <div class="col-lg-2">
                                                        <span class="input-group-btn">
                                                        <button id="browseSharepointDevice" ng-click="browseSharepointDevice()" class="btn btn-default" style="padding-bottom: 10px;" type="button">Browse</button>
                                                        </span>
                                                </div>
                                        </div>-->
                                    </div>
                                    <div class="form-group col-lg-12" style="margin-top:5px;">
<legend class="h4" style="color: #585f69;"><?=Language::show('Restore Options', 'keywords')?></legend>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsSharepointDevice"><?=Language::show('Disallow new backups during this restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchsuspendbackup1SharepointDevice" type="checkbox">
<div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
<div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                            	<label style="margin-top:7px;" for="maxVersionsSharepointDevice"><?=Language::show('Restore all Versions', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchallversionsSharepointDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 row">
                                            <div class="col-lg-8">
                                                <label style="margin-top:7px;" for="maxVersionsSharepointDevice"><?=Language::show('In place Restore', 'keywords');?></label>
                                            </div>
                                            <div class="col-lg-4">
                                                <label class="switch">
                                                <input id="switchinplaceSharepointDevice" type="checkbox">
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12" style="border: 1px solid grey;border-radius: 10px;">
                                            <div class="col-lg-12 row" style="margin-top: 5px;margin-left: -30px;">
                                                <div class="col-lg-4">
                                                        <label style="margin-top:7px;" for="maxVersionsSharepointDevice"><?=Language::show('Restore Data Before', 'keywords');?></label>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label class="switch" style="margin-left:10px">
                                                    <input id="switchDateSharepointDevice" type="checkbox">
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreDateSharepointDevice">Date </label>
                                                    <input type="text" class="form-control restoreDateSharepointDevice" id="restoreDateSharepointDevice" placeholder="Restore Date" data-parsley-trigger="change" disabled>
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <label for="restoreTimeSharepointDevice"><?=Language::show('Time', 'keywords');?></label>
                                                    <input type="text" class="form-control timePicker input-small" id="restoreTimeSharepointDevice" name="restoreTimeSharepointDevice" disabled>
                                                </div>
                                            </div>
</div>
</div>
                                    </div>
<!--tableresponsive-->
                            <div class="table-responsive currentProgressSharepointDevice col-lg-12 row" style="display:none;">
                                <h4 class="modal-title">Currently Running Restore Statistics</h4>
                                    <span class="d-none" id="batchIdSharepointDevice"></span>
                                </br>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>Current file being processed</th>
                                            <th>Overall Progress</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>
                                                    <span ng-if="progress.currentFolderPath != ''">{{ progress.currentFolderPath | limitTo:20 }}{{progress.currentFolderPath.length > 20 ? '...' : ''}}</span><span ng-if="progress.subject">/ {{ progress.subject | limitTo:40}}{{progress.subject.length > 40 ? '...' : ''}}</span>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore != ''">{{ progress.restoredFiles }}/{{ progress.totalNoOfFilesForRestore }}
                                                <div class="progress">
                                                        <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="color:#000 !important;content:{{progress.totalRestorePct}}%;width:{{progress.totalRestorePct}}%;">{{progress.totalRestorePct | number:0}}%</div>
                                                </div>
                                            </td>
                                            <td ng-if="progress.totalNoOfFilesForRestore == ''">0</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div><!--tableresponsive-->
</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" style="padding:10px !important;">
                        <button ng-if="selected[0].type === 'Folder'" type="button" ng-click="calculateRestorableSize('Onedrive')" class="btn btn-default calculateRestorableSizeBtnSharepointDevice">Calculate Restorable Size</button>
                        <button type="submit" ng-click="initiateRestoreSharepointDevice()"  class="btn btn-default initiateRestoreBtnSharepointDevice">Initiate Restore</button>
                        <button type="button" ng-click="restoreCancelConfirmSharepointDevice()" class="btn btn-primary cancelRestoreBtnSharepointDevice" style="display:none;">Cancel Restore </button>
                        <button type="button" ng-click="clearRefreshSharepointDevice()" class="btn btn-default normalCancelSharepointDevice" data-dismiss="modal">Close</button>
                        <button type="submit" ng-click="warningRestoreSharepointDevice()"  class="btn btn-default warningCancelSharepointDevice" style="display:none;">Close</button>
</div>
                </form>
            </div>
        </div>
    </div>
<div class="modal fade restoreWindowConfirmCloseSharepointDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
<div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <h4 class="modal-title">Are you sure you wish to close this window? The restore will still continue to run in the background.</h4>
                        </div>
                        <div class="modal-footer">
                          <button type="button" class="btn btn-default" ng-click="restoreWindowConfirmCloseBtnSharepointDevice()">Ok</button>
                          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<div class="modal fade restoreCancelConfirmSharepointDevice" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Restore Cancel Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <h4 class="modal-title">Are you sure you wish to cancel the restore?</h4>
                        </div>
                        <div class="modal-footer">
                                <button type="button" class="btn btn-default" ng-click="deleteRestoreSharepointDevice()">Ok</button>
                                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal start-->
<div class="modal fade browseSharepointDevice">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Browse path</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
                                <span>Current Path : </span><span ng-if="pathSharepointDevice == ''" ng-cloak>/</span><span ng-if="pathSharepointDevice != ''" ng-cloak>{{pathSharepointDevice}}</span>
                                <div class="col-lg-12">
                                        <div class="row">
                                                <div class="col-lg-7" style="border: 1px solid black;">
                                                        <a class="btn btn-small btn-primary" ng-click="backSharepointDevice(pathSharepointDevice)" style="margin:5px;" ng-if="pathSharepoint != ''"><i class="fa fa-arrow-left"></i> Back</a>
                                                        </br>
                                                                <div class="table-responsive browsePathDivSharepointDevice">
                                                                        <span class="noPathSharepointDevice" style="display:none;"> No path available</span>
                                                                        <span ng-if="browseElementsDevice == ''"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                                                                        <table id="browsePathSharepoint" class="table table-hover table-bordered browsePathSharepointDevice" style="display: none;">
                                                                                <tbody>
                                                                                        <tr ng-repeat="value in browseElementsDevice" class="text-left" ng-class="{'selected':$index == selectedRow}">
                                                                                                <td ng-click="pickSharepointDevice(value, $index)" ng-dblclick="getChildsSharepointDevice(value)" ng-cloak><span style="cursor: pointer;">{{ value }}</span></td>
                                                                                        </tr>
                                                                                </tbody>
                                                                        </table>
                                                                </div>
                                                </div>
                                                <div class="col-lg-5">
                                                	<div class="form-group">
                                                                <label for="newFolderSharepointDevice"><?=Language::show('Create new folder', 'keywords');?></label>
                                                                <div class="input-group">
                                                                        <input type="text" class="form-control" name="newFolderSharepointDevice" id="newFolderSharepointDevice" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Create new folder', 'keywords');?>" autocomplete="off"/>
                                                                        <span class="input-group-btn">
                                                                                <button ng-click="addNewFolderSharepointDevice()" class="btn btn-default addNewFolderBtnSharepointDevice" style="padding-bottom: 10px;" type="button">Create</button>
                                                                        </span>
                                                                </div>
                                                        </div>
                                                </div>
                                </div>
                        </div>
                        <div class="modal-footer">
                                <a class="btn btn-small btn-primary usePathSharepointDevice" ng-click="usePathSharepointDevice(pathSharepointDevice)">Use Path</a>
                                <button type="button" class="btn btn-small btn-default" data-dismiss="modal">Close</button>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
<!--browse modal end -->
<!-- restore for sharepoint Device end -->
<!--sharepoint Device end-->
<!--restorableSizeModal start-->
    	    <div class="modal fade restorableSizeModal" id="restorableSizeModal" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Restorable Size </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                        <div class="modal-body">
			    <span id="restorableSizeLabel" style="display:none;"> Calculating....</span>
                            <center><span id="restorableSizeSpinner" style="display:none;"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>
                            <h4 id="restorableSize" class="modal-title">
                                <p><span>Size: {{restorableSize}}</span></p>
                                <p ng-if="totalNumberOfFiles !=''"><span>Contains: {{totalNumberOfFiles}} items</span></p>
                            </h4>
			    <h4 id="restorableSizeError" class="modal-title">Operation to Calculate restorable size of folder failed.</h4>
                        </div>
                        <div class="modal-footer">
                                <button type="button" class="btn btn-primary" data-dismiss="modal">Close </button>
                        </div>
                    </div>
                </div>
	    </div>
<!--restorableSizeModal ends-->
<!--event hub modal start-->
<div class="modal fade deviceLogs">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
<!--                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                    <h4 class="modal-title">Backup Management</h4>
                </div>
                <div class="modal-body">
					<?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'eventHubForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'saveEventHub()',
                        'data-parsley-validate' => true
                    ));
                    ?>					
					<span class="d-none" id="actionToUserName"></span>
					<span class="d-none" id="actionToDeviceUUID"></span>
					<span class="d-none" id="deviceType"></span>
					<div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
						<div class="col-lg-6">
							<p><b>Backup Policy Refresh</b>:</p>
						</div>
						<div class="col-lg-6">
							<input id="backupPolicyRefresh" name="backupPolicyRefresh" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
						</div>
					</div></br>
					<?php if(Auth::checkCloudPermission('backup')  || Auth::checkCloudPermission('office365')) {?>
					<div class="row col-lg-12" style="margin-bottom: 10px;">
 						<div class="col-lg-6">
 							<p><b>Current Backup Status</b>:</p>
 						</div>
 						<div class="col-lg-6">
                            			<center>
					       		<label ng-if="currentBackup == true">Running</label>
		                    	   		<label ng-if="currentBackup == false">Not Running</label>
                            			</center>
 						</div>
 					</div>
 					<?php } ?>
					<?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
                                        <div class="row col-lg-12" style="margin-bottom: 10px;">
                                                <div class="col-lg-6">
                                                        <p><b>Current Restore Status</b>:</p>
                                                </div>
                                                <div class="col-lg-6">
                                                <center>
                                                        <label ng-if="currentRestore == true">Running</label>
                                                        <label ng-if="currentRestore == false">Not Running</label>
                                                </center>
                                                </div>
                                        </div>
                                        <?php } ?>
					<div class="row col-lg-12 agLogs" style="margin-bottom: 10px;">
                        <div class="col-lg-6">
                            <p><b>Pull Agent Logs</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="agentLogs" name="agentLogs" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                <div class="checkbox check-primary" id="historicalLogsBlock" style="display: none;margin-top: 8px;">
                                    <input id="historicalLogs" name="historicalLogs" type="checkbox" value="enabled">
                                    <label for="historicalLogs"><?=Language::show('Include Historical Logs', 'keywords');?></label>
                                    <input id="setupLogs" name="setupLogs" type="checkbox" value="enabled">
                                    <label for="setupLogs"><?=Language::show('Include Setup Logs', 'keywords');?></label>
                                    <input id="databases" name="databases" type="checkbox" value="enabled">
                                    <label for="databases"><?=Language::show('Include Databases', 'keywords');?></label>
                                </div>
                            </center>
                        </div>
                    </div>
                    <div class="row col-lg-12 fBackup" style="margin-bottom: 10px;display:none;">
                        <div class="col-lg-6">
                            <p><b>Full Backup</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="fullBackup" name="fullBackup" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Yes" data-off="No">
                            </center>
                        </div>
                    </div>
		     <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		     <input class="d-none" id="startBackupGet" name="startBackupGet" type="text" value="">
		     <div class="row col-lg-12 <?php if($data['readOnlyAdminUser'] == 'Yes'){ ?>hide<?php } ?>" style="margin-bottom: 10px;">
                         		<div class="col-lg-6">
                             		<p><b>Backup</b>:</p>
                         		</div>
                         		<div class="col-lg-6">
                                    <center>
                             			<a ng-if="buttonValue=='startBackup'" class="btn btn-small btn-success startBackup" ng-class="{'false': 'disabled'}[isAllowBackup]" id="startBackup" name="startBackup" val="No" ng-click="startBackupButton()" style="border-radius:15px;">Start Backup</a>
                             			<a ng-if="buttonValue=='stopBackup'" class="btn btn-small btn-danger stopBackup" id="stopBackup" name="stopBackup" val="false" ng-bootbox-confirm="<h4>Stop Backup </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopBackupButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;" style="border-radius:15px;"><?=Language::show('Stop Backup', 'keywords');?></a>
                                        <a ng-if="buttonPauseValue=='pauseBackup'" class="btn btn-small btn-danger pauseBackup" id="pauseBackup" name="pauseBackup" val="false" ng-click="pauseBackupButton()" style="border-radius:15px;">Pause Backup</a>
                             			<a ng-if="buttonValue=='cancelBackup'" class="btn btn-small btn-warning cancelBackup" id="cancelBackup" name="cancelBackup" val="No" ng-click="cancelBackupButton()" style="border-radius:15px;">Cancel Schedule</a>
                                    </center>
                                </div>
                    </div>
                    <?php } ?>
		    <?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		    <input class="d-none" id="startRestoreGet" name="startRestoreGet" type="text" value="">
                    <div class="row col-lg-12 d-none" style="margin-bottom: 10px;">
                                        <div class="col-lg-6">
                                        <p><b>Restore</b>:</p>
                                        </div>
                                        <div class="col-lg-6">
                                    <center>
                                                <a ng-if="buttonValueRestore=='startRestore'" class="btn btn-small btn-success startRestore" id="startRestore" name="startRestore" val="No" ng-click="startRestoreButton()">Start Restore</a>
                                                <a ng-if="buttonValueRestore=='stopRestore'" class="btn btn-small btn-danger stopRestore" id="stopRestore" name="stopRestore" val="false" ng-bootbox-confirm="<h4>Stop Restore </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopRestoreButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Stop Restore', 'keywords');?></a>
<!--                                        <a ng-if="buttonPauseValueRestore=='pauseRestore'" class="btn btn-small btn-danger pauseRestore" id="pauseRestore" name="pauseRestore" val="false" ng-click="pauseRestoreButton()">Pause Restore</a>-->
                                                <a ng-if="buttonValueRestore=='cancelRestore'" class="btn btn-small btn-warning cancelRestore" id="cancelRestore" name="cancelRestore" val="No" ng-click="cancelRestoreButton()">Cancel Restore</a>
                                    </center>
                                </div>
                    </div>
                    <?php } ?>
                    <div class="row col-lg-12 stopBackupWhileRestoreBlock d-none">
                        <div class="col-lg-6">
                             <label for="stopBackupWhileRestoree" style="font-weight:600!important;"><?=Language::show('Disable Backup:', 'keywords');?></label>
                        </div>
                        <div class="form-group col-lg-6">
                            <center>
                                <label class="switch">
                                    <input id="stopBackupWhileRestore" name="stopBackupWhileRestore" type="checkbox">
                                    <div class="slider round"></div>
                                </label>
                            </center>
                        </div>
                    </div>
                    <p>Note: Some of the changes may take effect only during next policy refresh.</p>
                    <?= Form::close(); ?>
                </div>
                <div class="modal-footer">
					<!--<button type="submit" class="btn btn-primary">Save changes</button>-->
					<a class="btn btn-success disabled" id="saveBtn" data-dismiss="modal" ng-click="saveEventHub()">Save</a>
                    <button type="button" id="modalClose" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<!--event hub modal ends-->
<!--configure sites modal start-->
<div class="modal fade configureSites">
        <div class="modal-dialog" style="width:1250px;">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Configure Sites</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <!--added starts-->
                    <div class="usersFound">
                            <div class="table-responsive browsePathDivOnedrive col-lg-12">
                                <div class="row col-lg-12">
<div class="col-lg-4">
                                        <div class="checkbox check-primary" style="margin-top:15px;">
                                                <input id="autoDiscover" name="autoDiscover" id="autoDiscover" type="checkbox" value="enabled">
                                                <label for="autoDiscover"><?=Language::show('Automatically configure all discovered SharePoint sites', 'keywords');?></label>
                                        </div>
</div>
<div class="col-lg-4">
                                    <div class="form-group">
                                        <!--<label for="bucketName"><?=Language::show('Change Storage repository', 'keywords');?></label><br/>
                                        <input type="text" value="" class="form-control bucketName" name="bucketName" id="bucketName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('Destination OneDrive for Business account', 'keywords');?>" required autocomplete="off">-->
                                        <label for="policyName"><?=Language::show('SharePoint Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="policyName" id="policyName" required="">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                    </div>
                                </div>
                                </div>
<hr>
                                <div class="row col-lg-12">
<div class="form-group col-lg-12 row">
                                <input class="form-control col-lg-3" type="text" id="searchDiscoveredSite" onkeyup="searchDiscoveredSite()" placeholder="Search for Sites.." title="Type in a Site name">

<div class="form-group col-lg-3"></div>
                                <input class="form-control col-lg-3" type="text" id="searchConfiguredSite" onkeyup="searchConfiguredSite()" placeholder="Search for Sites.." title="Type in a Site name" style="margin-left: 12px;">
</div>
                                <div class="col-lg-4" style="border: 1px dotted #f27331;height: 250px;overflow-y: scroll;">
                                    <table id="discoveredSites" class="table table-hover table-bordered discoveredSites">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th class="clickAble" ng-click="sortTypeSites = 'value'; sortReverseSites = !sortReverseSites">
                                                        Discovered SharePoint Sites
                                                        <span ng-show="sortTypeSites == 'value' && !sortReverseSites" class="fa fa-caret-up"></span>
                                                        <span ng-show="sortTypeSites == 'value' && sortReverseSites" class="fa fa-caret-down"></span>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr ng-repeat="value in discoveredSites | orderBy:sortTypeSites:sortReverseSites" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value }}"/>
                                                </td>
                                                <td ng-click="pickElement(value, $index)" ng-cloak><span title="{{value}}" style="cursor: pointer;">{{value | limitTo:25}}{{value.length > 25 ? '...' : ''}}</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-lg-2">
<center style="margin-top:50%;">
                                    <a ng-click="itemSelect1()" class="block btn btn-small btn-success" style="width: 50%;">><a>
                                    <br>
                                    <a ng-click="addAllName()" class="block btn btn-small btn-success" style="width: 50%;"> >><a>
                                    <br>
                                    <a ng-click="removeName1()" class="block btn btn-small btn-danger" style="width: 50%;"><</a>
                                    <br>
                                    <a ng-click="removeAllName()" class="block btn btn-small btn-danger" style="width: 50%;"><<</a>
</center>
                                </div>
                                <div class="col-lg-6" style="border: 1px dotted #f27331;height: 250px;overflow-y: scroll;">
                                    <table id="addedSites" class="table table-hover table-bordered">
                                        <thead ng-show="siteMapKeys.length <= 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Configured Sites</th>
                                            </tr>
                                        </thead>
                                        <tbody ng-show="siteMapKeys.length <= 0">
                                            <tr>
                                                <td></td>
                                                <td ng-cloak><span>No Sites Selected</span></td>
                                            </tr>
                                        </tbody>
                                        <thead ng-show="siteMapKeys.length > 0" ng-cloak>
                                            <tr>
                                                <th></th>
                                                <th>Configured Sites</th>
                                                <th>Policy Assigned</th>
                                            </tr>
                                        </thead>
<tbody ng-show="siteMapKeys.length > 0">
                                            <tr ng-repeat="(key,value) in aad " class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-itemright checkbox" name="select-itemright" value="{{ key }}"/>
                                                </td>
                                                <td ng-click="pickElement1(key, $index)" ng-cloak><span title="{{key}}" style="cursor: pointer;">{{key | limitTo:25}}{{key.length > 25 ? '...' : ''}}</span></td>
                                                <td>
                                    <select class="form-control selectPolicyPicker policyNames" name="policyNames[]" id="policyName{{$index}}">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            $la = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>" ng-selected="value == '<?=$la?>'"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>
<!--<tbody ng-show="siteMapKeys.length > 0">
                                            <tr ng-repeat="(key,value) in aad" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-itemright checkbox" name="select-itemright" value="{{ value1 }}"/>
                                                </td>
                                                <td ng-click="pickElement1(key, $index)" ng-cloak><span title="{{key}}" style="cursor: pointer;">{{key | limitTo:25}}{{key.length > 25 ? '...' : ''}}</span></td>
                                                <td>
                                    <select class="form-control selectPolicyPicker policyNames" name="policyNames[]" id="policyName{{$index}}">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>-->
<!--                                        <tbody ng-show="addedSites.length > 0">
                                            <tr ng-repeat="value1 in addedSites" class="text-left">
                                                <td class="text-center">
                                                    <input type="checkbox" class="select-itemright checkbox" name="select-itemright" value="{{ value1 }}"/>
                                                </td>
                                                <td ng-click="pickElement1(value1, $index)" ng-cloak><span title="{{value1}}" style="cursor: pointer;">{{value1 | limitTo:25}}{{value1.length > 25 ? '...' : ''}}</span></td>
                                                <td>
                                    <select class="form-control selectPolicyPicker policyNames" name="policyNames[]" id="policyName{{$index}}">
                                        <?php if(!empty($data['sharepointPolicies1'])){ ?>
                                            <?php foreach($data['sharepointPolicies1'] as $key => $value){
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>-->
                                    </table>
                                </div>
                                <div class="col-lg-6">
                                </div>
</div>
                            </div>
                            <div class="col-lg-12" style="margin-top:5%;">
<div class="row">
                                <div class="col-lg-6">
                                </div>
                                <div class="col-lg-6">
                                    <a class="btn btn-success btn-small pull-right"
                                        ng-bootbox-confirm="<h4><?=Language::show('Are you sure you want to configure selected sites to the selected policy?', 'keywords')?></h4>"
                                        ng-bootbox-confirm-action="startSiteConfiguration()"
                                        ng-bootbox-confirm-action-cancel=""
                                        href="javascript:;"><?=Language::show('Configure Sites', 'keywords');?></a>
<button type="button" class="btn btn-default btn-small pull-right" data-dismiss="modal" style="margin-right:10px;">Close</button>
                                </div>
</div>
                            </div>
                        </div>
                        <!--added ends-->
                </div>
                <div class="modal-footer hide">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<!--configure sites model ends-->
        </div>
    </div>
    <div class="modal fade restoreBucket">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Restore Bucket</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                        <label for="searchDeviceName">Select a Device to restore on:</label>
                                        <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="restoreBucket.deviceName" data-parsley-trigger="change"></select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="restoreAllVersions">Do you want to restore all versions</label>
                                        <select class="form-control selectPicker" name="restoreAllVersions" id="restoreAllVersions" required="">
                                            <option value="true"><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="destinationPath">Enter a Destination Path(optional)</label>
                                        <input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPath" id="destinationPath" placeholder="Enter Destination Path" />
                                        <span class="help-block">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="sendFilesForRestore(restoreBucket.deviceName, restoreBucket.destinationPath)"  class="btn btn-default">Initiate Restore</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/BackupController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        if(o.deviceName != 'All'){
                            return { id: o.deviceName, text: o.deviceName, img: o.profilePic };
                        }else{
                            return { id: 'default', text: 'On to the same device', img: o.profilePic };
                        }
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'On to the same device'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }


$(".searchDeviceNameSharepointDevice").select2({
ajax: {
            url: "<?=DIR?>"+"getAllUnBlockedSites",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                return {
                    results: $.map(data.users, function (o) {
                return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        templateResult: selectTemplateResultSites,
        templateSelection: selectTemplateSelectionSites,
        placeholder: 'Select sites'
    });

    function selectTemplateResultSites(users){
    	if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionSites(users){

            console.log("gggggggg : "+users.text);
            if(users.text != 'Select user'){
            $.ajax({
            url: "<?=DIR?>"+"devicesSharepoint",
            data: {deviceName: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
            console.log("newone111 : "+jData.devicesSharepoint);
            console.log("newone111 : "+jData.devicesSharepoint[0].deviceUUID);
            if (jData.devicesSharepoint){
            var options = "";
/*jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
            });*/
//$('.searchDeviceNameOnedriveDevice').html(options);
	    /*xx start*/
//$("#uuuSharepointDevice").val(users.text);	   
$("#uuuSharepointDevice").val(jData.devicesSharepoint[0].deviceUUID);
        /*xx end*/
        	}else{
//              $('.searchDeviceNameOnedriveDevice').html("<option value='all' selected>User has no devices configured</option>");
//                $('.searchDeviceNameOnedriveDevice').attr("readonly", "readonly");
                $("#uuuSharepointDevice").val('');
            }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
            }
        return users.text;
    }
</script>
<script>
$('.restoreDateSharepointDevice').datepicker({
        format: 'dd-M-yyyy',
        autoclose: true,
        todayHighlight: true,
        container:'.restoreBuckettSharepointDevice'
    }).attr('readonly', 'readonly');

$(".restoreDateSharepointDevice").datepicker().datepicker("setDate", new Date());

$("#switchDateSharepointDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#restoreDateSharepointDevice').removeAttr('disabled');
        $('#restoreTimeSharepointDevice').removeAttr('disabled');
    } else {
        $('#restoreDateSharepointDevice').attr('disabled', true); //disable input
        $('#restoreTimeSharepointDevice').attr('disabled', true);
    }
});


$("#switchinplaceSharepointDevice").click(function(){
    if ($(this).is(':checked')) {
        $('#destinationPathSharepointDevice').val('');
        $('#destinationPathSharepointDevice').removeAttr('required', 'required');
        $('#destinationPathlabelSharepointDevice').removeClass('star');
        $('#destinationPathSharepointDevice').attr('disabled', true);
        $('#browseSharepointDevice').attr('disabled', true);
    } else {
        $('#destinationPathSharepointDevice').val('');
        $('#destinationPathSharepointDevice').removeAttr('disabled');
        $('#destinationPathlabelSharepointDevice').addClass('star');
        $('#destinationPathSharepointDevice').attr('required', 'required');
        $('#browseSharepointDevice').removeAttr('disabled');
    }
});

    function searchDiscoveredSite() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchDiscoveredSite");
        filter = input.value.toUpperCase();
        table = document.getElementById("discoveredSites");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }

    function searchConfiguredSite() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchConfiguredSite");
        filter = input.value.toUpperCase();
        table = document.getElementById("addedSites");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 55px;
  height: 25px;
}
.switch input {display:none;}
.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}
.slider:before {
  position: absolute;
  content: "";
  height: 18px;
  width: 18px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}
input:checked + .slider {
  background-color: #f27331;
}
input:focus + .slider {
  box-shadow: 0 0 1px #f27331;
}
input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}
/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}
.slider.round:before {
  border-radius: 50%;
}
</style>
<script>
    $('#agentLogs').on('change', function(){
        $('#saveBtn').removeClass('disabled');
            if($(this).prop('checked')){
                $('#historicalLogsBlock').show();
            }else{
                $('#historicalLogsBlock').hide();
                //$('#historicalLogs').prop('checked',false);
            }
    });
    $("#stopBackupWhileRestore").click(function(){
        $('#saveBtn').removeClass('disabled');
    });
	
    $("#agentLogs").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    $("#historicalLogs").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    $("#setupLogs").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    $("#databases").click(function(){
	$('#saveBtn').removeClass('disabled');
    });

    document.getElementById('agentLogs').addEventListener('click', function(){
	$('#saveBtn').removeClass('disabled');
    });
	
    $(function () {
	$('.ios').tooltip({ trigger: 'click' });
    });
</script>
<script>
    $('.searchUsernameEndPointDevice').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
        dropdownParent: $('.restoreBuckettEndPointDevice'),
        templateResult: selectTemplateResultEndPointDevice,
        templateSelection: selectTemplateSelectionEndPointDevice,
        placeholder: 'Select user'
    });
    
    function selectTemplateResultEndPointDevice(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }
    
    function selectTemplateSelectionEndPointDevice(users){
            console.log("gggggggg : "+users.text);
            if(users.text != 'Select user'){
            $.ajax({
            url: "<?=DIR?>"+"getDeviceEndPoint",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
            console.log("newone111 : "+jData.newone1);
            if (jData.newone1.length > 0){
            var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID +","+device.osType+ '">' + device.deviceName + '</option>'
});
//options += '<option value="OneDrive">My OneDrive</option>'
$('.searchDeviceNameEndPointDevice').html(options);
/*xx start*/
if (jData.newone1.length > 0){
$("#uuu").val(jData.newone1[0].deviceUUID);
$("#uuuOS").val(jData.newone1[0].osType);
 var src = jData.newone1[0].osType;
        if(src == 'apple'){
        src = 'mac';
        }
        src = src.substring(0, 3);
        src = src.toLowerCase();
        if(jData.newone1[0].osType){
            var dest = jData.newone1[0].osType;
            dest = dest.substring(0, 3);
            dest = dest.toLowerCase();
                if(src != dest)
                {
                        $('#switchinplaceEndPointDevice').attr('disabled', 'disabled');
                }else{
                        $('#switchinplaceEndPointDevice').removeAttr('disabled');
                }
        }
}
        /*xx end*/
            }else{
                $('.searchDeviceNameEndPointDevice').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameEndPointDevice').attr("readonly", "readonly");
                $("#uuu").val('');
            }
}).fail(function(data){
            $('.searchDeviceNameEndPointDevice').html("<option value='all' selected>User has no devices configured</option>");
            $('.searchDeviceNameEndPointDevice').attr("readonly", "readonly");
            $("#uuu").val('');
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
            }
        return users.text;
    }
    
    $("#searchDeviceNameEndPointDevice").change(function () {
            var ghr = $('#searchDeviceNameEndPointDevice').val();
            if($('#searchDeviceNameEndPointDevice').val() != 'OneDrive'){
                var uuid = ghr.split(",")[0];
                var os = ghr.split(",")[1];
                console.log("uuidvvvvvv : "+uuid);
                console.log("osvvvvvv : "+os);
                $("#uuu").val(uuid);
                $("#uuuOS").val(os);
                var src = os;
                if(src == 'apple'){
                        src = 'mac';
                }
                src = src.substring(0, 3);
                src = src.toLowerCase();
                if(os){
                    var dest = os;
                    dest = dest.substring(0, 3);
                    dest = dest.toLowerCase();
                        if(src != dest)
                        {
                                $('#switchinplaceEndPointDevice').attr('disabled', 'disabled');
                        }else{
                                $('#switchinplaceEndPointDevice').removeAttr('disabled');
                        }
                }
                $('#destinationPathEndPointDevice').val('');
                $('#destinationPathEndPointDevice').removeAttr('disabled');
                $('#destinationPathlabelEndPointDevice').addClass('star');
                $('#destinationPathEndPointDevice').attr('required', 'required');
                $('#noOfThreads').val('');
                $('#noOfThreads').removeAttr('disabled');
                $('#noOfThreads').addClass('star');
                $('#noOfThreads').attr('required', 'required');
                $('#switchinplaceEndPointDevice').removeAttr('disabled');
                $('#switchoverwriteNewerFilesEndPointDevice').removeAttr('disabled');
                $('#switchsuspendbackupEndPointDevice').removeAttr('disabled');
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style.opacity = "1";
                document.getElementById("suspendbackupEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("suspendbackupEndPointDeviceRow").style.opacity = "1";
                document.getElementById("noOfThreadsRow").style['pointer-events'] = 'unset';
                document.getElementById("noOfThreadsRow").style.opacity = "1";
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style['pointer-events'] = 'unset';
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style.opacity = "1";
                document.getElementById("destinationPathEndPointDeviceRow").style.display = "block";
                document.getElementById("destinationPathEndPointOnedriveDeviceRow").style.display = "none";
            }else{
                $("#uuu").val($('.deviceUUID').html());
                $('#destinationPathEndPointDevice').val('');
                $('#destinationPathEndPointDevice').removeAttr('required', 'required');
                $('#destinationPathlabelEndPointDevice').removeClass('star');
                $('#destinationPathEndPointDevice').attr('disabled', true);
                $('#noOfThreads').val('');
                $('#noOfThreads').removeAttr('required', 'required');
                $('#noOfThreads').removeClass('star');
                $('#noOfThreads').attr('disabled', true);
                $('#switchinplaceEndPointDevice').attr('disabled', true);
                $('#switchoverwriteNewerFilesEndPointDevice').attr('disabled', true);
                $('#switchsuspendbackupEndPointDevice').attr('disabled', true);
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("inPlaceRestoreEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("suspendbackupEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("suspendbackupEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("noOfThreadsRow").style['pointer-events'] = 'none';
                document.getElementById("noOfThreadsRow").style.opacity = "0.5";
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style['pointer-events'] = 'none';
                document.getElementById("overwriteNewerFilesEndPointDeviceRow").style.opacity = "0.5";
                document.getElementById("destinationPathEndPointDeviceRow").style.display = "none";
                document.getElementById("destinationPathEndPointOnedriveDeviceRow").style.display = "block";
            }

    });
</script>
<script>
    $('.searchUsernameOutlookDevice').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettOutlookDevice'),
        templateResult: selectTemplateResultOutlookDevice,
        templateSelection: selectTemplateSelectionOutlookDevice,
        placeholder: 'Select user'
    });

    function selectTemplateResultOutlookDevice(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionOutlookDevice(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceOutlook",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
});
$('.searchDeviceNameOutlookDevice').html(options);
/*xx start*/
$("#uuuOutlookDevice").val(jData.newone1[0].deviceUUID);
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameOutlookDevice').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameOutlookDevice').attr("readonly", "readonly");
		$("#uuuOutlookDevice").val('');
	    }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameOutlookDevice").change(function () {
	    console.log("inside change"+$('#searchDeviceNameOutlookDevice').val());
	    var uuid = $('#searchDeviceNameOutlookDevice').val();	    
	    $("#uuuOutlookDevice").val(uuid);        

    });
</script>
<script>
    $('.searchUsernameOnedriveDevice').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDeviceForRestore",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
	dropdownParent: $('.restoreBuckettOnedriveDevice'),
        templateResult: selectTemplateResultOnedriveDevice,
        templateSelection: selectTemplateSelectionOnedriveDevice,
        placeholder: 'Select user'
    });

    function selectTemplateResultOnedriveDevice(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelectionOnedriveDevice(users){
	    console.log("gggggggg : "+users.text);
	    if(users.text != 'Select user'){
	    $.ajax({
            url: "<?=DIR?>"+"getDeviceOnedrive",
            data: {username: users.text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            var jData = JSON.parse(data);
	    console.log("newone111 : "+jData.newone1);
	    if (jData.newone1){
	    var options = "";
jData.newone1.forEach(function (device) {
                    options += '<option value="' + device.deviceUUID + '">' + device.deviceName + '</option>'
});
$('.searchDeviceNameOnedriveDevice').html(options);
/*xx start*/
$("#uuuOnedriveDevice").val(jData.newone1[0].deviceUUID);
	/*xx end*/
	    }else{
	    	$('.searchDeviceNameOnedriveDevice').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceNameOnedriveDevice').attr("readonly", "readonly");
		$("#uuuOnedriveDevice").val('');
	    }
}).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
});
	    }
        return users.text;
    }

    $("#searchDeviceNameOnedriveDevice").change(function () {
	    console.log("inside change"+$('#searchDeviceNameOnedriveDevice').val());
	    var uuid = $('#searchDeviceNameOnedriveDevice').val();	    
	    $("#uuuOnedriveDevice").val(uuid);        

    });
</script>
<script>		
    function searchedBluvaultDevices() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchBluvaultInput");
        filter = input.value.toUpperCase();
        table = document.getElementById("devicesListTable");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[0];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }
	
    function searchedExchangeDevices() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchExchangeInput");
        filter = input.value.toUpperCase();
        table = document.getElementById("devicesListExchangeTable");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[0];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }
	
    function searchedOnedriveDevices() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchOnedriveInput");
        filter = input.value.toUpperCase();
        table = document.getElementById("devicesListOnedriveTable");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[0];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }
	
    function searchedSharepointDevices() {
        var input, filter, table, tr, td, i, txtValue;
        input = document.getElementById("searchSharepointInput");
        filter = input.value.toUpperCase();
        table = document.getElementById("devicesListSharepointTable");
        tr = table.getElementsByTagName("tr");
        for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[0];
                if (td) {
                        txtValue = td.textContent || td.innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                                tr[i].style.display = "";
                        } else {
                                tr[i].style.display = "none";
                        }
                }
        }
    }	
</script>
<style>
    .invalid{
        background-color: gainsboro !important;
	pointer-events:none !important;
    }
</style>
