/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('HistoryController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', function($scope, toastr, $http, $ngBootbox, blockUI,BASE_FOLDER) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.sortReverse = true;
    $scope.sortReverseUA = true;
    $scope.sortReverseQL = true;
    $scope.sortReverseQD = false;
    $scope.sortType = 'endTimeLong';
    $scope.sortTypeUA = 'backupStartTimestamp';
    $scope.sortTypeQL = 'timestampInMillis';
    $scope.sortTypeQD = 'deviceName';
    $scope.summary = {};
    $scope.history = '';
    $scope.historyDetails = '';
    $scope.pageNumber = 1;
    $scope.limitNumber = 50;
    $scope.audits = [];
    $scope.historyDetailsType = '';
    $scope.skipValue = 0;
    $scope.currentpageCount = '';
    $scope.totalpageCount = '';
    
    $scope.updateDeviceBackupHistory = function(){
        $('.first').hide();
        $('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/backupHistory',
            data: {secret: '',csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            $('.deviceHistoryTable').show();
            var jData = JSON.parse(data);
            $scope.previous = jData.metadata.links.previous;
            $scope.next = jData.metadata.links.next;
            $scope.last = jData.metadata.links.last;
            $scope.self = jData.metadata.links.self;
            $scope.first = jData.metadata.links.first;
            $scope.currentpageCount = jData.metadata.pageNumber;
            $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
            if($scope.first){
            $('.first').show();
            }
            if($scope.self){
            $('.self').show();
            }
            if($scope.previous){
            $('.previous').show();
            }
            if($scope.next){
            $('.next').show();
            }
            if($scope.last){
            $('.last').show();
            }
            $scope.summary.completedPercentage      = jData.summary.completedPercentage;
            $scope.summary.totalNoOfFiles           = jData.summary.totalNoOfFiles;
            $scope.summary.noOfFilesToBeUploaded    = jData.summary.noOfFilesToBeUploaded;
            if(jData.history.length > 0){
                $scope.history = jData.history;
            }else{
                $('.deviceHistoryTable').hide();
                $('.loading').show();
                $('.loading').html('There is no history of backup...!');
            }
	    if(jData.history.length > 10){
		    $('.deviceHistoryTableDiv').css('overflowY', 'scroll');
                    $('.deviceHistoryTableDiv').height('400px');
	    }else{
		    $('.deviceHistoryTableDiv').css('overflowY', 'unset');
		    $('.deviceHistoryTableDiv').height('inherit');
	    }
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateDeviceBackupHistoryNavigate = function(url){
        $('.first').hide();
        $('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/backupHistory1',
            data: {secret: '',csrf_token: $('.token').html(),url:url},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            $('.deviceHistoryTable').show();
            var jData = JSON.parse(data);
            $scope.previous = jData.metadata.links.previous;
            $scope.next = jData.metadata.links.next;
            $scope.last = jData.metadata.links.last;
            $scope.self = jData.metadata.links.self;
            $scope.first = jData.metadata.links.first;
            $scope.currentpageCount = jData.metadata.pageNumber;
            $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
	    $(window).scrollTop(0);
            if($scope.first){
            $('.first').show();
            }
            if($scope.self){
            $('.self').show();
            }
            if($scope.previous){
            $('.previous').show();
            }
            if($scope.next){
            $('.next').show();
            }
            if($scope.last){
            $('.last').show();
            }
            $scope.summary.completedPercentage      = jData.summary.completedPercentage;
            $scope.summary.totalNoOfFiles           = jData.summary.totalNoOfFiles;
            $scope.summary.noOfFilesToBeUploaded    = jData.summary.noOfFilesToBeUploaded;
            if(jData.history.length > 0){
                $scope.history = jData.history;
            }else{
                $('.deviceHistoryTable').hide();
                $('.loading').show();
                $('.loading').html('There is no history of backup...!');
            }
	    if(jData.history.length > 10){
		    $('.deviceHistoryTableDiv').css('overflowY', 'scroll');
                    $('.deviceHistoryTableDiv').height('400px');
	    }else{
		    $('.deviceHistoryTableDiv').css('overflowY', 'unset');
		    $('.deviceHistoryTableDiv').height('inherit');
	    }
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.showHistoryDetails = function(batchId, type, count){
        if(count != '0' && count != '0 (0 %)' ){
            blockUI.start();
            $scope.historyDetailsType = type;
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/backupHistoryDetails',
                data: {batchId: batchId, csrf_token: $('.token').html()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                $('.loading').hide();
                $('.deviceHistoryDetailsTable').show();
                if(jData.historyDetails != null){
                    $scope.historyDetails = jData.historyDetails;
                }else{
                    $('.deviceHistoryDetailsTable').hide();
                    $('.loading').show();
                    $('.loading').html('There is no details for the selected backup history...');
                }
                $scope.$apply();
                $('.backupHistoryDetailsModal').modal('show');
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.info('There are no files to show details about', 'Information!!!', {allowHtml: true});
        }
    };

    //$scope.updateBackupActivityDetails = function(rows, pbAuditUserName, pbAuditDeviceName, pageNumber){
    $scope.updateBackupActivityDetails = function(pbAuditUserName, pbAuditDeviceName, pageNumber){
        var pageNumber = $scope.pageNumber;
	$('.first').hide();
	$('.self').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/activityHistory',
            data: {
		//rows: rows,
                pbAuditUserName: pbAuditUserName,
                pbAuditDeviceName: pbAuditDeviceName,
                pageNumber: pageNumber,
                csrf_token: $('.csrf_token').html()
            },
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}
		if($scope.self){
			$('.self').show();
		}
		if($scope.previous){
			$('.previous').show();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}
                if(jData.audits.length > 0){
                    //$scope.audits = $scope.audits.concat(jData.audits);
                    $scope.audits = jData.audits;
                    $scope.pageNumber = pageNumber+1;
                    $('.loadMore').show();
                }else{
                    $('.loadMore').hide();
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.navigate = function(url){
	$('.first').hide();
	$('.self').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/activityHistory1',
            data: {
                url: url,
                csrf_token: $('.csrf_token').html()
            },
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
	    	window.scrollTo(0, 0);
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		$(window).scrollTop(0);
		if($scope.first){
			$('.first').show();
		}
		if($scope.self){
			$('.self').show();
		}
		if($scope.previous){
			$('.previous').show();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}
                if(jData.audits.length > 0){
		//$scope.audits = $scope.audits.concat(jData.audits);
		$scope.audits = jData.audits;
		//$scope.pageNumber = pageNumber+1;
                    $('.loadMore').show();
                }else{
                    $('.loadMore').hide();
                }
		$scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateShareActivityHistory = function(skipValue){
        var html = $('.loadMoreBtn').html();
        $('.loadMoreBtn').attr('disabled','disabled');
        $('.loadMoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        var pageNumber = $scope.pageNumber;
        $('.first').hide();
        //$('.self').hide();
        $('.previous').hide();
        $('.next').hide();
        $('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/share/activityHistory',
            data: {csrf_token: $('.csrf_token').html(), skipValue: skipValue, pageNumber: pageNumber},
            type: 'POST'
        }).done(function(data){
            $('.loadMoreBtn').removeAttr('disabled');
            $('.loadMoreBtn').html(html);
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.metadata != '' && jData.audits.length > 0){
                    $('.Navigate').show();
                    $('.status').hide();
                    $scope.previous = jData.metadata.links.previous;
                    $scope.next = jData.metadata.links.next;
                    $scope.last = jData.metadata.links.last;
                    //$scope.self = jData.metadata.links.self;
                    $scope.first = jData.metadata.links.first;
                    $scope.currentpageCount = jData.metadata.pageNumber;
                    $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
                    if($scope.first){
                    $('.first').show();
                    }
                    if($scope.previous){
                    $('.previous').show();
                    }
                    if($scope.next){
                    $('.next').show();
                    }
                    if($scope.last){
                    $('.last').show();
                    }
                    $scope.audits = jData.audits;
                 }else{
                    $('.Navigate').hide();
                    $('.status').show();
                 }                
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
	    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateShareActivityHistoryNavigate = function(url){
            var html = $('.loadMoreBtn').html();
            $('.loadMoreBtn').attr('disabled','disabled');
            $('.loadMoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $('.first').hide();
            //$('.self').hide();
            $('.previous').hide();
            $('.next').hide();
            $('.last').hide();
            $.ajax({
                url: $scope.BASE_FOLDER+'/share/activityHistory1',
                data: {csrf_token: $('.csrf_token').html(), url: url},
                type: 'POST'
            }).done(function(data){
                $('.loadMoreBtn').removeAttr('disabled');
                $('.loadMoreBtn').html(html);
                blockUI.stop();
                $('.loading').hide();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
		    window.scrollTo(0, 0);
                    if(jData.metadata != '' && jData.audits.length > 0){
                        $('.Navigate').show();
                        $('.status').hide();
                        $scope.previous = jData.metadata.links.previous;
                        $scope.next = jData.metadata.links.next;
                        $scope.last = jData.metadata.links.last;
                        //$scope.self = jData.metadata.links.self;
                        $scope.first = jData.metadata.links.first;
                        $scope.currentpageCount = jData.metadata.pageNumber;
                        $scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
			$(window).scrollTop(0);
                        if($scope.first){
                        $('.first').show();
                        }
                        /*if($scope.self){
                        $('.self').show();
                        }*/
                        if($scope.previous){
                        $('.previous').show();
                        }
                        if($scope.next){
                        $('.next').show();
                        }
                        if($scope.last){
                        $('.last').show();
                        }
                        $scope.audits = jData.audits;
                     }else{
                        $('.Navigate').hide();
                        $('.status').show();
                     }
                    $scope.$apply();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };
    
    $scope.downloadLogFile = function(log1,log2){
        var log = log1+"/"+log2;
            $.ajax({
                url: $scope.BASE_FOLDER+'/checkFile',
                data: {id: log1, name : log2,csrf_token: $('.token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    window.location.href = $scope.BASE_FOLDER+'/downloadLogOne'+'/'+log1+'/'+log2;
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
     };
    
    $scope.showDetailedAnalysis = function(batchId){
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/backupAttemps',
            data: {secret: '',csrf_token: $('.token').html(),batchId:batchId},
            type: 'POST'
        }).done(function(data){
            $('.detailedAnalysis').modal('show');
            var jData = JSON.parse(data);
            $scope.batchElements = jData.batchElements;
            $scope.$apply();
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'shareActivityHistory'){
            blockUI.start();
            $scope.updateShareActivityHistory();
        }
        if($scope.currentPage == 'deviceBackupHistory'){
            blockUI.start();
            $scope.updateDeviceBackupHistory();
        }
        if($scope.currentPage == 'backupActivityHistory'){
            blockUI.start();
            //$scope.updateBackupActivityDetails(50, '', '', 0);
            $scope.updateBackupActivityDetails('', '', 1);
        }
        if($scope.currentPage == 'dashboard'){
            blockUI.start();
            $scope.updateBackupActivityDetails(5, '', '', 0);
        }
	if($scope.currentPage == 'unusualActivityHistory'){ 
                $scope.unusualActivityHistory(1);
                $scope.quarantineDevices();
                $scope.uploadStatistics();
        }
	if($scope.currentPage == 'quarantineList'){
		$scope.uploadStatistics();
	}
	if($scope.currentPage == 'ransomwareActivityHistory'){
                $scope.unusualActivityHistory(1);
        }
    });
	
    /*unusual activity*/
    $scope.unusualActivityHistory = function(pageNumber){
	$('.leftPanel').removeClass('col-lg-6');
        $('.leftPanel').addClass('col-lg-12');
        $('.rightPanel').hide();
        var pageNumber = $scope.pageNumber;
	$('.first').hide();
	$('.self').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
	$('.downloadLogs').hide();
        //$('.quarantineDevice').hide();
        $('.ignore').hide();
        //$('.enableDevice').hide();
	$scope.ualen = 0;
	$('.quarantineSpecificDevice').hide();
        $('.enableSpecificDevice').hide();
        $('.downloadSpecificLogs').hide();
        $('.ignoreSpecific').hide();
	$('#allUnusualSpinner').show();
	var onlyActive = $("#activeIncidents").prop('checked');
	if($('.redirectFrom').html() == 'fromDashboard'){
                var isAuditHistory = 'false';
        }else{
                var isAuditHistory = 'true';
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/unusualActivityHistory',
            data: {
                pageNumber: pageNumber,
                csrf_token: $('.csrf_token').html(),
                userName: $('.userName').html(),
                deviceName: $('.deviceName').html(),
                deviceUUID: $('.deviceUUID').html(),
		onlyActive: onlyActive,
		isAuditHistory: isAuditHistory
            },
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$('#allUnusualSpinner').hide();
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}
		if($scope.self){
			$('.self').show();
		}
		if($scope.previous){
			$('.previous').show();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}
                if(jData.audits.length > 0){
                    $scope.audits = jData.audits;
		    $scope.auditsUnique = jData.auditsUnique;
                    $scope.pageNumber = pageNumber+1;
                    $('.loadMore').show();
		    $('.records').show();
                    $('.noRecords').hide();
                }else{
                    $('.loadMore').hide();
		    $('.noRecords').show();
                    $('.records').hide();
                }
		    $scope.totalAlerts = jData.totalAlerts;
		    $scope.totalActiveAlerts = jData.totalActiveAlerts;
		    $scope.totalDevicesAffected = jData.totalDevicesAffected;
		    $scope.alertType = jData.alertType;		    
		    $scope.backupStartTime = jData.backupStartTime;		    
		    $scope.infFiles = jData.infFiles;
		    $scope.delFiles = jData.delFiles;
		    $scope.newFiles = jData.newFiles;
		    $scope.modifiedFiles = jData.modifiedFiles;
		    $scope.totalFiles = jData.totalFiles;
		    //console.log("a : "+$scope.totalAlerts);
		    $scope.userRole = jData.userRole;
		    //$scope.osType = jData.audits[0].osType;
		    if($scope.currentPage == 'unusualActivityHistory'){ 
		    	if(jData.audits != null && jData.audits.length < jData.metadata.recordsPerPage){
                        	$('.next').addClass('invalid');
                	}else{
                        	$('.next').removeClass('invalid');
                	}
		    }
		    if($scope.currentPage == 'ransomwareActivityHistory'){
                        if(jData.audits.length > 0 ){
                                $('.noactivity').hide();
                                $('.activity').show();
                                $('.next').addClass('invalid');
                        }else{
                                $('.noactivity').show();
                                $('.activity').hide();
                                $('.next').removeClass('invalid');
                        }
                    }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	        }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.navigateUnusualActivityHistory = function(url){
	$('.first').hide();
	$('.self').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
	var onlyActive = $("#activeIncidents").prop('checked');
	if($('.redirectFrom').html() == 'fromDashboard'){
                var isAuditHistory = 'false';
        }else{
                var isAuditHistory = 'true';
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/unusualActivityHistory1',
            data: {
                url: url,
                csrf_token: $('.csrf_token').html(),
                userName: $('.userName').html(),
                deviceName: $('.deviceName').html(),
                deviceUUID: $('.deviceUUID').html(),
		onlyActive: onlyActive,
		isAuditHistory: isAuditHistory
            },
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		$(window).scrollTop(0);
		if($scope.first){
			$('.first').show();
		}
		if($scope.self){
			$('.self').show();
		}
		if($scope.previous){
			$('.previous').show();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}
                if(jData.audits.length > 0){
		    $scope.audits = jData.audits;
                    $('.loadMore').show();
                }else{
                    $('.loadMore').hide();
                }
		if(jData.audits.length > 0){
                    $scope.audits = jData.audits;
		    $scope.auditsUnique = jData.auditsUnique;
                    $('.loadMore').show();
		    $('.records').show();
                    $('.noRecords').hide();
                }else{
                    $('.loadMore').hide();
		    $('.noRecords').show();
                    $('.records').hide();
                }
		    $scope.totalAlerts = jData.totalAlerts;
		    $scope.totalActiveAlerts = jData.totalActiveAlerts;
		    $scope.totalDevicesAffected = jData.totalDevicesAffected;
		    $scope.alertType = jData.alertType;		    
		    $scope.backupStartTime = jData.backupStartTime;		    
		    $scope.infFiles = jData.infFiles;
		    $scope.delFiles = jData.delFiles;
		    $scope.newFiles = jData.newFiles;
		    $scope.modifiedFiles = jData.modifiedFiles;
		    $scope.totalFiles = jData.totalFiles;
		    //console.log("a : "+$scope.totalAlerts);
		    $scope.userRole = jData.userRole;
		    //$scope.osType = jData.audits[0].osType;
		    if($scope.currentPage == 'unusualActivityHistory'){ 
		    	if(jData.audits != null && jData.audits.length < jData.metadata.recordsPerPage){
                        	$('.next').addClass('invalid');
                	}else{
                        	$('.next').removeClass('invalid');
                	}
		    }
		    if($scope.currentPage == 'ransomwareActivityHistory'){
                        if(jData.audits.length > 0 ){
                                $('.noactivity').hide();
                                $('.activity').show();
                                $('.next').addClass('invalid');
                        }else{
                                $('.noactivity').show();
                                $('.activity').hide();
                                $('.next').removeClass('invalid');
                        }
                    }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
	}).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

   $("#select-allUA").click(function () {
	var checked = this.checked;
	$("input.select-itemUA").each(function (index,item) {
		item.checked = checked;
	});
        var len = $("input.select-itemUA:checked:checked").length;
	if(len >1){
		$('.ignore').show();
	}else{
		$('.ignore').hide();
	}
   });

   $("#select-allS").click(function () {
        var checked = this.checked;
	$("input.select-itemS").each(function (index,item) {
		item.checked = checked;
	});
        var len = $("input.select-itemS:checked:checked").length;
        if(len >1){
                $('.ignoreSpecific').show();
        }else{
                $('.ignoreSpecific').hide();
        }
   });

   $scope.itemSelectUA = function(statuss, deviceUUID, batchId){	
	$scope.statuss = statuss;
	$scope.deviceUUID = deviceUUID;
	$scope.batchId = batchId;
        var all = $("input.select-allUA")[0];
        var total = $("input.select-itemUA").length;
        var len = $("input.select-itemUA:checked:checked").length;
	$scope.ualen = len;
	if(len > 0){
               $('.downloadLogs').show();
               $('.ignore').show();
               if(len > 1){
               	$('.downloadLogs').hide();
               }
               if(len > 1){
		//$('.quarantineDevice').hide();
  		//$('.enableDevice').hide();
               }
               if(len == 1 && statuss == false){
    		//$('.quarantineDevice').show();
      		//$('.enableDevice').hide();
               }else if(len == 1 && statuss == true){
        	//$('.quarantineDevice').hide();
          	//$('.enableDevice').show();
               }
        }else{
                $('.downloadLogs').hide();
		//$('.quarantineDevice').hide();
                $('.ignore').hide();
  		//$('.enableDevice').hide();
        }
	$scope.$evalAsync();
	/*if(len > 0){
		$('.downloadLogs').show();
                $('.quarantineDevice').show();
                $('.ignore').show();
		if(len > 1){
			$('.downloadLogs').hide();
			$('.quarantineDevice').hide();
		}
	}else{
		$('.downloadLogs').hide();
                $('.quarantineDevice').hide();
                $('.ignore').hide();
	}*/
	/*all.checked = len===total;
        var usersSelected;
        var arr = $('input.select-item:checkbox:checked').map(function () {
            return this.value;
        }).get();
        usersSelected = arr;
	    var xx = $('#selectedUsers').val();
	    if(xx.includes(vall) ){
		    var ary = xx.split(',');
		    ary.splice(ary.indexOf(vall),1)
		    var result = ary;
		    usersSelected = result;
	    }else{
	    var usersSelected = usersSelected.concat($('#selectedUsers').val());
	    }
        $('.selectedUsers').tagsinput('removeAll');
        $('.selectedUsers').tagsinput('add', usersSelected.join());*/
	var arr = $('input.select-itemUA:checkbox:checked').map(function () {
            return this.value;
           }).get();      
    };

    $scope.itemSelectS = function(statuss, deviceUUID, batchId){
        $scope.statuss = statuss;
        $scope.deviceUUID = deviceUUID;
        $scope.batchId = batchId;
        var all = $("input.select-allS")[0];
        var total = $("input.select-itemS").length;
        var len = $("input.select-itemS:checked:checked").length;
        $scope.ualen = len;
        if(len > 0){
               $('.downloadSpecificLogs').show();
               $('.ignoreSpecific').show();
               if(len > 1){
                $('.downloadSpecificLogs').hide();
               }
               if(len > 1){
		//$('.quarantineSpecificDevice').hide();
  		//$('.enableSpecificDevice').hide();
               }
               if(len == 1 && statuss == false){
    		//$('.quarantineSpecificDevice').show();
      		//$('.enableSpecificDevice').hide();
               }else if(len == 1 && statuss == true){
        	//$('.quarantineSpecificDevice').hide();
          	//$('.enableSpecificDevice').show();
               }
        }else{
                $('.downloadSpecificLogs').hide();
		//$('.quarantineSpecificDevice').hide();
                $('.ignoreSpecific').hide();
  		//$('.enableSpecificDevice').hide();
        }
        $scope.$evalAsync();
        /*if(len > 0){
                $('.downloadSpecificLogs').show();
                $('.quarantineSpecificDevice').show();
                $('.ignoreSpecific').show();
                if(len > 1){
                        $('.downloadSpecificLogs').hide();
                        $('.quarantineSpecificDevice').hide();
                }
        }else{
                $('.downloadSpecificLogs').hide();
                $('.quarantineSpecificDevice').hide();
                $('.ignoreSpecific').hide();
        }*/
        var arr = $('input.select-itemS:checkbox:checked').map(function () {
            return this.value;
           }).get();
    };

    $scope.unusualActivityAction = function(action, deviceUUID){	
        $.ajax({
            url: $scope.BASE_FOLDER+'/history/unusualActivityAction',
            data: {csrf_token: $('.csrf_token').html(),action: action, id: $scope.id, deviceUUID: deviceUUID},
            type: 'POST'
        }).done(function(data){
                $scope.unusualActivityHistory(1);
		$scope.$apply();
		if(action == 'getLogs'){
			toastr.success('Logs will appear in the support logs page at the next policy refresh','Logs request sent successfully!!!', {allowHtml: true});
		}else{
			toastr.success('Successful!!!', {allowHtml: true});
		}
		//toastr.success('Successful!!!', {allowHtml: true});
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.unusualActivityActionSpecific = function(action){
        var arr = $('input.select-itemS:checkbox:checked').map(function () {
            return this.value;
           }).get();
        var idArr = arr;
        console.log("arr : "+arr);
        $.ajax({
            url: $scope.BASE_FOLDER+'/history/unusualActivityAction',
            data: {csrf_token: $('.csrf_token').html(),action: action, id: idArr},
            type: 'POST'
        }).done(function(data){
              $scope.unusualActivityHistory(1);
              $scope.$apply();
        toastr.success('Successful!!!', {allowHtml: true});
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getLogs = function(){
	$scope.downloadLogFile($scope.deviceUUID, $scope.batchId);
    };

    $scope.uploadSampleModal = function(){
	$('#uploadSampleModal').modal('show');
    };

    $scope.uploadStatistics = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/history/getInfStatistics',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){           
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		    console.log("fileCount : "+jData.fileCount);
		    $scope.uploadedInfFilesCount = jData.fileCount;
		    $scope.quarantineList = jData.quarantineList;
		    console.log("scope.quarantineList.length : "+$scope.quarantineList.length);
		    if($scope.quarantineList.length > 0){
                        $('.recordsQL').show();
			$('.noRecordsQL').hide();
                    }else{
                        $('.noRecordsQL').show();
			$('.recordsQL').hide();
                    }
		    if($scope.uploadedInfFilesCount >= 50){
		    	$('.infForm').hide();
		    }else{
		    	$('.infForm').show();
		    }
		    if($scope.uploadedInfFilesCount >= 20){
                        $('.quarantineListDiv').height('500px');
                    }else{
                        $('.quarantineListDiv').height('fit-content');
                    }
		//toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});                
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $scope.quarantineDevices = function(){
            console.log("inside scope.quarantineDevices");
        $.ajax({
            url: $scope.BASE_FOLDER+'/history/quarantineDevices',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                    console.log("quarantineDevices : "+jData.quarantineDevices);
                    $scope.quarantineDevicesList = jData.quarantineDevices;
                    if($scope.quarantineDevicesList.length > 0){
                        $('.recordsMUD').show();
                        $('.noRecordsMUD').hide();
                    }else{
                        $('.noRecordsMUD').show();
                        $('.recordsMUD').hide();
                    }
                    if($scope.quarantineDevices.length >= 20){
                        $('.quarantineDevicesListDiv').height('500px');
                    }else{
                        $('.quarantineDevicesListDiv').height('fit-content');
                    }
                //toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});                */
                $scope.$apply();
            }else if(jData.result == 'fail_empty'){
                    $('.noRecordsMUD').show();
                    $('.recordsMUD').hide();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
			window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $('#infFileName').on('change', function(evt) {
	if(this.files[0].size > 8388608){
		toastr.error('File size more than 8Mb not allowed', {allowHtml: true});		
        	$('.infFileSave').attr('disabled','disabled');
	}else{		
        	$('.infFileSave').removeAttr('disabled');
	}
    });

    $('.infForm').on('submit', function(event){
	var formData = new FormData($('.infForm')[0]);
	$.ajax({
		    xhr: function() {
			var xhr = new window.XMLHttpRequest();
			xhr.upload.addEventListener("progress", function(evt) {
				$('#progress-div-inf').show();
			    if (evt.lengthComputable) {
				var percentComplete = (evt.loaded / evt.total) * 100;
				    percentComplete = percentComplete.toFixed(1);
				    $("#progress-bar-inf").width(percentComplete + '%');
				    $("#progress-bar-inf").html('<div id="progress-status-inf">' + percentComplete +' %</div>')
			    }
			}, false);
			return xhr;
		    },
	            type: 'POST',
	            url: $scope.BASE_FOLDER+'/history/uploadInfFile',
	            data: formData,
	            processData: false,
	            contentType: false
	        }).done(function(data){
	            var jData = $.parseJSON(data);
	            if(jData.result == 'success'){
	                toastr.success(jData.msg, 'Successful!!! ', {allowHtml: true});
	                document.getElementById('InfFileUploadingProgress').innerHTML = 'Details are being saved in server <i class="fa fa-spinner fa-pulse fa-fw"></i>';
	                //start
	                        $.ajax({
	                            type: 'POST',
	                            url: $scope.BASE_FOLDER+'/history/uploadInfFileApi',
	                            data: formData,
	                            processData: false,
	                            contentType: false
	                        }).done(function(data){
	                            var jData = JSON.parse(data);
	                            if(jData.result == 'success'){
	                                document.getElementById('InfFileUploadingProgress').innerHTML = '';
	                                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
									setTimeout(function(){
				                        window.location.reload();
			                	        }, 2000);
	                            }else{
	                                document.getElementById('InfFileUploadingProgress').innerHTML = '';
	                                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	                            }
	                        }).fail(function(data){
	                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	                            if(data.status == 424){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                                }, 3000);
	                            }else if(data.status == 503){
	                                setTimeout(function(){
	                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                                }, 3000);
	                            }
	                        });
	                //end
	            }else{
                    	document.getElementById('InfFileUploadingProgress').innerHTML = '';
			$('#progress-div-inf').hide();
	                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
	            }
	        }).fail(function(data){
	            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
	            if(data.status == 424){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	                }, 3000);
	            }else if(data.status == 503){
	                setTimeout(function(){
	                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
	                }, 3000);
	            }
	        });

    });

    $scope.showTrend = function(){
	$('.infGraph').modal('show');
	plotTrend();
    };

    function plotTrend(){
	var xValues = $scope.backupStartTime;
	const data = {
  			labels: xValues,
  			datasets: [
				    {
				      label: 'Infected Files',
				      data: $scope.infFiles,
				      borderColor: 'rgb(233, 15, 15, 1)',
                                      backgroundColor: 'rgba(233, 15, 15, 1)',				      
				      fill: false
				    },
				    {
				      label: 'New Files',
				      data: $scope.newFiles,
				      borderColor: 'rgba(255, 206, 86, 1)',
      				      backgroundColor: 'rgba(255, 206, 86, 1)',
				      fill: false
				    },
				    {
				      label: 'Deleted Files',
				      data: $scope.delFiles,
				      borderColor: 'rgba(153, 102, 255, 1)',
				      backgroundColor: 'rgba(153, 102, 255, 1)',
				      fill: false
				    },
                                    {
                                      label: 'Modified Files',
                                      data: $scope.modifiedFiles,
                                      borderColor: 'rgba(54, 162, 235, 1)',
				      backgroundColor: 'rgba(54, 162, 235, 1)',
                                      fill: false
                                    }
  			]
    };
	var barColors = ["red", "green","blue","orange","brown"];
	new Chart("myChart11", {
  		type: "line",
  		data: data,
  		options: {
    			legend: {display: true},
    			responsive : false,
    			scales: {
				xAxes: [{
	  				ticks: {
                				beginAtZero: true
	          			},
		          		scaleLabel: {
            					display: true,
            					labelString: 'Backup Start Time'
          				}
        			}],
        			yAxes: [{
	  				ticks: {
                				beginAtZero: true
          				},
          				scaleLabel: {
            					display: true,
            					labelString: 'Files Count'
          				}
        			}]	
      			}, 
    		title: {
      			display: true,
      			text: "Unusual Activity History Trend"
		}
	}
    });
/*//mychart1 start
	console.log("inffiles"+$scope.infFiles);
	console.log("totalfiles"+$scope.totalFiles);
var mychart1 = document.getElementById('myChart11').getContext('2d');
var deviceProtected = new Chart(mychart1, {
    type: 'bar',
    data: {
		labels: ['Statistics'],
	        datasets: [
{
            label: 'Total devices full backup completed',
            data: [10, 20, 40, 20, 50, 57],
            backgroundColor: 'rgba(54, 162, 235, 0.2)',
            borderColor: 'rgba(54, 162, 235, 1)',
            borderWidth: 1
},
{
            label: 'Devices with hearbeat to the server',
            data: [40, 50, 60, 30, 55, 75],
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            borderColor: 'rgba(75, 192, 192, 1)',
            borderWidth: 1
},

]
    }
});
//mychart1 end*/
}

    $('#activeIncidents').on('change', function(){            
	$scope.unusualActivityHistory(1);            
    });

    $scope.hidedetails1 = function(deviceName, userName, deviceUUID, batchId){
	$(".collapse").removeClass("show");
        $('#hidedetails1_'+deviceUUID).hide();
        $('#showdetails1_'+deviceUUID).show();
    };

    $scope.showEvents1 = function(deviceName, userName, deviceUUID, batchId){
	$scope.selectedRowMails = -1;
	$(".collapse").removeClass("show");
	$("[id*='hidedetails1_']").hide();
	$("[id*='showdetails1_']").show();
	$('#hidedetails1_'+deviceUUID).show();
	$('#showdetails1_'+deviceUUID).hide();
	$('.rightPanel').hide();
	var onlyActive = $("#activeIncidents").prop('checked');
	var pageNumber = $scope.pageNumber;
        $.ajax({
            url: $scope.BASE_FOLDER+'/unusualActivityHistory',
            data: {
                pageNumber: pageNumber,
                csrf_token: $('.csrf_token').html(),
                userName: userName,
                deviceName: deviceName,
                deviceUUID: deviceUUID,
		onlyActive: onlyActive
            },
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		$('#allUnusualSpinner').hide();
		$scope.previous = jData.metadata.links.previous;
		$scope.next = jData.metadata.links.next;
		$scope.last = jData.metadata.links.last;
		$scope.self = jData.metadata.links.self;
		$scope.first = jData.metadata.links.first;
		$scope.currentpageCount = jData.metadata.pageNumber;
		$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		if($scope.first){
			$('.first').show();
		}
		if($scope.self){
			$('.self').show();
		}
		if($scope.previous){
			$('.previous').show();
		}
		if($scope.next){
			$('.next').show();
		}
		if($scope.last){
			$('.last').show();
		}
                if(jData.audits.length > 0){
                    $scope.audits = jData.audits;
                    $scope.pageNumber = pageNumber+1;
                    $('.loadMore').show();
		    $('.records').show();
                    $('.noRecords').hide();
                }else{
                    $('.loadMore').hide();
		    $('.noRecords').show();
                    $('.records').hide();
                }
		if(jData.audits.length > 15){
                    $('.centerPanel').height('500px');
		    $('.centerPanel').css('overflowY', 'scroll');
                }else{
                    $('.centerPanel').css('overflowY', 'unset');
		    $('.centerPanel').height('inherit');
                }
                /*$scope.totalAlerts = jData.totalAlerts;
                $scope.totalActiveAlerts = jData.totalActiveAlerts;
                $scope.totalDevicesAffected = jData.totalDevicesAffected;*/
                $scope.backupStartTime = jData.backupStartTime;		    
                $scope.infFiles = jData.infFiles;
                $scope.totalFiles = jData.totalFiles;
                $scope.userRole = jData.userRole;
                $scope.osType = jData.audits[0].osType;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
	        }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });	
    };

    $scope.showEvents = function(deviceName, userName, deviceUUID, batchId, index){
	$scope.selectedRowMails = index;
	$('.rightPanel').show();
	var onlyActive = $("#activeIncidents").prop('checked');
	$scope.displayDeviceName = deviceName;
	$scope.displayUserName = userName;
	var finalIndex;
	$scope.audits.forEach(function(message, index) {
            Object.keys(message).forEach(function(prop) {
                if(message[prop] == batchId){
                finalIndex = index;
                }
            });
        });
        $scope.selectedAudit = $scope.audits[finalIndex];
	$scope.alertType = $scope.selectedAudit.alertType;
	$scope.status = $scope.selectedAudit.status;
	$scope.numberOfFilesInfected = $scope.selectedAudit.numberOfFilesInfected;
	$scope.numberOfFilesDeleted = $scope.selectedAudit.numberOfFilesDeleted;
	$scope.numberOfNewFiles = $scope.selectedAudit.numberOfNewFiles;
	$scope.totalNumberOfFiles = $scope.selectedAudit.totalNumberOfFiles;
	$scope.numberOfFilesmodified = $scope.selectedAudit.numberOfFilesmodified;
	$scope.id = $scope.selectedAudit.id;
	$scope.isDevicequarantined = $scope.selectedAudit.isDevicequarantined;
	};

	$scope.hideEvents = function(num){
		/*$('.leftPanel').removeClass('col-lg-3');
                $('.leftPanel').addClass('col-lg-6');*/
                $('.rightPanel').hide();
		/*$('.centerPanel').removeClass('col-lg-4');
                $('.centerPanel').addClass('col-lg-6');*/
		//$('.centerPanel').hide();
        };

    $scope.getQuarantineList = function(){
	$.ajax({
            url: $scope.BASE_FOLDER+'/history/getQuarantineList',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){           
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){		    
		    /*console.log("fileCount : "+jData.fileCount);
		    $scope.uploadedInfFilesCount = jData.fileCount;
		    if($scope.uploadedInfFilesCount >= 50){
		    	$('.infForm').hide();
		    }else{
		    	$('.infForm').show();
		    }*/
		//toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});                
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.deleteRwFile = function(id){
        $.ajax({
            url: $scope.BASE_FOLDER+'/history/deleteRwFile',
            data: {csrf_token: $('.csrf_token').html(), id: id},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.uploadStatistics();
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});                
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
/*unusual activity*/

var Base64 = {
    _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
    encode: function(input) {
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        input = Base64._utf8_encode(input);
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }
            output = output + this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) + this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
        }
        return output;
},
    decode: function(input) {
        var output = "";
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;
        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
        while (i < input.length) {
            enc1 = this._keyStr.indexOf(input.charAt(i++));
            enc2 = this._keyStr.indexOf(input.charAt(i++));
            enc3 = this._keyStr.indexOf(input.charAt(i++));
            enc4 = this._keyStr.indexOf(input.charAt(i++));
            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;
            output = output + String.fromCharCode(chr1);
            if (enc3 != 64) {
                output = output + String.fromCharCode(chr2);
            }
            if (enc4 != 64) {
                output = output + String.fromCharCode(chr3);
            }
        }
        output = Base64._utf8_decode(output);
        return output;
    },
    _utf8_encode: function(string) {
        string = string.replace(/\r\n/g, "\n");
        var utftext = "";
        for (var n = 0; n < string.length; n++) {
            var c = string.charCodeAt(n);
            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }
        }
        return utftext;
    },
    _utf8_decode: function(utftext) {
        var string = "";
        var i = 0;
        var c = c1 = c2 = 0;
        while (i < utftext.length) {
        c = utftext.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if ((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = utftext.charCodeAt(i + 1);
                c3 = utftext.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
}	
}]);

app.filter('filterStatusType', function(){
    return function(data, type){
        var filtered = [];
        if(type){
            for (var i = 0; i < data.length; i++){
                var value = data[i];
                if(value.status == type){
                    filtered.push(value);
                }
            }
            return filtered;
        }else{
            return data;
        }
    }
});
