/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('DeviceController', ['$scope', 'toastr', 'Upload', '$http', '$ngBootbox', '$timeout', 'blockUI', 'BASE_FOLDER', function($scope, toastr, Upload, $http, $ngBootbox, $timeout, blockUI, BASE_FOLDER) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.sortReverse = false;
    $scope.sortType = 'deviceName';
    $scope.sortReverseSites = false;
    $scope.sortTypeSites = 'value';
    $scope.currentPage = $('.currentPage').html();
    $scope.skipValue = 0;
    $scope.pageNumber = 1;
    $scope.devices = [];
    $scope.selectedDevice = '';
    $scope.currentSelectedDeviceName = '';
    $scope.searchDeviceName='';
    $scope.currentBackup=false; 
    $scope.buttonValue='';
    $scope.buttonPauseValue='';
    $scope.status = '';
    $scope.currentRestore=false;
    $scope.buttonValueRestore='';
    $scope.buttonPauseValueRestore='';
    $scope.isAllowBackup = 'true';

    $scope.devicesOneDrive = [];
    $scope.pageNumberOneDrive = 1;
    $scope.searchDeviceNameOneDrive = '';
    $scope.devicesExchange = [];
    $scope.pageNumberExchange = 1;
    $scope.searchDeviceNameExchange = '';
    $scope.devicesSharepoint = [];
    $scope.pageNumberSharepoint = 1;
    $scope.searchDeviceNameSharepoint = '';
    $scope.addedSites = [];
	
    $scope.openFilesPage = function(deviceId, deviceName, deviceUUID, deviceType, deviceOS, userName, blocked, unusualActivity){
        var isblocked;
        if(blocked){
            isblocked = 'blocked';
        }else{
            isblocked = 'active';
        }
        if(unusualActivity == true){
            var unusualActivity = 'unusual';
        }else{
            var unusualActivity = 'usual';
        }
        window.location.href = $scope.BASE_FOLDER+'/backup/files/'+deviceId+'/'+deviceName+'/'+deviceUUID+'/'+deviceType+'/'+deviceOS+'/'+userName+'/'+isblocked+'/'+unusualActivity;
    };

    $scope.updateDevices = function(deviceName, skipValue){
	var pageNumber = $scope.pageNumber;
	$('.first').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/devices',
            data: {deviceName: deviceName, pageNumber: pageNumber, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.metadata != ''){
			$('.deviceListTableNavigate').show();	
			$scope.previous = jData.metadata.links.previous;
			$scope.next = jData.metadata.links.next;
			$scope.last = jData.metadata.links.last;
			$scope.first = jData.metadata.links.first;
			$scope.currentpageCount = jData.metadata.pageNumber;
			$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
			if($scope.first){
				$('.first').show();
			}
			if($scope.previous){
				$('.previous').show();
			}
			if($scope.next){
				$('.next').show();
			}
			if($scope.last){
				$('.last').show();
			}
		}else{
			$('.deviceListTableNavigate').hide();
		}
                $('.deviceListTable').show();
                $('.nodevice1').hide();
		if(deviceName == 'all'){
			$scope.devices = jData.devices;
		}else{
			$scope.devices = jData.devices;
		}
		if($scope.devices.length > 0){
			$('.hasDevices').show();
			$('.nodevice1').hide();
		}else{
			$('.nodevice1').show();
			$('.hasDevices').hide();
		}		    
		$scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateDevicesNavigate = function(deviceName,url){
	$('.first').hide();
	$('.previous').hide();
	$('.next').hide();
	$('.last').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/devices1',
            data: {deviceName: deviceName, url: url, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.metadata != ''){
			$('.deviceListTableNavigate').show();	
			$scope.previous = jData.metadata.links.previous;
			$scope.next = jData.metadata.links.next;
			$scope.last = jData.metadata.links.last;
			$scope.first = jData.metadata.links.first;
			$scope.currentpageCount = jData.metadata.pageNumber;
			$scope.totalpageCount = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
			$(window).scrollTop(0);
			if($scope.first){
				$('.first').show();
			}
			if($scope.previous){
				$('.previous').show();
			}
			if($scope.next){
				$('.next').show();
			}
			if($scope.last){
				$('.last').show();
			}
		}else{
			$('.deviceListTableNavigate').hide();
		}	
                $('.deviceListTable').show();
                $('.nodevice1').hide();
		if(deviceName == 'all'){
			$scope.devices = jData.devices;
		}else{
			$scope.devices = jData.devices;
		}
		if($scope.devices.length > 0){
			$('.hasDevices').show();
			$('.nodevice1').hide();
		}else{
			$('.nodevice1').show();
			$('.hasDevices').hide();
		}
		$scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.searchDevice = function(deviceName){
        $('[name="searchUsername"]').popover('hide');
        $('.loading').html('Loading ...');
        if(deviceName.length == 0 || deviceName == 'all'){
            deviceName = 'all';
            $scope.devices = [];
            $scope.searchDeviceName='';
            $scope.skipValue = 0;
            $scope.updateDevices('all', 0);
        }else{
            $scope.searchDeviceName=deviceName;
            $scope.updateDevices(deviceName, 0);
         }
    };
    
    $scope.searchDevice1 = function(deviceName){
        deviceName = deviceName.join(',');
        $('[name="searchUsername"]').popover('hide');
        $('.loading').html('Loading ...');
        if(deviceName.length == 0 || deviceName == 'all'){
            deviceName = 'all';
            $scope.devices = [];
            $scope.searchDeviceName='';
            $scope.skipValue = 0;
            $scope.updateDevices('all', 1);
        }else{
            $scope.searchDeviceName=deviceName;
            $scope.updateDevices(deviceName, 1);
         }
    };

    $scope.loadMoreDevices= function(skipValue){
        $('.loadMoreBtn').attr('disabled','disabled');
        $('.loadMoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $scope.updateDevices('all', skipValue);
    };

    $scope.blockUnBlockDevice = function(deviceUUID, action,userName, deviceName, isSite){
    var finalIndex;
        $.ajax({
            url: $scope.BASE_FOLDER+'/device/blockUnBlockDevice',
            data: {deviceUUID: deviceUUID, action: action, csrf_token: $('.csrf_token').html(),userName : userName, deviceName : deviceName},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                /*$scope.devices.forEach(function(message, index) {
                    Object.keys(message).forEach(function(prop) {
                if(message[prop] == deviceUUID){
                finalIndex = index;
                }
                    });
                });*/
		if(isSite == 'site'){
			$scope.devicesSharepoint.forEach(function(message, index) {
			    Object.keys(message).forEach(function(prop) {
				if(message[prop] == deviceUUID){
					finalIndex = index;
				}
			    });
			});
			if(action == true){
				$scope.devicesSharepoint[finalIndex].blocked = true;
			}else{
				$scope.devicesSharepoint[finalIndex].blocked = false;
			}
		}else if(isSite == 'backup'){
			$scope.devices.forEach(function(message, index) {
			    Object.keys(message).forEach(function(prop) {
				if(message[prop] == deviceUUID){
					finalIndex = index;
				}
			    });
			});
			if(action == true){
				$scope.devices[finalIndex].blocked = true;
			}else{
				$scope.devices[finalIndex].blocked = false;
			}
		}else if(isSite == 'onedrive'){
			$scope.devicesOneDrive.forEach(function(message, index) {
			    Object.keys(message).forEach(function(prop) {
				if(message[prop] == deviceUUID){
					finalIndex = index;
				}
			    });
			});
			if(action == true){
				$scope.devicesOneDrive[finalIndex].blocked = true;
			}else{
				$scope.devicesOneDrive[finalIndex].blocked = false;
			}
		}else if(isSite == 'exchange'){
			$scope.devicesExchange.forEach(function(message, index) {
			    Object.keys(message).forEach(function(prop) {
				if(message[prop] == deviceUUID){
					finalIndex = index;
				}
			    });
			});
			if(action == true){
				$scope.devicesExchange[finalIndex].blocked = true;
			}else{
				$scope.devicesExchange[finalIndex].blocked = false;
			}
		}
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.deleteDevice = function(deviceUUID,userName, deviceName, type){
    var finalIndex;
        $.ajax({
            url: $scope.BASE_FOLDER+'/device/deleteDevice',
            data: {deviceUUID: deviceUUID, csrf_token: $('.csrf_token').html(),userName : userName, deviceName : deviceName},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
		if(type == 'backup'){
			$scope.devices.forEach(function(message, index) {
			    Object.keys(message).forEach(function(prop) {
				if(message[prop] == deviceUUID){
					finalIndex = index;
				}
			    });
			});
			$scope.devices.splice(finalIndex, 1);
		}else if(type == 'onedrive'){
			$scope.devicesOneDrive.forEach(function(message, index) {
			    Object.keys(message).forEach(function(prop) {
				if(message[prop] == deviceUUID){
					finalIndex = index;
				}
			    });
			});
			$scope.devicesOneDrive.splice(finalIndex, 1);
		}else if(type == 'exchange'){
			$scope.devicesExchange.forEach(function(message, index) {
			    Object.keys(message).forEach(function(prop) {
				if(message[prop] == deviceUUID){
					finalIndex = index;
				}
			    });
			});
			$scope.devicesExchange.splice(finalIndex, 1);
		}else if(type == 'site'){
			$scope.devicesSharepoint.forEach(function(message, index) {
			    Object.keys(message).forEach(function(prop) {
				if(message[prop] == deviceUUID){
					finalIndex = index;
				}
			    });
			});
			$scope.devicesSharepoint.splice(finalIndex, 1);
		}
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.blockMultipleDevices = function(blocked){
        var arr = $('input.select-item:checkbox:checked').map(function () {
        return this.value;
        }).get();
        var deviceUUIDs;
        var html;
        if(blocked == true){
            deviceUUIDs = $('#blockDevices').tagsinput('items');
        }else{
            deviceUUIDs = $('#unBlockDevices').tagsinput('items');
        }
        console.log("deviceUUIDsffffff "+arr);
        if(deviceUUIDs != null){
            if(blocked == true){
                html = $('.block').html();
                $('.block').attr('disabled','disabled');
                $('.block').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            }else{
                html = $('.unBlock').html();
                $('.unBlock').attr('disabled','disabled');
                $('.unBlock').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            }
            console.log("deviceUUIDs "+arr);
            $.ajax({
                url: $scope.BASE_FOLDER+'/device/blockMultipleDevices',
                data: {deviceUUIDs: arr, blocked: blocked, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(blocked == true){
                        $('.blockDevices').val(null).trigger('change');
                        $('.block').html(html);
                        $('.block').removeAttr('disabled');
                    }else{
                        $('.unBlockDevices').val(null).trigger('change');
                        $('.unBlock').html(html);
                        $('.unBlock').removeAttr('disabled');
                    }
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 5000);
                }else{
                    if(blocked == true){
                toastr.error('Please select a device to Unblock', 'Fail!!!', {allowHtml: true});
                setTimeout(function(){
                        window.location.reload(true);
                    }, 5000);
            }else{
                toastr.error('Please select a device to block', 'Fail!!!', {allowHtml: true});
                setTimeout(function(){
                        window.location.reload(true);
                    }, 5000);
            }
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(blocked == true){
                toastr.error('Please select a device to block', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a device to Un Block', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.deleteMultipleDevices = function(){
        var arr = $('input.select-item:checkbox:checked').map(function () {
                    return this.value;
                  }).get();
        console.log("delete  "+arr);
        var deviceUUIDs = arr;
        var html;
        if(deviceUUIDs != null){
            html = $('.deleteBTN').html();
            $('.deleteBTN').attr('disabled','disabled');
            $('.deleteBTN').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/device/deleteMultipleDevices',
                data: {deviceUUIDs: deviceUUIDs, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                $('.deleteBTN').html(html);
                $('.deleteBTN').removeAttr('disabled');
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('.unBlockDevices').val(null).trigger('change');
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 5000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 5000);
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(blocked == true){
                toastr.error('Please select a device to block', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a device to Un Block', 'Fail!!!', {allowHtml: true});
            }
        }
    };
    
    $scope.blockDevices = function(devices){
        $('.blockDevicesPanel').show();
        var devices = devices;
        var luCount = 0;
        if(devices != null){
            var html;
            $.ajax({
                url: $scope.BASE_FOLDER+'/blockDevices',
                data: {devices: devices, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                $scope.deviceList = jData.naveen;
                if(jData.naveen.length > 10){
                    	$('.blockDevicesPanel').css('overflowY', 'scroll');
                    	$('.blockDevicesPanel').height('500px');
                }
                jData.naveen.forEach(function(value){
			if(value.status == 'DELETED' || value.status == 'BLOCKED' || value.status == 'INVALID' || value.status == 'User or Device does not exist or invalid'){
			     luCount = luCount+1;
			}
                });
                if(luCount > 0){
			//document.getElementById("luStatement").innerHTML = "one or more users have been provisioned via "+type+" and cannot be blocked, download list to view";
 			document.getElementById("blockStatement").innerHTML = "One or more users cannot be blocked. Click on Download list to view details.";			    			     
			$('#blockDump').show();
                }
                if(jData.result == 'success'){
                    $('.blockdevices').show();//toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    $('.block').removeAttr('disabled');
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(active == true){
                toastr.error('Please select a user to Unblock', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a user to block', 'Fail!!!', {allowHtml: true});
            }
        }
    };
    
    $scope.unblockDevices = function(devices){
        $('.unblockDevicesPanel').show();
        var devices = devices;
        var luCount = 0;
        if(devices != null){
            var html;
            $.ajax({
                url: $scope.BASE_FOLDER+'/blockDevices',
                data: {devices: devices, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                $scope.unblockList = jData.naveen;
    		    if(jData.naveen.length > 10){
                    	$('.unblockDevicesPanel').css('overflowY', 'scroll');
                    	$('.unblockDevicesPanel').height('500px');
                    	}
		        jData.naveen.forEach(function(value){
			    if(value.status == 'DELETED' || value.status == 'DECOUPLED' || value.status == 'INVALID'  || value.status == 'ACTIVE' || value.status == 'User or Device does not exist or invalid'){
                        	luCount = luCount+1;
                    	    }
                    	});
                    	if(luCount > 0){
 				document.getElementById("unblockStatement").innerHTML = "One or more users cannot be unblocked or deleted. Click on Download list to view details";
			    	$('#unblockDump').show();
                    	}
                    	if(jData.result == 'success'){
                    		$('.unblockdeletedevices').show();//toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    		$('.unBlock').removeAttr('disabled');
                    		$('.deleteBTN').removeAttr('disabled');
                    	}else{
                    		toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                    	}
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(active == true){
                toastr.error('Please select a user to Unblock', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a user to block', 'Fail!!!', {allowHtml: true});
            }
        }
    };
    
    $scope.remoteWipe = function(deviceUUID, userName){
    var finalIndex;
        $.ajax({
            url: $scope.BASE_FOLDER+'/device/remoteWipe',
            data: {deviceUUID: deviceUUID, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                $scope.updateDevices('all', 0);
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.readUserNamesFromExcel = function(files) {
        angular.forEach(files, function(file, key) {
            if (file && !file.$error) {
                file.upload = Upload.upload({
                    url: $scope.BASE_FOLDER+'/readExcelFromUploadForDevices',
                    fields: {csrf_token: $('.csrf_token').html(), path: $scope.crumbString},
                    file: file
                });
                file.upload.then(function (response) {
                    $timeout(function () {
                        file.result = response.data;
                        console.log('data : '+JSON.stringify(response.data));
                        if(response.data.result == 'success'){
                            //console.log("deviceList "+JSON.stringify(response.data.deviceList));
                            if(response.data.userNames.length > 0){
                                response.data.userNames.forEach(function(value, key){
                                    if(value.length > 1 ){
                                        $('#blockDevices').tagsinput('add', value);
                                        blockUI.start();
                                        $scope.blockDevices(JSON.stringify(response.data.deviceList));
                                    }
                                });
                                toastr.success('Device names has been imported from the excel, please continue with the desired operation', 'Successfully!!!', {allowHtml: true});
                            }else{
                                toastr.error('There was no devicenames column in the selected excel file', 'Fail!!!', {allowHtml: true});
                            }
                        }else{
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                    });
                }, function (response) {
                    if (response.status > 0)
                        $scope.errorMsg = response.status + ': ' + response.data;
                });
                file.upload.progress(function (evt) {
                    file.progress = Math.min(100, parseInt(100.0 *
                        evt.loaded / evt.total));
                });
            }
        });
    };
    
    $scope.readUserNamesFromExcel1 = function(files) {
        angular.forEach(files, function(file, key) {
            if (file && !file.$error) {
                file.upload = Upload.upload({
                    url: $scope.BASE_FOLDER+'/readExcelFromUploadForDevices',
                    fields: {csrf_token: $('.csrf_token').html(), path: $scope.crumbString},
                    file: file
                });
                file.upload.then(function (response) {
                    $timeout(function () {
                        file.result = response.data;
                        //console.log('data : '+JSON.stringify(response.data));
                        if(response.data.result == 'success'){
                            if(response.data.userNames.length > 0){
                                response.data.userNames.forEach(function(value, key){
                                    if(value.length > 1 ){
                                        $('#unBlockDevices').tagsinput('add', value);
                                        blockUI.start();
                                        $scope.unblockDevices(JSON.stringify(response.data.deviceList));
                                    }
                                });
                                toastr.success('Device names has been imported from the excel, please continue with the desired operation', 'Successfully!!!', {allowHtml: true});
                            }else{
                                toastr.error('There was no devicenames column in the selected excel file', 'Fail!!!', {allowHtml: true});
                            }
                        }else{
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                    });
                }, function (response) {
                    if (response.status > 0)
                        $scope.errorMsg = response.status + ': ' + response.data;
                });
                file.upload.progress(function (evt) {
                    file.progress = Math.min(100, parseInt(100.0 *
                        evt.loaded / evt.total));
                });
            }
        });
    };

    $scope.properties = function(deviceId, type){
        var finalIndex;
	if(type == 'backup'){    
        $scope.devices.forEach(function(message, index) {
            Object.keys(message).forEach(function(prop) {
                if(message[prop] == deviceId){
                finalIndex = index;
                }
            });
        });
		$scope.selectedDevice = $scope.devices[finalIndex];
	}else if(type == 'ONEDRIVE'){
		$scope.devicesOneDrive.forEach(function(message, index) {
            Object.keys(message).forEach(function(prop) {
                if(message[prop] == deviceId){
                finalIndex = index;
                }
            });
        });
                $scope.selectedDevice = $scope.devicesOneDrive[finalIndex];
	
	}else if(type == 'EXCHANGE'){
		$scope.devicesExchange.forEach(function(message, index) {
            Object.keys(message).forEach(function(prop) {
                if(message[prop] == deviceId){
                finalIndex = index;
                }
            });
        });
                $scope.selectedDevice = $scope.devicesExchange[finalIndex];
	}else if(type == 'SHAREPOINT'){
	$scope.devicesSharepoint.forEach(function(message, index) {
            Object.keys(message).forEach(function(prop) {
                if(message[prop] == deviceId){
                finalIndex = index;
                }
            });
        });
		$scope.selectedDevice = $scope.devicesSharepoint[finalIndex];
	}
	//$scope.selectedDevice = $scope.devices[finalIndex];
        $('.deviceDetails').modal('show')
    };

    $scope.initiateRestoreBackup = function(uuid, deviceName){
        $('.restoreBucket').modal('show');
        $scope.currentSelectedDeviceUUID = uuid;
        $scope.currentSelectedDeviceName = deviceName;
    };

    $scope.sendFilesForRestore = function(deviceName, destinationPath){
        deviceName = (deviceName != "default" && deviceName != undefined) ? deviceName : $scope.currentSelectedDeviceName;
        var deviceLevelRestore = 'true';
        var selectedBTN = $('.restoreBtnForFiles');
        var html = selectedBTN.html();
        selectedBTN.attr('disabled','disabled');
        selectedBTN.html('Initiating... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        var paths = [];
        $.ajax({
            url: $scope.BASE_FOLDER+'/backup/files/sendFilesForRestore',
            data: {csrf_token: $('.csrf_token').html(),deviceLevelRestore: deviceLevelRestore, paths: paths, deviceName:deviceName, path: destinationPath, restoreAllVersions: $('[name="restoreAllVersions"]').val(), deviceUUID: $scope.currentSelectedDeviceUUID},
            type: 'POST'
        }).done(function(data){
            selectedBTN.removeAttr('disabled');
            selectedBTN.html('Initiate Restore');
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                setTimeout(function(){
                    window.location.reload(true);
                }, 3000);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.logAction = function(deviceId, deviceType){
        var finalIndex;
        $scope.devices.forEach(function(message, index) {
            Object.keys(message).forEach(function(prop) {
                if(message[prop] == deviceId){
                    finalIndex = index;
                }
            });
        });
        if(deviceType == "ONEDRIVE" || deviceType == "OUTLOOK" || deviceType == "SHAREPOINT"){
		$('.agLogs').addClass('hide');
		$('.fBackup').show();
		$('.stopBackupWhileRestoreBlock').addClass('hide');
        }
        $scope.selectedDevice = $scope.devices[finalIndex];
        $('#startBackup').removeAttr('disabled');
        $('#stopBackup').removeAttr('disabled');
        $('#pauseBackup').removeAttr('disabled');
        $('#cancelBackup').removeAttr('disabled');
        $('.deviceLogs').modal('show');
	$('#startRestore').removeAttr('disabled');
        $('#stopRestore').removeAttr('disabled');
	//$('#pauseRestore').removeAttr('disabled');
        $('#cancelRestore').removeAttr('disabled');
        $.ajax({
            url: $scope.BASE_FOLDER+'/eventHub',
            data: {deviceId:deviceId },
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            document.getElementById('actionToDeviceUUID').innerHTML = jData.actionToDeviceUUID;
	    document.getElementById('deviceType').innerHTML = deviceType;
            $("#actionToDeviceUUID").val(jData.actionToDeviceUUID);
	    if(jData.isFullBkpRunning == 'true'){
		$('#fullBackup').bootstrapToggle('on');
		$('#fullBackup').attr("disabled","disabled");
	    }else{
		$('#fullBackup').bootstrapToggle('off');
		$('#fullBackup').removeAttr("disabled","disabled");
	    }
	    if(jData.isPrevBkpPaused == 'true'){
		$('#fullBackup').attr("disabled","disabled");
		$('.ios').attr("data-original-title", "Already previous backup has been paused.");
		$('.ios').attr("data-placement", "bottom");
            }else{
		$('#fullBackup').removeAttr("disabled","disabled");
		$('#fullBackup').attr("title", "");
	    }		
            $('#startBackup').hide();
            $('#stopBackup').hide();
	    $('#pauseBackup').hide();
            $('#backupPolicyRefresh').bootstrapToggle('off');
            $('#agentLogs').bootstrapToggle('off');
            $('#cancelBackup').hide();
            $('#startBackup').val('No');
            $('#stopBackup').val('No');
            $('#cancelBackup').val('No');
	    $('#startRestore').hide();
	    $('#stopRestore').hide();
	    //$('#pauseRestore').hide();
	    $('#cancelRestore').hide();
	    $('#startRestore').val('No');
	    $('#stopRestore').val('No');
	    $('#cancelRestore').val('No');
            $scope.currentBackup=jData.currentBackup;
	    $scope.currentRestore=jData.currentRestore;
            if(jData.eventHub.length>0){
              //console.log(JSON.stringify(jData.eventHub));
		if(jData.eventHub.includes("BACKUPPOLICY_REFRESH")){
                        $('#backupPolicyRefresh').bootstrapToggle('on');
                }
                if(jData.eventHub.includes("START_BACKUP")){
		      $("#startBackupGet").val('yes');
 		      $scope.buttonValue="cancelBackup";	
                      $("#cancelBackup").show();		      
                }else{
		    document.getElementById("startBackupGet").value = "no";
                    if($scope.currentBackup){
                       $scope.buttonValue="stopBackup";
                       $scope.buttonPauseValue="pauseBackup";
                       $("#stopBackup").show();
                       $("#pauseBackup").show();
                    }
                    else{
 		      $scope.buttonValue="startBackup";
                      $("#startBackup").show();
                    }
                }
		if(jData.eventHub.includes("START_RESTORE")){
        		$("#startRestoreGet").val('yes');
        		document.getElementById("startRestoreGet").value = "yes";
		}else{
			document.getElementById("startRestoreGet").value = "no";
		}
		    /*restore start*/
                    if(jData.eventHub.includes("RESTORE_CREATED")){
                      $scope.buttonValueRestore="cancelRestore";
                      $("#cancelRestore").show();

                }else{
                    if($scope.currentRestore){
                       $scope.buttonValueRestore="stopRestore";
                       //$scope.buttonPauseValueRestore="pauseRestore";
                       $("#stopRestore").show();
                       //$("#pauseRestore").show();
                    }
                    else{
                      $scope.buttonValueRestore="startRestore";
                      $("#startRestore").show();
                    }
                }
                    /*restore end*/
                if(jData.eventHub.includes("PULL_AGENTLOGS")){
                  $('#agentLogs').bootstrapToggle('on');
                }
                if(jData.eventHub.includes("PULL_HISTORICAL_LOGS")){
                  $('#agentLogs').bootstrapToggle('on');
                  $('#historicalLogs').attr('checked', 'checked');
                }
                if(jData.eventHub.includes("SETUP_LOGS")){
                    $('#setupLogs').attr('checked', 'checked');
                }
                if(jData.eventHub.includes("DATABASES")){
                    $('#databases').attr('checked', 'checked');
                }
                if(jData.eventHub.includes("STOP_BACKUP_WHILE_RESTORE")){
                    document.getElementById('stopBackupWhileRestore').checked=true;
                }else{
                    document.getElementById('stopBackupWhileRestore').checked=false;
                }
            }else{
                 if($scope.currentBackup){
		                $scope.buttonValue="stopBackup";
                        $scope.buttonPauseValue="pauseBackup";
                        $("#stopBackup").show();
                        $("#pauseBackup").show();
                  }else{
		            $scope.buttonValue="startBackup";
                    $("#startBackup").show();
                 }   
                 /*restore start*/
                 if($scope.currentRestore){
                        $scope.buttonValueRestore="stopRestore";
  			//$scope.buttonPauseValueRestore="pauseRestore";
                        $("#stopRestore").show();
    			//$("#pauseRestore").show();
                  }else{
                        $scope.buttonValueRestore="startRestore";
                        $("#startRestore").show();
                 }
                 /*restore end*/
            }
            if(jData){
                $('#saveBtn').addClass('disabled');
                if(jData.status == 'SCANNING' && jData.action == null){
                    console.log("iiiiii");
                    $scope.buttonValue="stopBackup";
                    $scope.buttonPauseValue="pauseBackup";
                    $("#stopBackup").show();
                    $("#pauseBackup").show();
                }
                if(jData.status == 'SCANNING' && jData.action == 'STOP_BACKUP'){
                    console.log("inside scanning & stop");
                    $('#stopBackup').addClass("disabled");
                    $scope.buttonValue="stopBackup";
                    $("#stopBackup").show();
                    $('#stopBackup').css('opacity', '0.4');
                    $('#stopBackup').addClass("disabled");
                    $('#pauseBackup').hide();
                    disableStop();
                }
                if(jData.status == 'SCANNING' && jData.action == 'PAUSE_BACKUP'){
                    console.log("inside scanning & pause");
                    $scope.buttonPauseValue="pauseBackup";
                    $('#pauseBackup').addClass("disabled");
                    $("#pauseBackup").show();
                    $('#stopBackup').hide();
                    disablePause();
                }
		if(jData.isAllowBackup == 'false'){
                            console.log("got isAllowBackup as false");
                            $('.startBackup').addClass("disabled");
                            $scope.isAllowBackup = 'false';
                }
		if(jData.status == 'SCANNING'){
                	$scope.buttonPauseValue='';
                }
                $scope.$apply();
                /*if(jData.status == 'SCANNING'){
                    $('#pauseBackup').hide();
                }*/
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    function disableStop(){
        setTimeout(function(){
        	$('#stopBackup').attr("disabled","disabled");
        }, 1000);
    }

    function disablePause(){
        setTimeout(function(){
        	$('#pauseBackup').attr("disabled","disabled");
        }, 1000);
    }

    $scope.saveEventHub = function(){
          var actionToDeviceUUID = $('#actionToDeviceUUID').html();
          var startBackup=$("#startBackup").val();
          var stopBackup=$("#stopBackup").val();
          var pauseBackup=$("#pauseBackup").val();
          var cancelBackup=$("#cancelBackup").val();
            if($('#deviceType').html() == "ONEDRIVE" || $('#deviceType').html() == "OUTLOOK"){
                if($('#fullBackup').is(':checked') && $("#startBackup").val() === ""){
                    console.log("inside condi");
                    toastr.error('Please Start Backup before saving', 'Fail!!!', {allowHtml: true});
                    return false;
                }
            }
            /*console.log("startBackup : "+startBackup);
            console.log("stopBackup : "+stopBackup);
            console.log("cancelBackup : "+cancelBackup);
 	    console.log("pauseBackup : "+pauseBackup);*/
           if($("#cancelBackup").is(":visible") && cancelBackup==="No"){
             if($scope.currentBackup){
                stopBackup="true";
                pauseBackup="true";
             }
             else{
                 startBackup="Yes";
             }
           }
           /*restore start*/
          var startRestore=$("#startRestore").val();
          var stopRestore=$("#stopRestore").val();
          //var pauseRestore=$("#pauseRestore").val();
          var cancelRestore=$("#cancelRestore").val();

          if($("#cancelRestore").is(":visible") && cancelRestore==="No"){
             if($scope.currentRestore){
                stopRestore="true";
		//pauseRestore="true";
             }else{
                 startRestore="Yes";
             }
           }
           /*restore end*/
	    var startBackupGet = $("#startBackupGet").val();
	    var startRestoreGet = $("#startRestoreGet").val();
            var backupPolicyRefresh = $("#backupPolicyRefresh").val();
            $.ajax({
                url: $scope.BASE_FOLDER+'/saveEventHub',
                //data: {deviceid : $('#actionToDeviceUUID').html(), name : $('#actionToUserName').html()},
                data: $('.eventHubForm').serialize()+'&actionToDeviceUUID='+actionToDeviceUUID+'&startBackup='+startBackup+'&stopBackup='+stopBackup+'&pauseBackup='+pauseBackup+'&cancelBackup='+cancelBackup+'&startRestore='+startRestore+'&stopRestore='+stopRestore+'&cancelRestore='+cancelRestore+'&startBackupGet='+startBackupGet+'&backupPolicyRefresh='+backupPolicyRefresh+'&startRestoreGet='+startRestoreGet,
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('.unblockdeleteusers').show();
                    $('.unblock').removeAttr('disabled');
                    $('.delete').removeAttr('disabled');
                    toastr.success('Your request has been Queued.', 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
    };

    $scope.exportDevicesToExcel = function(policyType){
     deviceName=$scope.searchDeviceName;
         $.ajax({
             url: $scope.BASE_FOLDER+'/device/exportDevices',
             data: {csrf_token: $('.csrf_token').html(), deviceName: deviceName, policyType: policyType},
             type: 'POST'
         }).done(function(data){
             blockUI.stop();
             var jData = JSON.parse(data);
             if(jData.result == 'success'){
                 console.log("success");
                 window.location.href = $scope.BASE_FOLDER+'/device/downloadDevicesExcel';
                  //window.location.href = $scope.BASE_FOLDER+'/user/downloadUsersExcel';
                toastr.success('Devices list export generated', {allowHtml: true}); 
             }else{
                 toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
             }
         }).fail(function(data){
             toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
             if(data.status == 424){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/sleep';
                 }, 3000);
             }else if(data.status == 503){
                 setTimeout(function(){
                     window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                 }, 3000);
             }
         });
     };
     
    $('.deviceLogs').on('hide.bs.modal', function(e){
        if($('#deviceType').html() == "ONEDRIVE" || $('#deviceType').html() == "OUTLOOK"){
	        if($('#fullBackup').is(':checked') && $("#startBackup").val() === ""){
		        e.preventDefault();
		        e.stopImmediatePropagation();
                return false;
	        }
        }
    });
    
    $('#modalClose').click(function (){
    	window.location.reload(true);
    });
    
    $('#modalCloseX').click(function (){
    	window.location.reload(true);
    });

    $scope.changeDeviceOwner = function(){
	var blockedUsers = $('#blockedUsers').html();
	if(blockedUsers != ''){
		blockedUsers = $('#blockedUsers').html().split(',');
		$scope.blockedUsersList = blockedUsers;
		if($scope.blockedUsersList.length > 15){
			$('#blockedUsersListDiv').css('overflowY', 'scroll');
                        $('#blockedUsersListDiv').height('200px');
		}
                $('#blockedUsersWarning').modal('show');
                return;
	}
        $.ajax({
            url: $scope.BASE_FOLDER+'/device/changeDeviceOwner',
            data: $('.ownerShipForm').serialize(),
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            $('#ownerShipChange').modal('hide');
            if(jData.result == 'success'){
		toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                setTimeout(function(){                    
                    window.location.reload(true);
                }, 3000);
            }else{
                setTimeout(function(){
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }, 100);
            }
        });
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'devicesListPage'){
            blockUI.start();
            $scope.updateDevices('all', 1);
            $scope.updateDevicesOneDrive('all', 1);
            $scope.updateDevicesExchange('all', 1);		
            $scope.updateDevicesSharepoint('all', 1);		
        }

    });
    
    $scope.downloadSample = function(type){
	    switch (type) {
            	case 'common':
                	window.location.href = $scope.BASE_FOLDER+'/device/downloadSample';
			break;
		case 'downloadDump':
                	window.location.href = $scope.BASE_FOLDER+'/device/downloadDump';
                	break;
	    }
    };

    $scope.sendMeTo = function(location){
        window.location.href = location;
    };
	
    $scope.startBackupButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#startBackup').val('Yes');
        $('#startBackup').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };
    $scope.stopBackupButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#stopBackup').val('true');
        $('#stopBackup').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };
    $scope.pauseBackupButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#pauseBackup').val('true');
        $('#pauseBackup').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };
 
    $scope.cancelBackupButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#cancelBackup').val('Yes');
        $('#cancelBackup').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };
    
    /*restore start*/

    $scope.startRestoreButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#startRestore').val('Yes');
        $('#startRestore').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };
    $scope.stopRestoreButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#stopRestore').val('true');
        $('#stopRestore').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };
    $scope.pauseRestoreButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#pauseRestore').val('true');
        $('#pauseRestore').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };
    $scope.cancelRestoreButton=function(){
        $('#saveBtn').removeClass('disabled');
        $('#cancelRestore').val('Yes');
        $('#cancelRestore').attr('disabled','disabled');
        //toastr.success('Your request has been Queued.', 'Success!!!')
    };

/*restore end*/

/*onedrive exchange & sharepoint start*/
	$scope.updateDevicesOneDrive = function(deviceName, skipValue){
        var pageNumber = $scope.pageNumberOneDrive;
        $('.firstOneDrive').hide();
        $('.previousOneDrive').hide();
        $('.nextOneDrive').hide();
        $('.lastOneDrive').hide();
		console.log("devicenamewww : "+deviceName);
        $.ajax({
            url: $scope.BASE_FOLDER+'/devicesOneDrive',
            data: {deviceName: deviceName, pageNumber: pageNumber, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loadingOneDrive').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.metadata != ''){
			$('.deviceOneDriveListTableNavigate').show();	
			$scope.previousOneDrive = jData.metadata.links.previous;
			$scope.nextOneDrive = jData.metadata.links.next;
			$scope.lastOneDrive = jData.metadata.links.last;
			$scope.firstOneDrive = jData.metadata.links.first;
			$scope.currentpageCountOneDrive = jData.metadata.pageNumber;
			$scope.totalpageCountOneDrive = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
			$(window).scrollTop(0);
			if($scope.firstOneDrive){
				$('.firstOneDrive').show();
			}
			if($scope.previousOneDrive){
				$('.previousOneDrive').show();
			}
			if($scope.nextOneDrive){
				$('.nextOneDrive').show();
			}
			if($scope.lastOneDrive){
				$('.lastOneDrive').show();
			}			
		}else{
			$('.deviceOneDriveListTableNavigate').hide();
		}
                $('.deviceOneDriveListTable').show();
                $('.nodeviceOneDrive1').hide();
		if(deviceName == 'all'){
			$scope.devicesOneDrive = jData.devicesOneDrive;
		}else{
			$scope.devicesOneDrive = jData.devicesOneDrive;
		}
		if($scope.devicesOneDrive.length > 0){
			$('.hasDevicesOneDrive').show();
			$('.nodeviceOneDrive1').hide();
		}else{
			$('.nodeviceOneDrive1').show();
			$('.hasDevicesOneDrive').hide();
		}		    
		$scope.$apply();
		    console.log("onedrive devices length :"+jData.devicesOneDrive.length);
	    }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateDevicesOneDriveNavigate = function(deviceName,url){
	$('.firstOneDrive').hide();
	$('.previousOneDrive').hide();
	$('.nextOneDrive').hide();
	$('.lastOneDrive').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/devicesOneDrive1',
            data: {deviceName: deviceName, url: url, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loadingOneDrive').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.metadata != ''){
		$('.deviceOneDriveListTableNavigate').show();	
		$scope.previousOneDrive = jData.metadata.links.previous;
		$scope.nextOneDrive = jData.metadata.links.next;
		$scope.lastOneDrive = jData.metadata.links.last;
		$scope.firstOneDrive = jData.metadata.links.first;
		$scope.currentpageCountOneDrive = jData.metadata.pageNumber;
		$scope.totalpageCountOneDrive = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		$(window).scrollTop(0);
		if($scope.firstOneDrive){
			$('.firstOneDrive').show();
		}
		if($scope.previousOneDrive){
			$('.previousOneDrive').show();
		}
		if($scope.nextOneDrive){
			$('.nextOneDrive').show();
		}
		if($scope.lastOneDrive){
			$('.lastOneDrive').show();
		}
		}else{
			$('.deviceOneDriveListTableNavigate').hide();
		}	
                $('.deviceOneDriveListTable').show();
                $('.nodeviceOneDrive1').hide();
		if(deviceName == 'all'){
			$scope.devicesOneDrive = jData.devicesOneDrive;
		}else{
			$scope.devicesOneDrive = jData.devicesOneDrive;
		}
		if($scope.devicesOneDrive.length > 0){
			$('.hasDevicesOneDrive').show();
			$('.nodeviceOneDrive1').hide();
		}else{
			$('.nodeviceOneDrive1').show();
			$('.hasDevicesOneDrive').hide();
		}
		$scope.$apply();
	    }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.searchDeviceOneDrive1 = function(deviceName){
        deviceName = deviceName.join(',');
        $('[name="searchUsername"]').popover('hide');
        $('.loading').html('Loading ...');
        if(deviceName.length == 0 || deviceName == 'all'){
            deviceName = 'all';
            $scope.devicesOneDrive = [];
            $scope.searchDeviceNameOneDrive ='';
            $scope.skipValue = 0;
            $scope.updateDevicesOneDrive('all', 1);
        }else{
		console.log("deviceName : "+deviceName);
            $scope.searchDeviceNameOneDrive = deviceName;
            $scope.updateDevicesOneDrive(deviceName, 1);
         }
    };

    $scope.updateDevicesExchange = function(deviceName, skipValue){
        var pageNumber = $scope.pageNumberExchange;
        $('.firstExchange').hide();
        $('.previousExchange').hide();
        $('.nextExchange').hide();
        $('.lastExchange').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/devicesExchange',
            data: {deviceName: deviceName, pageNumber: pageNumber, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loadingExchange').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.metadata != ''){
			$('.deviceExchangeListTableNavigate').show();	
			$scope.previousExchange = jData.metadata.links.previous;
			$scope.nextExchange = jData.metadata.links.next;
			$scope.lastExchange = jData.metadata.links.last;
			$scope.firstExchange = jData.metadata.links.first;
			$scope.currentpageCountExchange = jData.metadata.pageNumber;
			$scope.totalpageCountExchange = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
			$(window).scrollTop(0);
			if($scope.firstExchange){
				$('.firstExchange').show();
			}
			if($scope.previousExchange){
				$('.previousExchange').show();
			}
			if($scope.nextExchange){
				$('.nextExchange').show();
			}
			if($scope.lastExchange){
				$('.lastExchange').show();
			}			
		}else{
			$('.deviceExchangeListTableNavigate').hide();
		}
                $('.deviceExchangeListTable').show();
                $('.nodeviceExchange1').hide();
		if(deviceName == 'all'){
			$scope.devicesExchange = jData.devicesExchange;
		}else{
			$scope.devicesExchange = jData.devicesExchange;
		}
		if($scope.devicesExchange.length > 0){
			$('.hasDevicesExchange').show();
			$('.nodeviceExchange1').hide();
		}else{
			$('.nodeviceExchange1').show();
			$('.hasDevicesExchange').hide();
		}		    
		$scope.$apply();
	    }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateDevicesExchangeNavigate = function(deviceName,url){
	$('.firstExchange').hide();
	$('.previousExchange').hide();
	$('.nextExchange').hide();
	$('.lastExchange').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/devicesExchange1',
            data: {deviceName: deviceName, url: url, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loadingExchange').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.metadata != ''){
		$('.deviceExchangeListTableNavigate').show();	
		$scope.previousExchange = jData.metadata.links.previous;
		$scope.nextExchange = jData.metadata.links.next;
		$scope.lastExchange = jData.metadata.links.last;
		$scope.firstExchange = jData.metadata.links.first;
		$scope.currentpageCountExchange = jData.metadata.pageNumber;
		$scope.totalpageCountExchange = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		$(window).scrollTop(0);
		if($scope.firstExchange){
			$('.firstExchange').show();
		}
		if($scope.previousExchange){
			$('.previousExchange').show();
		}
		if($scope.nextExchange){
			$('.nextExchange').show();
		}
		if($scope.lastExchange){
			$('.lastExchange').show();
		}
		}else{
			$('.deviceExchangeListTableNavigate').hide();
		}	
                $('.deviceExchangeListTable').show();
                $('.nodeviceExchange1').hide();
		if(deviceName == 'all'){
			$scope.devicesExchange = jData.devicesExchange;
		}else{
			$scope.devicesExchange = jData.devicesExchange;
		}
		if($scope.devicesExchange.length > 0){
			$('.hasDevicesExchange').show();
			$('.nodeviceExchange1').hide();
		}else{
			$('.nodeviceExchange1').show();
			$('.hasDevicesExchange').hide();
		}
		$scope.$apply();
	    }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.searchDeviceExchange1 = function(deviceName){
        deviceName = deviceName.join(',');
        $('[name="searchUsername"]').popover('hide');
        $('.loading').html('Loading ...');
        if(deviceName.length == 0 || deviceName == 'all'){
            deviceName = 'all';
            $scope.devicesExchange = [];
            $scope.searchDeviceNameExchange = '';
            $scope.skipValue = 0;
            $scope.updateDevicesExchange('all', 1);
        }else{
            $scope.searchDeviceNameExchange = deviceName;
            $scope.updateDevicesExchange(deviceName, 1);
         }
    };

    $scope.updateDevicesSharepoint = function(deviceName, skipValue){
        var pageNumber = $scope.pageNumberSharepoint;
        $('.firstSharepoint').hide();
        $('.previousSharepoint').hide();
        $('.nextSharepoint').hide();
        $('.lastSharepoint').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/devicesSharepoint',
            data: {deviceName: deviceName, pageNumber: pageNumber, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loadingSharepoint').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.metadata != ''){
			$('.deviceSharepointListTableNavigate').show();	
			$scope.previousSharepoint = jData.metadata.links.previous;
			$scope.nextSharepoint = jData.metadata.links.next;
			$scope.lastSharepoint = jData.metadata.links.last;
			$scope.firstSharepoint = jData.metadata.links.first;
			$scope.currentpageCountSharepoint = jData.metadata.pageNumber;
			$scope.totalpageCountSharepoint = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
			$(window).scrollTop(0);
			if($scope.firstSharepoint){
				$('.firstSharepoint').show();
			}
			if($scope.previousSharepoint){
				$('.previousSharepoint').show();
			}
			if($scope.nextSharepoint){
				$('.nextSharepoint').show();
			}
			if($scope.lastSharepoint){
				$('.lastSharepoint').show();
			}			
		}else{
			$('.deviceSharepointListTableNavigate').hide();
		}
                $('.deviceSharepointListTable').show();
                $('.nodeviceSharepoint1').hide();
		if(deviceName == 'all'){
			$scope.devicesSharepoint = jData.devicesSharepoint;
		}else{
			$scope.devicesSharepoint = jData.devicesSharepoint;
		}
		if($scope.devicesSharepoint.length > 0){
			$('.hasDevicesSharepoint').show();
			$('.nodeviceSharepoint1').hide();
		}else{
			$('.nodeviceSharepoint1').show();
			$('.hasDevicesSharepoint').hide();
		}		    	    
		$scope.$apply();
	    }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateDevicesSharepointNavigate = function(deviceName,url){
	$('.firstSharepoint').hide();
	$('.previousSharepoint').hide();
	$('.nextSharepoint').hide();
	$('.lastSharepoint').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/devicesSharepoint1',
            data: {deviceName: deviceName, url: url, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loadingSharepoint').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
		if(jData.metadata != ''){
		$('.deviceSharepointListTableNavigate').show();	
		$scope.previousSharepoint = jData.metadata.links.previous;
		$scope.nextSharepoint = jData.metadata.links.next;
		$scope.lastSharepoint = jData.metadata.links.last;
		$scope.firstSharepoint = jData.metadata.links.first;
		$scope.currentpageCountSharepoint = jData.metadata.pageNumber;
		$scope.totalpageCountSharepoint = Math.ceil(jData.metadata.totalCount/jData.metadata.recordsPerPage);
		$(window).scrollTop(0);
		if($scope.firstSharepoint){
			$('.firstSharepoint').show();
		}
		if($scope.previousSharepoint){
			$('.previousSharepoint').show();
		}
		if($scope.nextSharepoint){
			$('.nextSharepoint').show();
		}
		if($scope.lastSharepoint){
			$('.lastSharepoint').show();
		}
		}else{
			$('.deviceSharepointListTableNavigate').hide();
		}	
                $('.deviceSharepointListTable').show();
                $('.nodeviceSharepoint1').hide();
		if(deviceName == 'all'){
			$scope.devicesSharepoint = jData.devicesSharepoint;
		}else{
			$scope.devicesSharepoint = jData.devicesSharepoint;
		}
		if($scope.devicesSharepoint.length > 0){
			$('.hasDevicesSharepoint').show();
			$('.nodeviceSharepoint1').hide();
		}else{
			$('.nodeviceSharepoint1').show();
			$('.hasDevicesSharepoint').hide();
		}
		$scope.$apply();
	    }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.searchDeviceSharepoint1 = function(deviceName){
        deviceName = deviceName.join(',');
        $('[name="searchUsername"]').popover('hide');
        $('.loading').html('Loading ...');
        if(deviceName.length == 0 || deviceName == 'all'){
            deviceName = 'all';
            $scope.devicesSharepoint = [];
            $scope.searchDeviceNameSharepoint = '';
            $scope.skipValue = 0;
            $scope.updateDevicesSharepoint('all', 1);
        }else{
            $scope.searchDeviceNameSharepoint = deviceName;
            $scope.updateDevicesSharepoint(deviceName, 1);
         }
    };		
/*onedrive exchange & sharepoint end*/

    $scope.configureSites = function(){
	$('.configureSites').modal('show');
	$.ajax({
            url: $scope.BASE_FOLDER+'/sitesDiscovery',
            data: {csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){           
                $scope.discoveredSites = jData.discoveredSites;
		$scope.discoveredSites = $scope.discoveredSites.sort();
		$scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.pickElement = function(value, index){
	$scope.selectedRow = index;
	$scope.picked = value;
    };

    $scope.addName = function(){
	if($scope.addedSites.indexOf($scope.picked) == '-1'){
		$scope.addedSites.push($scope.picked);
		//console.log("addedSites : "+$scope.addedSites);
	}
    };

    $scope.pickElement1 = function(value, index){
	$scope.selectedRow1 = index;
	$scope.picked1 = value;
    };

    $scope.removeName = function(){
	var index = $scope.addedSites.indexOf($scope.picked1); // get index if value found otherwise -1
	if (index > -1) { //if found
        	$scope.addedSites.splice(index, 1);
        }
        //console.log("final list of Elements : "+$scope.addedSites);
    };

    $scope.itemSelect1 = function(){
        	//var all = $("input.select-all")[0];
            	var total = $("input.select-item").length;
            	var len = $("input.select-item:checked:checked").length;
            	//console.log("total:"+total);
            	//console.log("len:"+len);
            	//all.checked = len===total;
        	var usersSelected;
        	var arr = $('input.select-item:checkbox:checked').map(function () {
			//console.log("value to be added : "+this.value);
			/*remove login starts*/
			var index = $scope.discoveredSites.indexOf(this.value); // get index if value found otherwise -1
			if (index > -1) { //if found
				$scope.discoveredSites.splice(index, 1);
				$scope.addedSites = $scope.addedSites.concat(this.value);
				$scope.addedSites = $scope.addedSites.sort();
				$scope.discoveredSites = $scope.discoveredSites.sort();
			}
			/*remove logic ends*/
			return this.value;
        	}).get();
        	usersSelected = arr;
    };

    $scope.removeName1 = function(){
		//var all = $("input.select-all")[0];
            	var total = $("input.select-itemright").length;
            	var len = $("input.select-itemright:checked:checked").length;
            	//console.log("total:"+total);
            	//console.log("len:"+len);
            	//all.checked = len===total;
        	var usersSelected;
        	var arr = $('input.select-itemright:checkbox:checked').map(function () {
			/*remove login starts*/
			var index = $scope.addedSites.indexOf(this.value); // get index if value found otherwise -1
			if (index > -1) { //if found
				$scope.addedSites.splice(index, 1);
				$scope.discoveredSites = $scope.discoveredSites.concat(this.value);
				$scope.discoveredSites = $scope.discoveredSites.sort();
				$scope.addedSites = $scope.addedSites.sort();
			}
			/*remove logic ends*/
            	return this.value;
        	}).get();
        	usersSelected = arr;
    };

    $scope.removeAllName = function(){
	$scope.discoveredSites = $scope.discoveredSites.concat($scope.addedSites);
	$scope.discoveredSites = $scope.discoveredSites.sort();
	$scope.addedSites = [];
    };

    $scope.addAllName = function(){
	$scope.addedSites = $scope.addedSites.concat($scope.discoveredSites);
	$scope.addedSites = $scope.addedSites.sort();
	$scope.discoveredSites = [];
    };

    $('#autoDiscover').on('change', function(){
            var checked = document.getElementById('autoDiscover').checked;
            if(checked){
                $scope.addAllName();
            }else{
                $scope.removeAllName();
            }
	$scope.$apply();
    });

    $scope.startSiteConfiguration = function(){
    	var usersSelected;
        var arr = $('input.select-item:checkbox:checked').map(function () {
            return this.value;
           }).get();
        usersSelected = arr;        
	if($scope.addedSites.length <= 0){
        	toastr.error('Please select at least one SharePoint site for site configuration.', 'Fail!!!', {allowHtml: true});
                return;
        }
        $.ajax({
            type: 'POST',
            url: $scope.BASE_FOLDER+'/startSiteConfiguration',
	    data: {sitenames : $scope.addedSites, policyName : $('#policyName').val(), csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            var jData = $.parseJSON(data);
            if(jData.result == 'success'){
                $scope.$apply();
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
		location.reload();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $scope.exportSitesToExcel = function(){
        var userName = $scope.deviceNameSharepoint;
        $.ajax({
            url: $scope.BASE_FOLDER+'/site/exportSites',
            data: {csrf_token: $('.csrf_token').html() , userName: userName},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/site/downloadSitesExcel';
                toastr.success('Sites list export generated', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
	
    $('#deviceName').on('change', function(){
	var deviceName = $('#deviceName').val();
        $('.loading').html('Loading ...');
        if(deviceName.length == 0 || deviceName == 'all'){
            deviceName = 'all';
            $scope.devices = [];
            $scope.searchDeviceName='';
            $scope.skipValue = 0;
            $scope.updateDevices('all', 1);
        }else{
            $scope.searchDeviceName=deviceName;
            $scope.updateDevices(deviceName, 1);
        }
    });
	
    $('#deviceNameOneDrive').on('change', function(){
	var deviceName = $('#deviceNameOneDrive').val();
        $('.loading').html('Loading ...');
        if(deviceName.length == 0 || deviceName == 'all'){
            deviceName = 'all';
            $scope.devicesOneDrive = [];
            $scope.searchDeviceNameOneDrive ='';
            $scope.skipValue = 0;
            $scope.updateDevicesOneDrive('all', 1);
        }else{
            $scope.searchDeviceNameOneDrive = deviceName;
            $scope.updateDevicesOneDrive(deviceName, 1);
        }
    });
	
    $('#deviceNameExchange').on('change', function(){
	var deviceName = $('#deviceNameExchange').val();
        $('.loading').html('Loading ...');
        if(deviceName.length == 0 || deviceName == 'all'){
            deviceName = 'all';
            $scope.devicesExchange = [];
            $scope.searchDeviceNameExchange = '';
            $scope.skipValue = 0;
            $scope.updateDevicesExchange('all', 1);
        }else{
            $scope.searchDeviceNameExchange = deviceName;
            $scope.updateDevicesExchange(deviceName, 1);
        }
    });
	
    $('#deviceNameSharepoint').on('change', function(){
	var deviceName = $('#deviceNameSharepoint').val();
        $('.loading').html('Loading ...');
        if(deviceName.length == 0 || deviceName == 'all'){
            deviceName = 'all';
            $scope.devicesSharepoint = [];
            $scope.searchDeviceNameSharepoint = '';
            $scope.skipValue = 0;
            $scope.updateDevicesSharepoint('all', 1);
        }else{
            $scope.searchDeviceNameSharepoint = deviceName;
            $scope.updateDevicesSharepoint(deviceName, 1);
        }
    });	
	
	
	
	
}]);
