<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/**
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Class User
 * @package Models
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class SyncPms extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('Sync Policy Management Model Model was called', 'info');
    }

    /**
     * Below Method gets all schedules
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSchedules($headers){
        $url = $this->api->getUrl('getSchedules');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getCloudCredentials($headers){
        $url = $this->api->getUrl('getCloudCredentials');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFilters($headers){
        $url = $this->api->getUrl('getFilters');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllPolicies($headers){
        $url = $this->api->getUrl('getAllSyncPolices');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getPgs($headers){
        $url = $this->api->getUrl('getPgs');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all Policies
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function savePolicy($headers, $data){
        $url = $this->api->getUrl('saveSyncPolicy');
        $this->curl->setHeaders($headers);
        Model::req($url,$headers,$data);
        $this->log('Url: '.$url, 'info');
        $this->log('Headers: '.json_encode($headers), 'info');
        $this->log('Data: '.$data, 'info');

        $this->curl->put($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function savePolicyEdit($headers, $data){
        $url = $this->api->getUrl('saveSyncPolicy');
        $this->curl->setHeaders($headers);
        Model::req($url,$headers,$data);
        $this->log('Url: '.$url, 'info');
        $this->log('Headers: '.json_encode($headers), 'info');
        $this->log('Data: '.$data, 'info');

        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @param $policyName
     * @return array
     */
    public function getPolicy($headers, $policyName){
        $url = $this->api->getUrl('getSyncPolicy', array('policyName' => $policyName));
        Model::req($url,$headers,$policyName);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function blockPolicy($headers){
        $url = $this->api->getParacloudUrl('policyBlock');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->put($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getUserSyncPolicy($headers){
        $url = $this->api->getUrl('getUserSyncPolicy');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getPolicyMappingDetails($headers){
        $this->log('Post Data: '. json_encode($headers),'info');
        //$url = $this->api->getUrl('policySyncMappingDetails');
        $url = PROTOCOL.PARACLOUD_IP."/paracloud/cloud/".CLOUD_NAME."/load/all/userSyncPolicy/?pageNumber=1";
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getPolicyMappingDetailsNavigate($headers, $url){
        $this->log('Post Data: '. json_encode($headers),'info');
        //$url = $this->api->getUrl('policyMappingDetails');
        $url = PROTOCOL.PARACLOUD_IP.$url;
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function searchPolicyMapping($headers){
        $url = $this->api->getUrl('searchSyncPolicyMapping');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveSinglePolicyMapping($headers, $data){
        $url = $this->api->getUrl('saveSingleSyncPolicyMapping');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @return array
     */
    public function saveMultiplePolicyMapping($headers, $data){
        $url = $this->api->getUrl('saveMultipleSyncPolicyMapping');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Url: '. $url, 'info');
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function saveMultiplePolicyMappingOld($headers){
        $url = $this->api->getUrl('saveMultipleSyncPolicyMappingOld');
	$data = [];
	Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Url: '. $url, 'info');
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getCloudProperties($headers){
         $url = $this->api->getVersionUrl('getCloudProperties');
	 $data = [];
	 Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
    }
    
    public function getAllSyncPolicyName($headers){
            $url = $this->api->getUrl('newSync');
	    $data = [];
	    Model::req($url,$headers,$data);
            $this->curl->setHeaders($headers);
            $this->curl->get($url);
            $result = array(
                'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
                'body' => $this->curl->response,
                'header' => $this->curl->response_headers
            );
            $this->log('Result: '. json_encode($result), 'info');
            Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
            return $result;
    }
    
    public function getCannedFilters($headers){
         $url = $this->api->getParacloudUrl('getCannedFilters');
	 $data = [];
	 Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->get($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }
    
    public function getAllPoliciesPagination($headers){
	$url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/syncPolicy/loadAll?pageNumber=1";
	$data = [];
	Model::req($url,$headers,$data);
        $this->log("usrl". $url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getAllPoliciesPaginationNavigate($headers,$url){
	$url = PROTOCOL.PARACLOUD_IP.$url;
	$data = [];
	Model::req($url,$headers,$data);
        $this->log("usrl". $url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
	
    public function downloadSyncPolicyPdf($headers){
         $url = $this->api->getParacloudUrl('syncpolicyPdf');
	 $data = [];
	 Model::req($url,$headers,$data);
         $this->curl->setHeaders($headers);
         $this->curl->post($url);
         $result = array(
             'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
             'body' => $this->curl->response,
             'header' => $this->curl->response_headers
         );
         $this->log('Result: '. json_encode($result), 'info');
         Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
         return $result;
     }

}
