<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\Storage;
use Helpers\Auth;
use Helpers\JWT;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class StorageController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    public $accessToken;
    public $authToken;
    public $refreshToken;
    public $userName;
    public $ODFBCode;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->language->load('storage');
        $this->_model = new Storage();
    }

    /**
     * Define Index page title and load template files
     */
    public function googleOAuth(){
        if(!empty($_GET['code'])){
            $this->userName = !empty($_GET['state']) ? $_GET['state'] : $this->session->get('userName');
            $headers = array(
                'Content-Type' => 'application/x-www-form-urlencoded'
            );
            $data = "code=".$_GET['code']."&client_id=".GOOGLE_CLIENT_ID."&client_secret=".GOOGLE_SECRET_KEY."&redirect_uri=".Url::basePath(GOOGLE_RESOURCE_URI.'/')."&grant_type=authorization_code";
            $result = $this->_model->getGoogleRefreshToken(GOOGLE_TOKEN_URL, $headers, $data);
            if($result['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'There was no token passed from google drive please restart the cloud authentication process');
                Url::redirect('user/settings/'.$this->session->get('userName'));
                exit;
            }
            $this->accessToken = $result['body']->access_token;
            $this->authToken = $result['body']->id_token;
            $this->refreshToken = $result['body']->refresh_token;
            $userInfoResult = $this->_model->getUserInfoFromGoogle(GOOGLE_USER_INFO_URL.$result['body']->access_token);
            if($userInfoResult['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'Could not get the user email address details please restart the cloud authentication process');
                Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                exit;
            }
            $gdData = array(
                'accessToken' => $this->accessToken,
                'authenticationToken' => $this->authToken,
                'refreshToken' => $this->refreshToken,
                'cloudStorageType' => 'Google Drive',
                'clientId' => GOOGLE_CLIENT_ID,
                'clientSecret' => GOOGLE_SECRET_KEY,
                'redirectUri' => Url::basePath(GOOGLE_RESOURCE_URI.'/'),
                'emailId' => $userInfoResult['body']->emails[0]->value
            );
            $paraHeaders = array(
                'Content-Type' => 'application/json',
                'userName' => $this->userName
            );
            $result = $this->_model->saveAuthCredentials($paraHeaders, json_encode($gdData));
            if($result['status'] == 200){
                $this->session->put('storageResult', 'success');
                $this->session->put('storageMessage', 'Google drive has been successfully selected as the storage place');
                Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                exit;
            }else{
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', 'Due to some technical issues could not complete the cloud selection process, Error Code - '.$result['status']);
                Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                exit;
            }
        }else{
            $this->session->put('storageResult', 'error');
            $this->session->put('storageMessage', 'Could not get the authentication code from google please restart the cloud authentication process');
            Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
            exit;
        }
    }

    public function odb(){
        if(!empty($_GET['code'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),
		'isInternalCall' => true
            );
            $odbResult = $this->_model->getOdbDetails($headers);
            $this->ODFBCode = $_GET['code'];
            $this->userName = !empty($_GET['state']) ? $_GET['state'] : $this->session->get('userName');
            //$redirectUri = !empty(LOCAL_ODB_REDIRECT_URI) ? LOCAL_ODB_REDIRECT_URI : 'https://api-app.parablu.com/';
	    if(useLocalPackage != true){
                $redirectUri = "https://api-app.parablu.com/";
            }else{
                $redirectUri = LOCAL_IP."/app/index.php";
            }
            $result = $this->_model->getOneDriveAuthToken($odbResult["body"]->{"clientTokenURL"}, $odbResult["body"]->{"clientId"}, $redirectUri, urlencode($odbResult["body"]->{"clientSecretKey"}), $this->ODFBCode);
            $resultData = json_decode($result['body']);
            $this->log('ODB Result'. json_encode($result), 'info');
            if($result['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'There was no token passed from the selected cloud Storage please restart the cloud authentication process');
                Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                exit;
            }
            $this->accessToken 	= $resultData->access_token;
            $this->authToken    = $resultData->id_token;
            $this->refreshToken = $resultData->refresh_token;
            $jwtMsg = JWT::decode($this->accessToken, $odbResult["body"]->{"clientSecretKey"}, false);
            $odData = array(
                'accessToken' => $this->accessToken,
                'authenticationToken' => $this->authToken,
                'refreshToken' => $this->refreshToken,
                'cloudStorageType' => 'Office365',
                'clientId' => $odbResult["body"]->{"clientId"},
                'sharePointUrl' => $odbResult["body"]->{"clientResourceURL"},
                'clientSecret' => urldecode(urlencode($odbResult["body"]->{"clientSecretKey"})),
                'redirectUri' => urldecode(urlencode($redirectUri)),
                'emailId' => $this->session->get('emailId'),
                'accountId' =>$jwtMsg->unique_name,
                'serviceAccount' => true
            );
            $paraHeaders = array(
                'Content-Type' => 'application/json',
                'userName' => $this->userName
            );
            $result = $this->_model->saveAuthCredentials($paraHeaders, json_encode($odData));
            if($result['status'] == 200){
                $this->session->put('storageResult', 'success');
                $this->session->put('storageMessage', 'One Drive for Business has been successfully selected as the storage place');
                if($this->session->get('userName') != ''){
                        Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                }else{
                        Url::redirect('success');
                }
                exit;
            }else{
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', 'Due to some technical issues could not complete the cloud selection process, Error Code - '.$result['status']);
                Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                exit;
            }
        }else{
            $this->session->put('storageResult', 'error');
            $this->session->put('storageMessage', 'Could not get the authentication code from OneDrive for Business please restart the cloud authentication process');
            Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
            exit;
        }
    }

    public function odbrelogin(){
        $userName       = $_GET['uName'];
        $email          = $_GET['uEmail'];
        if(!empty($userName) && !empty($email)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),
		'isInternalCall' => true
            );
            $result = $this->_model->getOdbDetails($headers);
            $this->session->put('emailId', $email);
	    if(useLocalPackage != true){
                $redirectUri = "https://api-app.parablu.com/";
                $appURL = "https://api-app.parablu.com/call.php";
            }else{
                $redirectUri = LOCAL_IP."/app/index.php";
                $appURL = LOCAL_IP."/app/call.php";
            }
	    $user_principal = $result["body"]->{'accountId'};
            //$params = "?resource=".$result["body"]->{"clientResourceURL"}."&client_id=".$result["body"]->{"clientId"}."&response_type=code&redirect_uri=".$result["body"]->{"clientRedirectURI"}."&state=".$userName;
            //$MODBUrl = API_APP_URL.$params."&user=".$userName."&sourceURI=".\Helpers\Url::basePath();
	    $params = "?resource=".$result["body"]->{"clientResourceURL"}."&client_id=".$result["body"]->{"clientId"}."&response_type=code&redirect_uri=".$redirectUri."&state=".$userName."&user_principal=".$user_principal;
            $MODBUrl = $appURL.$params."&user=".$userName."&sourceURI=".\Helpers\Url::basePath();
            Url::redirect($MODBUrl, true);
        }else{
            Url::redirect('404');
        }
    }
    
    public function azure(){
        if(!empty($_GET['code'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),
                'Accept'        => 'application/json',
		'isInternalCall' => true
            );
            $azureResult = $this->_model->getAadDetails($headers);
            $this->log("CODEEEEEEEEE : ".$_GET['code'],"info");
            $this->AzureCode = $_GET['code'];
            $this->userName = !empty($_GET['state']) ? $_GET['state'] : $this->session->get('userName');
            //$redirectUri = $azureResult['body']->{'AADCredentialsElement'}->{'redirectURI'};
	    if(useLocalPackage != true){
                $redirectUri = "https://api-app.parablu.com/aad.php";
            }else{
                $redirectUri = LOCAL_IP."/app/aad.php";
            }
            /*$clientTokenURL = 'https://login.microsoftonline.com/'.$azureResult['body']->{'AADCredentialsElement'}->{'tenentId'}.'/oauth2/token';
            $clientId = $azureResult['body']->{'AADCredentialsElement'}->{'clientId'};
            $clientSecretKey = $azureResult['body']->{'AADCredentialsElement'}->{'secretKey'};*/
	    /*$clientTokenURL = 'https://login.microsoftonline.com/'.$_GET['tenentId'].'/oauth2/token';
            $clientId = $_GET['clientId'];
            $clientSecretKey = $_GET['clientSecret'];*/
	    $clientTokenURL = 'https://login.microsoftonline.com/'.$azureResult['body']->{'AADCredentialsElementList'}[0]->{'tenentId'}.'/oauth2/token';
            $clientId = $azureResult['body']->{'AADCredentialsElementList'}[0]->{'clientId'};
            $clientSecretKey = $azureResult['body']->{'AADCredentialsElementList'}[0]->{'secretKey'};

            $result = $this->_model->getAzureAuthToken($clientTokenURL, $clientId, $redirectUri,$clientSecretKey, $this->AzureCode);
            $resultData = json_decode($result['body']);
            $this->log('Azure Result'. json_encode($result), 'info');
            if($result['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'There was no token passed from the selected cloud Storage please restart the cloud authentication process');
                Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                exit;
            }
            $this->accessToken  = $resultData->access_token;
            $this->refreshToken = $resultData->refresh_token;
            $odData = array(
                'access_token' => $this->accessToken,
                'refresh_token' => $this->refreshToken,
                'user_principal' => $this->userName,
            );
            $paraHeaders = array(
                'Content-Type' => 'application/json',
                'userName' => $this->userName,
                'token'         => $this->session->get('token')
            );
            $this->log("ODDATA : ".json_encode($odData),"info");
             $this->log("paraHeaders : ".json_encode($paraHeaders),"info");
            $result = $this->_model->saveAzureCredentials($paraHeaders, json_encode($odData));

            if($result['status'] == 200){
                $this->session->put('storageResult', 'success');
                $this->session->put('storageMessage', 'Azure Active Directory has been successfully mapped');
                if($this->session->get('userName') != ''){
                        Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                }else{
                        Url::redirect('success');
                }
                exit;
            }else{
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', 'Due to some technical issues could not complete the cloud selection process, Error Code - '.$result['status']);
                Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                exit;
            }
        }else{
            $this->session->put('storageResult', 'error');
            $this->session->put('storageMessage', 'Could not get the authentication code from Azure Active Directory please restart the cloud authentication process');
            Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
            exit;
        }
    }
    
    public function azureReauth(){
        $this->log("inside new flow storagecontroller","info");
        $userName       = $_GET['uName'];
        $email          = $_GET['uEmail'];
        if(!empty($userName) && !empty($email)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),
                'Accept'        => 'application/json',
		'isInternalCall' => true
            );
            $azureResult = $this->_model->getAadDetails($headers);
            $tenentId = $azureResult['body']->{'AADCredentialsElementList'}[0]->{'tenentId'};
            $clientId = $azureResult['body']->{'AADCredentialsElementList'}[0]->{'clientId'};
	    $user_principal = $azureResult['body']->{'AADCredentialsElementList'}[0]->{'user_principal'};
	    //$redirectURI = $azureResult['body']->{'AADCredentialsElementList'}[0]->{'redirectURI'};
	    if(useLocalPackage != true){
                $redirectURI = "https://api-app.parablu.com/aad.php";
                $appURL = "https://api-app.parablu.com/call1.php";
            }else{
                $redirectURI = LOCAL_IP."/app/aad.php";
                $appURL = LOCAL_IP."/app/call1.php";
            }
            $this->session->put('emailId', $email);
            $params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI."&user_principal=".$user_principal;
            $ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
            Url::redirect($ADUrl, true);
        }else{
            Url::redirect('404');
        }
    }
    
    public function sharepoint(){
        $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token')
            );
        $odbResult = $this->_model->getOdbDetails($headers);
        $jwtMsg = JWT::decode($_GET['accessToken'], $odbResult["body"]->{"clientSecretKey"}, false);
        $odData = array(
                'accessToken' => $_GET['accessToken'],
                'authenticationToken' => '123456',
                'refreshToken' => $_GET['refreshToken'],
                'cloudStorageType' => 'Office365',
                'clientId' => $odbResult["body"]->{"clientId"},
                'sharePointUrl' => $odbResult["body"]->{"clientResourceURL"},
                'clientSecret' => urldecode(urlencode($odbResult["body"]->{"clientSecretKey"})),
                'redirectUri' => $odbResult["body"]->{"clientRedirectURI"},
                'emailId' => $this->session->get('emailId'),
                'accountId' =>$jwtMsg->unique_name,
                'serviceAccount' => true
            );
        $paraHeaders = array(
                'Content-Type' => 'application/json',
                'userName' => $this->session->get('userName')
            );
        $result = $this->_model->saveAuthCredentials($paraHeaders, json_encode($odData));
        if($result['status'] == 200){
                $this->session->put('storageResult', 'success');
                $this->session->put('storageMessage', 'Sharepoint has been successfully selected as the storage place');
                Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                exit;
            }else{
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', 'Could not complete, please restart the cloud authentication process');
                Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                exit;
            }
    }
    
    public function oneDrive(){
        if(!empty($_GET['code'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),
                'Accept'        => 'application/json',
		'isInternalCall' => true
            );
            $this->log("CODEEEEEEEEE test : ","info");
            $odbResult = $this->_model->getOneDriveDetails($headers);
            $this->log("CODEEEEEEEEE : ".$_GET['code'],"info");
            $this->AzureCode = $_GET['code'];
            $this->userName = !empty($_GET['state']) ? $_GET['state'] : $this->session->get('userName');

            $tenentId = $odbResult["body"]->{"tenantId"};
            $clientId = $odbResult["body"]->{"clientId"};
            //$redirectUri = $odbResult["body"]->{"clientRedirectURI"};
            if(useLocalPackage != true){
            	$redirectUri = "https://api-app.parablu.com/oneDrive.php";
            }else{
            	$redirectUri = LOCAL_IP."/app/oneDrive.php";
            }
            $clientSecretKey = $odbResult["body"]->{"clientSecretKey"};
            $clientTokenURL = 'https://login.microsoftonline.com/common/oauth2/token';
            //$clientTokenURL = 'https://login.microsoftonline.com/'.$tenentId.'/oauth2/token';
            $this->log("CODEEEEEEEEE clientid : ".$clientId,"info");
            $this->log("CODEEEEEEEEE clientsecret : ".$clientSecretKey,"info");
            $this->log("CODEEEEEEEEE tokenurl : ".$clientTokenURL,"info");
            $result = $this->_model->getOneDriveAppAuthToken($clientTokenURL, $clientId, $redirectUri,urlencode($clientSecretKey), $this->AzureCode);
            $resultData = json_decode($result['body']);
            $this->log('Azure Result'. json_encode($result), 'info');
            if($result['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'There was no token passed from the selected cloud Storage please restart the cloud authentication process');
                Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                exit;
            }
            $this->accessToken  = $resultData->access_token;
            $this->refreshToken = $resultData->refresh_token;
            $this->authToken    = $resultData->id_token;
            $jwtMsg = JWT::decode($this->accessToken, $odbResult["body"]->{"clientSecretKey"}, false);
            $odData = array(
                'accessToken' => $this->accessToken,
                'authenticationToken' => $this->authToken,
                'refreshToken' => $this->refreshToken,
                'cloudStorageType' => 'Office365',
                'clientId' => $odbResult["body"]->{"clientId"},
                'sharePointUrl' => $odbResult["body"]->{"clientResourceURL"},
                'clientSecret' => urldecode(urlencode($odbResult["body"]->{"clientSecretKey"})),
                'redirectUri' => urldecode(urlencode($redirectUri)),
                'emailId' => $this->session->get('emailId'),
                'accountId' =>$jwtMsg->unique_name,
                'serviceAccount' => true
            );
           $paraHeaders = array(
                        'Content-Type' => 'application/json',
                        'userName' => $this->userName,
                        'token'         => $this->session->get('token')
                    );
                    $this->log("ODDATA : ".json_encode($odData),"info");
                     $this->log("paraHeaders : ".json_encode($paraHeaders),"info");
                    $result = $this->_model->saveOneDriveCredentials($paraHeaders, json_encode($odData));
                    if($result['status'] == 200){
                        $this->session->put('storageResult', 'success');
                        $this->session->put('storageMessage', 'Office 365 Backup has been successfully selected as the storage place');
                        if($this->session->get('userName') != ''){
                        	Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                	}else{
                        	Url::redirect('success');
                	}
                        exit;
                    }else{
                        $this->session->put('storageResult', 'error');
                        $this->session->put('storageMessage', 'Due to some technical issues could not complete the cloud selection process, Error Code - '.$result['status']);
                        Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                        exit;
                    }

                }else{
                    $this->session->put('storageResult', 'error');
					$this->session->put('storageMessage', 'Could not get the authentication code from Azure Active Directory please restart the cloud authentication process');
                    Url::redirect('user/settings/'.base64_encode($this->session->get('userName')));
                    exit;
                }
            }
            
            public function o365login(){
                $this->log("inside new flow o365login storagecontroller","info");
                $userName       = $_GET['uName'];
                $email          = $_GET['uEmail'];
                if(!empty($userName) && !empty($email)){
                    $headers = array(
                        'Content-Type'  => 'application/json',
                        'token'         => $this->session->get('token'),
                        'Accept'        => 'application/json',
			'isInternalCall' => true
                    );
                    $odbResult = $this->_model->getOneDriveDetails($headers);
                    $tenentId = $odbResult["body"]->{"tenantId"};
                    $clientId = $odbResult["body"]->{"clientId"};
		    $user_principal = $odbResult['body']->{'accountId'};
                    //$redirectUri = $odbResult["body"]->{"clientRedirectURI"};
		    if(useLocalPackage != true){
                        $redirectUri = "https://api-app.parablu.com/oneDrive.php";
                        $appURL = "https://api-app.parablu.com/call1.php";
                    }else{
                        $redirectUri = LOCAL_IP."/app/oneDrive.php";
                        $appURL = LOCAL_IP."/app/call1.php";
                    }
                    $this->session->put('emailId', $email);
                        $params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectUri."&user_principal=".$user_principal;
                        $ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
                    Url::redirect($ADUrl, true);
                }else{
                    Url::redirect('404');
                }
            }
            
    public function sso(){
    	if(!empty($_GET['code'])){
    		$this->log("SSO___CODEEEEEEEEE : ".$_GET['code'],"info");
    		Url::redirect('login1/?code='.$_GET['code'],true);
    	}else{
    		$this->log("................EMPTY CODE.............","info");
    	}
    }
	
    public function adminConsent(){
        if(!empty($_GET['code'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),
                'Accept'        => 'application/json',
        	'isInternalCall' => true
            );
            $this->log("CODEEEEEEEEE test : ","info");
            $odbResult = $this->_model->getOneDriveDetails($headers);
            $this->log("CODEEEEEEEEE : ".$_GET['code'],"info");
            $this->AzureCode = $_GET['code'];
            $this->userName = !empty($_GET['state']) ? $_GET['state'] : $this->session->get('userName');
            $tenentId = $odbResult["body"]->{"tenantId"};
            $clientId = $odbResult["body"]->{"clientId"};
            //$redirectUri = $odbResult["body"]->{"clientRedirectURI"};
            if(useLocalPackage != true){
            	$redirectUri = "https://api-app.parablu.com/adminConsent.php";
            }else{
            	$redirectUri = LOCAL_IP."/app/adminConsent.php";
            }
            $clientSecretKey = $odbResult["body"]->{"clientSecretKey"};
            $clientTokenURL = 'https://login.microsoftonline.com/common/oauth2/token';
            //$clientTokenURL = 'https://login.microsoftonline.com/'.$tenentId.'/oauth2/token';
            $this->log("CODEEEEEEEEE clientid : ".$clientId,"info");
            $this->log("CODEEEEEEEEE clientsecret : ".$clientSecretKey,"info");
            $this->log("CODEEEEEEEEE tokenurl : ".$clientTokenURL,"info");
            $result = $this->_model->getOneDriveAppAuthToken($clientTokenURL, $clientId, $redirectUri,urlencode($clientSecretKey), $this->AzureCode);
            $resultData = json_decode($result['body']);
            $this->log('ADMIN CONSENT RESULTTTTTT'. json_encode($result), 'info');
            if($result['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'There was no token passed from the selected cloud Storage please restart the cloud authentication process');
		exit;
            }
/*          if($result['status'] == 200){
                    $this->session->put('storageResult', 'success');
                    $this->session->put('storageMessage', 'granted successfully');
                    Url::redirect('settings/oneDriveSettings');
                    exit;
            }*/
            $this->accessToken  = $resultData->access_token;
            $this->refreshToken = $resultData->refresh_token;
            $this->authToken    = $resultData->id_token;
            $jwtMsg = JWT::decode($this->accessToken, $odbResult["body"]->{"clientSecretKey"}, false);
            $odData = array(
                'accessToken' => $this->accessToken,
                'authenticationToken' => $this->authToken,
                'refreshToken' => $this->refreshToken,
                'cloudStorageType' => 'Office365',
                'clientId' => $odbResult["body"]->{"clientId"},
                'sharePointUrl' => $odbResult["body"]->{"clientResourceURL"},
                'clientSecret' => urldecode(urlencode($odbResult["body"]->{"clientSecretKey"})),
                'redirectUri' => urldecode(urlencode($redirectUri)),
                'emailId' => $this->session->get('emailId'),
                'accountId' =>$jwtMsg->unique_name,
                'serviceAccount' => true
            );
	    $paraHeaders = array(
                        'Content-Type' => 'application/json',
                        'userName' => $this->userName,
                        'token'         => $this->session->get('token')
                    );
                    $this->log("ODDATA : ".json_encode($odData),"info");
                     $this->log("paraHeaders : ".json_encode($paraHeaders),"info");
//                  $result = $this->_model->saveOneDriveCredentials($paraHeaders, json_encode($odData));
                    if($this->accessToken != ''){
//                    if($result['status'] == 200){
                        $this->session->put('storageResult', 'success');
                        $this->session->put('storageMessage', 'Granted permissions successfully.');
                        if($this->session->get('userName') != ''){
                                Url::redirect('settings/oneDriveSettings');
                            //Url::redirect('user/settings/'.$this->session->get('userName'));
                    }else{
                            Url::redirect('success');
                    }
                        exit;
                    }else{
                        $this->session->put('storageResult', 'error');
                        $this->session->put('storageMessage', 'Due to some technical issues could not complete the cloud selection process, Error Code - '.$result['status']);
                        //Url::redirect('user/settings/'.$this->session->get('userName'));
                        exit;
                    }
                }else{
                    $this->session->put('storageResult', 'error');
                    $this->session->put('storageMessage', 'Could not get the authentication code from Azure Active Directory please restart the cloud authentication process');
                    //Url::redirect('user/settings/'.$this->session->get('userName'));
                    exit;
                }
            }
	
	public function adminConsentMultiTenant(){
        if(!empty($_GET['code'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),
                'Accept'        => 'application/json',
        	'isInternalCall' => true
            );
            $this->log("CODEEEEEEEEE test : ","info");
            $odbResult = $result = $this->_model->getAadDetails($headers);
            $this->log("CODEEEEEEEEE : ".$_GET['code'],"info");
            $this->AzureCode = $_GET['code'];
            $this->userName = !empty($_GET['state']) ? $_GET['state'] : $this->session->get('userName');
            $tenentId = $_GET['tenentId'];
            $clientId = $odbResult['body']->{'AADCredentialsElementList'}[0]->{'clientId'};

            //$redirectUri = $odbResult["body"]->{"clientRedirectURI"};
            if(useLocalPackage != true){
                        $redirectUri = "https://api-app.parablu.com/adminConsentMultiTenant.php";
                    }else{
                        $redirectUri = LOCAL_IP."/app/adminConsentMultiTenant.php";
                    }
            $clientSecretKey = $odbResult["body"]->{'AADCredentialsElementList'}[0]->{"secretKey"};
            $clientTokenURL = 'https://login.microsoftonline.com/common/oauth2/token';
            //$clientTokenURL = 'https://login.microsoftonline.com/'.$tenentId.'/oauth2/token';
            $this->log("CODEEEEEEEEE clientid : ".$clientId,"info");
            $this->log("CODEEEEEEEEE clientsecret : ".$clientSecretKey,"info");
            $this->log("CODEEEEEEEEE tokenurl : ".$clientTokenURL,"info");
            $result = $this->_model->getOneDriveAppAuthToken($clientTokenURL, $clientId, $redirectUri,urlencode($clientSecretKey), $this->AzureCode);
            $resultData = json_decode($result['body']);
            $this->log('ADMIN CONSENT RESULTTTTTT'. json_encode($result), 'info');
            if($result['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'There was no token passed from the selected cloud Storage please restart the cloud authentication process');
		exit;
            }
/*          if($result['status'] == 200){
                    $this->session->put('storageResult', 'success');
                    $this->session->put('storageMessage', 'granted successfully');
                    Url::redirect('settings/oneDriveSettings');
                    exit;
            }*/
            $this->accessToken  = $resultData->access_token;
            $this->refreshToken = $resultData->refresh_token;
            $this->authToken    = $resultData->id_token;
            $jwtMsg = JWT::decode($this->accessToken, $odbResult["body"]->{'AADCredentialsElementList'}[0]->{"clientSecretKey"}, false);
            $odData = array(
                'accessToken' => $this->accessToken,
                'authenticationToken' => $this->authToken,
                'refreshToken' => $this->refreshToken,
                'cloudStorageType' => 'Office365',
                'clientId' => $odbResult["body"]->{'AADCredentialsElementList'}[0]->{"clientId"},
                'sharePointUrl' => $odbResult["body"]->{'AADCredentialsElementList'}[0]->{"clientResourceURL"},
                'clientSecret' => urldecode(urlencode($odbResult["body"]->{'AADCredentialsElementList'}[0]->{"clientSecretKey"})),
                'redirectUri' => urldecode(urlencode($redirectUri)),
                'emailId' => $this->session->get('emailId'),
                'accountId' =>$jwtMsg->unique_name,
                'serviceAccount' => true
            );
	    $paraHeaders = array(
                        'Content-Type' => 'application/json',
                        'userName' => $this->userName,
                        'token'         => $this->session->get('token')
                    );
                    $this->log("ODDATA : ".json_encode($odData),"info");
                     $this->log("paraHeaders : ".json_encode($paraHeaders),"info");
//                  $result = $this->_model->saveOneDriveCredentials($paraHeaders, json_encode($odData));
                    if($this->accessToken != ''){
//                    if($result['status'] == 200){
                        $this->session->put('storageResult', 'success');
                        $this->session->put('storageMessage', 'Granted permissions successfully.');
                        if($this->session->get('userName') != ''){
                                Url::redirect('settings/aadCredentials');
                            //Url::redirect('user/settings/'.$this->session->get('userName'));
                    }else{
                            Url::redirect('success');
                    }
                        exit;
                    }else{
                        $this->session->put('storageResult', 'error');
                        $this->session->put('storageMessage', 'Due to some technical issues could not complete the cloud selection process, Error Code - '.$result['status']);
                        //Url::redirect('user/settings/'.$this->session->get('userName'));
                        exit;
                    }
                }else{
                    $this->session->put('storageResult', 'error');
                    $this->session->put('storageMessage', 'Could not get the authentication code from Azure Active Directory please restart the cloud authentication process');
                    //Url::redirect('user/settings/'.$this->session->get('userName'));
                    exit;
                }
            }
	
	public function adminConsentExchange(){
        if(!empty($_GET['code'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),
                'Accept'        => 'application/json',
        	'isInternalCall' => true
            );
            $this->log("CODEEEEEEEEE test : ","info");
            $odbResult = $this->_model->getExchangeDetails($headers);
            $this->log("CODEEEEEEEEE : ".$_GET['code'],"info");
            $this->AzureCode = $_GET['code'];
            $this->userName = !empty($_GET['state']) ? $_GET['state'] : $this->session->get('userName');

            $tenentId = $odbResult["body"]->{"tenantId"};
            $clientId = $odbResult["body"]->{"clientId"};
            //$redirectUri = $odbResult["body"]->{"clientRedirectURI"};
            if(useLocalPackage != true){
                        $redirectUri = "https://api-app.parablu.com/adminConsentExchange.php";
                    }else{
                        $redirectUri = LOCAL_IP."/app/adminConsentExchange.php";
                    }
            $clientSecretKey = $odbResult["body"]->{"clientSecretKey"};
            $clientTokenURL = 'https://login.microsoftonline.com/common/oauth2/token';
            //$clientTokenURL = 'https://login.microsoftonline.com/'.$tenentId.'/oauth2/token';
            $this->log("CODEEEEEEEEE clientid : ".$clientId,"info");
            $this->log("CODEEEEEEEEE clientsecret : ".$clientSecretKey,"info");
            $this->log("CODEEEEEEEEE tokenurl : ".$clientTokenURL,"info");
            $result = $this->_model->getOneDriveAppAuthToken($clientTokenURL, $clientId, $redirectUri,urlencode($clientSecretKey), $this->AzureCode);
            $resultData = json_decode($result['body']);
            $this->log('ADMIN CONSENT RESULTTTTTT'. json_encode($result), 'info');
            if($result['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'There was no token passed from the selected cloud Storage please restart the cloud authentication process');
		exit;
            }
/*          if($result['status'] == 200){
                    $this->session->put('storageResult', 'success');
                    $this->session->put('storageMessage', 'granted successfully');
                    Url::redirect('settings/oneDriveSettings');
                    exit;
            }*/
            $this->accessToken  = $resultData->access_token;
            $this->refreshToken = $resultData->refresh_token;
            $this->authToken    = $resultData->id_token;
            $jwtMsg = JWT::decode($this->accessToken, $odbResult["body"]->{"clientSecretKey"}, false);
            $odData = array(
                'accessToken' => $this->accessToken,
                'authenticationToken' => $this->authToken,
                'refreshToken' => $this->refreshToken,
                'cloudStorageType' => 'Office365',
                'clientId' => $odbResult["body"]->{"clientId"},
                'sharePointUrl' => $odbResult["body"]->{"clientResourceURL"},
                'clientSecret' => urldecode(urlencode($odbResult["body"]->{"clientSecretKey"})),
                'redirectUri' => urldecode(urlencode($redirectUri)),
                'emailId' => $this->session->get('emailId'),
                'accountId' =>$jwtMsg->unique_name,
                'serviceAccount' => true
            );
	    $paraHeaders = array(
                        'Content-Type' => 'application/json',
                        'userName' => $this->userName,
                        'token'         => $this->session->get('token')
                    );
                    $this->log("ODDATA : ".json_encode($odData),"info");
                     $this->log("paraHeaders : ".json_encode($paraHeaders),"info");
//                  $result = $this->_model->saveOneDriveCredentials($paraHeaders, json_encode($odData));
                    if($this->accessToken != ''){
//                    if($result['status'] == 200){
                        $this->session->put('storageResult', 'success');
                        $this->session->put('storageMessage', 'Granted permissions successfully.');
                        if($this->session->get('userName') != ''){
                                Url::redirect('settings/exchangeSettings');
                            //Url::redirect('user/settings/'.$this->session->get('userName'));
                    }else{
                            Url::redirect('success');
                    }
                        exit;
                    }else{
                        $this->session->put('storageResult', 'error');
                        $this->session->put('storageMessage', 'Due to some technical issues could not complete the cloud selection process, Error Code - '.$result['status']);
                        //Url::redirect('user/settings/'.$this->session->get('userName'));
                        exit;
                    }

                }else{
                    $this->session->put('storageResult', 'error');
                    $this->session->put('storageMessage', 'Could not get the authentication code from Azure Active Directory please restart the cloud authentication process');
                    //Url::redirect('user/settings/'.$this->session->get('userName'));
                    exit;
                }
            }
	
	public function adminConsentSiem(){
        if(!empty($_GET['code'])){
            $headers = array(
                'Content-Type'  => 'application/json',
                'token'         => $this->session->get('token'),
                'Accept'        => 'application/json',
                'isInternalCall' => true
            );
            $this->log("CODEEEEEEEEE test : ","info");
            $odbResult = $this->_model->getSiemCredentials($headers);
            $this->log("CODEEEEEEEEE : ".$_GET['code'],"info");
            $this->AzureCode = $_GET['code'];
            $this->userName = !empty($_GET['state']) ? $_GET['state'] : $this->session->get('userName');
            $tenentId = $odbResult["body"]->{'SIEMCredentialElement'}->{"msTenantId"};
            $clientId = $odbResult["body"]->{'SIEMCredentialElement'}->{"msClientId"};
            if(useLocalPackage != true){
                $redirectUri = "https://api-app.parablu.com/adminConsentSiem.php";
            }else{
                $redirectUri = LOCAL_IP."/app/adminConsentSiem.php";
            }
            $clientSecretKey = $odbResult["body"]->{'SIEMCredentialElement'}->{"msClientSecretKey"};
            $clientTokenURL = 'https://login.microsoftonline.com/common/oauth2/token';
            $this->log("CODEEEEEEEEE clientid : ".$clientId,"info");
            $this->log("CODEEEEEEEEE clientsecret : ".$clientSecretKey,"info");
            $this->log("CODEEEEEEEEE tokenurl : ".$clientTokenURL,"info");
            $result = $this->_model->getOneDriveAppAuthToken($clientTokenURL, $clientId, $redirectUri,urlencode($clientSecretKey), $this->AzureCode);
            $resultData = json_decode($result['body']);
            $this->log('ADMIN CONSENT RESULTTTTTT'. json_encode($result), 'info');
            if($result['status'] !== 200){
                $this->session->put('storageResult', 'error');
                $this->session->put('storageMessage', !empty($result['body']->error_description) ? $result['body']->error_description : 'There was no token passed from the selected cloud Storage please restart the cloud authentication process');
                exit;
            }
	    $this->accessToken  = $resultData->access_token;
            $this->refreshToken = $resultData->refresh_token;
            $this->authToken    = $resultData->id_token;
            $jwtMsg = JWT::decode($this->accessToken, $odbResult["body"]->{"clientSecretKey"}, false);
                    if($this->accessToken != ''){
//                    if($result['status'] == 200){
                        $this->session->put('storageResult', 'success');
                        $this->session->put('storageMessage', 'Granted permissions successfully.');
                        if($this->session->get('userName') != ''){
                                Url::redirect('settings/siemCredentials');
                    }else{
                            Url::redirect('success');
                    }
                        exit;
                    }else{
                        $this->session->put('storageResult', 'error');
                        $this->session->put('storageMessage', 'Due to some technical issues could not complete the cloud selection process, Error Code - '.$result['status']);
                        exit;
                    }
                }else{
                    $this->session->put('storageResult', 'error');
                    $this->session->put('storageMessage', 'Could not get the authentication code from Azure Active Directory please restart the cloud authentication process');
                    exit;
                }
            }

}
