<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use Helpers\Url;
use Helpers\Auth;
use Models\Device;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class DeviceController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('device');
        $this->_model = new Device();
    }

    public function getDevicePolicyInformation($userName, $deviceUUID, $os){
        //$this->auth->checkLoggedInUser($userName);
        $this->session->put('currentDeviceUUID', $deviceUUID);
        $this->session->put('currentOs', $os);
	$_GET['deviceName'] = !empty($_GET['deviceName']) ? str_replace('_PB_', ' ', $_GET['deviceName']) : '';
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('device'),
            'crumb2' => $this->language->get('policy_info'),
            'active' => 'users',
            'os' => $os,
            'deviceName' => htmlentities($_GET['deviceName']),
            'currentUser' => $userName,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        $data['loggedInUser'] = $this->session->get('userName');
	$headers = array(
            'Content-Type'      => 'application/json',
            'token'             => $this->session->get('token')
        );
	$cloudProperties = $this->_model->getCloudProperties($headers);
        if($this->session->get('admin') == true || $this->session->get('readOnlyAdmin') == true){ 
        	$data['isAdmin'] = 'isAdmin';
	}else{
        	//$data['isAdmin'] = 'isNotAdmin';
        	if($cloudProperties['body']->{'cloudPropertyElement'}->{'allowUserLevelFolderExclusions'} == true){
                	$data['isAdmin'] = 'isAdmin';
        	}else{
                	$data['isAdmin'] = 'isNotAdmin';
        	}
	}
	if($this->session->get('readOnlyAdminUser') == 'Yes'){
                if(base64_decode($data['currentUser']) == $data['loggedInUser']){
                        $data['readOnlyAdminUser'] = 'No';
                }else{
                        $data['readOnlyAdminUser'] = 'Yes';
                }
        }else{
                $data['readOnlyAdminUser'] = 'No';
        }
	$this->session->put('redirectUrl', '');
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('device/policyInfo', $data);
        View::renderTemplate('footer', $data);
    }

    public function getCurrentDeviceIDInformation(){
        if(!empty($_POST) && !empty($this->session->get('currentDeviceUUID'))){
            $headers = array(
                'token' => $this->session->get('token'),
                'deviceUUID' => $this->session->get('currentDeviceUUID')
            );
            $result = $this->_model->userDevicePolicyInfo($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'defaultFolders' => $result['body']->bluSyncPortalBackupPolicyElement->defaultFolders,
                        'userExcludedFolders' => $result['body']->bluSyncPortalBackupPolicyElement->userExcludedFolders,
                        'userDefinedFolders' => $result['body']->bluSyncPortalBackupPolicyElement->userDefinedFolders,
                        'fileTypes' => $result['body']->bluSyncPortalBackupPolicyElement->fileTypes,
			'filterType' => $result['body']->bluSyncPortalBackupPolicyElement->filterType,
                        'maxSizeAllowed' => $result['body']->bluSyncPortalBackupPolicyElement->maxSizeAllowed,
			'canAdminRestore' => (boolean)$result['body']->bluSyncPortalBackupPolicyElement->canAdminRestore,
                        'showdisableAdminRestore' => (boolean)$result['body']->bluSyncPortalBackupPolicyElement->showdisableAdminRestore,
			'userSQLBackupFolders' => $result['body']->bluSyncPortalBackupPolicyElement->userSQLBackupFolders,
			'fromFilter' => $result['body']->bluSyncPortalBackupPolicyElement->fromFilter,
                        'toFilter' => $result['body']->bluSyncPortalBackupPolicyElement->toFilter,
                        'subjectFilter' => $result['body']->bluSyncPortalBackupPolicyElement->subjectFilter
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
	
    public function disableAdminRestore(){
        $this->verifyAndCleanItUp();
        if(!empty($_POST) && !empty($this->session->get('currentDeviceUUID'))){
            $headers = array(
                'Content-Type' => 'application/json',
                'token' => $this->session->get('token')
            );
            $data = json_encode(
                array(
                    'deviceUUID' => $this->session->get('currentDeviceUUID'),
                    'userName' => urldecode($_POST['userName']),
                    'canAdminRestore' => $_POST['canAdminRestore']
                )
            );
            $result = $this->_model->disableAdminRestore($headers, $data, $this->session->get('currentDeviceUUID'));
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => 'Saved successfully',
                        'data' => $result
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (447):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('447')
                        );
		    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function addInclusionFolder(){
        $this->verifyAndCleanItUp();
        if(!empty($_POST) && !empty($this->session->get('currentDeviceUUID'))){
            $headers = array(
                'Content-Type' => 'application/json',
                'token' => $this->session->get('token'),
		'userName' => base64_encode($this->session->get('userName'))
            );
            $_POST['folder'] = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $_POST['folder']);
            $_POST['folder'] = str_replace('%E2%81%A9%2F', "/", $_POST['folder']);
	    $_POST['folder'] = str_replace('%2527', "'", $_POST['folder']);
            $data = json_encode(
                array(
                    'folderPath' => urldecode($_POST['folder']),
                    'deviceUUID' => $this->session->get('currentDeviceUUID'),
                    'userName' => urldecode($_POST['userName']),
                    'folderType' => 'INCLUSION'
                )
            );
            $result = $this->_model->addInclusionFolder($headers, $data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('added_inclusion_folder'),
                        'data' => $result
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (447):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('447')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function removeInclusionFolder(){
        $this->verifyAndCleanItUp();
        if(!empty($_POST) && !empty($this->session->get('currentDeviceUUID'))){
            $_POST['folder'] = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $_POST['folder']);
            $_POST['folder'] = str_replace('%E2%81%A9%2F', "/", $_POST['folder']);
	    $_POST['folder'] = str_replace('%2527', "'", $_POST['folder']);
            $headers = array(
                'Content-Type' => 'application/json',
                'token' => $this->session->get('token'),
                'folderPath' => urldecode($_POST['folder']),
                'deviceUUID' => $this->session->get('currentDeviceUUID'),
                'userName' => urldecode($_POST['userName']),
                'folderType' => 'INCLUSION'
            );
            $result = $this->_model->removeInclusionFolder($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('removed_inclusion_folder'),
                        'data' => $result
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (447):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('447')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function addExclusionFolder(){
        $this->verifyAndCleanItUp();
        if(!empty($_POST) && !empty($this->session->get('currentDeviceUUID'))){
            $headers = array(
                'Content-Type' => 'application/json',
                'token' => $this->session->get('token'),
		'userName' => base64_encode($this->session->get('userName'))
            );
            $_POST['folder'] = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $_POST['folder']);
            $_POST['folder'] = str_replace('%E2%81%A9%2F', "/", $_POST['folder']);
	    $_POST['folder'] = str_replace('%2527', "'", $_POST['folder']);
            $data = json_encode(
                array(
                    'folderPath' => urldecode($_POST['folder']),
                    'deviceUUID' => $this->session->get('currentDeviceUUID'),
                    'userName' => urldecode($_POST['userName']),
                    'folderType' => 'EXCLUSION'
                )
            );
            $result = $this->_model->addInclusionFolder($headers, $data);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('added_exclusion_folder'),
                        'data' => $result
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (447):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('447')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function removeExclusionFolder(){
        $this->verifyAndCleanItUp();
        if(!empty($_POST) && !empty($this->session->get('currentDeviceUUID'))){
            $_POST['folder'] = str_replace('%E2%81%A9%20%E2%96%B8%20%E2%81%A8', "/", $_POST['folder']);
            $_POST['folder'] = str_replace('%E2%81%A9%2F', "/", $_POST['folder']);
	    $_POST['folder'] = str_replace('%2527', "'", $_POST['folder']);
            $headers = array(
                'Content-Type' => 'application/json',
                'token' => $this->session->get('token'),
                'folderPath' => urldecode($_POST['folder']),
                'deviceUUID' => $this->session->get('currentDeviceUUID'),
                'userName' => urldecode($_POST['userName']),
                'folderType' => 'EXCLUSION'
            );
            $result = $this->_model->removeInclusionFolder($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('removed_exclusion_folder'),
                        'data' => $result
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (447):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('447')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function devicesBulkBlock(){
        Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('devices'),
            'crumb1' => $this->language->get('devicesBulkBlock'),
            'active' => 'devices',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('device/devicesBulkBlock', $data);
        View::renderTemplate('footer', $data);
    }

    public function devices(){
        Auth::allowOnly('readOnlyAdmin');
        $data = array(
            'title' => $this->language->get('devices'),
            'crumb1' => $this->language->get('listOfDevices'),
            'active' => 'devices',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
    	);
	if($this->session->get('readOnlyAdminUser') == 'Yes'){
        	$data['readOnlyAdminUser'] = 'Yes';
	}else{
        	$data['readOnlyAdminUser'] = 'No';
	}
	if(Auth::checkCloudPermission('sharepoint')){
		$sharepointPolicyResult1 = $this->_model->getAllOneDrivePolicies(array('token'=>$this->session->get('token'), 'userEditProfile' => 'true', 'policyType' => 'Sharepoint'));        	
        	$sharepointPolicies1 = [];
		if(!empty($sharepointPolicyResult1['body']->{'officeBackupPolicyElementList'})){
		foreach((array)$sharepointPolicyResult1['body']->{'officeBackupPolicyElementList'} as $value){
            		$policy = array('name' => $value->{'policygroupName'});
            		$sharepointPolicies1 = array_merge(array($policy), $sharepointPolicies1);
		}
		}
		natcasesort($sharepointPolicies1);
		$data['sharepointPolicies1'] = $sharepointPolicies1;
    	}
	$data['activeTabBackup'] = '';
        $data['activeTabExchange'] = '';
        $data['activeTabOnedrive'] = '';
        $data['activeTabSharepoint'] = '';
        if(Auth::checkCloudPermission('backup') == true){
                $data['activeTabBackup'] = 'active';
        }else{
                if(Auth::checkCloudPermission('exchange') == true){
                        $data['activeTabExchange'] = 'active';
                }else{
                        if(Auth::checkCloudPermission('sharepoint') == true){
                                $data['activeTabSharepoint'] = 'active';
                        }else{
                                if(Auth::checkCloudPermission('onedrive') == true){
                                        $data['activeTabOnedrive'] = 'active';
                                }else{
                                }
                        }
                }
        }
        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('device/devices', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAllDevices(){
        if(is_array($_POST['deviceName'])){
            $_POST['deviceName'] = implode(',', $_POST['deviceName']);
        }
        Auth::allowOnly('readOnlyAdmin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){

            $headers = array(
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
                'policyType'	=> ''
            );
            if($_POST['deviceName'] != 'all'){
		//$_POST['deviceName'] = implode(',', $_POST['deviceName']);
                $headers['deviceNames'] = $_POST['deviceName'];
                $result = $this->_model->searchInDevices($headers);
            }else{
                $result = $this->_model->getAllDevices($headers,$_POST['pageNumber']);
            }
            $this->log('Result: '.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $devices = [];
                    if(!empty($result['body']->{'data'}->{'devices'})){
                        foreach($result['body']->{'data'}->{'devices'} as $value){

                            $version = (string)$value->{'osType'};
                        	/*if( (preg_match('/Win/', (string)$value->{'osType'} )) && (preg_match('/bit/', (string)$value->{'device-os-version'} ))) {
					$char = "(";
					$str = explode($char,(string)$value->{'osVersion'});
					$version =$version."(".$str[1];
			    }*/
                            if($value->{'blocked'} == false && $value->{'decoupled'} == false){
                                $status = 'Active';
                            }else if($value->{'blocked'} == true){
                                $status = 'Blocked';
                            }else if($value->{'blocked'} == false && $value->{'decoupled'} == true){
                                $status = 'Decoupled';
			    }			    
			    if(!empty($value->{'ownerList'})){
				$this->log("length : ".count($value->{'ownerList'}),"info");			    
				if(count($value->{'ownerList'}) >= 1){
					$deviceAssigned = 'Yes';
				}
			    }else{
					$deviceAssigned = 'No';
			    }
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'status' => $status,
                                'decoupled' => $value->{'decoupled'},
                                'deviceId' => (string)$value->{'deviceId'},
                                'createdTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
                                'modifiedTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
                                'deviceName' => (string)$value->{'deviceName'},
				'deviceNameNew' => str_replace(' ', '_PB_', $value->{'deviceName'}),
                                //'icon' => $this->getOsIcon($value->{'osType'}),
                                'icon' => ((string)$value->{'osType'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'osType'}),
                                'version' => (string)$value->{'osVersion'},
                                'tempPath' => (string)$value->{'deviceTempPath'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'deviceType' => (string)$value->{'deviceType'},
                                'blocked' => $value->{'blocked'},
                                'isRemoteWipeEnabled' => (string)$value->{'remoteWipeEnabled'},
                                'userName' => (string)$value->{'userName'},
				'userNameForSearch' => base64_encode((string)$value->{'userName'}),
                                'osType' =>  $version,
				'ownerList' => !empty($value->{'ownerList'}) ? implode(',',(array)$value->{'ownerList'}) : '',
				'deviceAssigned' => $deviceAssigned,
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'},
				'showAssignDevices' => $value->{'showAssignDevices'}

                            );
                            $devices = array_merge(array($device), $devices);
                        }
		    }
		    $this->log("DATAAA : ".json_encode($devices),"info");
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'devices' => $devices,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getAllDevices1(){        
        Auth::allowOnly('readOnlyAdmin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){
            $headers = array(
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
                'policyType'	=> ''
            );

            if($_POST['deviceName'] != 'all'){
                $headers['deviceNames'] = $_POST['deviceName'];
                $result = $this->_model->searchInDevices($headers);
            }else{
                $result = $this->_model->getAllDevices1($headers,$_POST['url']);
            }
            $this->log('Result: '.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $devices = [];
                    if(!empty($result['body']->{'data'}->{'devices'})){
                        foreach($result['body']->{'data'}->{'devices'} as $value){
                            $version = (string)$value->{'osType'};
                            /*if( (preg_match('/Win/', (string)$value->{'osType'} )) && (preg_match('/bit/', (string)$value->{'device-os-version'} ))) {
                                $char = "(";
                                $str = explode($char,(string)$value->{'osVersion'});
                                $version =$version."(".$str[1];
			    }*/
                            if($value->{'blocked'} == false && $value->{'decoupled'} == false){
                                $status = 'Active';
                            }else if($value->{'blocked'} == true){
                                $status = 'Blocked';
                            }else if($value->{'blocked'} == false && $value->{'decoupled'} == true){
                                $status = 'Decoupled';
			    }			    
			    if(!empty($value->{'ownerList'})){
				$this->log("length : ".count($value->{'ownerList'}),"info");
				if(count($value->{'ownerList'}) >= 1){
					$deviceAssigned = 'Yes';
			    	}
			    }else{
				$deviceAssigned = 'No';
			    }
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'status' => $status,
                                'decoupled' => $value->{'decoupled'},
                                'deviceId' => (string)$value->{'deviceId'},
                                'createdTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
                                'modifiedTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
                                'deviceName' => (string)$value->{'deviceName'},
				'deviceNameNew' => str_replace(' ', '_PB_', $value->{'deviceName'}),
                                //'icon' => $this->getOsIcon($value->{'osType'}),
                                'icon' => ((string)$value->{'osType'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'osType'}),
                                'version' => (string)$value->{'osVersion'},
                                'tempPath' => (string)$value->{'deviceTempPath'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'deviceType' => (string)$value->{'deviceType'},
                                'blocked' => $value->{'blocked'},
                                'isRemoteWipeEnabled' => (string)$value->{'remoteWipeEnabled'},
                                'userName' => (string)$value->{'userName'},
				'userNameForSearch' => base64_encode((string)$value->{'userName'}),
                                'osType' =>  $version,
				'ownerList' => !empty($value->{'ownerList'}) ? implode(',',(array)$value->{'ownerList'}) : '',
				'deviceAssigned' => $deviceAssigned,
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'},
				'showAssignDevices' => $value->{'showAssignDevices'}
                            );
                            $devices = array_merge(array($device), $devices);
                        }
                    }
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'devices' => $devices,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
            }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    /*exchange onedrive & sharepoint devices start*/
	public function getAllDevicesOneDrive(){
        if(is_array($_POST['deviceName'])){
            $_POST['deviceName'] = implode(',', $_POST['deviceName']);
	}
        Auth::allowOnly('readOnlyAdmin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){

            $headers = array(
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
		'policyType'	=> 'ODB'
                
            );
            if($_POST['deviceName'] != 'all'){
		//$_POST['deviceName'] = implode(',', $_POST['deviceName']);
		    $headers['deviceNames'] = $_POST['deviceName'];
		    $this->log("came for search  ".$_POST['deviceName'],"info");
                $result = $this->_model->searchInDevicesPt($headers);
	    }else{
		    $this->log("came for all search  ".$_POST['deviceName'],"info");
                $result = $this->_model->getAllDevicesOneDrive($headers,$_POST['pageNumber']);
            }
            $this->log('Result: '.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $devices = [];
                    if(!empty($result['body']->{'data'}->{'devices'})){
                        foreach($result['body']->{'data'}->{'devices'} as $value){

                            $version = (string)$value->{'osType'};
                        	/*if( (preg_match('/Win/', (string)$value->{'osType'} )) && (preg_match('/bit/', (string)$value->{'device-os-version'} ))) {
					$char = "(";
					$str = explode($char,(string)$value->{'osVersion'});
					$version =$version."(".$str[1];
				}*/
                            if($value->{'blocked'} == false && $value->{'decoupled'} == false){
                                $status = 'Active';
                            }else if($value->{'blocked'} == true){
                                $status = 'Blocked';
                            }else if($value->{'blocked'} == false && $value->{'decoupled'} == true){
                                $status = 'Decoupled';
			    }			    
			    if(!empty($value->{'ownerList'})){			    
				$this->log("length : ".count($value->{'ownerList'}),"info");			    
				if(count($value->{'ownerList'}) >= 1){
					$deviceAssigned = 'Yes';
				}
			    }else{
					$deviceAssigned = 'No';
			    }
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'status' => $status,
                                'decoupled' => $value->{'decoupled'},
                                'deviceId' => (string)$value->{'deviceId'},
                                'createdTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
                                'modifiedTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
                                'deviceName' => (string)$value->{'deviceName'},
				'deviceNameNew' => str_replace(' ', '_PB_', $value->{'deviceName'}),
                                //'icon' => $this->getOsIcon($value->{'osType'}),
                                'icon' => ((string)$value->{'osType'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'osType'}),
                                'version' => (string)$value->{'osVersion'},
                                'tempPath' => (string)$value->{'deviceTempPath'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'deviceType' => (string)$value->{'deviceType'},
                                'blocked' => $value->{'blocked'},
                                'isRemoteWipeEnabled' => (string)$value->{'remoteWipeEnabled'},
                                'userName' => (string)$value->{'userName'},
				'userNameForSearch' => base64_encode((string)$value->{'userName'}),
                                'osType' =>  $version,
				'ownerList' => !empty($value->{'ownerList'}) ? implode(',',(array)$value->{'ownerList'}) : '',
				'deviceAssigned' => $deviceAssigned,
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'}

                            );
                            $devices = array_merge(array($device), $devices);
                        }
		    }
		    $this->log("DATAAA : ".json_encode($devices),"info");
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'devicesOneDrive' => $devices,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getAllDevicesOneDrive1(){        
        Auth::allowOnly('readOnlyAdmin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){
            $headers = array(
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
                'policyType'	=> 'ODB'                
            );

            if($_POST['deviceName'] != 'all'){
                $headers['deviceNames'] = $_POST['deviceName'];
                $result = $this->_model->searchInDevicesPt($headers);
            }else{
                $result = $this->_model->getAllDevicesOneDrive1($headers,$_POST['url']);
            }
            $this->log('Result: '.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $devices = [];
                    if(!empty($result['body']->{'data'}->{'devices'})){
                        foreach($result['body']->{'data'}->{'devices'} as $value){
                            $version = (string)$value->{'osType'};
                            /*if( (preg_match('/Win/', (string)$value->{'osType'} )) && (preg_match('/bit/', (string)$value->{'device-os-version'} ))) {
                                $char = "(";
                                $str = explode($char,(string)$value->{'osVersion'});
                                $version =$version."(".$str[1];
			    }*/
                            if($value->{'blocked'} == false && $value->{'decoupled'} == false){
                                $status = 'Active';
                            }else if($value->{'blocked'} == true){
                                $status = 'Blocked';
                            }else if($value->{'blocked'} == false && $value->{'decoupled'} == true){
                                $status = 'Decoupled';
			    }			    
			    if(!empty($value->{'ownerList'})){
				$this->log("length : ".count($value->{'ownerList'}),"info");
				if(count($value->{'ownerList'}) >= 1){
					$deviceAssigned = 'Yes';
			    	}
			    }else{
				$deviceAssigned = 'No';
			    }
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'status' => $status,
                                'decoupled' => $value->{'decoupled'},
                                'deviceId' => (string)$value->{'deviceId'},
                                'createdTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
                                'modifiedTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
                                'deviceName' => (string)$value->{'deviceName'},
				'deviceNameNew' => str_replace(' ', '_PB_', $value->{'deviceName'}),
                                //'icon' => $this->getOsIcon($value->{'osType'}),
                                'icon' => ((string)$value->{'osType'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'osType'}),
                                'version' => (string)$value->{'osVersion'},
                                'tempPath' => (string)$value->{'deviceTempPath'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'deviceType' => (string)$value->{'deviceType'},
                                'blocked' => $value->{'blocked'},
                                'isRemoteWipeEnabled' => (string)$value->{'remoteWipeEnabled'},
                                'userName' => (string)$value->{'userName'},
				'userNameForSearch' => base64_encode((string)$value->{'userName'}),
                                'osType' =>  $version,
				'ownerList' => !empty($value->{'ownerList'}) ? implode(',',(array)$value->{'ownerList'}) : '',
				'deviceAssigned' => $deviceAssigned,
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'}
                            );
                            $devices = array_merge(array($device), $devices);
                        }
                    }
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'devicesOneDrive' => $devices,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
            }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getAllDevicesExchange(){
        if(is_array($_POST['deviceName'])){
            $_POST['deviceName'] = implode(',', $_POST['deviceName']);
        }
        Auth::allowOnly('readOnlyAdmin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){

            $headers = array(
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
		'policyType'	=> 'Exchange'

            );
            if($_POST['deviceName'] != 'all'){
		//$_POST['deviceName'] = implode(',', $_POST['deviceName']);
                $headers['deviceNames'] = $_POST['deviceName'];
                $result = $this->_model->searchInDevicesPt($headers);
            }else{
                $result = $this->_model->getAllDevicesExchange($headers,$_POST['pageNumber']);
            }
            $this->log('Result: '.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $devices = [];
                    if(!empty($result['body']->{'data'}->{'devices'})){
                        foreach($result['body']->{'data'}->{'devices'} as $value){

                            $version = (string)$value->{'osType'};
                        	/*if( (preg_match('/Win/', (string)$value->{'osType'} )) && (preg_match('/bit/', (string)$value->{'device-os-version'} ))) {
					$char = "(";
					$str = explode($char,(string)$value->{'osVersion'});
					$version =$version."(".$str[1];
				}*/
                            if($value->{'blocked'} == false && $value->{'decoupled'} == false){
                                $status = 'Active';
                            }else if($value->{'blocked'} == true){
                                $status = 'Blocked';
                            }else if($value->{'blocked'} == false && $value->{'decoupled'} == true){
                                $status = 'Decoupled';
			    }
			    if(!empty($value->{'ownerList'})){
				$this->log("length : ".count($value->{'ownerList'}),"info");
				if(count($value->{'ownerList'}) >= 1){
					$deviceAssigned = 'Yes';
				}
			    }else{
					$deviceAssigned = 'No';
			    }
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'status' => $status,
                                'decoupled' => $value->{'decoupled'},
                                'deviceId' => (string)$value->{'deviceId'},
                                'createdTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
                                'modifiedTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
                                'deviceName' => (string)$value->{'deviceName'},
				'deviceNameNew' => str_replace(' ', '_PB_', $value->{'deviceName'}),
                                //'icon' => $this->getOsIcon($value->{'osType'}),
                                'icon' => ((string)$value->{'osType'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'osType'}),
                                'version' => (string)$value->{'osVersion'},
                                'tempPath' => (string)$value->{'deviceTempPath'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'deviceType' => (string)$value->{'deviceType'},
                                'blocked' => $value->{'blocked'},
                                'isRemoteWipeEnabled' => (string)$value->{'remoteWipeEnabled'},
                                'userName' => (string)$value->{'userName'},
				'userNameForSearch' => base64_encode((string)$value->{'userName'}),
                                'osType' =>  $version,
				'ownerList' => !empty($value->{'ownerList'}) ? implode(',',(array)$value->{'ownerList'}) : '',
				'deviceAssigned' => $deviceAssigned,
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'}

                            );
                            $devices = array_merge(array($device), $devices);
                        }
		    }
		    $this->log("DATAAA : ".json_encode($devices),"info");
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'devicesExchange' => $devices,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getAllDevicesExchange1(){
        Auth::allowOnly('readOnlyAdmin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){
            $headers = array(
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
                'policyType'	=> 'Exchange'
            );

            if($_POST['deviceName'] != 'all'){
                $headers['deviceNames'] = $_POST['deviceName'];
                $result = $this->_model->searchInDevicesPt($headers);
            }else{
                $result = $this->_model->getAllDevicesExchange1($headers,$_POST['url']);
            }
            $this->log('Result: '.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $devices = [];
                    if(!empty($result['body']->{'data'}->{'devices'})){
                        foreach($result['body']->{'data'}->{'devices'} as $value){
                            $version = (string)$value->{'osType'};
                            /*if( (preg_match('/Win/', (string)$value->{'osType'} )) && (preg_match('/bit/', (string)$value->{'device-os-version'} ))) {
                                $char = "(";
                                $str = explode($char,(string)$value->{'osVersion'});
                                $version =$version."(".$str[1];
			    }*/
                            if($value->{'blocked'} == false && $value->{'decoupled'} == false){
                                $status = 'Active';
                            }else if($value->{'blocked'} == true){
                                $status = 'Blocked';
                            }else if($value->{'blocked'} == false && $value->{'decoupled'} == true){
                                $status = 'Decoupled';
			    }
			    if(!empty($value->{'ownerList'})){
				$this->log("length : ".count($value->{'ownerList'}),"info");
				if(count($value->{'ownerList'}) >= 1){
					$deviceAssigned = 'Yes';
			    	}
			    }else{
				$deviceAssigned = 'No';
			    }
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'status' => $status,
                                'decoupled' => $value->{'decoupled'},
                                'deviceId' => (string)$value->{'deviceId'},
                                'createdTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
                                'modifiedTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
                                'deviceName' => (string)$value->{'deviceName'},
				'deviceNameNew' => str_replace(' ', '_PB_', $value->{'deviceName'}),
                                //'icon' => $this->getOsIcon($value->{'osType'}),
                                'icon' => ((string)$value->{'osType'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'osType'}),
                                'version' => (string)$value->{'osVersion'},
                                'tempPath' => (string)$value->{'deviceTempPath'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'deviceType' => (string)$value->{'deviceType'},
                                'blocked' => $value->{'blocked'},
                                'isRemoteWipeEnabled' => (string)$value->{'remoteWipeEnabled'},
                                'userName' => (string)$value->{'userName'},
				'userNameForSearch' => base64_encode((string)$value->{'userName'}),
                                'osType' =>  $version,
				'ownerList' => !empty($value->{'ownerList'}) ? implode(',',(array)$value->{'ownerList'}) : '',
				'deviceAssigned' => $deviceAssigned,
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'}
                            );
                            $devices = array_merge(array($device), $devices);
                        }
                    }
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'devicesExchange' => $devices,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
            }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getAllDevicesSharepoint(){
        if(is_array($_POST['deviceName'])){
            $_POST['deviceName'] = implode(',', $_POST['deviceName']);
        }
        Auth::allowOnly('readOnlyAdmin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){

            $headers = array(
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
		'policyType'	=> 'Sharepoint'

            );
            if($_POST['deviceName'] != 'all'){
		//$_POST['deviceName'] = implode(',', $_POST['deviceName']);
                $headers['deviceNames'] = $_POST['deviceName'];
                $result = $this->_model->searchInDevicesPt($headers);
            }else{
                $result = $this->_model->getAllDevicesSharepoint($headers,$_POST['pageNumber']);
            }
            $this->log('Result: '.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $devices = [];
                    if(!empty($result['body']->{'data'}->{'devices'})){
                        foreach($result['body']->{'data'}->{'devices'} as $value){

                            $version = (string)$value->{'osType'};
                        	/*if( (preg_match('/Win/', (string)$value->{'osType'} )) && (preg_match('/bit/', (string)$value->{'device-os-version'} ))) {
					$char = "(";
					$str = explode($char,(string)$value->{'osVersion'});
					$version =$version."(".$str[1];
				}*/
                            if($value->{'blocked'} == false && $value->{'decoupled'} == false){
                                $status = 'Active';
                            }else if($value->{'blocked'} == true){
                                $status = 'Blocked';
                            }else if($value->{'blocked'} == false && $value->{'decoupled'} == true){
                                $status = 'Decoupled';
			    }
			    if(!empty($value->{'ownerList'})){
				$this->log("length : ".count($value->{'ownerList'}),"info");
				if(count($value->{'ownerList'}) >= 1){
					$deviceAssigned = 'Yes';
				}
			    }else{
					$deviceAssigned = 'No';
			    }
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'status' => $status,
                                'decoupled' => $value->{'decoupled'},
                                'deviceId' => (string)$value->{'deviceId'},
                                'createdTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
                                'modifiedTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
                                'deviceName' => (string)$value->{'deviceName'},
				'deviceNameNew' => str_replace(' ', '_PB_', $value->{'deviceName'}),
                                //'icon' => $this->getOsIcon($value->{'osType'}),
                                'icon' => ((string)$value->{'osType'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'osType'}),
                                'version' => (string)$value->{'osVersion'},
                                'tempPath' => (string)$value->{'deviceTempPath'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'deviceType' => (string)$value->{'deviceType'},
                                'blocked' => $value->{'blocked'},
                                'isRemoteWipeEnabled' => (string)$value->{'remoteWipeEnabled'},
				'userName' => (string)$value->{'userName'},
				'userNameForView' => base64_encode((string)$value->{'userName'}),
				'userNameForSearch' => base64_encode((string)$value->{'userName'}),
                                'osType' =>  $version,
				'ownerList' => !empty($value->{'ownerList'}) ? implode(',',(array)$value->{'ownerList'}) : '',
				'deviceAssigned' => $deviceAssigned,
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'}

                            );
                            $devices = array_merge(array($device), $devices);
                        }
		    }
		    $this->log("DATAAA : ".json_encode($devices),"info");
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'devicesSharepoint' => $devices,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getAllDevicesSharepoint1(){
        Auth::allowOnly('readOnlyAdmin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){
            $headers = array(
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
                'policyType'	=> 'Sharepoint'
            );

            if($_POST['deviceName'] != 'all'){
                $headers['deviceNames'] = $_POST['deviceName'];
                $result = $this->_model->searchInDevicesPt($headers);
            }else{
                $result = $this->_model->getAllDevicesSharepoint1($headers,$_POST['url']);
            }
            $this->log('Result: '.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $devices = [];
                    if(!empty($result['body']->{'data'}->{'devices'})){
                        foreach($result['body']->{'data'}->{'devices'} as $value){
                            $version = (string)$value->{'osType'};
                            /*if( (preg_match('/Win/', (string)$value->{'osType'} )) && (preg_match('/bit/', (string)$value->{'device-os-version'} ))) {
                                $char = "(";
                                $str = explode($char,(string)$value->{'osVersion'});
                                $version =$version."(".$str[1];
			    }*/
                            if($value->{'blocked'} == false && $value->{'decoupled'} == false){
                                $status = 'Active';
                            }else if($value->{'blocked'} == true){
                                $status = 'Blocked';
                            }else if($value->{'blocked'} == false && $value->{'decoupled'} == true){
                                $status = 'Decoupled';
			    }
			    if(!empty($value->{'ownerList'})){
				$this->log("length : ".count($value->{'ownerList'}),"info");
				if(count($value->{'ownerList'}) >= 1){
					$deviceAssigned = 'Yes';
			    	}
			    }else{
				$deviceAssigned = 'No';
			    }
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'status' => $status,
                                'decoupled' => $value->{'decoupled'},
                                'deviceId' => (string)$value->{'deviceId'},
                                'createdTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
                                'modifiedTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
                                'deviceName' => (string)$value->{'deviceName'},
				'deviceNameNew' => str_replace(' ', '_PB_', $value->{'deviceName'}),
                                //'icon' => $this->getOsIcon($value->{'osType'}),
                                'icon' => ((string)$value->{'osType'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'osType'}),
                                'version' => (string)$value->{'osVersion'},
                                'tempPath' => (string)$value->{'deviceTempPath'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'deviceType' => (string)$value->{'deviceType'},
                                'blocked' => $value->{'blocked'},
                                'isRemoteWipeEnabled' => (string)$value->{'remoteWipeEnabled'},
				'userName' => (string)$value->{'userName'},
				'userNameForView' => base64_encode((string)$value->{'userName'}),
				'userNameForSearch' => base64_encode((string)$value->{'userName'}),
                                'osType' =>  $version,
				'ownerList' => !empty($value->{'ownerList'}) ? implode(',',(array)$value->{'ownerList'}) : '',
				'deviceAssigned' => $deviceAssigned,
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'}
                            );
                            $devices = array_merge(array($device), $devices);
                        }
                    }
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'devicesSharepoint' => $devices,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
            }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    /*exchange onedrive & sharepoint devices ends*/

    public function blockUnBlockDevice(){
        //Auth::allowOnly('admin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'user-name' => $_POST['userName'],
                'device-name' => $_POST['deviceName']
            );
            $this->log("UUID : ".$_POST['deviceUUID'],"info");
            $this->log("ACTION : ".$_POST['action'],"info");
            $result = $this->_model->blockUnBlockDevice($headers, $_POST['deviceUUID'], $_POST['action']);
            switch ($result['status']) {
                case (200):
                    if($_POST['action'] == 'true'){
                        $msg = $this->language->get('deviceBlocked');
                    }else{
                        $msg = $this->language->get('deviceUnBlocked');
                    }
                    $response = array(
                        'result' => 'success',
                        'msg' => $msg
                    );
                    echo json_encode($response);
                    exit;
                case (418):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('deviceLimitReached')
                    );
                    echo json_encode($result);
                    exit();
		case (420):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'The user does not have a proper license.'			
                    );
                    echo json_encode($result);
                    exit();
		case (426):
                    $result = array(
                        'result' => 'fail',
			'msg' => 'Please assign device back to original owner to perform the operation.'
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
			            'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function deleteDevice(){
        //Auth::allowOnly('admin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'deletedBy'    => $this->session->get('userName'),
                'user-name' => $_POST['userName'],
                'device-name' => $_POST['deviceName']
            );
            $this->log('UUID : '.$_POST['deviceUUID'], 'info');
            $this->log('TOKEN : '.json_encode($headers), 'info');
            $result = $this->_model->deleteDevice($headers, $_POST['deviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('deviceDeleted')
                    );
                    echo json_encode($response);
                    exit;
                case (418):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('deviceLimitReachedDelete')
                    );
                    echo json_encode($result);
                    exit();
		case (420):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'The user does not have a proper license.'
                    );
                    echo json_encode($result);
                    exit();
		case (426):
                    $result = array(
                        'result' => 'fail',
			'msg' => 'Please assign device back to original owner to perform the operation.'
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function remoteWipe(){
        //Auth::allowOnly('admin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $this->log('UUID : '.$_POST['deviceUUID'], 'info');
            $result = $this->_model->remoteWipe($headers, $_POST['deviceUUID']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('deviceDeleted')
                    );
                    echo json_encode($response);
                    exit;
                case (418):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('deviceLimitReachedDelete')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function blockMultipleDevices(){
        //Auth::allowOnly('admin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){
            $headers = array(
                'Content-Type' => 'application/json',
                'token' => $this->session->get('token'),
                'active' => $_POST['blocked'],
            );
            $result = $this->_model->blockUnBlockMultipleDevice($headers, $_POST['deviceUUIDs']);
            switch ($result['status']) {
                case (200):
                    if($_POST['blocked'] == 'true'){
                        $msg = $this->language->get('multipleDeviceBlocked');
                    }else{
                        $msg = $this->language->get('multipleDeviceUnBlocked');
                    }
                    $response = array(
                        'result' => 'success',
                        'msg' => $msg
                    );
                    echo json_encode($response);
                    exit;
                case (418):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('deviceLimitReached')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function blockDevices(){
        if(!empty($_POST['devices'])){
            $headers = array(
                'Content-Type' => 'application/json',
                'token'     => $this->session->get('token'),
            );        
            $this->log('Type________'. json_encode($_POST['devices']), 'info');
            $result = $this->_model->blockDevices($headers, $_POST['devices']);
            $this->log('Type'. json_encode($result['body']->deviceElementList), 'info');
            switch ($result['status']) {
                case (200):
                    //$this->log('UUUUUUUEEEEE'. json_encode($result['body']), 'info');
                    $policies = [];
                    foreach($result['body']->{'deviceElementList'} as $value){
			if((string)$value->{'status'} == 'DELETED' || (string)$value->{'status'} == 'DECOUPLED' || (string)$value->{'status'} == 'INVALID'  || (string)$value->{'status'} == 'ACTIVE' || (string)$value->{'status'} == 'User or Device does not exist or invalid' || $value->{'deviceAssigned'} == true || (string)$value->{'status'} == "The user does not have proper license"){
                        	$flag = 'disablee';
                        }else{
                            $flag = 'enablee';
                        }
			if($value->{'status'} == 'BLOCKED'){
                                $isBlocked = 'Yes';
                        }else{
                                $isBlocked = 'No';
                        }
			if($value->{'deviceAssigned'} == true){
                                $value->{'status'} = 'Device Assigned';
                        }
                        $policy = array(                         
                            'userName' => (string)$value->{'userName'},
                            'deviceName' => (string)$value->{'deviceName'},
                            'deviceUUID' => (string)$value->{'deviceUUID'},
                            'time'        => date("M j, Y, g:i:s", (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                            'status' => (string)$value->{'status'},
			    'flag' => $flag,
			    'deviceAssigned' => $value->{'deviceAssigned'}
                            );
                        $policies = array_merge(array($policy), $policies);
                    }                    
                    $this->log('UUUUUUU'. json_encode($policies), 'info');
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('deletedMultipleUsers'),
                        'naveen'  => array_reverse($policies)
                    );
                    echo json_encode($response);
                    exit;
                case (447):
                    $response = array(
                        'result' => 'fail',
                        'message' => $this->language->get('447')
                    );
                    echo json_encode($response);
                    exit;                
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array('result' => 'noData','message' => $this->language->get('noData')));
        }
    }

    public function deleteMultipleDevices(){
        //Auth::allowOnly('admin');
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){
            $headers = array(
                'Content-Type' => 'application/json',
                'token' => $this->session->get('token'),
                'deletedBy'    => $this->session->get('userName')
            );
            $result = $this->_model->deleteMultipleDevices($headers, $_POST['deviceUUIDs']);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('multipleDevicesDeleted')
                    );
                    echo json_encode($response);
                    exit;
                case (418):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('deviceLimitReached')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    public function searchDevices(){
        if(!empty($_GET)){
            $headers = array(
                'Content-Type' => 'application/json',
                'token' => $this->session->get('token'),
                'skipValue' => $_GET['skipValue']
            );
            if(!empty($_GET['q']) && $_GET['q'] != 'all'){
                $headers['deviceNames'] = $_GET['q'];
                $result = $this->_model->searchInDevices($headers);
            }else{
                $result = $this->_model->getAllDevices($headers);
            }
            switch ($result['status']) {
                case (200):
                    $devices = [];
                    if(!empty($result['body'])){
                        foreach($result['body']->{'device-info'} as $value){
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'decoupled' => (string)$value->{'decoupled'},
                                'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'device-created-timestamp'}) / 1000)),
                                'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'modified-timestamp'},
                                'deviceName' => (string)$value->{'device-name'},
                                'osType' => (string)$value->{'device-os-type'},
                                'icon' => (strpos((string)$value->{'device-os-type'},'Win') !== false ? 'windows' : 'apple'),
                                'version' => (string)$value->{'device-os-version'},
                                'tempPath' => (string)$value->{'device-temp-path'},
                                'deviceUUID' => (string)$value->{'device-uuid'},
                                'blocked' => (string)$value->{'is-blocked'},
                                'userName' => (string)$value->{'userName'},
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'}
                            );
                            $devices = array_merge(array($device), $devices);
                        }
                    }
                    $devices = array_merge(array(array("deviceName" => "all", "profilePic" => Url::profilePic("default"))), $devices);
                    $response = array(
                        'result' => 'success',
                        'devices' => $devices
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getAllBlockedDevices(){
        if(empty($_GET)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'Content-Type' => 'application/json',
            'token' => $this->session->get('token'),
            'skipValue' => $_GET['skipValue']
        );
        if(!empty($_GET['q']) && $_GET['q'] != 'all'){
            $headers['deviceNames'] = $_GET['q'];
            $result = $this->_model->searchInDevices($headers);
        }else{
            $result = $this->_model->getAllDevices($headers);
        }
        switch ($result['status']) {
            case (200):
                $devices = [];
                if(!empty($result['body'])){
                    foreach($result['body']->{'device-info'} as $value){
                        if((string)$value->{'is-blocked'} == 'true'){
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'decoupled' => (string)$value->{'decoupled'},
                                'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'device-created-timestamp'}) / 1000)),
                                'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'modified-timestamp'},
                                'deviceName' => (string)$value->{'device-name'},
                                'osType' => (string)$value->{'device-os-type'},
                                'icon' => (strpos((string)$value->{'device-os-type'},'Win') !== false ? 'windows' : 'apple'),
                                'version' => (string)$value->{'device-os-version'},
                                'tempPath' => (string)$value->{'device-temp-path'},
                                'deviceUUID' => (string)$value->{'device-uuid'},
                                'blocked' => (string)$value->{'is-blocked'},
                                'userName' => (string)$value->{'userName'},
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'}
                            );
                            $devices = array_merge(array($device), $devices);
                        }
                    }
                }
                $response = array(
                    'result' => 'success',
                    'devices' => $devices
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function getAllUnBlockedDevices(){
        if(empty($_GET)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
            exit;
        }
        $headers = array(
            'Content-Type' => 'application/json',
            'token' => $this->session->get('token'),
            'skipValue' => $_GET['skipValue']
        );

        if(!empty($_GET['q']) && $_GET['q'] != 'all'){
            $headers['deviceNames'] = $_GET['q'];
            $result = $this->_model->searchInDevices($headers);
        }else{
            $result = $this->_model->getAllDevices($headers);
        }
        switch ($result['status']) {
            case (200):
                $devices = [];
                if(!empty($result['body'])){
                    foreach($result['body']->{'device-info'} as $value){
                        if((string)$value->{'is-blocked'} == 'false'){
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'decoupled' => (string)$value->{'decoupled'},
                                'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'device-created-timestamp'}) / 1000)),
                                'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'modified-timestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'modified-timestamp'},
                                'deviceName' => (string)$value->{'device-name'},
                                'osType' => (string)$value->{'device-os-type'},
                                'icon' => (strpos((string)$value->{'device-os-type'},'Win') !== false ? 'windows' : 'apple'),
                                'version' => (string)$value->{'device-os-version'},
                                'tempPath' => (string)$value->{'device-temp-path'},
                                'deviceUUID' => (string)$value->{'device-uuid'},
                                'blocked' => (string)$value->{'is-blocked'},
                                'userName' => (string)$value->{'userName'},
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'}
                            );
                            $devices = array_merge(array($device), $devices);
                        }
                    }
                }
                $response = array(
                    'result' => 'success',
                    'devices' => $devices
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function getOsType($deviceType){
        if((strpos($deviceType, 'Wind') === false )){
            if((strpos($deviceType, 'Lin') === false )){
                return 'MAC';
            }else{
                return 'Linux';
            }
        }else{
            return 'Windows';
        }
    }

    public function getOsIcon($deviceType){
    	if((strpos($deviceType, 'ONE') === false )){
            if((strpos($deviceType, 'Wind') === false )){
                if((strpos($deviceType, 'Lin') === false )){
                    if(strpos($deviceType, 'Android') === false){
                        $type =  'apple';
                    }else{
                        $type =  'android';
                    }
                }else{
                    $type =  'linux';
                }
            }else{
                $type =  'windows';
            }
        }else{
            $type =  'cloud';
        }
    return $type;
    }        

    public function eventHub(){
            $headers = array(
                'token' => $this->session->get('token'),
                'clientType'     => 'PORTAL'
            );
            $result = $this->_model->getEventHub($headers, $_POST['deviceId']);
            $result1 = $this->_model->getCurrentBackupDetails($headers,$_POST['deviceId']);
	    $result2 = $this->_model->getCurrentRestoreDetails($headers,$_POST['deviceId']);
            switch ($result['status']) {
                case (200):
                    $response = array(
			'actionToDeviceUUID' => $result['body']->{'eventHubElement'}->{'actionToDeviceUUID'},
                        'actionToUserName' => $result['body']->{'eventHubElement'}->{'actionToUserName'},
                        'eventHub' => $result['body']->{'eventHubElement'}->{'actions'},
                        'currentBackup' => $result1['body']->{'boolean'},
                        'status' => !empty($result1['body']->{'status'}) ? $result1['body']->{'status'} : '',
                        'action' => !empty($result1['body']->{'action'}) ? $result1['body']->{'action'} : null,
                        'currentRestore' => $result2['body']->{'boolean'},
			//'statusRestore' => !empty$result2['body']->{'status'},
			//'actionRestore' => $result2['body']->{'action'},
                        'isFullBkpRunning' => !empty($result1['header']->{'container'}['isFullBkpRunning']) ? $result1['header']->{'container'}['isFullBkpRunning'] : 'false',
			//'isRestoreRunning' => $result2['header']->{'container'}['isRestoreRunning'],
                        'isAllowBackup' => !empty($result1['header']->{'container'}['isAllowBackup']) ? $result1['header']->{'container'}['isAllowBackup'] : 'false',
                        'isPrevBkpPaused' => !empty($result1['header']->{'container'}['isPrevBkpPaused']) ? $result1['header']->{'container'}['isPrevBkpPaused'] : 'false',
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }
    
    public function saveEventHub(){
            $headers = array(
                'Content-Type' => 'application/json',
                'token'         => $this->session->get('token'),
 		'isStopBackup' => 'false',
                'isPauseBackup' => 'false'
	    );
	    $eventHubElements = [];
                    if((isset($_POST['agentLogs']) && $_POST['agentLogs'] == 'Yes') && (isset($_POST['historicalLogs']) && $_POST['historicalLogs'] == 'enabled')){
                        array_push($eventHubElements,'PULL_HISTORICAL_LOGS');
                    }elseif((isset($_POST['agentLogs']) && $_POST['agentLogs'] == 'Yes') && !isset($_POST['historicalLogs']) ){
                        array_push($eventHubElements,'PULL_AGENTLOGS');
                    }else{
                        unset($eventHubElements[array_search('PULL_AGENTLOGS',$eventHubElements)]);
                        unset($eventHubElements[array_search('PULL_HISTORICAL_LOGS',$eventHubElements)]);
                    }
                    if(isset($_POST['cancelBackup']) && $_POST['cancelBackup'] == 'Yes' ){
                         $_POST['startBackup']='No';
                         $_POST['stopBackup']='No';
                    }
                    if(isset($_POST['fullBackup']) && $_POST['fullBackup'] == 'Yes'){
                        array_push($eventHubElements,'FULL_BACKUP');
                    }
                    if(!isset($_POST['fullBackup'])){
                        if(isset($_POST['startBackup']) && $_POST['startBackup'] == 'Yes' ){
                            array_push($eventHubElements,'START_BACKUP');
                        }
                    }
                    if(isset($_POST['stopBackup']) && $_POST['stopBackup'] == 'true'){
                        $headers["isStopBackup"]="true";
                    }
                    if(isset($_POST['pauseBackup']) && $_POST['pauseBackup'] == 'true'){
                        $headers["isPauseBackup"]="true";
                    }
                    if(isset($_POST['stopBackupWhileRestore']) && $_POST['stopBackupWhileRestore']=='on'){
                        array_push($eventHubElements,'STOP_BACKUP_WHILE_RESTORE');
                    }
                    if((isset($_POST['agentLogs']) && $_POST['agentLogs'] == 'Yes') && (isset($_POST['setupLogs']) && $_POST['setupLogs'] == 'enabled')){
                        array_push($eventHubElements,'SETUP_LOGS');
		    }
		    if((isset($_POST['agentLogs']) && $_POST['agentLogs'] == 'Yes') && (isset($_POST['databases']) && $_POST['databases'] == 'enabled')){
                        array_push($eventHubElements,'DATABASES');
                    }
/*restore start*/
                    if(isset($_POST['startRestore']) && $_POST['startRestore'] == 'Yes' ){
                            $headers["isRestoreStarted"]="true";
                        }
                    if(isset($_POST['cancelRestore']) && $_POST['cancelRestore'] == 'Yes' ){
                         $_POST['startRestore']='No';
                         $_POST['stopRestore']='No';
                    }


                    if(isset($_POST['stopRestore']) && $_POST['stopRestore'] == 'true'){
                        $headers["isStopRestore"]="true";
                    }

                    if(in_array("START_BACKUP", $eventHubElements)){
                        $this->log("start backup present in array","info");
                    }else{
                            $this->log("start backup not present in array","info");
                            if((isset($_POST['startBackupGet']) && $_POST['startBackupGet'] == 'yes') && (isset($_POST['cancelBackup']) && $_POST['cancelBackup'] != 'Yes')){
                                array_push($eventHubElements,'START_BACKUP');
                                $this->log("start backup not present in array but we got start backup in get events so adding back","info");
                            }
		    }
		    if(isset($_POST['startRestoreGet']) && $_POST['startRestoreGet'] == 'yes'){
                            array_push($eventHubElements,'START_RESTORE');
                    }

/*                    if(isset($_POST['pauseRestore']) && $_POST['pauseRestore'] == 'true'){
                        $headers["isPauseRestore"]="true";
                    }*/
                    /*restore end*/
                    if(isset($_POST['backupPolicyRefresh']) && $_POST['backupPolicyRefresh'] == 'Yes'){
                        array_push($eventHubElements,'BACKUPPOLICY_REFRESH');
                    }
                $data = array(
                    "actionToDeviceUUID" => $_POST['actionToDeviceUUID'],
                    "actions"         => $eventHubElements,
                );
                $result = $this->_model->saveEventHub($headers, $data);
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => "Settings Saved"
                        );
                        echo json_encode($response);
                        exit;
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (409):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('policyExists')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }

    }
    
    public function exportDevicesToExcel(){
         $headers = array(
             'Content-Type' => 'application/json',
             'token'     => $this->session->get('token'),
	     'policyType' => $_POST['policyType']
         );
         $data= array(
             'deviceName' => $_POST['deviceName']
         );
         $result = $this->_model->exportDevicesToExcel($headers,$data);
         switch ($result['status']) {
                 case (200):
                     $response = array(
                         'result' => 'success'
                     );
                     echo json_encode($response);
                     exit;
                 case (403):
                     $response = array(
                         'result' => 'fail',
                         'msg' => 'No records found, Unable to create excel.'
                     );
                     echo json_encode($response);
                     exit;
                 case (421):
                     $result = array(
                         'result' => 'fail',
                         'msg' => $this->language->get('421')
                     );
                     echo json_encode($result);
                     exit();
                 case (500):
                     $result = array(
                         'result' => 'fail',
                         'msg' => $this->language->get('500')
                     );
                     echo json_encode($result);
                     exit();
                 case (0):
                     $result = array(
                         'result' => 'fail',
                         'msg' => $this->language->get('0')
                     );
                     echo json_encode($result);
                     exit();
                 default:
                     $result = array(
                         'result' => 'fail',
                         'msg' => $this->language->get('default')
                     );
                     echo json_encode($result);
                     exit();
         }
     }
     
     public function downloadDevicesToExcel(){
         $filePath = AGENT_NOT_HEARD_PATH.DEVICE_EXCEL_NAME;
         if(file_exists($filePath)){
             header('Content-Type: application/csv');
             header('Content-Disposition: attachment; filename='.DEVICE_EXCEL_NAME);
             header('Pragma: no-cache');
             ob_clean();
             readfile($filePath);
         }else{
             header('Location: '.Url::basePath('devices/'.$_GET['from'].'?result=404'));
         }
      }
      
      public function downloadSample(){
      	$this->log("here . ","info");
    	$filePath = OVERVIEW_REPORT_PATH.BULK_BLOCK_UNBLOCK_DELETE_DEVICES_SAMPLE;
    	$this->log("path -> ".$filePath,"info");
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.BULK_BLOCK_UNBLOCK_DELETE_DEVICES_SAMPLE);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
/*        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=500'));
        }*/

    }
    
    public function getDeviceOwner(){
            $headers = array(
                'Accept'            => 'application/json',
                'token'             => $this->session->get('token'),
		'deviceUUID'	    => $_POST['selectedDeviceUUID']
            );
            $result = $this->_model->getDeviceOwner($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'ownerList' => $result['body']->{'deviceElement'}->{'ownerList'}
                	//'msg' => $this->language->get('changeOwner')
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
                    case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
    
    public function changeDeviceOwner(){
	    if(!isset($_POST['owner']) || $_POST['owner'] == ''){
	    	$_POST['owner'] = '';
	    }else{
	    	$_POST['owner'] = implode(',', $_POST['owner']);
	    }
            $headers = array(
                'Accept'            => 'application/json',
                'token'             => $this->session->get('token'),
                'ownerList'         => $_POST['owner'],
		'deviceUUID' 	    => $_POST['deviceName']
            );
            $result = $this->_model->changeDeviceOwner($headers);
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('changeOwner')
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (445):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('445')
                    );
                    echo json_encode($result);
                    exit();
		case (206):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'User mapping failed due to device limit reached'
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                        );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }
    
    public function downloadDump(){
        $filePath = AGENT_NOT_HEARD_PATH.BULK_BLOCK_UNBLOCK_DELETE_DEVICE_FAIL;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.BULK_BLOCK_UNBLOCK_DELETE_DEVICE_FAIL);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
    }

    public function getDevicesPt(){
        $headers = array(
            'Content-Type' => 'application/json',
	    'Accept' => 'application/json',
            'token' => $this->session->get('token'),
            'policyType' => 'ODB'
        );
        if(!empty($_GET['q']) && $_GET['q'] != 'all'){
            $headers['deviceNames'] = $_GET['q'];
            $result = $this->_model->searchInDevicesPt($headers);
        }else{
            $result = $this->_model->getAllDevicesPt($headers);
        }
        switch ($result['status']) {
            case (200):
                $devices = array();
                if(!empty($_GET['q']) && $_GET['q'] != 'all'){
			if(empty($result['body']->{'data'}->{'devices'})){

			    $response = array(
				'result' => 'success',
				'devices' => $devices
			    );
			    echo json_encode($response);
			    exit;
			}
		}

                if(!empty($_GET['q']) && $_GET['q'] != 'all'){
			foreach($result['body']->{'data'}->{'devices'} as $value){
			    $device = array(
				'profilePic' => Url::profilePic((string)$value->{'userName'}),
				'decoupled' => (string)$value->{'decoupled'},
				'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
				'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
				'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
				'deviceName' => (string)$value->{'deviceName'},
				'osType' => (string)$value->{'osType'},
				'icon' => (strpos((string)$value->{'osType'},'Win') !== false ? 'windows' : 'apple'),
				'version' => (string)$value->{'osVersion'},
				'tempPath' => (string)$value->{'deviceTempPath'},
				'deviceUUID' => (string)$value->{'deviceUUID'},
				'blocked' => (string)$value->{'blocked'},
				'userName' => (string)$value->{'userName'},
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'}
			    );
				$devices = array_merge(array($device), $devices);
				if($device['deviceName'] == $this->session->get('currentDeviceName')){
				    $isCurrentDeviceBlocked = true;
				}
			}
		}else{
			foreach($result['body']->{'deviceElementResponse'}->{'devices'} as $value){
				$device = array(
					'profilePic' => Url::profilePic((string)$value->{'userName'}),
					'decoupled' => (string)$value->{'decoupled'},
					'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
					'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
					'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
					'deviceName' => (string)$value->{'deviceName'},
					'osType' => (string)$value->{'osType'},
					'icon' => (strpos((string)$value->{'osType'},'Win') !== false ? 'windows' : 'apple'),
					'version' => (string)$value->{'osVersion'},
					'tempPath' => (string)$value->{'deviceTempPath'},
					'deviceUUID' => (string)$value->{'deviceUUID'},
					'blocked' => (string)$value->{'blocked'},
					'userName' => (string)$value->{'userName'},
				);
					$devices = array_merge(array($device), $devices);
					if($device['deviceName'] == $this->session->get('currentDeviceName')){
						$isCurrentDeviceBlocked = true;
					}
			}
		}

                $response = array(
                    'result' => 'success',
                    'devices' => $devices
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function getDevicesExchangePt(){
        $headers = array(
            'Content-Type' => 'application/json',
	    'Accept' => 'application/json',
            'token' => $this->session->get('token'),
            'policyType' => 'Exchange'
        );
        if(!empty($_GET['q']) && $_GET['q'] != 'all'){
            $headers['deviceNames'] = $_GET['q'];
            $result = $this->_model->searchInDevicesPt($headers);
        }else{
            $result = $this->_model->getAllDevicesPt($headers);
        }
        switch ($result['status']) {
            case (200):
                $devices = array();
		if(!empty($_GET['q']) && $_GET['q'] != 'all'){
			if(empty($result['body']->{'data'}->{'devices'})){

			    $response = array(
				'result' => 'success',
				'devices' => $devices
			    );
			    echo json_encode($response);
			    exit;
			}
		}

                if(!empty($_GET['q']) && $_GET['q'] != 'all'){
			foreach($result['body']->{'data'}->{'devices'} as $value){
			    $device = array(
				'profilePic' => Url::profilePic((string)$value->{'userName'}),
				'decoupled' => (string)$value->{'decoupled'},
				'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
				'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
				'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
				'deviceName' => (string)$value->{'deviceName'},
				'osType' => (string)$value->{'osType'},
				'icon' => (strpos((string)$value->{'osType'},'Win') !== false ? 'windows' : 'apple'),
				'version' => (string)$value->{'osVersion'},
				'tempPath' => (string)$value->{'deviceTempPath'},
				'deviceUUID' => (string)$value->{'deviceUUID'},
				'blocked' => (string)$value->{'blocked'},
				'userName' => (string)$value->{'userName'},
				'unusualActivity' => $value->{'unusualActivity'},
                                'quarantineDevice' => $value->{'quarantineDevice'}
			    );
				$devices = array_merge(array($device), $devices);
				if($device['deviceName'] == $this->session->get('currentDeviceName')){
				    $isCurrentDeviceBlocked = true;
				}
			}
		}else{
			foreach($result['body']->{'deviceElementResponse'}->{'devices'} as $value){
				$device = array(
					'profilePic' => Url::profilePic((string)$value->{'userName'}),
					'decoupled' => (string)$value->{'decoupled'},
					'createdTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
					'modifiedTimeStamp' => date('d-m-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
					'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
					'deviceName' => (string)$value->{'deviceName'},
					'osType' => (string)$value->{'osType'},
					'icon' => (strpos((string)$value->{'osType'},'Win') !== false ? 'windows' : 'apple'),
					'version' => (string)$value->{'osVersion'},
					'tempPath' => (string)$value->{'deviceTempPath'},
					'deviceUUID' => (string)$value->{'deviceUUID'},
					'blocked' => (string)$value->{'blocked'},
					'userName' => (string)$value->{'userName'},
				);
					$devices = array_merge(array($device), $devices);
					if($device['deviceName'] == $this->session->get('currentDeviceName')){
						$isCurrentDeviceBlocked = true;
					}
			}
		}

                $response = array(
                    'result' => 'success',
                    'devices' => $devices
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function sitesConfiguration(){
        $this->log("Called startDataMigration ","info");
        $this->log("autoMigrationEnabled : ".$_POST['autoMigrationEnabled'],"info");
        $this->log("sitenames : ".json_encode($_POST['sitenames']),"info");
        $this->log("policyName : ".$_POST['policyName'],"info");
        $this->log("policyNames : ".json_encode($_POST['policyNames']),"info");
	if(!empty($_POST['sitenames'])){
		$array = $_POST['sitenames'];
		$array1 = $_POST['policyNames'];
		$array1 = array_combine($array, $array1);
	}else{
		$array1 = [];
	}
        $this->log("FINALLLLLL--->ARRAY1 : ".json_encode($array1),"info");
        /*$overviewList = [];
                for($i=0; $i<count($_POST['sitenames']);$i++){
                        $overview = array(
                        $_POST['sitenames'][$i] => $_POST['policyNames'][$i],
                );
                        $overviewList = array_merge(array($overview), $overviewList);

                }
        $this->log("FINALLLLLL---> : ".json_encode($overviewList),"info");*/
        $_POST['sitenames'] = implode(',', $_POST['sitenames']);
        $headers = array(
            'Content-Type'  => 'application/json',
            'Accept'  => 'application/json',
            'token'         => $this->session->get('token')
        );
        $data = array(
                "policyName"=> $_POST['policyName'],
                "autoMigrationEnabled"=> $_POST['autoMigrationEnabled'],
                "siteMap"=> $array1,
                "discoveredSites"=>[]
		/*'siteName'      => $_POST['sitenames'],
                'policyName'    => $_POST['policyName']*/
        );
	$this->log("jjjjjjjjjjjjjjjj_HEADERS : ".json_encode($headers),"info");
	$this->log("jjjjjjjjjjjjjjjj_BODY : ".json_encode($data),"info");
        $result = $this->_model->sitesConfiguration($headers, $data);
                    switch ($result['status']) {
                        case (200):
                            $response = array(
                                'result' => 'success',
                                'response' => $result,
                                'msg'    => 'Sites configured successfully.'
                            );
                            echo json_encode($response);
                            exit;
                        case (421):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('421')
                            );
                            echo json_encode($result);
                            exit();
                        case (500):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('500')
                            );
                            echo json_encode($result);
                            exit();
                        case (0):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('0')
                            );
                            echo json_encode($result);
                            exit();
                        default:
                            $result = array(
                                'result' => 'fail',
                                'response' => $result,
                                'msg' => $this->language->get('default')
                            );
                            echo json_encode($result);
                            exit();
                    }

    }

    public function sitesConfigurationMapping(){
        $this->log("Called startDataMigration ","info");
	//$_POST['sitenames'] = implode(',', $_POST['sitenames']);
        $headers = array(
            'Content-Type'  => 'application/json',
            'Accept'  => 'application/json',
            'token'         => $this->session->get('token')
        );
        $this->log("sitenames : ".json_encode($_POST['sitenames']),"info");
        $this->log("sitenames count : ".count($_POST['sitenames']),"info");
        $this->log("policyNames : ".$_POST['policyName'],"info");
        $site = [];
        for($i=0;$i<count($_POST['sitenames']);$i++){
                array_push($site, $_POST['policyName']);
        }
        $this->log("sitenames : ".json_encode($site),"info");
        if(!empty($_POST['sitenames'])){
                $array = $_POST['sitenames'];
                $array1 = $site;
                $array1 = array_combine($array, $array1);
        }else{
                $array1 = [];
        }
        $this->log("sitemap : ".json_encode($array1),"info");
        $data = array(
                "siteMap"=> $array1,
		/*'siteName'      => $_POST['sitenames'],
		'policyName'    => $_POST['policyName']*/
        );
        $this->log("jjjjjjjjjjjjjjjj_HEADERS : ".json_encode($headers),"info");
        $this->log("jjjjjjjjjjjjjjjj_BODY : ".json_encode($data),"info");
        $result = $this->_model->sitesConfigurationMapping($headers, $data);
                    switch ($result['status']) {
                        case (200):
                            $response = array(
                                'result' => 'success',
                                'response' => $result,
                                'msg'    => 'Sites mapped successfully.'
                            );
                            echo json_encode($response);
                            exit;
                        case (421):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('421')
                            );
                            echo json_encode($result);
                            exit();
                        case (500):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('500')
                            );
                            echo json_encode($result);
                            exit();
                        case (0):
                            $result = array(
                                'result' => 'fail',
                                'msg' => $this->language->get('0')
                            );
                            echo json_encode($result);
                            exit();
                        default:
                            $result = array(
                                'result' => 'fail',
                                'response' => $result,
                                'msg' => $this->language->get('default')
                            );
                            echo json_encode($result);
                            exit();
                    }
    }
	
    public function getAllDevicesSearch(){
        if(is_array($_POST['deviceName'])){
            $_POST['deviceName'] = implode(',', $_POST['deviceName']);
        }
        $this->verifyAndCleanItUp();
        if(!empty($_POST)){

            $headers = array(
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'token' => $this->session->get('token'),
                'policyType'	=> ''
            );
            if($_POST['deviceName'] != 'all'){
		//$_POST['deviceName'] = implode(',', $_POST['deviceName']);
                $headers['deviceNames'] = $_POST['deviceName'];
                $result = $this->_model->searchInDevices($headers);
            }else{
                $result = $this->_model->getAllDevices($headers,$_POST['pageNumber']);
            }
            $this->log('Result: '.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $devices = [];
                    if(!empty($result['body']->{'data'}->{'devices'})){
                        foreach($result['body']->{'data'}->{'devices'} as $value){

                            $version = (string)$value->{'osType'};
                        	/*if( (preg_match('/Win/', (string)$value->{'osType'} )) && (preg_match('/bit/', (string)$value->{'device-os-version'} ))) {
					$char = "(";
					$str = explode($char,(string)$value->{'osVersion'});
					$version =$version."(".$str[1];
			    } */             		    
                            if($value->{'blocked'} == false && $value->{'decoupled'} == false){
                                $status = 'Active';
                            }else if($value->{'blocked'} == true){
                                $status = 'Blocked';
                            }else if($value->{'blocked'} == false && $value->{'decoupled'} == true){
                                $status = 'Decoupled';
			    }			    
			    if(!empty($value->{'ownerList'})){
				$this->log("length : ".count($value->{'ownerList'}),"info");			    
				if(count($value->{'ownerList'}) >= 1){
					$deviceAssigned = 'Yes';
				}
			    }else{
					$deviceAssigned = 'No';
			    }
                            $device = array(
                                'profilePic' => Url::profilePic((string)$value->{'userName'}),
                                'status' => $status,
                                'decoupled' => $value->{'decoupled'},
                                'deviceId' => (string)$value->{'deviceId'},
                                'createdTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'deviceCreatedDate'}) / 1000)),
                                'modifiedTimeStamp' => date('d-M-Y H:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'modifiedTimeStampUnix' => (int)$value->{'lastModifiedTimestamp'},
                                'deviceName' => (string)$value->{'deviceName'},
                                //'icon' => $this->getOsIcon($value->{'osType'}),
                                'icon' => ((string)$value->{'osType'} == 'OUTLOOK') ? 'envelope' : $this->getOsIcon($value->{'osType'}),
                                'version' => (string)$value->{'osVersion'},
                                'tempPath' => (string)$value->{'deviceTempPath'},
                                'deviceUUID' => (string)$value->{'deviceUUID'},
                                'deviceType' => (string)$value->{'deviceType'},
                                'blocked' => $value->{'blocked'},
                                'isRemoteWipeEnabled' => (string)$value->{'remoteWipeEnabled'},
                                'userName' => (string)$value->{'userName'},
				'userNameForSearch' => base64_encode((string)$value->{'userName'}),
                                'osType' =>  $version,
				'ownerList' => !empty($value->{'ownerList'}) ? implode(',',(array)$value->{'ownerList'}) : '',
				'deviceAssigned' => $deviceAssigned

                            );
                            $devices = array_merge(array($device), $devices);
                        }
		    }
		    $this->log("DATAAA : ".json_encode($devices),"info");
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'devices' => $devices,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
}

