<?php

namespace Controllers;


use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\Amazon;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class AmazonController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loggedOutCheck();
        $this->language->load('amazon');
        $this->_model = new Amazon();
    }

    public function create(){
        $cloudName = $this->_model->isFirstCustomer();
        if($cloudName == 'true'){
            $data['title'] = $this->language->get('indexPageName');
            $data['indexPage_message'] = $this->language->get('indexPage_message');
            $data['csrf_token'] = $this->setCSRFToken();

            View::renderTemplate('LoginHeader', $data);
            View::render('amazon/create', $data);
        }else{
            $_SESSION['cloudName'] = ($cloudName != 'config') ? $cloudName : '';
            Url::redirect('login');
        }

    }

    public function checkCloudName(){
        if(!empty($_POST['cloudName'])){
            if($this->_model->checkCloud($_POST['cloudName']) && $this->checkAlpha($_POST['cloudName'])){
                echo json_encode('success', 200);
            }else{
                header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error', true, 500);
            }
        }else{
            header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error', true, 500);
        }
    }

    public function saveCloud(){
        if(!empty($_POST)){
            foreach($_POST as $key => $value){
                if($this->checkRequired($value)){
                    $data = array(
                        'result' => 'error',
                        'message' => ucfirst($key).' cannot be empty'
                    );
                    echo json_encode($data);
                    exit;
                }elseif($key == 'cloudName'){
                    if(!$this->checkAlpha($value)){
                        $data = array(
                            'result' => 'error',
                            'message' => ucfirst($key).' cannot have special characters nor numbers'
                        );
                        echo json_encode($data);
                        exit;
                    }
                }elseif($key == 'email'){
                    if($this->checkEmail($value)){
                        $data = array(
                            'result' => 'error',
                            'message' => ucfirst($key).' is not a valid email address'
                        );
                        echo json_encode($data);
                        exit;
                    }
                }
            }
            $_SESSION["cloudName"] = $_POST['cloudName'];
            $_SESSION["email"] = $_POST['email'];
            $data = array(
                'cloudName' => htmlentities($_POST['cloudName'])
            );
            $rawText = $_SERVER['SERVER_NAME'];
            $noSlashes = trim($rawText, '/');
            $noDotsArray = explode('.', $noSlashes);
            $noDots = implode('', $noDotsArray);
            $noCom = trim($noDots, 'com');
            $firstString = $this->generateRandomString(4, $noCom);
            $secondString = $this->generateRandomString(4, $noCom);
            $thirdString = $this->generateRandomString(4, $noCom);
            $fourthString = $this->generateRandomString(4, $noCom);
            $deviceID = $firstString.'-'.$secondString.'-'.$thirdString.'-'.$fourthString;
            $path = '/var/lib/parablusys/bin/devID.txt';
            $myFile = fopen($path, "w");
            fwrite($myFile, $deviceID);
            fclose($myFile);
            if($this->_model->registerCloudName(json_encode($data), htmlentities($_POST['cloudName'])) && $this->_model->updateDNS(htmlentities($_POST['cloudName']), $deviceID)){
                $data = array(
                    'result' => 'success',
                    'message' => 'Cloud has been registered successfully'
                );
                echo json_encode($data);
            }else{
                $data = array(
                    'result' => 'error',
                    'message' => 'Due to some technical issues the cloud was not created, please, try to create a cloud after some time'
                );
                echo json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'error',
                'message' => 'There was no data posted'
            );
            echo json_encode($data);
        }
    }

    public function amazonSaveUser(){
        if(!empty($_POST)){
            foreach($_POST as $key => $value){
                if($this->checkRequired($value)){
                    $data = array(
                        'result' => 'error',
                        'message' => ucfirst($key).' cannot be empty'
                    );
                    echo json_encode($data);
                    exit;
                }elseif($key == 'cloudName' || $key == 'userName'){
                    if(!$this->checkAlpha($value)){
                        $data = array(
                            'result' => 'error',
                            'message' => ucfirst($key).' cannot have special characters nor numbers'
                        );
                        echo json_encode($data);
                        exit;
                    }
                }elseif($key == 'email'){
                    if($this->checkEmail($value)){
                        $data = array(
                            'result' => 'error',
                            'message' => ucfirst($key).' is not a valid email address'
                        );
                        echo json_encode($data);
                        exit;
                    }
                }
            }
            $data = array(
                'userName' => htmlentities($_POST['userName']),
                'passwdHash' => md5($_POST['password']),
                'emailId' => $_POST["email"]
            );
            $cloudName = $this->_model->isFirstCustomer();
            $result = $this->_model->registerUsername(json_encode($data), htmlentities($cloudName), htmlentities($_POST['userName']));
            if($result == 201){
                $data = array(
                    'result' => 'success',
                    'message' => 'User Name has been registered'
                );
                echo json_encode($data);
            }else{
                $data = array(
                    'result' => 'error',
                    'code' => $result,
                    'message' => 'Due to some technical issues the cloud name was not created, please, try to create a cloud name after some time'
                );
                echo json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'error',
                'message' => 'There was no data posted'
            );
            echo json_encode($data);
        }
    }

    public function checkAlpha($string){
        return preg_match('/^[0-9a-zA-Z_-\s]+$/', $string);
    }

    public function checkEmail($email){
        return !filter_var($email, FILTER_VALIDATE_EMAIL);
    }

    public function checkRequired($string){
        return (!empty($string)) ? false : true;
    }

    public function generateRandomString($length, $string) {
        $length = 10;
        $characters = '0123456789abcdefghijklmnopqrstuvwxyz'.$string;
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    /**
     * Below method was used to test dns
    public function test(){
    $dnsData = array(
    'public-ip' => '192.168.7.166',
    'domainName' => 'blucloud.parablu.com',
    'cloud-name' => 'test'
    );
    echo '<pre>';
    print_r($this->amazon->updateDNS(json_encode($dnsData), 'test'));
    }
     */

}
