import torch.nn as nn
import torch.nn.functional as F

"""
This file contains the NNModel - Should not need to change this. 
"""


class NNModel(nn.Module):
    def __init__(self, num_inputs=6, num_outputs=2, num_hidden=256):
        super(NNModel,self).__init__()
        self.fc1 = nn.Linear(num_inputs, num_hidden, bias=True)
        self.fc2 = nn.Linear(num_hidden, num_hidden, bias=True)
        self.fc3 = nn.Linear(num_hidden, num_outputs, bias=True)
        self.dropout_layer = nn.Dropout(p=0.2)
        self.means = None
        self.stds = None
            
    def forward(self, x, testing=False):
        x = F.relu(self.fc1(x))
        x = self.dropout_layer(x)
        x = F.relu(self.fc2(x))
        x = self.dropout_layer(x)
        x = self.fc3(x)
        return x
        
    def set_means(self, buf):
        self.means = buf
        
    def set_stds(self, buf):
        self.stds = buf
        
    def get_means(self):
        return self.means
        
    def get_stds(self):
        return self.stds