import subprocess
from pathlib import Path
import argparse

"""
Argument parser 
"""
parser = argparse.ArgumentParser(description='Converts a folder containing files to their entropy outputs (features). ')
parser.add_argument(dest='folder_string', metavar='f', type=str, help='path of folder to read from - eg. data/ransomware_files')
parser.add_argument(dest='output_string', metavar='out', type=str, help='path to output file - eg. saved_features/ransomware.txt')
parser.add_argument('--capture_name', dest='capture_name', default=False, action='store_true', help='capture file names (default false)')

args = parser.parse_args()

"""
Iterate over each file in the folder specified in arguments - run ent.exe to capture features in the specified output_file
"""

pathlist = Path(args.folder_string).glob('**/*')
with open(args.output_string, 'wb') as file:
    for path in pathlist:
         path_in_str = str(path)
         captured = subprocess.check_output(['ent.exe', '-t', path_in_str])
         file.write(captured)
         if args.capture_name:
            file.write((path_in_str+'\r\n').encode('utf-8'))
         print('Captured output = {}'.format(captured))