/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.util.Map;
import org.mongodb.morphia.query.FieldCriteria;
import org.mongodb.morphia.query.FilterOperator;
import org.mongodb.morphia.query.QueryImpl;

class GeoFieldCriteria
extends FieldCriteria {
    private final Map<String, Object> opts;

    GeoFieldCriteria(QueryImpl<?> query, String field, FilterOperator op, Object value, Map<String, Object> opts) {
        super(query, field, op, value);
        this.opts = opts;
    }

    @Override
    public void addTo(DBObject obj) {
        BasicDBObjectBuilder query;
        switch (this.getOperator()) {
            case NEAR: {
                query = BasicDBObjectBuilder.start(FilterOperator.NEAR.val(), this.getValue());
                break;
            }
            case NEAR_SPHERE: {
                query = BasicDBObjectBuilder.start(FilterOperator.NEAR_SPHERE.val(), this.getValue());
                break;
            }
            case WITHIN_BOX: {
                query = BasicDBObjectBuilder.start().push(FilterOperator.GEO_WITHIN.val()).add(this.getOperator().val(), this.getValue());
                break;
            }
            case WITHIN_CIRCLE: {
                query = BasicDBObjectBuilder.start().push(FilterOperator.GEO_WITHIN.val()).add(this.getOperator().val(), this.getValue());
                break;
            }
            case WITHIN_CIRCLE_SPHERE: {
                query = BasicDBObjectBuilder.start().push(FilterOperator.GEO_WITHIN.val()).add(this.getOperator().val(), this.getValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)this.getOperator()) + " not supported for geo-query");
            }
        }
        if (this.opts != null) {
            for (Map.Entry<String, Object> e : this.opts.entrySet()) {
                query.append(e.getKey(), e.getValue());
            }
        }
        obj.put(this.getField(), query.get());
    }
}

