/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query;

import com.mongodb.CursorType;
import com.mongodb.DBObject;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DBCollectionFindOptions;
import java.util.concurrent.TimeUnit;

public class FindOptions {
    private DBCollectionFindOptions options = new DBCollectionFindOptions();

    public FindOptions() {
    }

    private FindOptions(DBCollectionFindOptions copy) {
        this.options = copy.copy();
    }

    public FindOptions copy() {
        return new FindOptions(this.options.copy());
    }

    public int getLimit() {
        return this.options.getLimit();
    }

    public FindOptions limit(int limit) {
        this.options.limit(limit);
        return this;
    }

    public int getSkip() {
        return this.options.getSkip();
    }

    public FindOptions skip(int skip) {
        this.options.skip(skip);
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        return this.options.getMaxTime(timeUnit);
    }

    public FindOptions maxTime(long maxTime, TimeUnit timeUnit) {
        this.options.maxTime(maxTime, timeUnit);
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        return this.options.getMaxAwaitTime(timeUnit);
    }

    public FindOptions maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.options.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    public int getBatchSize() {
        return this.options.getBatchSize();
    }

    public FindOptions batchSize(int batchSize) {
        this.options.batchSize(batchSize);
        return this;
    }

    DBObject getModifiers() {
        return this.options.getModifiers();
    }

    public FindOptions modifier(String key, Object value) {
        this.options.getModifiers().put(key, value);
        return this;
    }

    DBObject getProjection() {
        return this.options.getProjection();
    }

    FindOptions projection(DBObject projection) {
        this.options.projection(projection);
        return this;
    }

    DBObject getSortDBObject() {
        return this.options.getSort();
    }

    FindOptions sort(DBObject sort) {
        this.options.sort(sort);
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.options.isNoCursorTimeout();
    }

    public FindOptions noCursorTimeout(boolean noCursorTimeout) {
        this.options.noCursorTimeout(noCursorTimeout);
        return this;
    }

    public boolean isOplogReplay() {
        return this.options.isOplogReplay();
    }

    public FindOptions oplogReplay(boolean oplogReplay) {
        this.options.oplogReplay(oplogReplay);
        return this;
    }

    public boolean isPartial() {
        return this.options.isPartial();
    }

    public FindOptions partial(boolean partial) {
        this.options.partial(partial);
        return this;
    }

    public CursorType getCursorType() {
        return this.options.getCursorType();
    }

    public FindOptions cursorType(CursorType cursorType) {
        this.options.cursorType(cursorType);
        return this;
    }

    public ReadPreference getReadPreference() {
        return this.options.getReadPreference();
    }

    public FindOptions readPreference(ReadPreference readPreference) {
        this.options.readPreference(readPreference);
        return this;
    }

    public ReadConcern getReadConcern() {
        return this.options.getReadConcern();
    }

    public FindOptions readConcern(ReadConcern readConcern) {
        this.options.readConcern(readConcern);
        return this;
    }

    public Collation getCollation() {
        return this.options.getCollation();
    }

    public FindOptions collation(Collation collation) {
        this.options.collation(collation);
        return this;
    }

    DBCollectionFindOptions getOptions() {
        return this.options;
    }

    boolean isSnapshot() {
        Object snapshot = this.getModifiers().get("$snapshot");
        return snapshot != null ? (Boolean)snapshot : false;
    }

    boolean hasHint() {
        return this.getModifiers().get("$indexHint") != null;
    }
}

