/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation.classrules;

import java.util.List;
import java.util.Set;
import org.mongodb.morphia.annotations.Version;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.validation.ClassConstraint;
import org.mongodb.morphia.mapping.validation.ConstraintViolation;
import org.mongodb.morphia.mapping.validation.classrules.FieldEnumString;

public class MultipleVersions
implements ClassConstraint {
    @Override
    public void check(Mapper mapper, MappedClass mc, Set<ConstraintViolation> ve) {
        List<MappedField> versionFields = mc.getFieldsAnnotatedWith(Version.class);
        if (versionFields.size() > 1) {
            ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, this.getClass(), "Multiple @" + Version.class + " annotations are not allowed. (" + new FieldEnumString(versionFields)));
        }
    }
}

