/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation.classrules;

import java.util.List;
import java.util.Set;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.validation.ClassConstraint;
import org.mongodb.morphia.mapping.validation.ConstraintViolation;
import org.mongodb.morphia.mapping.validation.classrules.FieldEnumString;

public class MultipleId
implements ClassConstraint {
    @Override
    public void check(Mapper mapper, MappedClass mc, Set<ConstraintViolation> ve) {
        List<MappedField> idFields = mc.getFieldsAnnotatedWith(Id.class);
        if (idFields.size() > 1) {
            ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, this.getClass(), String.format("More than one @%s Field found (%s).", Id.class.getSimpleName(), new FieldEnumString(idFields))));
        }
    }
}

