/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.cache;

import java.util.HashMap;
import java.util.Map;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.mapping.cache.EntityCache;
import org.mongodb.morphia.mapping.cache.EntityCacheStatistics;
import org.mongodb.morphia.mapping.lazy.LazyFeatureDependencies;
import org.mongodb.morphia.mapping.lazy.proxy.ProxyHelper;
import relocated.morphia.org.apache.commons.collections.ReferenceMap;

public class DefaultEntityCache
implements EntityCache {
    private final Map entityMap = new ReferenceMap(0, 2);
    private final Map proxyMap = new ReferenceMap(2, 2);
    private final Map<Key, Boolean> existenceMap = new HashMap<Key, Boolean>();
    private final EntityCacheStatistics stats = new EntityCacheStatistics();

    @Override
    public Boolean exists(Key<?> k) {
        if (this.entityMap.containsKey(k)) {
            this.stats.incHits();
            return true;
        }
        Boolean b = this.existenceMap.get(k);
        if (b == null) {
            this.stats.incMisses();
        } else {
            this.stats.incHits();
        }
        return b;
    }

    @Override
    public void flush() {
        this.entityMap.clear();
        this.existenceMap.clear();
        this.proxyMap.clear();
        this.stats.reset();
    }

    @Override
    public <T> T getEntity(Key<T> k) {
        Object o = this.entityMap.get(k);
        if (o == null) {
            Object proxy;
            if (LazyFeatureDependencies.testDependencyFullFilled() && (proxy = this.proxyMap.get(k)) != null) {
                ProxyHelper.isFetched(proxy);
                this.stats.incHits();
                return (T)ProxyHelper.unwrap(proxy);
            }
            this.stats.incMisses();
        } else {
            this.stats.incHits();
        }
        return (T)o;
    }

    @Override
    public <T> T getProxy(Key<T> k) {
        Object o = this.proxyMap.get(k);
        if (o == null) {
            this.stats.incMisses();
        } else {
            this.stats.incHits();
        }
        return (T)o;
    }

    @Override
    public void notifyExists(Key<?> k, boolean exists) {
        Boolean put = this.existenceMap.put(k, exists);
        if (put == null || !put.booleanValue()) {
            this.stats.incEntities();
        }
    }

    @Override
    public <T> void putEntity(Key<T> k, T t) {
        this.notifyExists(k, true);
        this.entityMap.put(k, t);
    }

    @Override
    public <T> void putProxy(Key<T> k, T t) {
        this.proxyMap.put(k, t);
        this.stats.incEntities();
    }

    @Override
    public EntityCacheStatistics stats() {
        return this.stats.copy();
    }
}

