/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.mapping.CustomMapper;
import org.mongodb.morphia.mapping.EphemeralMappedField;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.cache.EntityCache;
import org.mongodb.morphia.utils.IterHelper;
import org.mongodb.morphia.utils.ReflectionUtils;

class EmbeddedMapper
implements CustomMapper {
    EmbeddedMapper() {
    }

    static boolean shouldSaveClassName(Object rawVal, Object convertedVal, MappedField mf) {
        if (rawVal == null || mf == null) {
            return true;
        }
        if (mf.isSingleValue()) {
            return !mf.getType().equals(rawVal.getClass()) || convertedVal instanceof BasicDBList;
        }
        boolean isDBObject = convertedVal instanceof DBObject;
        boolean anInterface = mf.getSubClass().isInterface();
        boolean anAbstract = Modifier.isAbstract(mf.getSubClass().getModifiers());
        boolean equals = mf.getSubClass().equals(rawVal.getClass());
        return convertedVal == null || !isDBObject || anInterface || anAbstract || !equals;
    }

    private static boolean isMapOrCollection(MappedField mf) {
        return Map.class.isAssignableFrom(mf.getSubClass()) || Iterable.class.isAssignableFrom(mf.getSubClass());
    }

    @Override
    public void fromDBObject(Datastore datastore, DBObject dbObject, MappedField mf, Object entity, EntityCache cache, Mapper mapper) {
        try {
            if (mf.isMap()) {
                this.readMap(datastore, mapper, entity, cache, mf, dbObject);
            } else if (mf.isMultipleValues()) {
                this.readCollection(datastore, mapper, entity, cache, mf, dbObject);
            } else {
                Object dbVal = mf.getDbObjectValue(dbObject);
                if (dbVal != null) {
                    boolean isDBObject = dbVal instanceof DBObject;
                    if (isDBObject && !mapper.isMapped(mf.getConcreteType()) && (mapper.getConverters().hasDbObjectConverter(mf) || mapper.getConverters().hasDbObjectConverter(mf.getType()))) {
                        mapper.getConverters().fromDBObject(dbObject, mf, entity);
                    } else {
                        Object refObj;
                        if (mapper.getConverters().hasSimpleValueConverter(mf) || mapper.getConverters().hasSimpleValueConverter(mf.getType())) {
                            refObj = mapper.getConverters().decode(mf.getType(), dbVal, mf);
                        } else {
                            DBObject value = (DBObject)dbVal;
                            refObj = mapper.getOptions().getObjectFactory().createInstance(mapper, mf, value);
                            refObj = mapper.fromDb(datastore, value, refObj, cache);
                        }
                        if (refObj != null) {
                            mf.setFieldValue(entity, refObj);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void toDBObject(Object entity, MappedField mf, DBObject dbObject, Map<Object, DBObject> involvedObjects, Mapper mapper) {
        String name = mf.getNameToStore();
        Object fieldValue = mf.getFieldValue(entity);
        if (mf.isMap()) {
            this.writeMap(mf, dbObject, involvedObjects, name, fieldValue, mapper);
        } else if (mf.isMultipleValues()) {
            this.writeCollection(mf, dbObject, involvedObjects, name, fieldValue, mapper);
        } else {
            DBObject dbObj;
            if (mapper.getConverters().hasDbObjectConverter(mf) || mapper.getConverters().hasDbObjectConverter(entity.getClass())) {
                mapper.getConverters().toDBObject(entity, mf, dbObject, mapper.getOptions());
                return;
            }
            DBObject dBObject = dbObj = fieldValue == null ? null : mapper.toDBObject(fieldValue, involvedObjects);
            if (dbObj != null) {
                if (!EmbeddedMapper.shouldSaveClassName(fieldValue, dbObj, mf)) {
                    dbObj.removeField("className");
                }
                if (!dbObj.keySet().isEmpty() || mapper.getOptions().isStoreEmpties()) {
                    dbObject.put(name, dbObj);
                }
            }
        }
    }

    private void readCollection(Datastore datastore, Mapper mapper, Object entity, EntityCache cache, MappedField mf, DBObject dbObject) {
        Object dbVal = mf.getDbObjectValue(dbObject);
        if (dbVal != null) {
            List dbValues;
            Collection<Object> values;
            Collection collection = values = mf.isSet() ? mapper.getOptions().getObjectFactory().createSet(mf) : mapper.getOptions().getObjectFactory().createList(mf);
            if (dbVal instanceof List) {
                dbValues = (List)dbVal;
            } else {
                dbValues = new BasicDBList();
                dbValues.add(dbVal);
            }
            EphemeralMappedField ephemeralMappedField = !mapper.isMapped(mf.getType()) && EmbeddedMapper.isMapOrCollection(mf) && mf.getSubType() instanceof ParameterizedType ? new EphemeralMappedField((ParameterizedType)mf.getSubType(), mf, mapper) : null;
            for (Object o : dbValues) {
                Object newEntity = null;
                if (o != null) {
                    newEntity = mapper.getConverters().hasSimpleValueConverter(mf) || mapper.getConverters().hasSimpleValueConverter(mf.getSubClass()) ? mapper.getConverters().decode(mf.getSubClass(), o, mf) : this.readMapOrCollectionOrEntity(datastore, mapper, cache, mf, ephemeralMappedField, (DBObject)o);
                }
                values.add(newEntity);
            }
            if (!values.isEmpty() || mapper.getOptions().isStoreEmpties()) {
                if (mf.getType().isArray()) {
                    mf.setFieldValue(entity, ReflectionUtils.convertToArray(mf.getSubClass(), ReflectionUtils.iterToList(values)));
                } else {
                    mf.setFieldValue(entity, values);
                }
            }
        }
    }

    private void readMap(final Datastore datastore, final Mapper mapper, Object entity, final EntityCache cache, final MappedField mf, DBObject dbObject) {
        DBObject dbObj = (DBObject)mf.getDbObjectValue(dbObject);
        if (dbObj != null) {
            final Map map = mapper.getOptions().getObjectFactory().createMap(mf);
            final EphemeralMappedField ephemeralMappedField = EmbeddedMapper.isMapOrCollection(mf) ? new EphemeralMappedField((ParameterizedType)mf.getSubType(), mf, mapper) : null;
            new IterHelper<Object, Object>().loopMap(dbObj, new IterHelper.MapIterCallback<Object, Object>(){

                @Override
                public void eval(Object k, Object val) {
                    Object newEntity = null;
                    if (val != null) {
                        newEntity = mapper.getConverters().hasSimpleValueConverter(mf) || mapper.getConverters().hasSimpleValueConverter(mf.getSubClass()) ? mapper.getConverters().decode(mf.getSubClass(), val, mf) : (val instanceof DBObject ? EmbeddedMapper.this.readMapOrCollectionOrEntity(datastore, mapper, cache, mf, ephemeralMappedField, (DBObject)val) : val);
                    }
                    Object objKey = mapper.getConverters().decode(mf.getMapKeyClass(), k, mf);
                    map.put(objKey, newEntity);
                }
            });
            if (!map.isEmpty() || mapper.getOptions().isStoreEmpties()) {
                mf.setFieldValue(entity, map);
            }
        }
    }

    private Object readMapOrCollectionOrEntity(Datastore datastore, Mapper mapper, EntityCache cache, MappedField mf, EphemeralMappedField ephemeralMappedField, DBObject dbObj) {
        if (ephemeralMappedField != null) {
            mapper.fromDb(datastore, dbObj, ephemeralMappedField, cache);
            return ephemeralMappedField.getValue();
        }
        Object newEntity = mapper.getOptions().getObjectFactory().createInstance(mapper, mf, dbObj);
        return mapper.fromDb(datastore, dbObj, newEntity, cache);
    }

    private void writeCollection(MappedField mf, DBObject dbObject, Map<Object, DBObject> involvedObjects, String name, Object fieldValue, Mapper mapper) {
        List<Object> coll = null;
        if (fieldValue != null) {
            coll = mf.isArray() ? Arrays.asList((Object[])fieldValue) : (List<Object>)fieldValue;
        }
        if (coll != null) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object t : coll) {
                if (null == t) {
                    values.add(null);
                    continue;
                }
                if (mapper.getConverters().hasSimpleValueConverter(mf) || mapper.getConverters().hasSimpleValueConverter(t.getClass())) {
                    values.add(mapper.getConverters().encode(t));
                    continue;
                }
                Object val = Collection.class.isAssignableFrom(t.getClass()) || Map.class.isAssignableFrom(t.getClass()) ? mapper.toMongoObject(t, true) : mapper.toDBObject(t, involvedObjects);
                if (!EmbeddedMapper.shouldSaveClassName(t, val, mf)) {
                    ((DBObject)val).removeField("className");
                }
                values.add(val);
            }
            if (!values.isEmpty() || mapper.getOptions().isStoreEmpties()) {
                dbObject.put(name, values);
            }
        }
    }

    private void writeMap(MappedField mf, DBObject dbObject, Map<Object, DBObject> involvedObjects, String name, Object fieldValue, Mapper mapper) {
        Map map = (Map)fieldValue;
        if (map != null) {
            BasicDBObject values = new BasicDBObject();
            for (Map.Entry entry : map.entrySet()) {
                Object val;
                Object entryVal = entry.getValue();
                if (entryVal == null) {
                    val = null;
                } else if (mapper.getConverters().hasSimpleValueConverter(mf) || mapper.getConverters().hasSimpleValueConverter(entryVal.getClass())) {
                    val = mapper.getConverters().encode(entryVal);
                } else {
                    val = Map.class.isAssignableFrom(entryVal.getClass()) || Collection.class.isAssignableFrom(entryVal.getClass()) ? mapper.toMongoObject(entryVal, true) : mapper.toDBObject(entryVal, involvedObjects);
                    if (!EmbeddedMapper.shouldSaveClassName(entryVal, val, mf)) {
                        if (val instanceof List) {
                            if (((List)val).get(0) instanceof DBObject) {
                                List list = (List)val;
                                for (DBObject o : list) {
                                    o.removeField("className");
                                }
                            }
                        } else {
                            ((DBObject)val).removeField("className");
                        }
                    }
                }
                String strKey = mapper.getConverters().encode(entry.getKey()).toString();
                values.put(strKey, val);
            }
            if (!values.isEmpty() || mapper.getOptions().isStoreEmpties()) {
                dbObject.put(name, values);
            }
        }
    }
}

