/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.privilege;

import com.thoughtworks.proxy.toys.privilege.ActionExecutor;
import java.security.AccessControlContext;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectExecutor
implements ActionExecutor {
    private final AccessControlContext context;
    private final Subject subject;

    public SubjectExecutor(Subject subject) {
        this(subject, null);
    }

    public SubjectExecutor(Subject subject, AccessControlContext context) {
        this.subject = subject;
        this.context = context;
    }

    @Override
    public Object execute(PrivilegedExceptionAction<Object> action) throws PrivilegedActionException {
        if (this.context == null) {
            return Subject.doAs(this.subject, action);
        }
        return Subject.doAsPrivileged(this.subject, action, this.context);
    }
}

