/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class SonyDataRestore {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String mainMongoIP = config.getProperty("mainMongoIP").toString();
        String mainMongoPort = config.getProperty("mainMongoPort").toString();
        int skip = Integer.parseInt(config.getProperty("skip").toString());
        int limit = Integer.parseInt(config.getProperty("limit").toString());
        boolean updateDB = Boolean.parseBoolean(config.getProperty("updateDB").toString());
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mainMongoIP + ":" + mainMongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase mainPB001DB = client.getDatabase(uri.getDatabase());
        MongoClientURI urilocal = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/blukrypt");
        MongoClient clientLocal = new MongoClient(urilocal);
        MongoDatabase localBlukryptDb = clientLocal.getDatabase(urilocal.getDatabase());
        MongoClientURI uriDump = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/blukrypt");
        MongoClient clientDump = new MongoClient(uriDump);
        MongoDatabase dbDump = clientDump.getDatabase(uriDump.getDatabase());
        MongoCollection<Document> dumpPGCollection = dbDump.getCollection("DUMP_BACKUP_PG");
        MongoCollection<Document> deviceCollection = mainPB001DB.getCollection("DEVICE");
        MongoCollection<Document> deviceBkpOverviewCollection = mainPB001DB.getCollection("DEVICE_BACKUP_OVERVIEW");
        MongoCollection<Document> localDB = localBlukryptDb.getCollection("PRIVACY_GATEWAY_BACKUP_SONY_LOCAL");
        MongoCollection<Document> backupPGCollection = mainPB001DB.getCollection("BACKUP_PG");
        HashMap<String, String> deviceMap = new HashMap<String, String>();
        int count = 0;
        long overAllUpdatedSize = 0L;
        block10: while (true) {
            FindIterable<Document> pgFiles = skip == 0 ? dumpPGCollection.find().limit(limit) : dumpPGCollection.find().skip(skip * limit).limit(limit);
            System.out.println("Skip value :" + ++skip + " limit value :" + limit + " count :" + count);
            Iterator iterator = pgFiles.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block10;
                Document pgFile = (Document)iterator.next();
                try {
                    System.out.println("started for " + pgFile.getObjectId("_id") + " count :" + ++count);
                    String deviceUUID = pgFile.getString("deviceUUID");
                    if (deviceMap.get(deviceUUID) == null) {
                        Document device1 = (Document)deviceCollection.find(new BasicDBObject("deviceUUID", deviceUUID)).first();
                        if (device1 != null) {
                            deviceMap.put(deviceUUID, device1.getString("destCollection"));
                        } else {
                            System.out.println(".....device is not present in db ... " + deviceUUID);
                            deviceMap.put(deviceUUID, null);
                        }
                    }
                    if (deviceMap.get(deviceUUID) != null) {
                        String destCollection = (String)deviceMap.get(deviceUUID);
                        MongoCollection<Document> bkpCollection = mainPB001DB.getCollection(destCollection);
                        Document bkpFile = (Document)bkpCollection.find(new BasicDBObject("id", pgFile.getObjectId("_id"))).first();
                        String deviceTempPath = "/parablu/sony/upload/" + deviceUUID + "/" + pgFile.getString("batchId") + "/chunk";
                        List chunks = (List)pgFile.get("chunkFiles");
                        boolean chunksExists = false;
                        for (String chunkName : chunks) {
                            chunksExists = false;
                            File chunkFile = SonyDataRestore.getFileFromChunkPath(pgFile, deviceTempPath, chunkName);
                            if (!chunkFile.exists()) {
                                System.out.println("Chunk For " + pgFile.getObjectId("_id") + " file not exists in " + chunkFile.getPath());
                                chunksExists = false;
                                break;
                            }
                            chunksExists = true;
                        }
                        if (bkpFile == null && chunksExists) {
                            System.out.println(String.valueOf(pgFile.getString("userName")) + "......bkpFile is NULL for :" + pgFile.getObjectId("_id") + " and all chunks present in /parablu so insert db entries..");
                            MongoCollection<Document> dumpBkpCollection = dbDump.getCollection("DUMP_" + destCollection);
                            Document dumpBkpFile = (Document)dumpBkpCollection.find(new BasicDBObject("_id", pgFile.getObjectId("_id"))).first();
                            if (dumpBkpFile != null) {
                                if (!updateDB) continue;
                                System.out.println("Inside save in db");
                                try {
                                    Document deviceBkpOverview;
                                    boolean bkpAlreadyInserted = false;
                                    try {
                                        bkpCollection.insertOne(dumpBkpFile);
                                    }
                                    catch (Exception e) {
                                        bkpAlreadyInserted = true;
                                    }
                                    try {
                                        localDB.insertOne(pgFile);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    try {
                                        backupPGCollection.insertOne(pgFile);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    if (bkpAlreadyInserted || (deviceBkpOverview = (Document)deviceCollection.find(new BasicDBObject("deviceUUID", pgFile.getString("deviceUUID"))).first()) == null) continue;
                                    BasicDBObject searchQuery = new BasicDBObject();
                                    searchQuery.append("deviceUUID", pgFile.get("deviceUUID"));
                                    BasicDBObject bkpUpdateFields = new BasicDBObject();
                                    long size = deviceBkpOverview.getLong("storageUtilized");
                                    long filesizeInKB = (long)Math.ceil((double)dumpBkpFile.getLong("size").longValue() / 1024.0);
                                    long updateSize = size + filesizeInKB;
                                    overAllUpdatedSize += filesizeInKB;
                                    bkpUpdateFields.append("storageUtilized", updateSize);
                                    BasicDBObject updatebkpQuery = new BasicDBObject();
                                    updatebkpQuery.append("$set", bkpUpdateFields);
                                    deviceBkpOverviewCollection.updateOne(searchQuery, updatebkpQuery);
                                    System.out.println("completed updating overview in db... " + overAllUpdatedSize + "...count... " + count);
                                }
                                catch (Exception e) {
                                    System.out.println("Exception while saving");
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            System.out.println(String.valueOf(destCollection) + ".....Info not present in DUMP DB" + pgFile.getObjectId("_id"));
                            continue;
                        }
                        if (chunksExists) {
                            System.out.println("bkpFile is NOT NULL for :" + pgFile.getObjectId("_id") + " and all chunks present in /parablu so update db entries..");
                            if (updateDB && bkpFile.get("storagePlace") != null && !bkpFile.get("storagePlace").equals("CLOUD")) {
                                System.out.println("Inside update in db");
                                localDB.insertOne(pgFile);
                                backupPGCollection.insertOne(pgFile);
                                continue;
                            }
                            System.out.println("....file already moved to cloud ......... " + pgFile.getObjectId("_id") + "...." + destCollection);
                            continue;
                        }
                        System.out.println("All chunks are not present");
                        continue;
                    }
                    System.out.println(String.valueOf(deviceUUID) + ".... device is empty for pgFile id :" + pgFile.getObjectId("_id") + "...." + pgFile.getString("userName"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            break;
        }
    }

    private static File getFileFromChunkPath(Document pgFile, String deviceTempPath, String chunkName) {
        File dir;
        Object[] files;
        int occurance = StringUtils.countMatches(chunkName, ".");
        String md5 = SonyDataRestore.getMd5FromFileName(chunkName, occurance);
        String fileNameExcludeId = chunkName;
        if (occurance > 1) {
            fileNameExcludeId = chunkName.substring(0, chunkName.lastIndexOf(46));
        } else if (occurance == 0) {
            chunkName = String.valueOf(chunkName) + "." + pgFile.getObjectId("_id").toString();
        }
        File file = new File(String.valueOf(deviceTempPath) + "/" + fileNameExcludeId);
        if (!file.exists() && ArrayUtils.isNotEmpty(files = (dir = new File(deviceTempPath)).list(new PrefixFileFilter(fileNameExcludeId)))) {
            file = new File(String.valueOf(deviceTempPath) + "/" + (String)files[0]);
        }
        return file;
    }

    private static String getMd5FromFileName(String fileName, int occurance) {
        String md5 = "";
        if (occurance == 1 && !fileName.startsWith("part")) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance == 1 && fileName.startsWith("part")) {
            md5 = fileName.substring(fileName.lastIndexOf(46) + 1);
        } else if (occurance == 0) {
            md5 = fileName;
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        return md5;
    }

    public static String getDateInddMMMyyyy(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return date;
    }
}

