/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import Utility.com.parablu.HttpClientUtil;
import Utility.com.parablu.MD5Generator;
import Utility.com.parablu.Office365;
import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.PciAuthorizationTokenElement;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.bson.Document;
import org.json.JSONObject;

public class PBStorageMatrix {
    private static final String PERSONAL_URL = "/personal/";
    private static final String BEARER = "Bearer ";
    public static final String HEADER_KEY_ACCEPT = "Accept";
    public static final String HEADER_VALUE_APPLICATION_JSON = "application/json;odata=verbose";
    public static final String HEADER_KEY_CONTENT_TYPE = "Content-Type";

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String userNames = config.getProperty("userNames").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        boolean isMultiplexAccount = false;
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoClientURI uriPar = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu");
        MongoClient clientPar = new MongoClient(uriPar);
        MongoDatabase dbPar = clientPar.getDatabase(uriPar.getDatabase());
        MongoCollection<Document> cloudCollection = dbPar.getCollection("CLOUD");
        MongoCollection<Document> cloudCustomiCollection = dbPar.getCollection("CLOUD_CUSTOMIZABLE_DETAILS");
        Document cloud = (Document)cloudCollection.find().first();
        List customaizable = (List)cloud.get("cloudCustomisableDetails");
        boolean isOdbEnabled = false;
        for (DBRef cust : customaizable) {
            Document cu = (Document)cloudCustomiCollection.find(new BasicDBObject("_id", cust.getId())).first();
            if (cu == null || !StringUtils.isNotEmpty(cu.getString("name")) || !cu.getString("name").equals("ODB Enabled")) continue;
            isOdbEnabled = true;
            break;
        }
        if (!isOdbEnabled) {
            System.out.println("ODB Enabled is false.... so return");
            return;
        }
        MongoCollection<Document> tokenCollection = db.getCollection("PCI_AUTHORIZATION_TOKENS");
        Document tokenDoc = (Document)tokenCollection.find().first();
        PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
        pciAuthorizationTokenElement.setAccessToken(tokenDoc.getString("accessToken"));
        pciAuthorizationTokenElement.setAuthenticationToken(tokenDoc.getString("authenticationToken"));
        pciAuthorizationTokenElement.setClientId(tokenDoc.getString("clientId"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        pciAuthorizationTokenElement.setClientSecret(tokenDoc.getString("clientSecret"));
        pciAuthorizationTokenElement.setCloudName(tokenDoc.getString("cloudName"));
        pciAuthorizationTokenElement.setRefreshToken(tokenDoc.getString("refreshToken"));
        pciAuthorizationTokenElement.setSharePointUrl(tokenDoc.getString("sharePointUrl"));
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        MongoCollection<Document> deviceDBCollection = db.getCollection("DEVICE");
        MongoCollection<Document> deviceBkpDBCollection = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        ArrayList<String> userList = new ArrayList<String>();
        userNames = userNames.replace("[", "");
        userNames = userNames.replace("]", "");
        userList.addAll(Arrays.asList(userNames.split(",")));
        for (String userName : userList) {
            userName = userName.trim();
            String userODBID = "";
            Document user = (Document)userDBCollection.find(new Document("userName", userName)).first();
            if (user == null) continue;
            userODBID = !StringUtils.isEmpty(user.getString("odbLoginId")) ? user.getString("odbLoginId") : user.getString("emailId");
            pciAuthorizationTokenElement.setAccountId(userODBID);
            pciAuthorizationTokenElement.setEmailId(userODBID);
            long storageSize = 0L;
            storageSize = PBStorageMatrix.getSizeOfFolder(pciAuthorizationTokenElement, "ts2g5aabxph1");
            if (storageSize != 0L) {
                System.out.println(String.valueOf(userName) + "," + PBStorageMatrix.formatFileSize(storageSize /= 1024L));
                continue;
            }
            System.out.println(String.valueOf(userName) + "," + "No pb folder");
        }
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    public static long getSizeOfFolder(PciAuthorizationTokenElement ppciTokenElement, String cloudStoragePath) {
        String userNameToGetUrl = "";
        PciAuthorizationTokenElement pciTokenElement = ppciTokenElement;
        String paraBluFolderPath = PBStorageMatrix.getParabluLibrarySizeUrl(pciTokenElement.getSharePointUrl(), pciTokenElement.getAccountId(), userNameToGetUrl, cloudStoragePath, "");
        long count = 0L;
        String fileUrl = paraBluFolderPath;
        System.out.println("parabluFodler file url:" + fileUrl);
        HttpGet httpGet = new HttpGet(fileUrl);
        httpGet.addHeader("Authorization", BEARER + pciTokenElement.getAccessToken());
        httpGet.addHeader(HEADER_KEY_ACCEPT, HEADER_VALUE_APPLICATION_JSON);
        HttpResponse result = null;
        try {
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute(httpGet);
            int statusCode = result.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                pciTokenElement = Office365.getAccessToken(pciTokenElement);
                long l = PBStorageMatrix.getSizeOfFolder(pciTokenElement, cloudStoragePath);
                return l;
            }
            if (statusCode != 200) {
                long l = count;
                return l;
            }
            try {
                String json = EntityUtils.toString(result.getEntity());
                JSONObject jsonObject = new JSONObject(json);
                String itemCount = jsonObject.optString("d");
                if (itemCount != null) {
                    jsonObject = new JSONObject(new String(itemCount));
                    String StorageMetrics = jsonObject.optString("StorageMetrics");
                    jsonObject = new JSONObject(new String(StorageMetrics));
                    itemCount = jsonObject.optString("TotalFileStreamSize");
                    count = Long.parseLong(itemCount);
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " " + e);
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " Exception While Getting Count of Files In Folder :" + e.getMessage());
            }
        }
        finally {
            httpGet.releaseConnection();
        }
        return count;
    }

    public static String getParabluLibrarySizeUrl(String office365baseUrl, String accountId, String paramUserName, String suffixFolderPath, String pbFolderName1) {
        String pbFolderName = pbFolderName1;
        pbFolderName = "";
        String userName = paramUserName;
        if (!userName.isEmpty()) {
            userName = "/" + userName;
        }
        if (StringUtils.isEmpty(pbFolderName)) {
            pbFolderName = "PB";
        }
        String personalSite = PBStorageMatrix.getPersonalSite(office365baseUrl, accountId);
        String personalUrl = PERSONAL_URL;
        if (accountId.contains("sites/")) {
            personalUrl = "/";
        }
        return String.valueOf(personalSite) + "/_api/web/getFolderByServerRelativeUrl('" + personalUrl + PBStorageMatrix.getEmailId(accountId) + "/" + pbFolderName + userName + "/" + suffixFolderPath + "/')?$select=StorageMetrics&$expand=StorageMetrics";
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty(deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString(deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    public static String getPersonalSite(String office365baseUrl, String accountId) {
        if (accountId.contains("sites/")) {
            return String.valueOf(office365baseUrl) + "/" + PBStorageMatrix.getEmailId(accountId);
        }
        return String.valueOf(office365baseUrl) + PERSONAL_URL + PBStorageMatrix.getEmailId(accountId);
    }

    private static String getEmailId(String emailId) {
        String replacedEmailId = emailId.replace(".", "_");
        replacedEmailId = replacedEmailId.replace("@", "_");
        return replacedEmailId;
    }
}

