/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.querydsl;

import com.querydsl.core.types.Predicate;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.querydsl.binding.QuerydslBinderCustomizer;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.util.CastUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class QuerydslPredicateArgumentResolver
implements HandlerMethodArgumentResolver {
    private final QuerydslBindingsFactory bindingsFactory;
    private final QuerydslPredicateBuilder predicateBuilder;

    public QuerydslPredicateArgumentResolver(QuerydslBindingsFactory factory, Optional<ConversionService> conversionService) {
        this.bindingsFactory = factory;
        this.predicateBuilder = new QuerydslPredicateBuilder(conversionService.orElseGet(DefaultConversionService::new), factory.getEntityPathResolver());
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (Predicate.class.equals(parameter.getParameterType())) {
            return true;
        }
        if (parameter.hasParameterAnnotation(QuerydslPredicate.class)) {
            throw new IllegalArgumentException(String.format("Parameter at position %s must be of type Predicate but was %s.", parameter.getParameterIndex(), parameter.getParameterType()));
        }
        return false;
    }

    @Nullable
    public Predicate resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        LinkedMultiValueMap<String, String> parameters = new LinkedMultiValueMap<String, String>();
        for (Map.Entry entry : webRequest.getParameterMap().entrySet()) {
            parameters.put((String)entry.getKey(), (String)((Object)Arrays.asList((Object[])entry.getValue())));
        }
        Optional<QuerydslPredicate> annotation = Optional.ofNullable(parameter.getParameterAnnotation(QuerydslPredicate.class));
        TypeInformation<?> domainType = QuerydslPredicateArgumentResolver.extractTypeInfo(parameter).getRequiredActualType();
        Optional<Class> bindings = annotation.map(QuerydslPredicate::bindings).map(CastUtils::cast);
        return this.predicateBuilder.getPredicate(domainType, parameters, bindings.map(it -> this.bindingsFactory.createBindingsFor(domainType, (Class<? extends QuerydslBinderCustomizer<?>>)it)).orElseGet(() -> this.bindingsFactory.createBindingsFor(domainType)));
    }

    static TypeInformation<?> extractTypeInfo(MethodParameter parameter) {
        Optional<QuerydslPredicate> annotation = Optional.ofNullable(parameter.getParameterAnnotation(QuerydslPredicate.class));
        return annotation.filter(it -> !Object.class.equals(it.root())).map(it -> ClassTypeInformation.from(it.root())).orElseGet(() -> QuerydslPredicateArgumentResolver.detectDomainType(parameter));
    }

    private static TypeInformation<?> detectDomainType(MethodParameter parameter) {
        Method method = parameter.getMethod();
        if (method == null) {
            throw new IllegalArgumentException("Method parameter is not backed by a method!");
        }
        return QuerydslPredicateArgumentResolver.detectDomainType(ClassTypeInformation.fromReturnTypeOf(method));
    }

    private static TypeInformation<?> detectDomainType(TypeInformation<?> source) {
        if (source.getTypeArguments().isEmpty()) {
            return source;
        }
        TypeInformation<?> actualType = source.getActualType();
        if (actualType == null) {
            throw new IllegalArgumentException(String.format("Could not determine domain type from %s!", source));
        }
        if (source != actualType) {
            return QuerydslPredicateArgumentResolver.detectDomainType(actualType);
        }
        if (source instanceof Iterable) {
            return source;
        }
        return QuerydslPredicateArgumentResolver.detectDomainType(source.getRequiredComponentType());
    }
}

