/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.BootstrapMode;
import org.springframework.data.repository.config.DeferredRepositoryInitializationListener;
import org.springframework.data.repository.config.RepositoryBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;

public class RepositoryConfigurationDelegate {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryConfigurationDelegate.class);
    private static final String REPOSITORY_REGISTRATION = "Spring Data {} - Registering repository: {} - Interface: {} - Factory: {}";
    private static final String MULTIPLE_MODULES = "Multiple Spring Data modules found, entering strict repository configuration mode!";
    private static final String NON_DEFAULT_AUTOWIRE_CANDIDATE_RESOLVER = "Non-default AutowireCandidateResolver ({}) detected. Skipping the registration of LazyRepositoryInjectionPointResolver. Lazy repository injection will not be working!";
    static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";
    private final RepositoryConfigurationSource configurationSource;
    private final ResourceLoader resourceLoader;
    private final Environment environment;
    private final boolean isXml;
    private final boolean inMultiStoreMode;

    public RepositoryConfigurationDelegate(RepositoryConfigurationSource configurationSource, ResourceLoader resourceLoader, Environment environment2) {
        this.isXml = configurationSource instanceof XmlRepositoryConfigurationSource;
        boolean isAnnotation = configurationSource instanceof AnnotationRepositoryConfigurationSource;
        Assert.isTrue(this.isXml || isAnnotation, "Configuration source must either be an Xml- or an AnnotationBasedConfigurationSource!");
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null!");
        this.configurationSource = configurationSource;
        this.resourceLoader = resourceLoader;
        this.environment = RepositoryConfigurationDelegate.defaultEnvironment(environment2, resourceLoader);
        this.inMultiStoreMode = this.multipleStoresDetected();
    }

    private static Environment defaultEnvironment(@Nullable Environment environment2, @Nullable ResourceLoader resourceLoader) {
        if (environment2 != null) {
            return environment2;
        }
        return resourceLoader instanceof EnvironmentCapable ? ((EnvironmentCapable)((Object)resourceLoader)).getEnvironment() : new StandardEnvironment();
    }

    public List<BeanComponentDefinition> registerRepositoriesIn(BeanDefinitionRegistry registry, RepositoryConfigurationExtension extension) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Bootstrapping Spring Data repositories in {} mode.", (Object)this.configurationSource.getBootstrapMode().name());
        }
        extension.registerBeansForRoot(registry, this.configurationSource);
        RepositoryBeanDefinitionBuilder builder = new RepositoryBeanDefinitionBuilder(registry, extension, this.configurationSource, this.resourceLoader, this.environment);
        ArrayList<BeanComponentDefinition> definitions = new ArrayList<BeanComponentDefinition>();
        StopWatch watch = new StopWatch();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanning for repositories in packages {}.", (Object)this.configurationSource.getBasePackages().stream().collect(Collectors.joining(", ")));
        }
        watch.start();
        Collection<RepositoryConfiguration<RepositoryConfigurationSource>> configurations = extension.getRepositoryConfigurations(this.configurationSource, this.resourceLoader, this.inMultiStoreMode);
        HashMap configurationsByRepositoryName = new HashMap(configurations.size());
        for (RepositoryConfiguration<RepositoryConfigurationSource> configuration : configurations) {
            configurationsByRepositoryName.put(configuration.getRepositoryInterface(), configuration);
            BeanDefinitionBuilder definitionBuilder = builder.build(configuration);
            extension.postProcess(definitionBuilder, this.configurationSource);
            if (this.isXml) {
                extension.postProcess(definitionBuilder, (XmlRepositoryConfigurationSource)this.configurationSource);
            } else {
                extension.postProcess(definitionBuilder, (AnnotationRepositoryConfigurationSource)this.configurationSource);
            }
            AbstractBeanDefinition beanDefinition = definitionBuilder.getBeanDefinition();
            String beanName = this.configurationSource.generateBeanName(beanDefinition);
            if (LOG.isTraceEnabled()) {
                LOG.trace(REPOSITORY_REGISTRATION, extension.getModuleName(), beanName, configuration.getRepositoryInterface(), configuration.getRepositoryFactoryBeanClassName());
            }
            beanDefinition.setAttribute(FACTORY_BEAN_OBJECT_TYPE, configuration.getRepositoryInterface());
            registry.registerBeanDefinition(beanName, beanDefinition);
            definitions.add(new BeanComponentDefinition(beanDefinition, beanName));
        }
        RepositoryConfigurationDelegate.potentiallyLazifyRepositories(configurationsByRepositoryName, registry, this.configurationSource.getBootstrapMode());
        watch.stop();
        if (LOG.isInfoEnabled()) {
            LOG.info("Finished Spring Data repository scanning in {}ms. Found {} repository interfaces.", (Object)watch.getLastTaskTimeMillis(), (Object)configurations.size());
        }
        return definitions;
    }

    private static void potentiallyLazifyRepositories(Map<String, RepositoryConfiguration<?>> configurations, BeanDefinitionRegistry registry, BootstrapMode mode) {
        if (!DefaultListableBeanFactory.class.isInstance(registry) || mode.equals((Object)BootstrapMode.DEFAULT)) {
            return;
        }
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)DefaultListableBeanFactory.class.cast(registry);
        AutowireCandidateResolver resolver = beanFactory.getAutowireCandidateResolver();
        if (!Arrays.asList(ContextAnnotationAutowireCandidateResolver.class, LazyRepositoryInjectionPointResolver.class).contains(resolver.getClass())) {
            LOG.warn(NON_DEFAULT_AUTOWIRE_CANDIDATE_RESOLVER, (Object)resolver.getClass().getName());
            return;
        }
        LazyRepositoryInjectionPointResolver newResolver = LazyRepositoryInjectionPointResolver.class.isInstance(resolver) ? ((LazyRepositoryInjectionPointResolver)LazyRepositoryInjectionPointResolver.class.cast(resolver)).withAdditionalConfigurations(configurations) : new LazyRepositoryInjectionPointResolver(configurations);
        beanFactory.setAutowireCandidateResolver(newResolver);
        if (mode.equals((Object)BootstrapMode.DEFERRED)) {
            LOG.debug("Registering deferred repository initialization listener.");
            beanFactory.registerSingleton(DeferredRepositoryInitializationListener.class.getName(), new DeferredRepositoryInitializationListener(beanFactory));
        }
    }

    private boolean multipleStoresDetected() {
        boolean multipleModulesFound;
        boolean bl = multipleModulesFound = SpringFactoriesLoader.loadFactoryNames(RepositoryFactorySupport.class, this.resourceLoader.getClassLoader()).size() > 1;
        if (multipleModulesFound) {
            LOG.info(MULTIPLE_MODULES);
        }
        return multipleModulesFound;
    }

    static class LazyRepositoryInjectionPointResolver
    extends ContextAnnotationAutowireCandidateResolver {
        @Generated
        private static final Logger LOG = LoggerFactory.getLogger(LazyRepositoryInjectionPointResolver.class);
        private final Map<String, RepositoryConfiguration<?>> configurations;

        LazyRepositoryInjectionPointResolver withAdditionalConfigurations(Map<String, RepositoryConfiguration<?>> configurations) {
            HashMap map = new HashMap(this.configurations);
            map.putAll(configurations);
            return new LazyRepositoryInjectionPointResolver(map);
        }

        @Override
        protected boolean isLazy(DependencyDescriptor descriptor) {
            Class<?> type = descriptor.getDependencyType();
            RepositoryConfiguration<?> configuration = this.configurations.get(type.getName());
            if (configuration == null) {
                return super.isLazy(descriptor);
            }
            boolean lazyInit = configuration.isLazyInit();
            if (lazyInit) {
                LOG.debug("Creating lazy injection proxy for {}\u2026", (Object)configuration.getRepositoryInterface());
            }
            return lazyInit;
        }

        @Generated
        public LazyRepositoryInjectionPointResolver(Map<String, RepositoryConfiguration<?>> configurations) {
            this.configurations = configurations;
        }
    }
}

