/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.repository.util.ReactiveWrappers;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

class ReactiveMongoParameterAccessor
extends MongoParametersParameterAccessor {
    private final Object[] values;
    private final List<MonoProcessor<?>> subscriptions;

    public ReactiveMongoParameterAccessor(MongoQueryMethod method, Object[] values) {
        super(method, values);
        this.values = values;
        this.subscriptions = new ArrayList(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value == null || !ReactiveWrappers.supports(value.getClass())) {
                this.subscriptions.add(null);
                continue;
            }
            if (ReactiveWrappers.isSingleValueType(value.getClass())) {
                this.subscriptions.add(ReactiveWrapperConverters.toWrapper(value, Mono.class).toProcessor());
                continue;
            }
            this.subscriptions.add(ReactiveWrapperConverters.toWrapper(value, Flux.class).collectList().toProcessor());
        }
    }

    @Override
    protected <T> T getValue(int index) {
        if (this.subscriptions.get(index) != null) {
            return (T)this.subscriptions.get(index).block();
        }
        return super.getValue(index);
    }

    @Override
    public Object[] getValues() {
        Object[] result = new Object[this.values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getValue(i);
        }
        return result;
    }

    @Override
    public Object getBindableValue(int index) {
        return this.getValue(((Parameter)this.getParameters().getBindableParameter(index)).getIndex());
    }
}

