/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.bson.Document;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.mongodb.core.query.Query;

class QueryUtils {
    QueryUtils() {
    }

    static Query decorateSort(Query query, Document defaultSort) {
        if (defaultSort.isEmpty()) {
            return query;
        }
        ProxyFactory factory = new ProxyFactory(query);
        factory.addAdvice(invocation -> {
            if (!invocation.getMethod().getName().equals("getSortObject")) {
                return invocation.proceed();
            }
            Document combinedSort = new Document(defaultSort);
            combinedSort.putAll((Document)invocation.proceed());
            return combinedSort;
        });
        return (Query)factory.getProxy();
    }
}

