/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class UntypedJsonSchemaObject
implements JsonSchemaObject {
    protected final Restrictions restrictions;
    @Nullable
    protected final String description;
    protected final boolean generateDescription;

    UntypedJsonSchemaObject(@Nullable Restrictions restrictions, @Nullable String description, boolean generateDescription) {
        this.description = description;
        this.restrictions = restrictions != null ? restrictions : Restrictions.empty();
        this.generateDescription = generateDescription;
    }

    public static UntypedJsonSchemaObject newInstance() {
        return new UntypedJsonSchemaObject(null, null, false);
    }

    @Override
    public Set<JsonSchemaObject.Type> getTypes() {
        return Collections.emptySet();
    }

    public UntypedJsonSchemaObject description(String description) {
        return new UntypedJsonSchemaObject(this.restrictions, description, this.generateDescription);
    }

    public UntypedJsonSchemaObject generatedDescription() {
        return new UntypedJsonSchemaObject(this.restrictions, this.description, true);
    }

    public UntypedJsonSchemaObject possibleValues(Collection<? extends Object> possibleValues) {
        return new UntypedJsonSchemaObject(this.restrictions.possibleValues(possibleValues), this.description, this.generateDescription);
    }

    public UntypedJsonSchemaObject allOf(Collection<JsonSchemaObject> allOf) {
        return new UntypedJsonSchemaObject(this.restrictions.allOf(allOf), this.description, this.generateDescription);
    }

    public UntypedJsonSchemaObject anyOf(Collection<JsonSchemaObject> anyOf) {
        return new UntypedJsonSchemaObject(this.restrictions.anyOf(anyOf), this.description, this.generateDescription);
    }

    public UntypedJsonSchemaObject oneOf(Collection<JsonSchemaObject> oneOf) {
        return new UntypedJsonSchemaObject(this.restrictions.oneOf(oneOf), this.description, this.generateDescription);
    }

    public UntypedJsonSchemaObject notMatch(JsonSchemaObject notMatch) {
        return new UntypedJsonSchemaObject(this.restrictions.notMatch(notMatch), this.description, this.generateDescription);
    }

    @Override
    public Document toDocument() {
        Document document = new Document();
        this.getOrCreateDescription().ifPresent(val -> document.append("description", val));
        document.putAll(this.restrictions.toDocument());
        return document;
    }

    private Optional<String> getOrCreateDescription() {
        if (this.description != null) {
            return this.description.isEmpty() ? Optional.empty() : Optional.of(this.description);
        }
        return this.generateDescription ? Optional.ofNullable(this.generateDescription()) : Optional.empty();
    }

    @Nullable
    protected String generateDescription() {
        return null;
    }

    static class Restrictions {
        private final Collection<? extends Object> possibleValues;
        private final Collection<JsonSchemaObject> allOf;
        private final Collection<JsonSchemaObject> anyOf;
        private final Collection<JsonSchemaObject> oneOf;
        @Nullable
        private final JsonSchemaObject notMatch;

        static Restrictions empty() {
            return new Restrictions(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null);
        }

        Restrictions possibleValues(Collection<? extends Object> possibleValues) {
            Assert.notNull(possibleValues, "PossibleValues must not be null!");
            return new Restrictions(possibleValues, this.allOf, this.anyOf, this.oneOf, this.notMatch);
        }

        Restrictions allOf(Collection<JsonSchemaObject> allOf) {
            Assert.notNull(allOf, "AllOf must not be null!");
            return new Restrictions(this.possibleValues, allOf, this.anyOf, this.oneOf, this.notMatch);
        }

        Restrictions anyOf(Collection<JsonSchemaObject> anyOf) {
            Assert.notNull(anyOf, "AnyOf must not be null!");
            return new Restrictions(this.possibleValues, this.allOf, anyOf, this.oneOf, this.notMatch);
        }

        Restrictions oneOf(Collection<JsonSchemaObject> oneOf) {
            Assert.notNull(oneOf, "OneOf must not be null!");
            return new Restrictions(this.possibleValues, this.allOf, this.anyOf, oneOf, this.notMatch);
        }

        Restrictions notMatch(JsonSchemaObject notMatch) {
            Assert.notNull((Object)notMatch, "NotMatch must not be null!");
            return new Restrictions(this.possibleValues, this.allOf, this.anyOf, this.oneOf, notMatch);
        }

        Document toDocument() {
            Document document = new Document();
            if (!CollectionUtils.isEmpty(this.possibleValues)) {
                document.append("enum", this.possibleValues);
            }
            if (!CollectionUtils.isEmpty(this.allOf)) {
                document.append("allOf", Restrictions.render(this.allOf));
            }
            if (!CollectionUtils.isEmpty(this.anyOf)) {
                document.append("anyOf", Restrictions.render(this.anyOf));
            }
            if (!CollectionUtils.isEmpty(this.oneOf)) {
                document.append("oneOf", Restrictions.render(this.oneOf));
            }
            if (this.notMatch != null) {
                document.append("not", this.notMatch.toDocument());
            }
            return document;
        }

        private static List<Document> render(Collection<JsonSchemaObject> objects) {
            return objects.stream().map(JsonSchemaObject::toDocument).collect(Collectors.toList());
        }

        Restrictions(Collection<? extends Object> possibleValues, Collection<JsonSchemaObject> allOf, Collection<JsonSchemaObject> anyOf, Collection<JsonSchemaObject> oneOf, @Nullable JsonSchemaObject notMatch) {
            this.possibleValues = possibleValues;
            this.allOf = allOf;
            this.anyOf = anyOf;
            this.oneOf = oneOf;
            this.notMatch = notMatch;
        }
    }
}

