/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.HashMap;
import java.util.Map;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Field {
    private final Map<String, Integer> criteria = new HashMap<String, Integer>();
    private final Map<String, Object> slices = new HashMap<String, Object>();
    private final Map<String, Criteria> elemMatchs = new HashMap<String, Criteria>();
    @Nullable
    private String positionKey;
    private int positionValue;

    public Field include(String key) {
        this.criteria.put(key, 1);
        return this;
    }

    public Field exclude(String key) {
        this.criteria.put(key, 0);
        return this;
    }

    public Field slice(String key, int size) {
        this.slices.put(key, size);
        return this;
    }

    public Field slice(String key, int offset, int size) {
        this.slices.put(key, new Integer[]{offset, size});
        return this;
    }

    public Field elemMatch(String key, Criteria elemMatchCriteria) {
        this.elemMatchs.put(key, elemMatchCriteria);
        return this;
    }

    public Field position(String field, int value) {
        Assert.hasText(field, "DocumentField must not be null or empty!");
        this.positionKey = field;
        this.positionValue = value;
        return this;
    }

    public Document getFieldsObject() {
        Document document = new Document(this.criteria);
        for (Map.Entry<String, Object> entry : this.slices.entrySet()) {
            document.put(entry.getKey(), (Object)new Document("$slice", entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.elemMatchs.entrySet()) {
            document.put(entry.getKey(), (Object)new Document("$elemMatch", ((Criteria)entry.getValue()).getCriteriaObject()));
        }
        if (this.positionKey != null) {
            document.put(this.positionKey + ".$", (Object)this.positionValue);
        }
        return document;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Integer> this$criteria = this.criteria;
        Map<String, Integer> other$criteria = other.criteria;
        if (this$criteria == null ? other$criteria != null : !((Object)this$criteria).equals(other$criteria)) {
            return false;
        }
        Map<String, Object> this$slices = this.slices;
        Map<String, Object> other$slices = other.slices;
        if (this$slices == null ? other$slices != null : !((Object)this$slices).equals(other$slices)) {
            return false;
        }
        Map<String, Criteria> this$elemMatchs = this.elemMatchs;
        Map<String, Criteria> other$elemMatchs = other.elemMatchs;
        if (this$elemMatchs == null ? other$elemMatchs != null : !((Object)this$elemMatchs).equals(other$elemMatchs)) {
            return false;
        }
        String this$positionKey = this.positionKey;
        String other$positionKey = other.positionKey;
        if (this$positionKey == null ? other$positionKey != null : !this$positionKey.equals(other$positionKey)) {
            return false;
        }
        return this.positionValue == other.positionValue;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Field;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Integer> $criteria = this.criteria;
        result = result * 59 + ($criteria == null ? 43 : ((Object)$criteria).hashCode());
        Map<String, Object> $slices = this.slices;
        result = result * 59 + ($slices == null ? 43 : ((Object)$slices).hashCode());
        Map<String, Criteria> $elemMatchs = this.elemMatchs;
        result = result * 59 + ($elemMatchs == null ? 43 : ((Object)$elemMatchs).hashCode());
        String $positionKey = this.positionKey;
        result = result * 59 + ($positionKey == null ? 43 : $positionKey.hashCode());
        result = result * 59 + this.positionValue;
        return result;
    }
}

