/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface Message<S, T> {
    @Nullable
    public S getRaw();

    @Nullable
    public T getBody();

    public MessageProperties getProperties();

    public static class MessageProperties {
        private static final MessageProperties EMPTY = new MessageProperties();
        @Nullable
        private String databaseName;
        @Nullable
        private String collectionName;

        @Nullable
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Nullable
        public String getCollectionName() {
            return this.collectionName;
        }

        public static MessageProperties empty() {
            return EMPTY;
        }

        public static MessagePropertiesBuilder builder() {
            return new MessagePropertiesBuilder();
        }

        public String toString() {
            return "Message.MessageProperties(databaseName=" + this.getDatabaseName() + ", collectionName=" + this.getCollectionName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageProperties)) {
                return false;
            }
            MessageProperties other = (MessageProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$databaseName = this.getDatabaseName();
            String other$databaseName = other.getDatabaseName();
            if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
                return false;
            }
            String this$collectionName = this.getCollectionName();
            String other$collectionName = other.getCollectionName();
            return !(this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $databaseName = this.getDatabaseName();
            result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
            String $collectionName = this.getCollectionName();
            result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
            return result;
        }

        public static class MessagePropertiesBuilder {
            @Nullable
            private String databaseName;
            @Nullable
            private String collectionName;

            public MessagePropertiesBuilder databaseName(String dbName) {
                Assert.notNull((Object)dbName, "Database name must not be null!");
                this.databaseName = dbName;
                return this;
            }

            public MessagePropertiesBuilder collectionName(String collectionName) {
                Assert.notNull((Object)collectionName, "Collection name must not be null!");
                this.collectionName = collectionName;
                return this;
            }

            public MessageProperties build() {
                MessageProperties properties = new MessageProperties();
                properties.collectionName = this.collectionName;
                properties.databaseName = this.databaseName;
                return properties;
            }
        }
    }
}

