/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBRef;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.convert.EntityConverter;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public interface MongoConverter
extends EntityConverter<MongoPersistentEntity<?>, MongoPersistentProperty, Object, Bson>,
MongoWriter<Object>,
EntityReader<Object, Bson> {
    public MongoTypeMapper getTypeMapper();

    @Nullable
    default public <S, T> T mapValueToTargetType(S source, Class<T> targetType, DbRefResolver dbRefResolver) {
        Assert.notNull(targetType, "TargetType must not be null!");
        Assert.notNull((Object)dbRefResolver, "DbRefResolver must not be null!");
        if (targetType != Object.class && ClassUtils.isAssignable(targetType, source.getClass())) {
            return (T)source;
        }
        if (source instanceof BsonValue) {
            Object value = BsonUtils.toJavaType((BsonValue)source);
            if (value instanceof Document) {
                Document sourceDocument = (Document)value;
                if (sourceDocument.containsKey("$ref") && sourceDocument.containsKey("$id") && (sourceDocument = dbRefResolver.fetch(new DBRef(sourceDocument.getString("$ref"), sourceDocument.get("$id")))) == null) {
                    return null;
                }
                return this.read(targetType, sourceDocument);
            }
            if (!ClassUtils.isAssignable(targetType, value.getClass()) && this.getConversionService().canConvert(value.getClass(), targetType)) {
                return this.getConversionService().convert(value, targetType);
            }
            return (T)value;
        }
        return this.getConversionService().convert(source, targetType);
    }
}

