/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.List;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.util.Assert;

public class TypedAggregation<I>
extends Aggregation {
    private final Class<I> inputType;

    public TypedAggregation(Class<I> inputType, AggregationOperation ... operations) {
        this(inputType, TypedAggregation.asAggregationList(operations));
    }

    public TypedAggregation(Class<I> inputType, List<AggregationOperation> operations) {
        this(inputType, operations, DEFAULT_OPTIONS);
    }

    public TypedAggregation(Class<I> inputType, List<AggregationOperation> operations, AggregationOptions options) {
        super(operations, options);
        Assert.notNull(inputType, "Input type must not be null!");
        this.inputType = inputType;
    }

    public Class<I> getInputType() {
        return this.inputType;
    }

    @Override
    public TypedAggregation<I> withOptions(AggregationOptions options) {
        Assert.notNull((Object)options, "AggregationOptions must not be null.");
        return new TypedAggregation<I>(this.inputType, this.operations, options);
    }
}

