/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.Collection;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;

public class ObjectOperators {
    public static ObjectOperatorFactory valueOf(String fieldReference) {
        return new ObjectOperatorFactory(Fields.field(fieldReference));
    }

    public static ObjectOperatorFactory valueOf(AggregationExpression expression) {
        return new ObjectOperatorFactory(expression);
    }

    public static class ObjectToArray
    extends AbstractAggregationExpression {
        private ObjectToArray(Object value) {
            super(value);
        }

        public static ObjectToArray valueOfToArray(String fieldReference) {
            return ObjectToArray.toArray(Fields.field(fieldReference));
        }

        public static ObjectToArray valueOfToArray(AggregationExpression expression) {
            return ObjectToArray.toArray(expression);
        }

        public static ObjectToArray toArray(Object value) {
            return new ObjectToArray(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$objectToArray";
        }
    }

    public static class MergeObjects
    extends AbstractAggregationExpression {
        private MergeObjects(Object value) {
            super(value);
        }

        public static MergeObjects merge(Object ... values) {
            return new MergeObjects(Arrays.asList(values));
        }

        public static MergeObjects mergeValuesOf(String ... fieldReferences) {
            return MergeObjects.merge(Arrays.stream(fieldReferences).map(Fields::field).toArray());
        }

        public static MergeObjects mergeValuesOf(AggregationExpression ... expressions) {
            return MergeObjects.merge(expressions);
        }

        public MergeObjects mergeWithValuesOf(String ... fieldReferences) {
            return this.mergeWith(Arrays.stream(fieldReferences).map(Fields::field).toArray());
        }

        public MergeObjects mergeWithValuesOf(AggregationExpression ... expression) {
            return this.mergeWith(expression);
        }

        public MergeObjects mergeWith(Object ... values) {
            return new MergeObjects(this.append(Arrays.asList(values)));
        }

        @Override
        public Document toDocument(Object value, AggregationOperationContext context) {
            return super.toDocument(this.potentiallyExtractSingleValue(value), context);
        }

        private Object potentiallyExtractSingleValue(Object value) {
            Collection collection;
            if (value instanceof Collection && (collection = (Collection)value).size() == 1) {
                return collection.iterator().next();
            }
            return value;
        }

        @Override
        protected String getMongoMethod() {
            return "$mergeObjects";
        }
    }

    public static class ObjectOperatorFactory {
        private final Object value;

        public ObjectOperatorFactory(Object value) {
            Assert.notNull(value, "Value must not be null!");
            this.value = value;
        }

        public MergeObjects merge() {
            return MergeObjects.merge(this.value);
        }

        public MergeObjects mergeWith(Object ... values) {
            return this.merge().mergeWith(values);
        }

        public MergeObjects mergeWithValuesOf(String ... fieldReferences) {
            return this.merge().mergeWithValuesOf(fieldReferences);
        }

        public MergeObjects mergeWithValuesOf(AggregationExpression ... expression) {
            return this.merge().mergeWithValuesOf(expression);
        }

        public ObjectToArray toArray() {
            return ObjectToArray.toArray(this.value);
        }
    }
}

