/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.BucketOperationSupport;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.util.Assert;

public class BucketAutoOperation
extends BucketOperationSupport<BucketAutoOperation, BucketAutoOperationOutputBuilder>
implements FieldsExposingAggregationOperation {
    private final int buckets;
    private final String granularity;

    public BucketAutoOperation(Field groupByField, int buckets) {
        super(groupByField);
        Assert.isTrue(buckets > 0, "Number of buckets must be greater 0!");
        this.buckets = buckets;
        this.granularity = null;
    }

    public BucketAutoOperation(AggregationExpression groupByExpression, int buckets) {
        super(groupByExpression);
        Assert.isTrue(buckets > 0, "Number of buckets must be greater 0!");
        this.buckets = buckets;
        this.granularity = null;
    }

    private BucketAutoOperation(BucketAutoOperation bucketOperation, BucketOperationSupport.Outputs outputs) {
        super(bucketOperation, outputs);
        this.buckets = bucketOperation.buckets;
        this.granularity = bucketOperation.granularity;
    }

    private BucketAutoOperation(BucketAutoOperation bucketOperation, int buckets, String granularity) {
        super(bucketOperation);
        this.buckets = buckets;
        this.granularity = granularity;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document options = new Document();
        options.put("buckets", (Object)this.buckets);
        if (this.granularity != null) {
            options.put("granularity", (Object)this.granularity);
        }
        options.putAll(super.toDocument(context));
        return new Document("$bucketAuto", options);
    }

    public BucketAutoOperation withBuckets(int buckets) {
        Assert.isTrue(buckets > 0, "Number of buckets must be greater 0!");
        return new BucketAutoOperation(this, buckets, this.granularity);
    }

    public BucketAutoOperation withGranularity(Granularity granularity) {
        Assert.notNull((Object)granularity, "Granularity must not be null!");
        return new BucketAutoOperation(this, this.buckets, granularity.getMongoRepresentation());
    }

    @Override
    protected BucketAutoOperation newBucketOperation(BucketOperationSupport.Outputs outputs) {
        return new BucketAutoOperation(this, outputs);
    }

    public ExpressionBucketAutoOperationBuilder andOutputExpression(String expression, Object ... params) {
        return new ExpressionBucketAutoOperationBuilder(expression, this, params);
    }

    @Override
    public BucketAutoOperationOutputBuilder andOutput(AggregationExpression expression) {
        return new BucketAutoOperationOutputBuilder((Object)expression, this);
    }

    @Override
    public BucketAutoOperationOutputBuilder andOutput(String fieldName) {
        return new BucketAutoOperationOutputBuilder((Object)Fields.field(fieldName), this);
    }

    public static enum Granularities implements Granularity
    {
        R5,
        R10,
        R20,
        R40,
        R80,
        SERIES_1_2_5("1-2-5"),
        E6,
        E12,
        E24,
        E48,
        E96,
        E192,
        POWERSOF2;

        private final String granularity;

        private Granularities() {
            this.granularity = this.name();
        }

        private Granularities(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public String getMongoRepresentation() {
            return this.granularity;
        }
    }

    public static interface Granularity {
        public String getMongoRepresentation();
    }

    public static class ExpressionBucketAutoOperationBuilder
    extends BucketOperationSupport.ExpressionBucketOperationBuilderSupport<BucketAutoOperationOutputBuilder, BucketAutoOperation> {
        protected ExpressionBucketAutoOperationBuilder(String expression, BucketAutoOperation operation, Object[] parameters) {
            super(expression, operation, parameters);
        }

        @Override
        protected BucketAutoOperationOutputBuilder apply(BucketOperationSupport.OperationOutput operationOutput) {
            return new BucketAutoOperationOutputBuilder((Object)operationOutput, (BucketAutoOperation)this.operation);
        }
    }

    public static class BucketAutoOperationOutputBuilder
    extends BucketOperationSupport.OutputBuilder<BucketAutoOperationOutputBuilder, BucketAutoOperation> {
        protected BucketAutoOperationOutputBuilder(Object value, BucketAutoOperation operation) {
            super(value, operation);
        }

        @Override
        protected BucketAutoOperationOutputBuilder apply(BucketOperationSupport.OperationOutput operationOutput) {
            return new BucketAutoOperationOutputBuilder((Object)operationOutput, (BucketAutoOperation)this.operation);
        }
    }
}

