/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import lombok.NonNull;
import org.springframework.data.mongodb.core.ReactiveMapReduceOperation;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

class ReactiveMapReduceOperationSupport
implements ReactiveMapReduceOperation {
    private static final Query ALL_QUERY = new Query();
    @NonNull
    private final ReactiveMongoTemplate template;

    public <T> ReactiveMapReduceSupport<T> mapReduce(Class<T> domainType) {
        Assert.notNull(domainType, "DomainType must not be null!");
        return new ReactiveMapReduceSupport<T>(this.template, domainType, domainType, null, ALL_QUERY, null, null, null);
    }

    public ReactiveMapReduceOperationSupport(@NonNull ReactiveMongoTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template is marked @NonNull but is null");
        }
        this.template = template;
    }

    static class ReactiveMapReduceSupport<T>
    implements ReactiveMapReduceOperation.ReactiveMapReduce<T>,
    ReactiveMapReduceOperation.MapReduceWithOptions<T>,
    ReactiveMapReduceOperation.MapReduceWithCollection<T>,
    ReactiveMapReduceOperation.MapReduceWithProjection<T>,
    ReactiveMapReduceOperation.MapReduceWithQuery<T>,
    ReactiveMapReduceOperation.MapReduceWithReduceFunction<T>,
    ReactiveMapReduceOperation.MapReduceWithMapFunction<T> {
        private final ReactiveMongoTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        @Nullable
        private final String collection;
        private final Query query;
        @Nullable
        private final String mapFunction;
        @Nullable
        private final String reduceFunction;
        @Nullable
        private final MapReduceOptions options;

        ReactiveMapReduceSupport(ReactiveMongoTemplate template, Class<?> domainType, Class<T> returnType, @Nullable String collection, Query query, @Nullable String mapFunction, @Nullable String reduceFunction, @Nullable MapReduceOptions options) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.collection = collection;
            this.query = query;
            this.mapFunction = mapFunction;
            this.reduceFunction = reduceFunction;
            this.options = options;
        }

        @Override
        public Flux<T> all() {
            return this.template.mapReduce(this.query, this.domainType, this.getCollectionName(), this.returnType, this.mapFunction, this.reduceFunction, this.options);
        }

        @Override
        public ReactiveMapReduceOperation.MapReduceWithProjection<T> inCollection(String collection) {
            Assert.hasText(collection, "Collection name must not be null nor empty!");
            return new ReactiveMapReduceSupport<T>(this.template, this.domainType, this.returnType, collection, this.query, this.mapFunction, this.reduceFunction, this.options);
        }

        @Override
        public ReactiveMapReduceOperation.TerminatingMapReduce<T> matching(Query query) {
            Assert.notNull((Object)query, "Query must not be null!");
            return new ReactiveMapReduceSupport<T>(this.template, this.domainType, this.returnType, this.collection, query, this.mapFunction, this.reduceFunction, this.options);
        }

        @Override
        public <R> ReactiveMapReduceOperation.MapReduceWithQuery<R> as(Class<R> resultType) {
            Assert.notNull(resultType, "ResultType must not be null!");
            return new ReactiveMapReduceSupport<R>(this.template, this.domainType, resultType, this.collection, this.query, this.mapFunction, this.reduceFunction, this.options);
        }

        @Override
        public ReactiveMapReduceOperation.ReactiveMapReduce<T> with(MapReduceOptions options) {
            Assert.notNull((Object)options, "Options must not be null! Please consider empty MapReduceOptions#options() instead.");
            return new ReactiveMapReduceSupport<T>(this.template, this.domainType, this.returnType, this.collection, this.query, this.mapFunction, this.reduceFunction, options);
        }

        @Override
        public ReactiveMapReduceOperation.MapReduceWithReduceFunction<T> map(String mapFunction) {
            Assert.hasText(mapFunction, "MapFunction name must not be null nor empty!");
            return new ReactiveMapReduceSupport<T>(this.template, this.domainType, this.returnType, this.collection, this.query, mapFunction, this.reduceFunction, this.options);
        }

        @Override
        public ReactiveMapReduceOperation.ReactiveMapReduce<T> reduce(String reduceFunction) {
            Assert.hasText(reduceFunction, "ReduceFunction name must not be null nor empty!");
            return new ReactiveMapReduceSupport<T>(this.template, this.domainType, this.returnType, this.collection, this.query, this.mapFunction, reduceFunction, this.options);
        }

        private String getCollectionName() {
            return StringUtils.hasText(this.collection) ? this.collection : this.template.determineCollectionName(this.domainType);
        }
    }
}

