/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.MongoCredentialPropertyEditor;
import org.springframework.data.mongodb.config.ReadPreferencePropertyEditor;
import org.springframework.data.mongodb.config.WriteConcernPropertyEditor;
import org.springframework.data.mongodb.core.MongoClientOptionsFactoryBean;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class MongoParsingUtils {
    private MongoParsingUtils() {
    }

    static void parseReplicaSet(Element element, BeanDefinitionBuilder mongoBuilder) {
        ParsingUtils.setPropertyValue(mongoBuilder, element, "replica-set", "replicaSetSeeds");
    }

    public static boolean parseMongoClientOptions(Element element, BeanDefinitionBuilder mongoClientBuilder) {
        Element optionsElement = DomUtils.getChildElementByTagName(element, "client-options");
        if (optionsElement == null) {
            return false;
        }
        BeanDefinitionBuilder clientOptionsDefBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoClientOptionsFactoryBean.class);
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "description", "description");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "min-connections-per-host", "minConnectionsPerHost");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "connections-per-host", "connectionsPerHost");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "threads-allowed-to-block-for-connection-multiplier", "threadsAllowedToBlockForConnectionMultiplier");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "max-wait-time", "maxWaitTime");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "max-connection-idle-time", "maxConnectionIdleTime");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "max-connection-life-time", "maxConnectionLifeTime");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "connect-timeout", "connectTimeout");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "socket-timeout", "socketTimeout");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "socket-keep-alive", "socketKeepAlive");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "read-preference", "readPreference");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "write-concern", "writeConcern");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "heartbeat-frequency", "heartbeatFrequency");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "min-heartbeat-frequency", "minHeartbeatFrequency");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "heartbeat-connect-timeout", "heartbeatConnectTimeout");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "heartbeat-socket-timeout", "heartbeatSocketTimeout");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "ssl", "ssl");
        ParsingUtils.setPropertyReference(clientOptionsDefBuilder, optionsElement, "ssl-socket-factory-ref", "sslSocketFactory");
        ParsingUtils.setPropertyValue(clientOptionsDefBuilder, optionsElement, "server-selection-timeout", "serverSelectionTimeout");
        mongoClientBuilder.addPropertyValue("mongoClientOptions", clientOptionsDefBuilder.getBeanDefinition());
        return true;
    }

    static BeanDefinitionBuilder getWriteConcernPropertyEditorBuilder() {
        ManagedMap<String, Class<WriteConcernPropertyEditor>> customEditors = new ManagedMap<String, Class<WriteConcernPropertyEditor>>();
        customEditors.put("com.mongodb.WriteConcern", WriteConcernPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getServerAddressPropertyEditorBuilder() {
        ManagedMap<String, String> customEditors = new ManagedMap<String, String>();
        customEditors.put("com.mongodb.ServerAddress[]", "org.springframework.data.mongodb.config.ServerAddressPropertyEditor");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getReadPreferencePropertyEditorBuilder() {
        ManagedMap<String, Class<ReadPreferencePropertyEditor>> customEditors = new ManagedMap<String, Class<ReadPreferencePropertyEditor>>();
        customEditors.put("com.mongodb.ReadPreference", ReadPreferencePropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getMongoCredentialPropertyEditor() {
        ManagedMap<String, Class<MongoCredentialPropertyEditor>> customEditors = new ManagedMap<String, Class<MongoCredentialPropertyEditor>>();
        customEditors.put("com.mongodb.MongoCredential[]", MongoCredentialPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", customEditors);
        return builder;
    }
}

