/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.config.EnableMongoAuditing;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.event.AuditingEventListener;
import org.springframework.util.Assert;

class MongoAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    MongoAuditingRegistrar() {
    }

    @Override
    protected Class<? extends Annotation> getAnnotation() {
        return EnableMongoAuditing.class;
    }

    @Override
    protected String getAuditingHandlerBeanName() {
        return "mongoAuditingHandler";
    }

    @Override
    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)annotationMetadata, "AnnotationMetadata must not be null!");
        Assert.notNull((Object)registry, "BeanDefinitionRegistry must not be null!");
        super.registerBeanDefinitions(annotationMetadata, registry);
    }

    @Override
    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, "AuditingConfiguration must not be null!");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(IsNewAwareAuditingHandler.class);
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(MongoMappingContextLookup.class);
        definition.setAutowireMode(3);
        builder.addConstructorArgValue(definition.getBeanDefinition());
        return this.configureDefaultAuditHandlerAttributes(configuration, builder);
    }

    @Override
    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)auditingHandlerDefinition, "BeanDefinition must not be null!");
        Assert.notNull((Object)registry, "BeanDefinitionRegistry must not be null!");
        BeanDefinitionBuilder listenerBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(AuditingEventListener.class);
        listenerBeanDefinitionBuilder.addConstructorArgValue(ParsingUtils.getObjectFactoryBeanDefinition(this.getAuditingHandlerBeanName(), registry));
        this.registerInfrastructureBeanWithId(listenerBeanDefinitionBuilder.getBeanDefinition(), AuditingEventListener.class.getName(), registry);
    }

    static class MongoMappingContextLookup
    implements FactoryBean<MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>> {
        private final MappingMongoConverter converter;

        public MongoMappingContextLookup(MappingMongoConverter converter) {
            this.converter = converter;
        }

        @Override
        public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getObject() throws Exception {
            return this.converter.getMappingContext();
        }

        @Override
        public Class<?> getObjectType() {
            return MappingContext.class;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }
    }
}

