/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonatype.guice.bean.locators.HiddenSource;
import org.sonatype.guice.bean.locators.LazyQualifiedBean;
import org.sonatype.guice.bean.locators.QualifiedBean;
import org.sonatype.guice.bean.locators.QualifyingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QualifiedBeans<Q extends Annotation, T>
implements Iterable<QualifiedBean<Q, T>> {
    static final Annotation DEFAULT_QUALIFIER = Names.named("default");
    private final QualifyingStrategy strategy;
    private final Key<T> key;
    private ArrayList<QualifiedBean<Q, T>> beans = null;
    private boolean exposed;

    QualifiedBeans(Key<T> key) {
        this.strategy = QualifiedBeans.selectQualifyingStrategy(key);
        this.key = key;
    }

    @Override
    public final synchronized Iterator<QualifiedBean<Q, T>> iterator() {
        if (null != this.beans) {
            this.exposed = true;
            return this.beans.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public List<QualifiedBean<Q, T>> add(Injector injector) {
        List<Binding<Object>> bindings;
        TypeLiteral<T> bindingType = this.key.getTypeLiteral();
        if (this.strategy == QualifyingStrategy.NAMED_WITH_ATTRIBUTES) {
            boolean isDefault = ((Object)DEFAULT_QUALIFIER).equals(this.key.getAnnotation());
            Binding<?> b = injector.getBindings().get(isDefault ? Key.get(bindingType) : this.key);
            bindings = null != b ? Collections.singletonList(b) : Collections.EMPTY_LIST;
        } else {
            bindings = injector.findBindingsByType(bindingType);
        }
        if (bindings.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        int pivot = 0;
        ArrayList<QualifiedBean<Q, T>> newBeans = new ArrayList<QualifiedBean<Q, T>>();
        for (Binding binding : bindings) {
            Annotation qualifier;
            if (binding.getSource() instanceof HiddenSource || null == (qualifier = this.strategy.qualify(this.key, binding))) continue;
            LazyQualifiedBean bean = new LazyQualifiedBean(qualifier, binding);
            if (((Object)DEFAULT_QUALIFIER).equals(qualifier)) {
                newBeans.add(pivot++, bean);
                continue;
            }
            newBeans.add(bean);
        }
        if (!newBeans.isEmpty()) {
            this.mergeQualifiedBeans(pivot, newBeans);
        }
        return newBeans;
    }

    public synchronized List<QualifiedBean<Q, T>> remove(Injector injector) {
        if (null == this.beans) {
            return Collections.emptyList();
        }
        ArrayList<QualifiedBean<Q, T>> oldBeans = new ArrayList<QualifiedBean<Q, T>>();
        Collection<Binding<?>> bindings = injector.getBindings().values();
        for (int i = 0; i < this.beans.size(); ++i) {
            if (!bindings.contains(this.beans.get(i).getBinding())) continue;
            if (this.exposed) {
                this.beans = new ArrayList<QualifiedBean<Q, T>>(this.beans);
                this.exposed = false;
            }
            oldBeans.add(this.beans.remove(i--));
        }
        if (this.beans.isEmpty()) {
            this.beans = null;
        } else if (!oldBeans.isEmpty()) {
            this.beans.trimToSize();
        }
        return oldBeans;
    }

    public synchronized List<QualifiedBean<Q, T>> clear() {
        if (null != this.beans) {
            ArrayList<QualifiedBean<Q, T>> oldBeans = this.beans;
            this.beans = null;
            this.exposed = false;
            return oldBeans;
        }
        return Collections.emptyList();
    }

    private static final QualifyingStrategy selectQualifyingStrategy(Key<?> key) {
        Class<Annotation> qualifierType = key.getAnnotationType();
        if (null == qualifierType) {
            return QualifyingStrategy.UNRESTRICTED;
        }
        if (Named.class == qualifierType) {
            return key.hasAttributes() ? QualifyingStrategy.NAMED_WITH_ATTRIBUTES : QualifyingStrategy.NAMED;
        }
        return key.hasAttributes() ? QualifyingStrategy.MARKED_WITH_ATTRIBUTES : QualifyingStrategy.MARKED;
    }

    private synchronized void mergeQualifiedBeans(int pivot, List<QualifiedBean<Q, T>> newBeans) {
        int newBeansLength = newBeans.size();
        if (null == this.beans) {
            this.beans = new ArrayList(newBeansLength);
        } else {
            this.beans.ensureCapacity(this.beans.size() + newBeansLength);
        }
        if (pivot > 0) {
            this.beans.addAll(0, newBeans.subList(0, pivot));
        }
        if (pivot < newBeansLength) {
            int i;
            for (i = pivot; i < this.beans.size() && ((Object)DEFAULT_QUALIFIER).equals(this.beans.get(i).getKey()); ++i) {
            }
            this.beans.addAll(i, newBeans.subList(pivot, newBeansLength));
        }
    }
}

