/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.resolvers.AbstractResolveMojo;
import org.apache.maven.plugins.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.dependency.utils.filters.ResolveFileFilter;
import org.apache.maven.plugins.dependency.utils.markers.SourcesFileMarkerHandler;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;

@Mojo(name="resolve", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ResolveDependenciesMojo
extends AbstractResolveMojo {
    @Parameter(property="mdep.outputScope", defaultValue="true")
    protected boolean outputScope;
    DependencyStatusSets results;
    @Parameter(property="sort", defaultValue="false")
    boolean sort;
    @Parameter(property="includeParents", defaultValue="false")
    boolean includeParents;

    @Override
    protected void doExecute() throws MojoExecutionException {
        this.results = this.getDependencySets(false, this.includeParents);
        String output = this.getOutput(this.outputAbsoluteArtifactFilename, this.outputScope, this.sort);
        try {
            if (this.outputFile == null) {
                DependencyUtil.log(output, this.getLog());
            } else {
                DependencyUtil.write(output, this.outputFile, this.appendOutput, this.getLog());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public DependencyStatusSets getResults() {
        return this.results;
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new ResolveFileFilter(new SourcesFileMarkerHandler(this.markersDirectory));
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename, boolean theOutputScope, boolean theSort) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("The following files have been resolved:\n");
        if (this.results.getResolvedDependencies() == null || this.results.getResolvedDependencies().isEmpty()) {
            sb.append("   none\n");
        } else {
            sb.append((CharSequence)this.buildArtifactListOutput(this.results.getResolvedDependencies(), outputAbsoluteArtifactFilename, theOutputScope, theSort));
        }
        if (this.results.getSkippedDependencies() != null && !this.results.getSkippedDependencies().isEmpty()) {
            sb.append("\n");
            sb.append("The following files were skipped:\n");
            LinkedHashSet<Artifact> skippedDependencies = new LinkedHashSet<Artifact>();
            skippedDependencies.addAll(this.results.getSkippedDependencies());
            sb.append((CharSequence)this.buildArtifactListOutput(skippedDependencies, outputAbsoluteArtifactFilename, theOutputScope, theSort));
        }
        if (this.results.getUnResolvedDependencies() != null && !this.results.getUnResolvedDependencies().isEmpty()) {
            sb.append("\n");
            sb.append("The following files have NOT been resolved:\n");
            LinkedHashSet<Artifact> unResolvedDependencies = new LinkedHashSet<Artifact>();
            unResolvedDependencies.addAll(this.results.getUnResolvedDependencies());
            sb.append((CharSequence)this.buildArtifactListOutput(unResolvedDependencies, outputAbsoluteArtifactFilename, theOutputScope, theSort));
        }
        sb.append("\n");
        return sb.toString();
    }

    private StringBuilder buildArtifactListOutput(Set<Artifact> artifacts, boolean outputAbsoluteArtifactFilename, boolean theOutputScope, boolean theSort) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> artifactStringList = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            ModuleDescriptor moduleDescriptor;
            MessageBuilder messageBuilder = MessageUtils.buffer();
            messageBuilder.a("   ");
            if (theOutputScope) {
                messageBuilder.a(artifact.toString());
            } else {
                messageBuilder.a(artifact.getId());
            }
            if (outputAbsoluteArtifactFilename) {
                try {
                    String artifactFilename = artifact.getFile().getAbsoluteFile().getPath();
                    messageBuilder.a(Character.valueOf(':')).a(artifactFilename);
                }
                catch (NullPointerException artifactFilename) {
                    // empty catch block
                }
            }
            if (theOutputScope && artifact.isOptional()) {
                messageBuilder.a(" (optional) ");
            }
            if (artifact.getFile() != null && (moduleDescriptor = this.getModuleDescriptor(artifact.getFile())) != null) {
                messageBuilder.project(" -- module " + moduleDescriptor.name);
                if (moduleDescriptor.automatic) {
                    if ("MANIFEST".equals(moduleDescriptor.moduleNameSource)) {
                        messageBuilder.strong(" [auto]");
                    } else {
                        messageBuilder.warning(" (auto)");
                    }
                }
            }
            artifactStringList.add(messageBuilder.toString() + "\n");
        }
        if (theSort) {
            Collections.sort(artifactStringList);
        }
        for (String artifactString : artifactStringList) {
            sb.append(artifactString);
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleDescriptor getModuleDescriptor(File artifactFile) {
        ModuleDescriptor moduleDescriptor;
        block20: {
            moduleDescriptor = null;
            try {
                Class<?> moduleFinderClass = Class.forName("java.lang.module.ModuleFinder");
                Path path = artifactFile.toPath();
                Method ofMethod = moduleFinderClass.getMethod("of", Path[].class);
                Object moduleFinderInstance = ofMethod.invoke(null, new Object[]{new Path[]{path}});
                Method findAllMethod = moduleFinderClass.getMethod("findAll", new Class[0]);
                Set moduleReferences = (Set)findAllMethod.invoke(moduleFinderInstance, new Object[0]);
                if (moduleReferences.isEmpty()) break block20;
                Object moduleReference = moduleReferences.iterator().next();
                Method descriptorMethod = moduleReference.getClass().getMethod("descriptor", new Class[0]);
                Object moduleDescriptorInstance = descriptorMethod.invoke(moduleReference, new Object[0]);
                Method nameMethod = moduleDescriptorInstance.getClass().getMethod("name", new Class[0]);
                String name = (String)nameMethod.invoke(moduleDescriptorInstance, new Object[0]);
                moduleDescriptor = new ModuleDescriptor();
                moduleDescriptor.name = name;
                Method isAutomaticMethod = moduleDescriptorInstance.getClass().getMethod("isAutomatic", new Class[0]);
                moduleDescriptor.automatic = (Boolean)isAutomaticMethod.invoke(moduleDescriptorInstance, new Object[0]);
                if (!moduleDescriptor.automatic || !artifactFile.isFile()) break block20;
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(artifactFile);
                    Manifest manifest = jarFile.getManifest();
                    moduleDescriptor.moduleNameSource = manifest != null && manifest.getMainAttributes().getValue("Automatic-Module-Name") != null ? "MANIFEST" : "FILENAME";
                }
                catch (IOException iOException) {
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (ClassNotFoundException moduleFinderClass) {
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                this.getLog().info("Can't extract module name from " + artifactFile.getName() + ": " + cause.getMessage());
            }
        }
        return moduleDescriptor;
    }

    private class ModuleDescriptor {
        String name;
        boolean automatic = true;
        String moduleNameSource;

        private ModuleDescriptor() {
        }
    }
}

