/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class ChunksCleaningWithTread {
    private static int skipValue;
    private static TimerTask backupTimerTask;
    private static Timer timer;
    private static int count;
    static int totalCount;
    private static int threads;
    private static int limit;

    static {
        backupTimerTask = null;
        timer = null;
        count = 0;
    }

    public ChunksCleaningWithTread() {
        totalCount = 0;
    }

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String chunkCollName = config.getProperty("chunkCollName").toString();
        String bkpCollName = config.getProperty("bkpCollName").toString();
        String thread = config.getProperty("thread").toString();
        String skip = config.getProperty("skip").toString();
        String limitValue = config.getProperty("limit").toString();
        skipValue = Integer.parseInt(skip);
        limit = Integer.parseInt(limitValue);
        threads = Integer.parseInt(thread);
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> chunksDBCollection = db.getCollection(chunkCollName.toUpperCase());
        MongoCollection<Document> bkpDBCollection = db.getCollection(bkpCollName.toUpperCase());
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
        ChunksCleaningWithTread.checkThreadStatusAndStartUpdate(chunksDBCollection, bkpDBCollection, pool);
        int i = 0;
        while (i < threads) {
            System.out.println("Creating thread for first time>>>>>>>>> i value::");
            ChunksCleaningWithTread.callUpdateDeviceUUID(chunksDBCollection, bkpDBCollection, pool);
            ++i;
        }
    }

    public static void checkThreadStatusAndStartUpdate(final MongoCollection chunksDBCollection, final MongoCollection bkpDBCollection, final CompletionService<String> pool) {
        if (timer == null) {
            timer = new Timer();
        }
        if (backupTimerTask == null) {
            backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Future future = pool.take();
                        if (future.isDone()) {
                            ChunksCleaningWithTread.callUpdateDeviceUUID(chunksDBCollection, bkpDBCollection, pool);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            timer.schedule(backupTimerTask, 1000L, 1000L);
        }
    }

    private static void callUpdateDeviceUUID(MongoCollection dbBackupCollection, MongoCollection parablu001DB, CompletionService<String> pool) {
        Runnable uploadJob = () -> {
            try {
                ChunksCleaningWithTread.updateTheRef(dbBackupCollection, parablu001DB);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        pool.submit(uploadJob, "");
    }

    public static synchronized int getSkipValue() {
        return ++skipValue;
    }

    public static synchronized void reduceSkip() {
        if (skipValue >= threads) {
            System.out.println("Inside Skip to 0");
            skipValue = 0;
        }
    }

    private static void updateTheRef(MongoCollection chunksDBCollection, MongoCollection bkpDBCollection) {
        BasicDBObject query = new BasicDBObject("newRef", new BasicDBObject("$exists", false));
        FindIterable chunksList = chunksDBCollection.find(query).limit(2000);
        int skip = ChunksCleaningWithTread.getSkipValue();
        System.out.println(String.valueOf(Thread.currentThread().getName()) + "....." + skip);
        chunksList = skip > 0 ? chunksDBCollection.find(query).skip(skip * limit).limit(limit) : chunksDBCollection.find(query).limit(limit);
        int succesChunksCount = 0;
        int failedchunksCount = 0;
        long chunksCompleted = chunksDBCollection.count(query);
        for (Document chunk : chunksList) {
            ++chunksCompleted;
            ++totalCount;
            BasicDBObject chunkSearchQuery = new BasicDBObject();
            chunkSearchQuery.append("_id", chunk.get("_id"));
            if (!StringUtils.isEmpty(chunk.getString("md5"))) {
                BasicDBObject updateChunkQuery;
                BasicDBObject chunkUpdateQuey;
                BasicDBObject andQuery = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                whereQuery.add(new BasicDBObject("chunkFiles.md5", chunk.getString("md5")));
                andQuery.put("$and", whereQuery);
                Document bkpFile = (Document)bkpDBCollection.find(andQuery).limit(1).first();
                if (bkpFile == null) {
                    chunkUpdateQuey = new BasicDBObject();
                    chunkUpdateQuey.append("newRef", false);
                    updateChunkQuery = new BasicDBObject();
                    updateChunkQuery.append("$set", chunkUpdateQuey);
                    chunksDBCollection.updateOne(chunkSearchQuery, updateChunkQuery);
                    System.out.println(String.valueOf(Thread.currentThread().getName()) + "..." + chunk.getObjectId("_id") + ".....CHUNK NOT FOUND ..........succesChunksCount : " + succesChunksCount + "....failedchunksCount :" + ++failedchunksCount + ".......chunksCompleted :" + totalCount);
                    continue;
                }
                chunkUpdateQuey = new BasicDBObject();
                chunkUpdateQuey.append("newRef", true);
                updateChunkQuery = new BasicDBObject();
                updateChunkQuery.append("$set", chunkUpdateQuey);
                chunksDBCollection.updateOne(chunkSearchQuery, updateChunkQuery);
                System.out.println(String.valueOf(Thread.currentThread().getName()) + "..." + chunk.getObjectId("_id") + ".....CHUNK FOUND ..........succesChunksCount : " + ++succesChunksCount + "....failedchunksCount :" + failedchunksCount + ".......chunksCompleted :" + totalCount);
                continue;
            }
            BasicDBObject chunkUpdateQuey = new BasicDBObject();
            chunkUpdateQuey.append("newRef", false);
            BasicDBObject updateChunkQuery = new BasicDBObject();
            updateChunkQuery.append("$set", chunkUpdateQuey);
            chunksDBCollection.updateOne(chunkSearchQuery, updateChunkQuery);
            System.out.println(String.valueOf(Thread.currentThread().getName()) + "..." + chunk.getObjectId("_id") + ".....CHUNK NOT FOUND ..........succesChunksCount : " + succesChunksCount + "....failedchunksCount :" + ++failedchunksCount + ".......chunksCompleted :" + totalCount);
        }
        ChunksCleaningWithTread.reduceSkip();
    }
}

