/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.binders;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.ultradns.ws.domain.DirectionalGroup;

public class UpdateDirectionalDNSGroupToXML
implements MapBinder {
    private static final String template = "<v01:updateDirectionalDNSGroup><transactionID /><dirPoolRecordId>%s</dirPoolRecordId>%s</v01:updateDirectionalDNSGroup>";

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        DirectionalGroup group = (DirectionalGroup)DirectionalGroup.class.cast(postParams.get("group"));
        String xml = UpdateDirectionalDNSGroupToXML.toXML(postParams.get("dirPoolRecordId"), group);
        return (R)((HttpRequest.Builder)request.toBuilder().payload(xml)).build();
    }

    @VisibleForTesting
    static String toXML(Object dirPoolRecordId, DirectionalGroup group) {
        return String.format(template, dirPoolRecordId, UpdateDirectionalDNSGroupToXML.geo(group));
    }

    private static String geo(DirectionalGroup group) {
        StringBuilder groupData = new StringBuilder();
        groupData.append("<DirectionalDNSGroupDetail GroupName=\"").append(group.getName()).append('\"');
        if (group.getDescription().isPresent()) {
            groupData.append(" Description=\"").append(group.getDescription().get()).append('\"');
        }
        groupData.append(" ><DirectionalDNSRegion>");
        for (Map.Entry region : group.asMap().entrySet()) {
            groupData.append("<RegionForNewGroups RegionName=\"").append((String)region.getKey()).append('\"');
            groupData.append(" TerritoryName=\"").append(Joiner.on(';').join(region.getValue())).append("\" />");
        }
        groupData.append("</DirectionalDNSRegion></DirectionalDNSGroupDetail>");
        return groupData.toString();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException("use map form");
    }
}

