/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class TagType {
    private final String keyName;
    private final String description;

    @ConstructorProperties(value={"keyName", "description"})
    public TagType(@Nullable String keyName, @Nullable String description) {
        this.keyName = keyName;
        this.description = description;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagType that = (TagType)o;
        return Objects.equal(this.keyName, that.keyName) && Objects.equal(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hashCode(this.keyName, this.description);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("keyName", this.keyName).add("description", this.description).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return TagType.builder().fromTagType(this);
    }

    public static class Builder {
        private String keyName;
        private String description;

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public TagType build() {
            return new TagType(this.keyName, this.description);
        }

        public Builder fromTagType(TagType in) {
            return this.keyName(in.getKeyName()).description(in.getDescription());
        }
    }
}

