/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.s3.domain.CannedAccessPolicy;

public class PutObjectOptions
extends BaseHttpRequestOptions {
    public static final PutObjectOptions NONE = new PutObjectOptions();
    private CannedAccessPolicy acl = CannedAccessPolicy.PRIVATE;
    private String headerTag;

    @Inject
    public void setHeaderTag(@Named(value="jclouds.aws.header.tag") String headerTag) {
        this.headerTag = headerTag;
    }

    @Override
    public Multimap<String, String> buildRequestHeaders() {
        Preconditions.checkState(this.headerTag != null, "headerTag should have been injected!");
        ImmutableMultimap.Builder returnVal = ImmutableMultimap.builder();
        for (Map.Entry entry : this.headers.entries()) {
            returnVal.put(((String)entry.getKey()).replace("amz", this.headerTag), entry.getValue());
        }
        return returnVal.build();
    }

    public PutObjectOptions withAcl(CannedAccessPolicy acl) {
        this.acl = Preconditions.checkNotNull(acl, "acl");
        if (!acl.equals((Object)CannedAccessPolicy.PRIVATE)) {
            this.replaceHeader("x-amz-acl", acl.toString());
        }
        return this;
    }

    public CannedAccessPolicy getAcl() {
        return this.acl;
    }

    public static class Builder {
        public static PutObjectOptions withAcl(CannedAccessPolicy acl) {
            PutObjectOptions options = new PutObjectOptions();
            return options.withAcl(acl);
        }
    }
}

