/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindMetadataToHeaders
implements Binder {
    private final String metadataPrefix;

    public BindMetadataToHeaders(String metadataPrefix) {
        this.metadataPrefix = Preconditions.checkNotNull(metadataPrefix, "metadataPrefix");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkNotNull(request, "request");
        Preconditions.checkArgument(input instanceof Map, "input must be a non-null java.util.Map!");
        Map metadata = (Map)Map.class.cast(input);
        ImmutableMultimap<String, String> headers = this.toHeaders(metadata);
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders(headers)).build();
    }

    protected void putMetadata(ImmutableMultimap.Builder<String, String> headers, String key, String value) {
        headers.put(key, value);
    }

    public ImmutableMultimap<String, String> toHeaders(Map<String, String> metadata) {
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        for (Map.Entry<String, String> keyVal : metadata.entrySet()) {
            String keyInLowercase = keyVal.getKey().toLowerCase();
            if (keyVal.getKey().startsWith(this.metadataPrefix)) {
                this.putMetadata(builder, keyInLowercase, keyVal.getValue());
                continue;
            }
            this.putMetadata(builder, String.format("%s%s", this.metadataPrefix, keyInLowercase), keyVal.getValue());
        }
        return builder.build();
    }

    public static abstract class ForRemoval
    extends BindMetadataToHeaders {
        ForRemoval(String metadataPrefix) {
            super(metadataPrefix);
        }

        @Override
        protected void putMetadata(ImmutableMultimap.Builder<String, String> headers, String key, String value) {
            headers.put(String.format("x-remove%s", key.substring(1)), "ignored");
        }
    }

    public static class BindRemoveObjectMetadataToHeaders
    extends ForRemoval {
        BindRemoveObjectMetadataToHeaders() {
            super("X-Object-Meta-");
        }
    }

    public static class BindObjectMetadataToHeaders
    extends BindMetadataToHeaders {
        BindObjectMetadataToHeaders() {
            super("X-Object-Meta-");
        }
    }

    public static class BindRemoveContainerMetadataToHeaders
    extends ForRemoval {
        BindRemoveContainerMetadataToHeaders() {
            super("X-Container-Meta-");
        }
    }

    public static class BindContainerMetadataToHeaders
    extends BindMetadataToHeaders {
        BindContainerMetadataToHeaders() {
            super("X-Container-Meta-");
        }
    }

    public static class BindRemoveAccountMetadataToHeaders
    extends ForRemoval {
        BindRemoveAccountMetadataToHeaders() {
            super("X-Account-Meta-");
        }
    }

    public static class BindAccountMetadataToHeaders
    extends BindMetadataToHeaders {
        BindAccountMetadataToHeaders() {
            super("X-Account-Meta-");
        }
    }
}

