/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;

public class Console {
    private final URI url;
    private final Type type;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromConsole(this);
    }

    @ConstructorProperties(value={"url", "type"})
    protected Console(URI url, Type type) {
        this.url = Preconditions.checkNotNull(url, "url");
        this.type = Preconditions.checkNotNull(type, "type");
    }

    public URI getUrl() {
        return this.url;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.url, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Console that = (Console)Console.class.cast(obj);
        return Objects.equal(this.url, that.url) && Objects.equal((Object)this.type, (Object)that.type);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("url", this.url).add("type", (Object)this.type);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected URI url;
        protected Type type;

        protected abstract T self();

        public T url(URI url) {
            this.url = Preconditions.checkNotNull(url, "url");
            return this.self();
        }

        public T type(Type type) {
            this.type = type;
            return this.self();
        }

        public Console build() {
            return new Console(this.url, this.type);
        }

        public T fromConsole(Console in) {
            return ((Builder)this.url(in.getUrl())).type(in.getType());
        }
    }

    public static enum Type {
        NOVNC("novnc"),
        XVPVNC("xvpvnc"),
        SPICE_HTML5("spice-html5"),
        RDP_HTML5("rdp-html5"),
        UNRECOGNIZED("unrecognized");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }

        public static Type fromValue(String type) {
            if (type != null) {
                for (Type value : Type.values()) {
                    if (!type.equals(value.type)) continue;
                    return value;
                }
                return UNRECOGNIZED;
            }
            return null;
        }

        public String toString() {
            return this.type();
        }
    }
}

