/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class Address {
    private final String addr;
    private final int version;
    @Named(value="OS-EXT-IPS-MAC:mac_addr")
    private final Optional<String> macAddr;
    @Named(value="OS-EXT-IPS:type")
    private final Optional<String> type;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAddress(this);
    }

    public static Address createV4(String addr) {
        return ((Builder)((Builder)Address.builder().version(4)).addr(addr)).build();
    }

    public static Address createV6(String addr) {
        return ((Builder)((Builder)Address.builder().version(6)).addr(addr)).build();
    }

    @ConstructorProperties(value={"addr", "version", "OS-EXT-IPS-MAC:mac_addr", "OS-EXT-IPS:type"})
    protected Address(String addr, int version, @Nullable String macAddr, @Nullable String type) {
        this.addr = Preconditions.checkNotNull(addr, "addr");
        this.version = version;
        this.macAddr = Optional.fromNullable(macAddr);
        this.type = Optional.fromNullable(type);
    }

    public String getAddr() {
        return this.addr;
    }

    public int getVersion() {
        return this.version;
    }

    public Optional<String> getMacAddr() {
        return this.macAddr;
    }

    public Optional<String> getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode(this.addr, this.version, this.macAddr, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Address that = (Address)Address.class.cast(obj);
        return Objects.equal(this.addr, that.addr) && Objects.equal(this.version, that.version) && Objects.equal(this.macAddr, that.macAddr) && Objects.equal(this.type, that.type);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("addr", this.addr).add("version", this.version).add("macAddr", this.macAddr.or("")).add("type", this.type.or(""));
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String addr;
        protected int version;
        protected String macAddr;
        protected String type;

        protected abstract T self();

        public T addr(String addr) {
            this.addr = addr;
            return this.self();
        }

        public T version(int version) {
            this.version = version;
            return this.self();
        }

        public T macAddr(String macAddr) {
            this.macAddr = macAddr;
            return this.self();
        }

        public T type(String type) {
            this.type = type;
            return this.self();
        }

        public Address build() {
            return new Address(this.addr, this.version, this.macAddr, this.type);
        }

        public T fromAddress(Address in) {
            return ((Builder)((Builder)((Builder)this.addr(in.getAddr())).version(in.getVersion())).macAddr(in.getMacAddr().orNull())).type(in.getType().orNull());
        }
    }
}

