/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.Port;
import org.jclouds.openstack.neutron.v2.features.PortApi;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class PortsToPagedIterable
extends Arg0ToPagedIterable.FromCaller<Port, PortsToPagedIterable> {
    private final NeutronApi api;

    @Inject
    protected PortsToPagedIterable(NeutronApi api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    @Override
    protected Function<Object, IterableWithMarker<Port>> markerToNextForArg0(Optional<Object> arg0) {
        String region = arg0.isPresent() ? arg0.get().toString() : null;
        final PortApi portApi = this.api.getPortApi(region);
        return new Function<Object, IterableWithMarker<Port>>(){

            @Override
            public IterableWithMarker<Port> apply(Object input) {
                PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                return (IterableWithMarker)IterableWithMarker.class.cast(portApi.list(paginationOptions));
            }

            public String toString() {
                return "listPortsInDetail()";
            }
        };
    }
}

