/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateSnapshotOptions
implements MapBinder {
    public static final CreateSnapshotOptions NONE = new CreateSnapshotOptions();
    @Inject
    private BindToJsonPayload jsonBinder;
    private String name;
    private String description;
    private boolean force = false;

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        HashMap<String, Object> data = Maps.newHashMap(postParams);
        if (this.name != null) {
            data.put("display_name", this.name);
        }
        if (this.description != null) {
            data.put("display_description", this.description);
        }
        if (this.force) {
            data.put("force", "true");
        }
        return this.jsonBinder.bindToRequest(request, ImmutableMap.of("snapshot", data));
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("CreateSnapshot is a POST operation");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CreateSnapshotOptions)) {
            return false;
        }
        CreateSnapshotOptions other = (CreateSnapshotOptions)CreateSnapshotOptions.class.cast(object);
        return Objects.equal(this.name, other.name) && Objects.equal(this.description, other.description);
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.description);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper("").add("name", this.name).add("description", this.description);
    }

    public String toString() {
        return this.string().toString();
    }

    public CreateSnapshotOptions name(String name) {
        this.name = name;
        return this;
    }

    public CreateSnapshotOptions description(String description) {
        this.description = description;
        return this;
    }

    public CreateSnapshotOptions force() {
        this.force = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isForce() {
        return this.force;
    }

    public static class Builder {
        public static CreateSnapshotOptions name(String name) {
            return new CreateSnapshotOptions().name(name);
        }

        public static CreateSnapshotOptions description(String description) {
            return new CreateSnapshotOptions().description(description);
        }

        public static CreateSnapshotOptions force() {
            return new CreateSnapshotOptions().force();
        }
    }
}

