/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.xml.BaseReservationHandler;
import org.jclouds.ec2.xml.TagSetHandler;
import org.jclouds.location.Region;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DescribeInstancesResponseHandler
extends BaseReservationHandler<Set<Reservation<? extends RunningInstance>>> {
    private final TagSetHandler tagSetHandler;
    private ImmutableSet.Builder<Reservation<? extends RunningInstance>> reservations = ImmutableSet.builder();
    private boolean inTagSet;

    @Inject
    DescribeInstancesResponseHandler(DateService dateService, @Region Supplier<String> defaultRegion, TagSetHandler tagSetHandler) {
        super(dateService, defaultRegion);
        this.tagSetHandler = tagSetHandler;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        super.startElement(uri, name, qName, attrs);
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = true;
        }
        if (this.inTagSet) {
            this.tagSetHandler.startElement(uri, name, qName, attrs);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inTagSet) {
            this.tagSetHandler.characters(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = false;
            this.builder.tags((Map<String, String>)this.tagSetHandler.getResult());
        } else if (this.inTagSet) {
            this.tagSetHandler.endElement(uri, name, qName);
        }
        super.endElement(uri, name, qName);
    }

    @Override
    public Set<Reservation<? extends RunningInstance>> getResult() {
        return this.reservations.build();
    }

    protected boolean endOfReservationItem() {
        return this.itemDepth == 1;
    }

    @Override
    protected void inItem() {
        if (this.endOfReservationItem()) {
            this.reservations.add(super.newReservation());
        } else {
            super.inItem();
        }
    }

    @Override
    protected boolean endOfInstanceItem() {
        return this.itemDepth == 2 && this.inInstancesSet;
    }
}

