/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import org.jclouds.cloudwatch.domain.Datapoint;
import org.jclouds.javax.annotation.Nullable;

public class GetMetricStatisticsResponse
extends FluentIterable<Datapoint> {
    private final Iterable<Datapoint> datapoints;
    private final String label;

    public GetMetricStatisticsResponse(@Nullable Iterable<Datapoint> datapoints, String label) {
        this.datapoints = datapoints == null ? ImmutableSet.of() : ImmutableSet.copyOf(datapoints);
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public int hashCode() {
        return Objects.hashCode(this.datapoints, this.label);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetMetricStatisticsResponse other = (GetMetricStatisticsResponse)obj;
        return Objects.equal(this.datapoints, other.datapoints) && Objects.equal(this.label, other.label);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("label", this.label).add("datapoints", this.datapoints).toString();
    }

    @Override
    public Iterator<Datapoint> iterator() {
        return this.datapoints.iterator();
    }
}

