/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.UncheckedExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.logging.Logger;

@Singleton
public class BlockUntilJobCompletesAndReturnResult {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudStackApi client;
    private final Predicate<String> jobComplete;

    @Inject
    public BlockUntilJobCompletesAndReturnResult(CloudStackApi client, Predicate<String> jobComplete) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.jobComplete = Preconditions.checkNotNull(jobComplete, "jobComplete");
    }

    public <T> T apply(AsyncCreateResponse job) {
        boolean completed = this.jobComplete.apply(job.getJobId());
        this.logger.trace("<< job(%s) complete(%s)", job, completed);
        AsyncJob jobWithResult = this.client.getAsyncJobApi().getAsyncJob(job.getJobId());
        Preconditions.checkState(completed, "job %s failed to complete in time %s", job.getJobId(), jobWithResult);
        if (jobWithResult.getError() != null) {
            throw new UncheckedExecutionException(String.format("job %s failed with exception %s", job.getJobId(), jobWithResult.getError().toString())){};
        }
        return jobWithResult.getResult();
    }
}

